/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Global topology of the streaming Dataflow job, including all computations and their sharded
 * locations.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TopologyConfig extends com.google.api.client.json.GenericJson {

  /**
   * The computations associated with a streaming Dataflow job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ComputationTopology> computations;

  static {
    // hack to force ProGuard to consider ComputationTopology used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ComputationTopology.class);
  }

  /**
   * The disks assigned to a streaming Dataflow job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<DataDiskAssignment> dataDiskAssignments;

  static {
    // hack to force ProGuard to consider DataDiskAssignment used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(DataDiskAssignment.class);
  }

  /**
   * The size (in bits) of keys that will be assigned to source messages.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer forwardingKeyBits;

  /**
   * Version number for persistent state.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer persistentStateVersion;

  /**
   * Maps user stage names to stable computation names.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.String> userStageToComputationNameMap;

  /**
   * The computations associated with a streaming Dataflow job.
   * @return value or {@code null} for none
   */
  public java.util.List<ComputationTopology> getComputations() {
    return computations;
  }

  /**
   * The computations associated with a streaming Dataflow job.
   * @param computations computations or {@code null} for none
   */
  public TopologyConfig setComputations(java.util.List<ComputationTopology> computations) {
    this.computations = computations;
    return this;
  }

  /**
   * The disks assigned to a streaming Dataflow job.
   * @return value or {@code null} for none
   */
  public java.util.List<DataDiskAssignment> getDataDiskAssignments() {
    return dataDiskAssignments;
  }

  /**
   * The disks assigned to a streaming Dataflow job.
   * @param dataDiskAssignments dataDiskAssignments or {@code null} for none
   */
  public TopologyConfig setDataDiskAssignments(java.util.List<DataDiskAssignment> dataDiskAssignments) {
    this.dataDiskAssignments = dataDiskAssignments;
    return this;
  }

  /**
   * The size (in bits) of keys that will be assigned to source messages.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getForwardingKeyBits() {
    return forwardingKeyBits;
  }

  /**
   * The size (in bits) of keys that will be assigned to source messages.
   * @param forwardingKeyBits forwardingKeyBits or {@code null} for none
   */
  public TopologyConfig setForwardingKeyBits(java.lang.Integer forwardingKeyBits) {
    this.forwardingKeyBits = forwardingKeyBits;
    return this;
  }

  /**
   * Version number for persistent state.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getPersistentStateVersion() {
    return persistentStateVersion;
  }

  /**
   * Version number for persistent state.
   * @param persistentStateVersion persistentStateVersion or {@code null} for none
   */
  public TopologyConfig setPersistentStateVersion(java.lang.Integer persistentStateVersion) {
    this.persistentStateVersion = persistentStateVersion;
    return this;
  }

  /**
   * Maps user stage names to stable computation names.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.String> getUserStageToComputationNameMap() {
    return userStageToComputationNameMap;
  }

  /**
   * Maps user stage names to stable computation names.
   * @param userStageToComputationNameMap userStageToComputationNameMap or {@code null} for none
   */
  public TopologyConfig setUserStageToComputationNameMap(java.util.Map<String, java.lang.String> userStageToComputationNameMap) {
    this.userStageToComputationNameMap = userStageToComputationNameMap;
    return this;
  }

  @Override
  public TopologyConfig set(String fieldName, Object value) {
    return (TopologyConfig) super.set(fieldName, value);
  }

  @Override
  public TopologyConfig clone() {
    return (TopologyConfig) super.clone();
  }

}
