/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Metadata describing a template.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TemplateMetadata extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Indicates the default streaming mode for a streaming template. Only valid if both
   * supports_at_least_once and supports_exactly_once are true. Possible values: UNSPECIFIED,
   * EXACTLY_ONCE and AT_LEAST_ONCE
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String defaultStreamingMode;

  /**
   * Optional. A description of the template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String description;

  /**
   * Required. The name of the template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * The parameters for the template.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<ParameterMetadata> parameters;

  static {
    // hack to force ProGuard to consider ParameterMetadata used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(ParameterMetadata.class);
  }

  /**
   * Optional. Indicates if the template is streaming or not.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean streaming;

  /**
   * Optional. Indicates if the streaming template supports at least once mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean supportsAtLeastOnce;

  /**
   * Optional. Indicates if the streaming template supports exactly once mode.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean supportsExactlyOnce;

  /**
   * Optional. For future use.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String yamlDefinition;

  /**
   * Optional. Indicates the default streaming mode for a streaming template. Only valid if both
   * supports_at_least_once and supports_exactly_once are true. Possible values: UNSPECIFIED,
   * EXACTLY_ONCE and AT_LEAST_ONCE
   * @return value or {@code null} for none
   */
  public java.lang.String getDefaultStreamingMode() {
    return defaultStreamingMode;
  }

  /**
   * Optional. Indicates the default streaming mode for a streaming template. Only valid if both
   * supports_at_least_once and supports_exactly_once are true. Possible values: UNSPECIFIED,
   * EXACTLY_ONCE and AT_LEAST_ONCE
   * @param defaultStreamingMode defaultStreamingMode or {@code null} for none
   */
  public TemplateMetadata setDefaultStreamingMode(java.lang.String defaultStreamingMode) {
    this.defaultStreamingMode = defaultStreamingMode;
    return this;
  }

  /**
   * Optional. A description of the template.
   * @return value or {@code null} for none
   */
  public java.lang.String getDescription() {
    return description;
  }

  /**
   * Optional. A description of the template.
   * @param description description or {@code null} for none
   */
  public TemplateMetadata setDescription(java.lang.String description) {
    this.description = description;
    return this;
  }

  /**
   * Required. The name of the template.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The name of the template.
   * @param name name or {@code null} for none
   */
  public TemplateMetadata setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * The parameters for the template.
   * @return value or {@code null} for none
   */
  public java.util.List<ParameterMetadata> getParameters() {
    return parameters;
  }

  /**
   * The parameters for the template.
   * @param parameters parameters or {@code null} for none
   */
  public TemplateMetadata setParameters(java.util.List<ParameterMetadata> parameters) {
    this.parameters = parameters;
    return this;
  }

  /**
   * Optional. Indicates if the template is streaming or not.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getStreaming() {
    return streaming;
  }

  /**
   * Optional. Indicates if the template is streaming or not.
   * @param streaming streaming or {@code null} for none
   */
  public TemplateMetadata setStreaming(java.lang.Boolean streaming) {
    this.streaming = streaming;
    return this;
  }

  /**
   * Optional. Indicates if the streaming template supports at least once mode.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSupportsAtLeastOnce() {
    return supportsAtLeastOnce;
  }

  /**
   * Optional. Indicates if the streaming template supports at least once mode.
   * @param supportsAtLeastOnce supportsAtLeastOnce or {@code null} for none
   */
  public TemplateMetadata setSupportsAtLeastOnce(java.lang.Boolean supportsAtLeastOnce) {
    this.supportsAtLeastOnce = supportsAtLeastOnce;
    return this;
  }

  /**
   * Optional. Indicates if the streaming template supports exactly once mode.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getSupportsExactlyOnce() {
    return supportsExactlyOnce;
  }

  /**
   * Optional. Indicates if the streaming template supports exactly once mode.
   * @param supportsExactlyOnce supportsExactlyOnce or {@code null} for none
   */
  public TemplateMetadata setSupportsExactlyOnce(java.lang.Boolean supportsExactlyOnce) {
    this.supportsExactlyOnce = supportsExactlyOnce;
    return this;
  }

  /**
   * Optional. For future use.
   * @return value or {@code null} for none
   */
  public java.lang.String getYamlDefinition() {
    return yamlDefinition;
  }

  /**
   * Optional. For future use.
   * @param yamlDefinition yamlDefinition or {@code null} for none
   */
  public TemplateMetadata setYamlDefinition(java.lang.String yamlDefinition) {
    this.yamlDefinition = yamlDefinition;
    return this;
  }

  @Override
  public TemplateMetadata set(String fieldName, Object value) {
    return (TemplateMetadata) super.set(fieldName, value);
  }

  @Override
  public TemplateMetadata clone() {
    return (TemplateMetadata) super.clone();
  }

}
