/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A rich message format, including a human readable string, a key for identifying the message, and
 * structured data associated with the message for programmatic consumption.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StructuredMessage extends com.google.api.client.json.GenericJson {

  /**
   * Identifier for this message type. Used by external systems to internationalize or personalize
   * message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String messageKey;

  /**
   * Human-readable version of message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String messageText;

  /**
   * The structured data associated with this message.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Parameter> parameters;

  static {
    // hack to force ProGuard to consider Parameter used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Parameter.class);
  }

  /**
   * Identifier for this message type. Used by external systems to internationalize or personalize
   * message.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessageKey() {
    return messageKey;
  }

  /**
   * Identifier for this message type. Used by external systems to internationalize or personalize
   * message.
   * @param messageKey messageKey or {@code null} for none
   */
  public StructuredMessage setMessageKey(java.lang.String messageKey) {
    this.messageKey = messageKey;
    return this;
  }

  /**
   * Human-readable version of message.
   * @return value or {@code null} for none
   */
  public java.lang.String getMessageText() {
    return messageText;
  }

  /**
   * Human-readable version of message.
   * @param messageText messageText or {@code null} for none
   */
  public StructuredMessage setMessageText(java.lang.String messageText) {
    this.messageText = messageText;
    return this;
  }

  /**
   * The structured data associated with this message.
   * @return value or {@code null} for none
   */
  public java.util.List<Parameter> getParameters() {
    return parameters;
  }

  /**
   * The structured data associated with this message.
   * @param parameters parameters or {@code null} for none
   */
  public StructuredMessage setParameters(java.util.List<Parameter> parameters) {
    this.parameters = parameters;
    return this;
  }

  @Override
  public StructuredMessage set(String fieldName, Object value) {
    return (StructuredMessage) super.set(fieldName, value);
  }

  @Override
  public StructuredMessage clone() {
    return (StructuredMessage) super.clone();
  }

}
