/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Summarized straggler identification details.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StragglerSummary extends com.google.api.client.json.GenericJson {

  /**
   * The most recent stragglers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<Straggler> recentStragglers;

  static {
    // hack to force ProGuard to consider Straggler used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(Straggler.class);
  }

  /**
   * Aggregated counts of straggler causes, keyed by the string representation of the StragglerCause
   * enum.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.Map<String, java.lang.Long> stragglerCauseCount;

  /**
   * The total count of stragglers.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long totalStragglerCount;

  /**
   * The most recent stragglers.
   * @return value or {@code null} for none
   */
  public java.util.List<Straggler> getRecentStragglers() {
    return recentStragglers;
  }

  /**
   * The most recent stragglers.
   * @param recentStragglers recentStragglers or {@code null} for none
   */
  public StragglerSummary setRecentStragglers(java.util.List<Straggler> recentStragglers) {
    this.recentStragglers = recentStragglers;
    return this;
  }

  /**
   * Aggregated counts of straggler causes, keyed by the string representation of the StragglerCause
   * enum.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Long> getStragglerCauseCount() {
    return stragglerCauseCount;
  }

  /**
   * Aggregated counts of straggler causes, keyed by the string representation of the StragglerCause
   * enum.
   * @param stragglerCauseCount stragglerCauseCount or {@code null} for none
   */
  public StragglerSummary setStragglerCauseCount(java.util.Map<String, java.lang.Long> stragglerCauseCount) {
    this.stragglerCauseCount = stragglerCauseCount;
    return this;
  }

  /**
   * The total count of stragglers.
   * @return value or {@code null} for none
   */
  public java.lang.Long getTotalStragglerCount() {
    return totalStragglerCount;
  }

  /**
   * The total count of stragglers.
   * @param totalStragglerCount totalStragglerCount or {@code null} for none
   */
  public StragglerSummary setTotalStragglerCount(java.lang.Long totalStragglerCount) {
    this.totalStragglerCount = totalStragglerCount;
    return this;
  }

  @Override
  public StragglerSummary set(String fieldName, Object value) {
    return (StragglerSummary) super.set(fieldName, value);
  }

  @Override
  public StragglerSummary clone() {
    return (StragglerSummary) super.clone();
  }

}
