/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Information for a straggler.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Straggler extends com.google.api.client.json.GenericJson {

  /**
   * Batch straggler identification and debugging information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StragglerInfo batchStraggler;

  /**
   * Streaming straggler identification and debugging information.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private StreamingStragglerInfo streamingStraggler;

  /**
   * Batch straggler identification and debugging information.
   * @return value or {@code null} for none
   */
  public StragglerInfo getBatchStraggler() {
    return batchStraggler;
  }

  /**
   * Batch straggler identification and debugging information.
   * @param batchStraggler batchStraggler or {@code null} for none
   */
  public Straggler setBatchStraggler(StragglerInfo batchStraggler) {
    this.batchStraggler = batchStraggler;
    return this;
  }

  /**
   * Streaming straggler identification and debugging information.
   * @return value or {@code null} for none
   */
  public StreamingStragglerInfo getStreamingStraggler() {
    return streamingStraggler;
  }

  /**
   * Streaming straggler identification and debugging information.
   * @param streamingStraggler streamingStraggler or {@code null} for none
   */
  public Straggler setStreamingStraggler(StreamingStragglerInfo streamingStraggler) {
    this.streamingStraggler = streamingStraggler;
    return this;
  }

  @Override
  public Straggler set(String fieldName, Object value) {
    return (Straggler) super.set(fieldName, value);
  }

  @Override
  public Straggler clone() {
    return (Straggler) super.clone();
  }

}
