/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Defines a particular step within a Cloud Dataflow job. A job consists of multiple steps, each of
 * which performs some specific operation as part of the overall job. Data is typically passed from
 * one step to another as part of the job. **Note:** The properties of this object are not stable
 * and might change. Here's an example of a sequence of steps which together implement a Map-Reduce
 * job: * Read a collection of data from some source, parsing the collection's elements. * Validate
 * the elements. * Apply a user-defined function to map each element to some value and extract an
 * element-specific key value. * Group elements with the same key into a single element with that
 * key, transforming a multiply-keyed collection into a uniquely-keyed collection. * Write the
 * elements out to some data sink. Note that the Cloud Dataflow service may be used to run many
 * different types of jobs, not just Map-Reduce.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Step extends com.google.api.client.json.GenericJson {

  /**
   * The kind of step in the Cloud Dataflow job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The name that identifies the step. This must be unique for each step with respect to all other
   * steps in the Cloud Dataflow job.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Named properties associated with the step. Each kind of predefined step has its own required
   * set of properties. Must be provided on Create. Only retrieved with JOB_VIEW_ALL.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> properties;

  /**
   * The kind of step in the Cloud Dataflow job.
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * The kind of step in the Cloud Dataflow job.
   * @param kind kind or {@code null} for none
   */
  public Step setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The name that identifies the step. This must be unique for each step with respect to all other
   * steps in the Cloud Dataflow job.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * The name that identifies the step. This must be unique for each step with respect to all other
   * steps in the Cloud Dataflow job.
   * @param name name or {@code null} for none
   */
  public Step setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Named properties associated with the step. Each kind of predefined step has its own required
   * set of properties. Must be provided on Create. Only retrieved with JOB_VIEW_ALL.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getProperties() {
    return properties;
  }

  /**
   * Named properties associated with the step. Each kind of predefined step has its own required
   * set of properties. Must be provided on Create. Only retrieved with JOB_VIEW_ALL.
   * @param properties properties or {@code null} for none
   */
  public Step setProperties(java.util.Map<String, java.lang.Object> properties) {
    this.properties = properties;
    return this;
  }

  @Override
  public Step set(String fieldName, Object value) {
    return (Step) super.set(fieldName, value);
  }

  @Override
  public Step clone() {
    return (Step) super.clone();
  }

}
