/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Description of an input or output of an execution stage.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StageSource extends com.google.api.client.json.GenericJson {

  /**
   * Dataflow service generated name for this source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * User name for the original user transform or collection with which this source is most closely
   * associated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalTransformOrCollection;

  /**
   * Size of the source, if measurable.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long sizeBytes;

  /**
   * Human-readable name for this source; may be user or system generated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String userName;

  /**
   * Dataflow service generated name for this source.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Dataflow service generated name for this source.
   * @param name name or {@code null} for none
   */
  public StageSource setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * User name for the original user transform or collection with which this source is most closely
   * associated.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalTransformOrCollection() {
    return originalTransformOrCollection;
  }

  /**
   * User name for the original user transform or collection with which this source is most closely
   * associated.
   * @param originalTransformOrCollection originalTransformOrCollection or {@code null} for none
   */
  public StageSource setOriginalTransformOrCollection(java.lang.String originalTransformOrCollection) {
    this.originalTransformOrCollection = originalTransformOrCollection;
    return this;
  }

  /**
   * Size of the source, if measurable.
   * @return value or {@code null} for none
   */
  public java.lang.Long getSizeBytes() {
    return sizeBytes;
  }

  /**
   * Size of the source, if measurable.
   * @param sizeBytes sizeBytes or {@code null} for none
   */
  public StageSource setSizeBytes(java.lang.Long sizeBytes) {
    this.sizeBytes = sizeBytes;
    return this;
  }

  /**
   * Human-readable name for this source; may be user or system generated.
   * @return value or {@code null} for none
   */
  public java.lang.String getUserName() {
    return userName;
  }

  /**
   * Human-readable name for this source; may be user or system generated.
   * @param userName userName or {@code null} for none
   */
  public StageSource setUserName(java.lang.String userName) {
    this.userName = userName;
    return this;
  }

  @Override
  public StageSource set(String fieldName, Object value) {
    return (StageSource) super.set(fieldName, value);
  }

  @Override
  public StageSource clone() {
    return (StageSource) super.clone();
  }

}
