/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A sink that records can be encoded and written to.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Sink extends com.google.api.client.json.GenericJson {

  /**
   * The codec to use to encode data written to the sink.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> codec;

  /**
   * The sink to write to, plus its parameters.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.Map<String, java.lang.Object> spec;

  /**
   * The codec to use to encode data written to the sink.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getCodec() {
    return codec;
  }

  /**
   * The codec to use to encode data written to the sink.
   * @param codec codec or {@code null} for none
   */
  public Sink setCodec(java.util.Map<String, java.lang.Object> codec) {
    this.codec = codec;
    return this;
  }

  /**
   * The sink to write to, plus its parameters.
   * @return value or {@code null} for none
   */
  public java.util.Map<String, java.lang.Object> getSpec() {
    return spec;
  }

  /**
   * The sink to write to, plus its parameters.
   * @param spec spec or {@code null} for none
   */
  public Sink setSpec(java.util.Map<String, java.lang.Object> spec) {
    this.spec = spec;
    return this;
  }

  @Override
  public Sink set(String fieldName, Object value) {
    return (Sink) super.set(fieldName, value);
  }

  @Override
  public Sink clone() {
    return (Sink) super.clone();
  }

}
