/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Additional job parameters that can only be updated during runtime using the projects.jobs.update
 * method. These fields have no effect when specified during job creation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class RuntimeUpdatableParams extends com.google.api.client.json.GenericJson {

  /**
   * The maximum number of workers to cap autoscaling at. This field is currently only supported for
   * Streaming Engine jobs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer maxNumWorkers;

  /**
   * The minimum number of workers to scale down to. This field is currently only supported for
   * Streaming Engine jobs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer minNumWorkers;

  /**
   * Target worker utilization, compared against the aggregate utilization of the worker pool by
   * autoscaler, to determine upscaling and downscaling when absent other constraints such as
   * backlog. For more information, see [Update an existing
   * pipeline](https://cloud.google.com/dataflow/docs/guides/updating-a-pipeline).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double workerUtilizationHint;

  /**
   * The maximum number of workers to cap autoscaling at. This field is currently only supported for
   * Streaming Engine jobs.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMaxNumWorkers() {
    return maxNumWorkers;
  }

  /**
   * The maximum number of workers to cap autoscaling at. This field is currently only supported for
   * Streaming Engine jobs.
   * @param maxNumWorkers maxNumWorkers or {@code null} for none
   */
  public RuntimeUpdatableParams setMaxNumWorkers(java.lang.Integer maxNumWorkers) {
    this.maxNumWorkers = maxNumWorkers;
    return this;
  }

  /**
   * The minimum number of workers to scale down to. This field is currently only supported for
   * Streaming Engine jobs.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getMinNumWorkers() {
    return minNumWorkers;
  }

  /**
   * The minimum number of workers to scale down to. This field is currently only supported for
   * Streaming Engine jobs.
   * @param minNumWorkers minNumWorkers or {@code null} for none
   */
  public RuntimeUpdatableParams setMinNumWorkers(java.lang.Integer minNumWorkers) {
    this.minNumWorkers = minNumWorkers;
    return this;
  }

  /**
   * Target worker utilization, compared against the aggregate utilization of the worker pool by
   * autoscaler, to determine upscaling and downscaling when absent other constraints such as
   * backlog. For more information, see [Update an existing
   * pipeline](https://cloud.google.com/dataflow/docs/guides/updating-a-pipeline).
   * @return value or {@code null} for none
   */
  public java.lang.Double getWorkerUtilizationHint() {
    return workerUtilizationHint;
  }

  /**
   * Target worker utilization, compared against the aggregate utilization of the worker pool by
   * autoscaler, to determine upscaling and downscaling when absent other constraints such as
   * backlog. For more information, see [Update an existing
   * pipeline](https://cloud.google.com/dataflow/docs/guides/updating-a-pipeline).
   * @param workerUtilizationHint workerUtilizationHint or {@code null} for none
   */
  public RuntimeUpdatableParams setWorkerUtilizationHint(java.lang.Double workerUtilizationHint) {
    this.workerUtilizationHint = workerUtilizationHint;
    return this;
  }

  @Override
  public RuntimeUpdatableParams set(String fieldName, Object value) {
    return (RuntimeUpdatableParams) super.set(fieldName, value);
  }

  @Override
  public RuntimeUpdatableParams clone() {
    return (RuntimeUpdatableParams) super.clone();
  }

}
