/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Metrics for a particular unfused step and namespace. A metric is uniquely identified by the
 * `metrics_namespace`, `original_step`, `metric name` and `metric_labels`.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PerStepNamespaceMetrics extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Metrics that are recorded for this namespace and unfused step.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<MetricValue> metricValues;

  static {
    // hack to force ProGuard to consider MetricValue used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(MetricValue.class);
  }

  /**
   * The namespace of these metrics on the worker.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String metricsNamespace;

  /**
   * The original system name of the unfused step that these metrics are reported from.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String originalStep;

  /**
   * Optional. Metrics that are recorded for this namespace and unfused step.
   * @return value or {@code null} for none
   */
  public java.util.List<MetricValue> getMetricValues() {
    return metricValues;
  }

  /**
   * Optional. Metrics that are recorded for this namespace and unfused step.
   * @param metricValues metricValues or {@code null} for none
   */
  public PerStepNamespaceMetrics setMetricValues(java.util.List<MetricValue> metricValues) {
    this.metricValues = metricValues;
    return this;
  }

  /**
   * The namespace of these metrics on the worker.
   * @return value or {@code null} for none
   */
  public java.lang.String getMetricsNamespace() {
    return metricsNamespace;
  }

  /**
   * The namespace of these metrics on the worker.
   * @param metricsNamespace metricsNamespace or {@code null} for none
   */
  public PerStepNamespaceMetrics setMetricsNamespace(java.lang.String metricsNamespace) {
    this.metricsNamespace = metricsNamespace;
    return this;
  }

  /**
   * The original system name of the unfused step that these metrics are reported from.
   * @return value or {@code null} for none
   */
  public java.lang.String getOriginalStep() {
    return originalStep;
  }

  /**
   * The original system name of the unfused step that these metrics are reported from.
   * @param originalStep originalStep or {@code null} for none
   */
  public PerStepNamespaceMetrics setOriginalStep(java.lang.String originalStep) {
    this.originalStep = originalStep;
    return this;
  }

  @Override
  public PerStepNamespaceMetrics set(String fieldName, Object value) {
    return (PerStepNamespaceMetrics) super.set(fieldName, value);
  }

  @Override
  public PerStepNamespaceMetrics clone() {
    return (PerStepNamespaceMetrics) super.clone();
  }

}
