/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Utilization details about the GPU.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class GPUUtilization extends com.google.api.client.json.GenericJson {

  /**
   * Required. GPU utilization rate of any kernel over the last sample period in the range of [0,
   * 1].
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double rate;

  /**
   * Required. GPU utilization rate of any kernel over the last sample period in the range of [0,
   * 1].
   * @return value or {@code null} for none
   */
  public java.lang.Double getRate() {
    return rate;
  }

  /**
   * Required. GPU utilization rate of any kernel over the last sample period in the range of [0,
   * 1].
   * @param rate rate or {@code null} for none
   */
  public GPUUtilization setRate(java.lang.Double rate) {
    this.rate = rate;
    return this;
  }

  @Override
  public GPUUtilization set(String fieldName, Object value) {
    return (GPUUtilization) super.set(fieldName, value);
  }

  @Override
  public GPUUtilization clone() {
    return (GPUUtilization) super.clone();
  }

}
