/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * A metric value representing a distribution.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DistributionUpdate extends com.google.api.client.json.GenericJson {

  /**
   * The count of the number of elements present in the distribution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SplitInt64 count;

  /**
   * (Optional) Histogram of value counts for the distribution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Histogram histogram;

  /**
   * The maximum value present in the distribution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SplitInt64 max;

  /**
   * The minimum value present in the distribution.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SplitInt64 min;

  /**
   * Use an int64 since we'd prefer the added precision. If overflow is a common problem we can
   * detect it and use an additional int64 or a double.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private SplitInt64 sum;

  /**
   * Use a double since the sum of squares is likely to overflow int64.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double sumOfSquares;

  /**
   * The count of the number of elements present in the distribution.
   * @return value or {@code null} for none
   */
  public SplitInt64 getCount() {
    return count;
  }

  /**
   * The count of the number of elements present in the distribution.
   * @param count count or {@code null} for none
   */
  public DistributionUpdate setCount(SplitInt64 count) {
    this.count = count;
    return this;
  }

  /**
   * (Optional) Histogram of value counts for the distribution.
   * @return value or {@code null} for none
   */
  public Histogram getHistogram() {
    return histogram;
  }

  /**
   * (Optional) Histogram of value counts for the distribution.
   * @param histogram histogram or {@code null} for none
   */
  public DistributionUpdate setHistogram(Histogram histogram) {
    this.histogram = histogram;
    return this;
  }

  /**
   * The maximum value present in the distribution.
   * @return value or {@code null} for none
   */
  public SplitInt64 getMax() {
    return max;
  }

  /**
   * The maximum value present in the distribution.
   * @param max max or {@code null} for none
   */
  public DistributionUpdate setMax(SplitInt64 max) {
    this.max = max;
    return this;
  }

  /**
   * The minimum value present in the distribution.
   * @return value or {@code null} for none
   */
  public SplitInt64 getMin() {
    return min;
  }

  /**
   * The minimum value present in the distribution.
   * @param min min or {@code null} for none
   */
  public DistributionUpdate setMin(SplitInt64 min) {
    this.min = min;
    return this;
  }

  /**
   * Use an int64 since we'd prefer the added precision. If overflow is a common problem we can
   * detect it and use an additional int64 or a double.
   * @return value or {@code null} for none
   */
  public SplitInt64 getSum() {
    return sum;
  }

  /**
   * Use an int64 since we'd prefer the added precision. If overflow is a common problem we can
   * detect it and use an additional int64 or a double.
   * @param sum sum or {@code null} for none
   */
  public DistributionUpdate setSum(SplitInt64 sum) {
    this.sum = sum;
    return this;
  }

  /**
   * Use a double since the sum of squares is likely to overflow int64.
   * @return value or {@code null} for none
   */
  public java.lang.Double getSumOfSquares() {
    return sumOfSquares;
  }

  /**
   * Use a double since the sum of squares is likely to overflow int64.
   * @param sumOfSquares sumOfSquares or {@code null} for none
   */
  public DistributionUpdate setSumOfSquares(java.lang.Double sumOfSquares) {
    this.sumOfSquares = sumOfSquares;
    return this;
  }

  @Override
  public DistributionUpdate set(String fieldName, Object value) {
    return (DistributionUpdate) super.set(fieldName, value);
  }

  @Override
  public DistributionUpdate clone() {
    return (DistributionUpdate) super.clone();
  }

}
