/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Describes any options that have an effect on the debugging of pipelines.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DebugOptions extends com.google.api.client.json.GenericJson {

  /**
   * Configuration options for sampling elements from a running pipeline.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DataSamplingConfig dataSampling;

  /**
   * Optional. When true, enables the logging of the literal hot key to the user's Cloud Logging.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean enableHotKeyLogging;

  /**
   * Configuration options for sampling elements from a running pipeline.
   * @return value or {@code null} for none
   */
  public DataSamplingConfig getDataSampling() {
    return dataSampling;
  }

  /**
   * Configuration options for sampling elements from a running pipeline.
   * @param dataSampling dataSampling or {@code null} for none
   */
  public DebugOptions setDataSampling(DataSamplingConfig dataSampling) {
    this.dataSampling = dataSampling;
    return this;
  }

  /**
   * Optional. When true, enables the logging of the literal hot key to the user's Cloud Logging.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getEnableHotKeyLogging() {
    return enableHotKeyLogging;
  }

  /**
   * Optional. When true, enables the logging of the literal hot key to the user's Cloud Logging.
   * @param enableHotKeyLogging enableHotKeyLogging or {@code null} for none
   */
  public DebugOptions setEnableHotKeyLogging(java.lang.Boolean enableHotKeyLogging) {
    this.enableHotKeyLogging = enableHotKeyLogging;
    return this;
  }

  @Override
  public DebugOptions set(String fieldName, Object value) {
    return (DebugOptions) super.set(fieldName, value);
  }

  @Override
  public DebugOptions clone() {
    return (DebugOptions) super.clone();
  }

}
