/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * Summary statistics for a population of values. HistogramValue contains a sequence of buckets and
 * gives a count of values that fall into each bucket. Bucket boundares are defined by a formula and
 * bucket widths are either fixed or exponentially increasing.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataflowHistogramValue extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The number of values in each bucket of the histogram, as described in
   * `bucket_options`. `bucket_counts` should contain N values, where N is the number of buckets
   * specified in `bucket_options`. If `bucket_counts` has fewer than N values, the remaining values
   * are assumed to be 0.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.util.List<java.lang.Long> bucketCounts;

  /**
   * Describes the bucket boundaries used in the histogram.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BucketOptions bucketOptions;

  /**
   * Number of values recorded in this histogram.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long count;

  /**
   * Statistics on the values recorded in the histogram that fall out of the bucket boundaries.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OutlierStats outlierStats;

  /**
   * Optional. The number of values in each bucket of the histogram, as described in
   * `bucket_options`. `bucket_counts` should contain N values, where N is the number of buckets
   * specified in `bucket_options`. If `bucket_counts` has fewer than N values, the remaining values
   * are assumed to be 0.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.Long> getBucketCounts() {
    return bucketCounts;
  }

  /**
   * Optional. The number of values in each bucket of the histogram, as described in
   * `bucket_options`. `bucket_counts` should contain N values, where N is the number of buckets
   * specified in `bucket_options`. If `bucket_counts` has fewer than N values, the remaining values
   * are assumed to be 0.
   * @param bucketCounts bucketCounts or {@code null} for none
   */
  public DataflowHistogramValue setBucketCounts(java.util.List<java.lang.Long> bucketCounts) {
    this.bucketCounts = bucketCounts;
    return this;
  }

  /**
   * Describes the bucket boundaries used in the histogram.
   * @return value or {@code null} for none
   */
  public BucketOptions getBucketOptions() {
    return bucketOptions;
  }

  /**
   * Describes the bucket boundaries used in the histogram.
   * @param bucketOptions bucketOptions or {@code null} for none
   */
  public DataflowHistogramValue setBucketOptions(BucketOptions bucketOptions) {
    this.bucketOptions = bucketOptions;
    return this;
  }

  /**
   * Number of values recorded in this histogram.
   * @return value or {@code null} for none
   */
  public java.lang.Long getCount() {
    return count;
  }

  /**
   * Number of values recorded in this histogram.
   * @param count count or {@code null} for none
   */
  public DataflowHistogramValue setCount(java.lang.Long count) {
    this.count = count;
    return this;
  }

  /**
   * Statistics on the values recorded in the histogram that fall out of the bucket boundaries.
   * @return value or {@code null} for none
   */
  public OutlierStats getOutlierStats() {
    return outlierStats;
  }

  /**
   * Statistics on the values recorded in the histogram that fall out of the bucket boundaries.
   * @param outlierStats outlierStats or {@code null} for none
   */
  public DataflowHistogramValue setOutlierStats(OutlierStats outlierStats) {
    this.outlierStats = outlierStats;
    return this;
  }

  @Override
  public DataflowHistogramValue set(String fieldName, Object value) {
    return (DataflowHistogramValue) super.set(fieldName, value);
  }

  @Override
  public DataflowHistogramValue clone() {
    return (DataflowHistogramValue) super.clone();
  }

}
