/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * All configuration data for a particular Computation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class ComputationTopology extends com.google.api.client.json.GenericJson {

  /**
   * The ID of the computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String computationId;

  /**
   * The inputs to the computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StreamLocation> inputs;

  /**
   * The key ranges processed by the computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<KeyRangeLocation> keyRanges;

  /**
   * The outputs from the computation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StreamLocation> outputs;

  /**
   * The state family values.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StateFamilyConfig> stateFamilies;

  /**
   * The system stage name.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String systemStageName;

  /**
   * The ID of the computation.
   * @return value or {@code null} for none
   */
  public java.lang.String getComputationId() {
    return computationId;
  }

  /**
   * The ID of the computation.
   * @param computationId computationId or {@code null} for none
   */
  public ComputationTopology setComputationId(java.lang.String computationId) {
    this.computationId = computationId;
    return this;
  }

  /**
   * The inputs to the computation.
   * @return value or {@code null} for none
   */
  public java.util.List<StreamLocation> getInputs() {
    return inputs;
  }

  /**
   * The inputs to the computation.
   * @param inputs inputs or {@code null} for none
   */
  public ComputationTopology setInputs(java.util.List<StreamLocation> inputs) {
    this.inputs = inputs;
    return this;
  }

  /**
   * The key ranges processed by the computation.
   * @return value or {@code null} for none
   */
  public java.util.List<KeyRangeLocation> getKeyRanges() {
    return keyRanges;
  }

  /**
   * The key ranges processed by the computation.
   * @param keyRanges keyRanges or {@code null} for none
   */
  public ComputationTopology setKeyRanges(java.util.List<KeyRangeLocation> keyRanges) {
    this.keyRanges = keyRanges;
    return this;
  }

  /**
   * The outputs from the computation.
   * @return value or {@code null} for none
   */
  public java.util.List<StreamLocation> getOutputs() {
    return outputs;
  }

  /**
   * The outputs from the computation.
   * @param outputs outputs or {@code null} for none
   */
  public ComputationTopology setOutputs(java.util.List<StreamLocation> outputs) {
    this.outputs = outputs;
    return this;
  }

  /**
   * The state family values.
   * @return value or {@code null} for none
   */
  public java.util.List<StateFamilyConfig> getStateFamilies() {
    return stateFamilies;
  }

  /**
   * The state family values.
   * @param stateFamilies stateFamilies or {@code null} for none
   */
  public ComputationTopology setStateFamilies(java.util.List<StateFamilyConfig> stateFamilies) {
    this.stateFamilies = stateFamilies;
    return this;
  }

  /**
   * The system stage name.
   * @return value or {@code null} for none
   */
  public java.lang.String getSystemStageName() {
    return systemStageName;
  }

  /**
   * The system stage name.
   * @param systemStageName systemStageName or {@code null} for none
   */
  public ComputationTopology setSystemStageName(java.lang.String systemStageName) {
    this.systemStageName = systemStageName;
    return this;
  }

  @Override
  public ComputationTopology set(String fieldName, Object value) {
    return (ComputationTopology) super.set(fieldName, value);
  }

  @Override
  public ComputationTopology clone() {
    return (ComputationTopology) super.clone();
  }

}
