/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.dataflow.model;

/**
 * The message type used for encoding metrics of type bounded trie.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Dataflow API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class BoundedTrie extends com.google.api.client.json.GenericJson {

  /**
   * The maximum number of elements to store before truncation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer bound;

  /**
   * A compact representation of all the elements in this trie.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private BoundedTrieNode root;

  /**
   * A more efficient representation for metrics consisting of a single value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<java.lang.String> singleton;

  /**
   * The maximum number of elements to store before truncation.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getBound() {
    return bound;
  }

  /**
   * The maximum number of elements to store before truncation.
   * @param bound bound or {@code null} for none
   */
  public BoundedTrie setBound(java.lang.Integer bound) {
    this.bound = bound;
    return this;
  }

  /**
   * A compact representation of all the elements in this trie.
   * @return value or {@code null} for none
   */
  public BoundedTrieNode getRoot() {
    return root;
  }

  /**
   * A compact representation of all the elements in this trie.
   * @param root root or {@code null} for none
   */
  public BoundedTrie setRoot(BoundedTrieNode root) {
    this.root = root;
    return this;
  }

  /**
   * A more efficient representation for metrics consisting of a single value.
   * @return value or {@code null} for none
   */
  public java.util.List<java.lang.String> getSingleton() {
    return singleton;
  }

  /**
   * A more efficient representation for metrics consisting of a single value.
   * @param singleton singleton or {@code null} for none
   */
  public BoundedTrie setSingleton(java.util.List<java.lang.String> singleton) {
    this.singleton = singleton;
    return this;
  }

  @Override
  public BoundedTrie set(String fieldName, Object value) {
    return (BoundedTrie) super.set(fieldName, value);
  }

  @Override
  public BoundedTrie clone() {
    return (BoundedTrie) super.clone();
  }

}
