/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Options for data format adjustments.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DataFormatOptions extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The API output format for a timestamp. This offers more explicit control over the
   * timestamp output format as compared to the existing `use_int64_timestamp` option.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String timestampOutputFormat;

  /**
   * Optional. Output timestamp as usec int64. Default is false.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useInt64Timestamp;

  /**
   * Optional. The API output format for a timestamp. This offers more explicit control over the
   * timestamp output format as compared to the existing `use_int64_timestamp` option.
   * @return value or {@code null} for none
   */
  public java.lang.String getTimestampOutputFormat() {
    return timestampOutputFormat;
  }

  /**
   * Optional. The API output format for a timestamp. This offers more explicit control over the
   * timestamp output format as compared to the existing `use_int64_timestamp` option.
   * @param timestampOutputFormat timestampOutputFormat or {@code null} for none
   */
  public DataFormatOptions setTimestampOutputFormat(java.lang.String timestampOutputFormat) {
    this.timestampOutputFormat = timestampOutputFormat;
    return this;
  }

  /**
   * Optional. Output timestamp as usec int64. Default is false.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseInt64Timestamp() {
    return useInt64Timestamp;
  }

  /**
   * Optional. Output timestamp as usec int64. Default is false.
   * @param useInt64Timestamp useInt64Timestamp or {@code null} for none
   */
  public DataFormatOptions setUseInt64Timestamp(java.lang.Boolean useInt64Timestamp) {
    this.useInt64Timestamp = useInt64Timestamp;
    return this;
  }

  @Override
  public DataFormatOptions set(String fieldName, Object value) {
    return (DataFormatOptions) super.set(fieldName, value);
  }

  @Override
  public DataFormatOptions clone() {
    return (DataFormatOptions) super.clone();
  }

}
