/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Statistics for a vector search query. Populated as part of JobStatistics2.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class VectorSearchStatistics extends com.google.api.client.json.GenericJson {

  /**
   * When `indexUsageMode` is `UNUSED` or `PARTIALLY_USED`, this field explains why indexes were not
   * used in all or part of the vector search query. If `indexUsageMode` is `FULLY_USED`, this field
   * is not populated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<IndexUnusedReason> indexUnusedReasons;

  static {
    // hack to force ProGuard to consider IndexUnusedReason used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(IndexUnusedReason.class);
  }

  /**
   * Specifies the index usage mode for the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String indexUsageMode;

  /**
   * Specifies the usage of stored columns in the query when stored columns are used in the query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StoredColumnsUsage> storedColumnsUsages;

  static {
    // hack to force ProGuard to consider StoredColumnsUsage used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StoredColumnsUsage.class);
  }

  /**
   * When `indexUsageMode` is `UNUSED` or `PARTIALLY_USED`, this field explains why indexes were not
   * used in all or part of the vector search query. If `indexUsageMode` is `FULLY_USED`, this field
   * is not populated.
   * @return value or {@code null} for none
   */
  public java.util.List<IndexUnusedReason> getIndexUnusedReasons() {
    return indexUnusedReasons;
  }

  /**
   * When `indexUsageMode` is `UNUSED` or `PARTIALLY_USED`, this field explains why indexes were not
   * used in all or part of the vector search query. If `indexUsageMode` is `FULLY_USED`, this field
   * is not populated.
   * @param indexUnusedReasons indexUnusedReasons or {@code null} for none
   */
  public VectorSearchStatistics setIndexUnusedReasons(java.util.List<IndexUnusedReason> indexUnusedReasons) {
    this.indexUnusedReasons = indexUnusedReasons;
    return this;
  }

  /**
   * Specifies the index usage mode for the query.
   * @return value or {@code null} for none
   */
  public java.lang.String getIndexUsageMode() {
    return indexUsageMode;
  }

  /**
   * Specifies the index usage mode for the query.
   * @param indexUsageMode indexUsageMode or {@code null} for none
   */
  public VectorSearchStatistics setIndexUsageMode(java.lang.String indexUsageMode) {
    this.indexUsageMode = indexUsageMode;
    return this;
  }

  /**
   * Specifies the usage of stored columns in the query when stored columns are used in the query.
   * @return value or {@code null} for none
   */
  public java.util.List<StoredColumnsUsage> getStoredColumnsUsages() {
    return storedColumnsUsages;
  }

  /**
   * Specifies the usage of stored columns in the query when stored columns are used in the query.
   * @param storedColumnsUsages storedColumnsUsages or {@code null} for none
   */
  public VectorSearchStatistics setStoredColumnsUsages(java.util.List<StoredColumnsUsage> storedColumnsUsages) {
    this.storedColumnsUsages = storedColumnsUsages;
    return this;
  }

  @Override
  public VectorSearchStatistics set(String fieldName, Object value) {
    return (VectorSearchStatistics) super.set(fieldName, value);
  }

  @Override
  public VectorSearchStatistics clone() {
    return (VectorSearchStatistics) super.clone();
  }

}
