/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Replication info of a table created using `AS REPLICA` DDL like: `CREATE MATERIALIZED VIEW mv1 AS
 * REPLICA OF src_mv`
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class TableReplicationInfo extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Output only. If source is a materialized view, this field signifies the last refresh
   * time of the source.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long replicatedSourceLastRefreshTime;

  /**
   * Optional. Output only. Replication error that will permanently stopped table replication.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private ErrorProto replicationError;

  /**
   * Optional. Specifies the interval at which the source table is polled for updates. It's
   * Optional. If not specified, default replication interval would be applied.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long replicationIntervalMs;

  /**
   * Optional. Output only. Replication status of configured replication.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String replicationStatus;

  /**
   * Required. Source table reference that is replicated.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference sourceTable;

  /**
   * Optional. Output only. If source is a materialized view, this field signifies the last refresh
   * time of the source.
   * @return value or {@code null} for none
   */
  public java.lang.Long getReplicatedSourceLastRefreshTime() {
    return replicatedSourceLastRefreshTime;
  }

  /**
   * Optional. Output only. If source is a materialized view, this field signifies the last refresh
   * time of the source.
   * @param replicatedSourceLastRefreshTime replicatedSourceLastRefreshTime or {@code null} for none
   */
  public TableReplicationInfo setReplicatedSourceLastRefreshTime(java.lang.Long replicatedSourceLastRefreshTime) {
    this.replicatedSourceLastRefreshTime = replicatedSourceLastRefreshTime;
    return this;
  }

  /**
   * Optional. Output only. Replication error that will permanently stopped table replication.
   * @return value or {@code null} for none
   */
  public ErrorProto getReplicationError() {
    return replicationError;
  }

  /**
   * Optional. Output only. Replication error that will permanently stopped table replication.
   * @param replicationError replicationError or {@code null} for none
   */
  public TableReplicationInfo setReplicationError(ErrorProto replicationError) {
    this.replicationError = replicationError;
    return this;
  }

  /**
   * Optional. Specifies the interval at which the source table is polled for updates. It's
   * Optional. If not specified, default replication interval would be applied.
   * @return value or {@code null} for none
   */
  public java.lang.Long getReplicationIntervalMs() {
    return replicationIntervalMs;
  }

  /**
   * Optional. Specifies the interval at which the source table is polled for updates. It's
   * Optional. If not specified, default replication interval would be applied.
   * @param replicationIntervalMs replicationIntervalMs or {@code null} for none
   */
  public TableReplicationInfo setReplicationIntervalMs(java.lang.Long replicationIntervalMs) {
    this.replicationIntervalMs = replicationIntervalMs;
    return this;
  }

  /**
   * Optional. Output only. Replication status of configured replication.
   * @return value or {@code null} for none
   */
  public java.lang.String getReplicationStatus() {
    return replicationStatus;
  }

  /**
   * Optional. Output only. Replication status of configured replication.
   * @param replicationStatus replicationStatus or {@code null} for none
   */
  public TableReplicationInfo setReplicationStatus(java.lang.String replicationStatus) {
    this.replicationStatus = replicationStatus;
    return this;
  }

  /**
   * Required. Source table reference that is replicated.
   * @return value or {@code null} for none
   */
  public TableReference getSourceTable() {
    return sourceTable;
  }

  /**
   * Required. Source table reference that is replicated.
   * @param sourceTable sourceTable or {@code null} for none
   */
  public TableReplicationInfo setSourceTable(TableReference sourceTable) {
    this.sourceTable = sourceTable;
    return this;
  }

  @Override
  public TableReplicationInfo set(String fieldName, Object value) {
    return (TableReplicationInfo) super.set(fieldName, value);
  }

  @Override
  public TableReplicationInfo clone() {
    return (TableReplicationInfo) super.clone();
  }

}
