/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Represents privacy policy that contains the privacy requirements specified by the data owner.
 * Currently, this is only supported on views.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PrivacyPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Optional. Policy used for aggregation thresholds.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private AggregationThresholdPolicy aggregationThresholdPolicy;

  /**
   * Optional. Policy used for differential privacy.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private DifferentialPrivacyPolicy differentialPrivacyPolicy;

  /**
   * Optional. Join restriction policy is outside of the one of policies, since this policy can be
   * set along with other policies. This policy gives data providers the ability to enforce joins on
   * the 'join_allowed_columns' when data is queried from a privacy protected view.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private JoinRestrictionPolicy joinRestrictionPolicy;

  /**
   * Optional. Policy used for aggregation thresholds.
   * @return value or {@code null} for none
   */
  public AggregationThresholdPolicy getAggregationThresholdPolicy() {
    return aggregationThresholdPolicy;
  }

  /**
   * Optional. Policy used for aggregation thresholds.
   * @param aggregationThresholdPolicy aggregationThresholdPolicy or {@code null} for none
   */
  public PrivacyPolicy setAggregationThresholdPolicy(AggregationThresholdPolicy aggregationThresholdPolicy) {
    this.aggregationThresholdPolicy = aggregationThresholdPolicy;
    return this;
  }

  /**
   * Optional. Policy used for differential privacy.
   * @return value or {@code null} for none
   */
  public DifferentialPrivacyPolicy getDifferentialPrivacyPolicy() {
    return differentialPrivacyPolicy;
  }

  /**
   * Optional. Policy used for differential privacy.
   * @param differentialPrivacyPolicy differentialPrivacyPolicy or {@code null} for none
   */
  public PrivacyPolicy setDifferentialPrivacyPolicy(DifferentialPrivacyPolicy differentialPrivacyPolicy) {
    this.differentialPrivacyPolicy = differentialPrivacyPolicy;
    return this;
  }

  /**
   * Optional. Join restriction policy is outside of the one of policies, since this policy can be
   * set along with other policies. This policy gives data providers the ability to enforce joins on
   * the 'join_allowed_columns' when data is queried from a privacy protected view.
   * @return value or {@code null} for none
   */
  public JoinRestrictionPolicy getJoinRestrictionPolicy() {
    return joinRestrictionPolicy;
  }

  /**
   * Optional. Join restriction policy is outside of the one of policies, since this policy can be
   * set along with other policies. This policy gives data providers the ability to enforce joins on
   * the 'join_allowed_columns' when data is queried from a privacy protected view.
   * @param joinRestrictionPolicy joinRestrictionPolicy or {@code null} for none
   */
  public PrivacyPolicy setJoinRestrictionPolicy(JoinRestrictionPolicy joinRestrictionPolicy) {
    this.joinRestrictionPolicy = joinRestrictionPolicy;
    return this;
  }

  @Override
  public PrivacyPolicy set(String fieldName, Object value) {
    return (PrivacyPolicy) super.set(fieldName, value);
  }

  @Override
  public PrivacyPolicy clone() {
    return (PrivacyPolicy) super.clone();
  }

}
