/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Performance insights for the job.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class PerformanceInsights extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Average execution ms of previous runs. Indicates the job ran slow compared to
   * previous executions. To find previous executions, use INFORMATION_SCHEMA tables and filter jobs
   * with same query hash.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long avgPreviousExecutionMs;

  /**
   * Output only. Query stage performance insights compared to previous runs, for diagnosing
   * performance regression.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StagePerformanceChangeInsight> stagePerformanceChangeInsights;

  /**
   * Output only. Standalone query stage performance insights, for exploring potential improvements.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StagePerformanceStandaloneInsight> stagePerformanceStandaloneInsights;

  /**
   * Output only. Average execution ms of previous runs. Indicates the job ran slow compared to
   * previous executions. To find previous executions, use INFORMATION_SCHEMA tables and filter jobs
   * with same query hash.
   * @return value or {@code null} for none
   */
  public java.lang.Long getAvgPreviousExecutionMs() {
    return avgPreviousExecutionMs;
  }

  /**
   * Output only. Average execution ms of previous runs. Indicates the job ran slow compared to
   * previous executions. To find previous executions, use INFORMATION_SCHEMA tables and filter jobs
   * with same query hash.
   * @param avgPreviousExecutionMs avgPreviousExecutionMs or {@code null} for none
   */
  public PerformanceInsights setAvgPreviousExecutionMs(java.lang.Long avgPreviousExecutionMs) {
    this.avgPreviousExecutionMs = avgPreviousExecutionMs;
    return this;
  }

  /**
   * Output only. Query stage performance insights compared to previous runs, for diagnosing
   * performance regression.
   * @return value or {@code null} for none
   */
  public java.util.List<StagePerformanceChangeInsight> getStagePerformanceChangeInsights() {
    return stagePerformanceChangeInsights;
  }

  /**
   * Output only. Query stage performance insights compared to previous runs, for diagnosing
   * performance regression.
   * @param stagePerformanceChangeInsights stagePerformanceChangeInsights or {@code null} for none
   */
  public PerformanceInsights setStagePerformanceChangeInsights(java.util.List<StagePerformanceChangeInsight> stagePerformanceChangeInsights) {
    this.stagePerformanceChangeInsights = stagePerformanceChangeInsights;
    return this;
  }

  /**
   * Output only. Standalone query stage performance insights, for exploring potential improvements.
   * @return value or {@code null} for none
   */
  public java.util.List<StagePerformanceStandaloneInsight> getStagePerformanceStandaloneInsights() {
    return stagePerformanceStandaloneInsights;
  }

  /**
   * Output only. Standalone query stage performance insights, for exploring potential improvements.
   * @param stagePerformanceStandaloneInsights stagePerformanceStandaloneInsights or {@code null} for none
   */
  public PerformanceInsights setStagePerformanceStandaloneInsights(java.util.List<StagePerformanceStandaloneInsight> stagePerformanceStandaloneInsights) {
    this.stagePerformanceStandaloneInsights = stagePerformanceStandaloneInsights;
    return this;
  }

  @Override
  public PerformanceInsights set(String fieldName, Object value) {
    return (PerformanceInsights) super.set(fieldName, value);
  }

  @Override
  public PerformanceInsights clone() {
    return (PerformanceInsights) super.clone();
  }

}
