/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Represents privacy policy associated with "differential privacy" method.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class DifferentialPrivacyPolicy extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The total delta budget for all queries against the privacy-protected view. Each
   * subscriber query against this view charges the amount of delta that is pre-defined by the
   * contributor through the privacy policy delta_per_query field. If there is sufficient budget,
   * then the subscriber query attempts to complete. It might still fail due to other reasons, in
   * which case the charge is refunded. If there is insufficient budget the query is rejected. There
   * might be multiple charge attempts if a single query references multiple views. In this case
   * there must be sufficient budget for all charges or the query is rejected and charges are
   * refunded in best effort. The budget does not have a refresh policy and can only be updated via
   * ALTER VIEW or circumvented by creating a new view that can be queried with a fresh budget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double deltaBudget;

  /**
   * Output only. The delta budget remaining. If budget is exhausted, no more queries are allowed.
   * Note that the budget for queries that are in progress is deducted before the query executes. If
   * the query fails or is cancelled then the budget is refunded. In this case the amount of budget
   * remaining can increase.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double deltaBudgetRemaining;

  /**
   * Optional. The delta value that is used per query. Delta represents the probability that any row
   * will fail to be epsilon differentially private. Indicates the risk associated with exposing
   * aggregate rows in the result of a query.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double deltaPerQuery;

  /**
   * Optional. The total epsilon budget for all queries against the privacy-protected view. Each
   * subscriber query against this view charges the amount of epsilon they request in their query.
   * If there is sufficient budget, then the subscriber query attempts to complete. It might still
   * fail due to other reasons, in which case the charge is refunded. If there is insufficient
   * budget the query is rejected. There might be multiple charge attempts if a single query
   * references multiple views. In this case there must be sufficient budget for all charges or the
   * query is rejected and charges are refunded in best effort. The budget does not have a refresh
   * policy and can only be updated via ALTER VIEW or circumvented by creating a new view that can
   * be queried with a fresh budget.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double epsilonBudget;

  /**
   * Output only. The epsilon budget remaining. If budget is exhausted, no more queries are allowed.
   * Note that the budget for queries that are in progress is deducted before the query executes. If
   * the query fails or is cancelled then the budget is refunded. In this case the amount of budget
   * remaining can increase.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double epsilonBudgetRemaining;

  /**
   * Optional. The maximum epsilon value that a query can consume. If the subscriber specifies
   * epsilon as a parameter in a SELECT query, it must be less than or equal to this value. The
   * epsilon parameter controls the amount of noise that is added to the groups — a higher epsilon
   * means less noise.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Double maxEpsilonPerQuery;

  /**
   * Optional. The maximum groups contributed value that is used per query. Represents the maximum
   * number of groups to which each protected entity can contribute. Changing this value does not
   * improve or worsen privacy. The best value for accuracy and utility depends on the query and
   * data.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long maxGroupsContributed;

  /**
   * Optional. The privacy unit column associated with this policy. Differential privacy policies
   * can only have one privacy unit column per data source object (table, view).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String privacyUnitColumn;

  /**
   * Optional. The total delta budget for all queries against the privacy-protected view. Each
   * subscriber query against this view charges the amount of delta that is pre-defined by the
   * contributor through the privacy policy delta_per_query field. If there is sufficient budget,
   * then the subscriber query attempts to complete. It might still fail due to other reasons, in
   * which case the charge is refunded. If there is insufficient budget the query is rejected. There
   * might be multiple charge attempts if a single query references multiple views. In this case
   * there must be sufficient budget for all charges or the query is rejected and charges are
   * refunded in best effort. The budget does not have a refresh policy and can only be updated via
   * ALTER VIEW or circumvented by creating a new view that can be queried with a fresh budget.
   * @return value or {@code null} for none
   */
  public java.lang.Double getDeltaBudget() {
    return deltaBudget;
  }

  /**
   * Optional. The total delta budget for all queries against the privacy-protected view. Each
   * subscriber query against this view charges the amount of delta that is pre-defined by the
   * contributor through the privacy policy delta_per_query field. If there is sufficient budget,
   * then the subscriber query attempts to complete. It might still fail due to other reasons, in
   * which case the charge is refunded. If there is insufficient budget the query is rejected. There
   * might be multiple charge attempts if a single query references multiple views. In this case
   * there must be sufficient budget for all charges or the query is rejected and charges are
   * refunded in best effort. The budget does not have a refresh policy and can only be updated via
   * ALTER VIEW or circumvented by creating a new view that can be queried with a fresh budget.
   * @param deltaBudget deltaBudget or {@code null} for none
   */
  public DifferentialPrivacyPolicy setDeltaBudget(java.lang.Double deltaBudget) {
    this.deltaBudget = deltaBudget;
    return this;
  }

  /**
   * Output only. The delta budget remaining. If budget is exhausted, no more queries are allowed.
   * Note that the budget for queries that are in progress is deducted before the query executes. If
   * the query fails or is cancelled then the budget is refunded. In this case the amount of budget
   * remaining can increase.
   * @return value or {@code null} for none
   */
  public java.lang.Double getDeltaBudgetRemaining() {
    return deltaBudgetRemaining;
  }

  /**
   * Output only. The delta budget remaining. If budget is exhausted, no more queries are allowed.
   * Note that the budget for queries that are in progress is deducted before the query executes. If
   * the query fails or is cancelled then the budget is refunded. In this case the amount of budget
   * remaining can increase.
   * @param deltaBudgetRemaining deltaBudgetRemaining or {@code null} for none
   */
  public DifferentialPrivacyPolicy setDeltaBudgetRemaining(java.lang.Double deltaBudgetRemaining) {
    this.deltaBudgetRemaining = deltaBudgetRemaining;
    return this;
  }

  /**
   * Optional. The delta value that is used per query. Delta represents the probability that any row
   * will fail to be epsilon differentially private. Indicates the risk associated with exposing
   * aggregate rows in the result of a query.
   * @return value or {@code null} for none
   */
  public java.lang.Double getDeltaPerQuery() {
    return deltaPerQuery;
  }

  /**
   * Optional. The delta value that is used per query. Delta represents the probability that any row
   * will fail to be epsilon differentially private. Indicates the risk associated with exposing
   * aggregate rows in the result of a query.
   * @param deltaPerQuery deltaPerQuery or {@code null} for none
   */
  public DifferentialPrivacyPolicy setDeltaPerQuery(java.lang.Double deltaPerQuery) {
    this.deltaPerQuery = deltaPerQuery;
    return this;
  }

  /**
   * Optional. The total epsilon budget for all queries against the privacy-protected view. Each
   * subscriber query against this view charges the amount of epsilon they request in their query.
   * If there is sufficient budget, then the subscriber query attempts to complete. It might still
   * fail due to other reasons, in which case the charge is refunded. If there is insufficient
   * budget the query is rejected. There might be multiple charge attempts if a single query
   * references multiple views. In this case there must be sufficient budget for all charges or the
   * query is rejected and charges are refunded in best effort. The budget does not have a refresh
   * policy and can only be updated via ALTER VIEW or circumvented by creating a new view that can
   * be queried with a fresh budget.
   * @return value or {@code null} for none
   */
  public java.lang.Double getEpsilonBudget() {
    return epsilonBudget;
  }

  /**
   * Optional. The total epsilon budget for all queries against the privacy-protected view. Each
   * subscriber query against this view charges the amount of epsilon they request in their query.
   * If there is sufficient budget, then the subscriber query attempts to complete. It might still
   * fail due to other reasons, in which case the charge is refunded. If there is insufficient
   * budget the query is rejected. There might be multiple charge attempts if a single query
   * references multiple views. In this case there must be sufficient budget for all charges or the
   * query is rejected and charges are refunded in best effort. The budget does not have a refresh
   * policy and can only be updated via ALTER VIEW or circumvented by creating a new view that can
   * be queried with a fresh budget.
   * @param epsilonBudget epsilonBudget or {@code null} for none
   */
  public DifferentialPrivacyPolicy setEpsilonBudget(java.lang.Double epsilonBudget) {
    this.epsilonBudget = epsilonBudget;
    return this;
  }

  /**
   * Output only. The epsilon budget remaining. If budget is exhausted, no more queries are allowed.
   * Note that the budget for queries that are in progress is deducted before the query executes. If
   * the query fails or is cancelled then the budget is refunded. In this case the amount of budget
   * remaining can increase.
   * @return value or {@code null} for none
   */
  public java.lang.Double getEpsilonBudgetRemaining() {
    return epsilonBudgetRemaining;
  }

  /**
   * Output only. The epsilon budget remaining. If budget is exhausted, no more queries are allowed.
   * Note that the budget for queries that are in progress is deducted before the query executes. If
   * the query fails or is cancelled then the budget is refunded. In this case the amount of budget
   * remaining can increase.
   * @param epsilonBudgetRemaining epsilonBudgetRemaining or {@code null} for none
   */
  public DifferentialPrivacyPolicy setEpsilonBudgetRemaining(java.lang.Double epsilonBudgetRemaining) {
    this.epsilonBudgetRemaining = epsilonBudgetRemaining;
    return this;
  }

  /**
   * Optional. The maximum epsilon value that a query can consume. If the subscriber specifies
   * epsilon as a parameter in a SELECT query, it must be less than or equal to this value. The
   * epsilon parameter controls the amount of noise that is added to the groups — a higher epsilon
   * means less noise.
   * @return value or {@code null} for none
   */
  public java.lang.Double getMaxEpsilonPerQuery() {
    return maxEpsilonPerQuery;
  }

  /**
   * Optional. The maximum epsilon value that a query can consume. If the subscriber specifies
   * epsilon as a parameter in a SELECT query, it must be less than or equal to this value. The
   * epsilon parameter controls the amount of noise that is added to the groups — a higher epsilon
   * means less noise.
   * @param maxEpsilonPerQuery maxEpsilonPerQuery or {@code null} for none
   */
  public DifferentialPrivacyPolicy setMaxEpsilonPerQuery(java.lang.Double maxEpsilonPerQuery) {
    this.maxEpsilonPerQuery = maxEpsilonPerQuery;
    return this;
  }

  /**
   * Optional. The maximum groups contributed value that is used per query. Represents the maximum
   * number of groups to which each protected entity can contribute. Changing this value does not
   * improve or worsen privacy. The best value for accuracy and utility depends on the query and
   * data.
   * @return value or {@code null} for none
   */
  public java.lang.Long getMaxGroupsContributed() {
    return maxGroupsContributed;
  }

  /**
   * Optional. The maximum groups contributed value that is used per query. Represents the maximum
   * number of groups to which each protected entity can contribute. Changing this value does not
   * improve or worsen privacy. The best value for accuracy and utility depends on the query and
   * data.
   * @param maxGroupsContributed maxGroupsContributed or {@code null} for none
   */
  public DifferentialPrivacyPolicy setMaxGroupsContributed(java.lang.Long maxGroupsContributed) {
    this.maxGroupsContributed = maxGroupsContributed;
    return this;
  }

  /**
   * Optional. The privacy unit column associated with this policy. Differential privacy policies
   * can only have one privacy unit column per data source object (table, view).
   * @return value or {@code null} for none
   */
  public java.lang.String getPrivacyUnitColumn() {
    return privacyUnitColumn;
  }

  /**
   * Optional. The privacy unit column associated with this policy. Differential privacy policies
   * can only have one privacy unit column per data source object (table, view).
   * @param privacyUnitColumn privacyUnitColumn or {@code null} for none
   */
  public DifferentialPrivacyPolicy setPrivacyUnitColumn(java.lang.String privacyUnitColumn) {
    this.privacyUnitColumn = privacyUnitColumn;
    return this;
  }

  @Override
  public DifferentialPrivacyPolicy set(String fieldName, Object value) {
    return (DifferentialPrivacyPolicy) super.set(fieldName, value);
  }

  @Override
  public DifferentialPrivacyPolicy clone() {
    return (DifferentialPrivacyPolicy) super.clone();
  }

}
