/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Indicates the stored columns usage in the query.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class StoredColumnsUsage extends com.google.api.client.json.GenericJson {

  /**
   * Specifies the base table.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TableReference baseTable;

  /**
   * Specifies whether the query was accelerated with stored columns.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean isQueryAccelerated;

  /**
   * If stored columns were not used, explain why.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.util.List<StoredColumnsUnusedReason> storedColumnsUnusedReasons;

  static {
    // hack to force ProGuard to consider StoredColumnsUnusedReason used, since otherwise it would be stripped out
    // see https://github.com/google/google-api-java-client/issues/543
    com.google.api.client.util.Data.nullOf(StoredColumnsUnusedReason.class);
  }

  /**
   * Specifies the base table.
   * @return value or {@code null} for none
   */
  public TableReference getBaseTable() {
    return baseTable;
  }

  /**
   * Specifies the base table.
   * @param baseTable baseTable or {@code null} for none
   */
  public StoredColumnsUsage setBaseTable(TableReference baseTable) {
    this.baseTable = baseTable;
    return this;
  }

  /**
   * Specifies whether the query was accelerated with stored columns.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getIsQueryAccelerated() {
    return isQueryAccelerated;
  }

  /**
   * Specifies whether the query was accelerated with stored columns.
   * @param isQueryAccelerated isQueryAccelerated or {@code null} for none
   */
  public StoredColumnsUsage setIsQueryAccelerated(java.lang.Boolean isQueryAccelerated) {
    this.isQueryAccelerated = isQueryAccelerated;
    return this;
  }

  /**
   * If stored columns were not used, explain why.
   * @return value or {@code null} for none
   */
  public java.util.List<StoredColumnsUnusedReason> getStoredColumnsUnusedReasons() {
    return storedColumnsUnusedReasons;
  }

  /**
   * If stored columns were not used, explain why.
   * @param storedColumnsUnusedReasons storedColumnsUnusedReasons or {@code null} for none
   */
  public StoredColumnsUsage setStoredColumnsUnusedReasons(java.util.List<StoredColumnsUnusedReason> storedColumnsUnusedReasons) {
    this.storedColumnsUnusedReasons = storedColumnsUnusedReasons;
    return this;
  }

  @Override
  public StoredColumnsUsage set(String fieldName, Object value) {
    return (StoredColumnsUsage) super.set(fieldName, value);
  }

  @Override
  public StoredColumnsUsage clone() {
    return (StoredColumnsUsage) super.clone();
  }

}
