/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * Options for external data sources.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AvroOptions extends com.google.api.client.json.GenericJson {

  /**
   * Optional. If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the
   * corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for
   * example, INTEGER).
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean useAvroLogicalTypes;

  /**
   * Optional. If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the
   * corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for
   * example, INTEGER).
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getUseAvroLogicalTypes() {
    return useAvroLogicalTypes;
  }

  /**
   * Optional. If sourceFormat is set to "AVRO", indicates whether to interpret logical types as the
   * corresponding BigQuery data type (for example, TIMESTAMP), instead of using the raw type (for
   * example, INTEGER).
   * @param useAvroLogicalTypes useAvroLogicalTypes or {@code null} for none
   */
  public AvroOptions setUseAvroLogicalTypes(java.lang.Boolean useAvroLogicalTypes) {
    this.useAvroLogicalTypes = useAvroLogicalTypes;
    return this;
  }

  @Override
  public AvroOptions set(String fieldName, Object value) {
    return (AvroOptions) super.set(fieldName, value);
  }

  @Override
  public AvroOptions clone() {
    return (AvroOptions) super.clone();
  }

}
