/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.bigquery.model;

/**
 * High cardinality join detailed information.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the BigQuery API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class HighCardinalityJoin extends com.google.api.client.json.GenericJson {

  /**
   * Output only. Count of left input rows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long leftRows;

  /**
   * Output only. Count of the output rows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long outputRows;

  /**
   * Output only. Count of right input rows.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key @com.google.api.client.json.JsonString
  private java.lang.Long rightRows;

  /**
   * Output only. The index of the join operator in the ExplainQueryStep lists.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Integer stepIndex;

  /**
   * Output only. Count of left input rows.
   * @return value or {@code null} for none
   */
  public java.lang.Long getLeftRows() {
    return leftRows;
  }

  /**
   * Output only. Count of left input rows.
   * @param leftRows leftRows or {@code null} for none
   */
  public HighCardinalityJoin setLeftRows(java.lang.Long leftRows) {
    this.leftRows = leftRows;
    return this;
  }

  /**
   * Output only. Count of the output rows.
   * @return value or {@code null} for none
   */
  public java.lang.Long getOutputRows() {
    return outputRows;
  }

  /**
   * Output only. Count of the output rows.
   * @param outputRows outputRows or {@code null} for none
   */
  public HighCardinalityJoin setOutputRows(java.lang.Long outputRows) {
    this.outputRows = outputRows;
    return this;
  }

  /**
   * Output only. Count of right input rows.
   * @return value or {@code null} for none
   */
  public java.lang.Long getRightRows() {
    return rightRows;
  }

  /**
   * Output only. Count of right input rows.
   * @param rightRows rightRows or {@code null} for none
   */
  public HighCardinalityJoin setRightRows(java.lang.Long rightRows) {
    this.rightRows = rightRows;
    return this;
  }

  /**
   * Output only. The index of the join operator in the ExplainQueryStep lists.
   * @return value or {@code null} for none
   */
  public java.lang.Integer getStepIndex() {
    return stepIndex;
  }

  /**
   * Output only. The index of the join operator in the ExplainQueryStep lists.
   * @param stepIndex stepIndex or {@code null} for none
   */
  public HighCardinalityJoin setStepIndex(java.lang.Integer stepIndex) {
    this.stepIndex = stepIndex;
    return this;
  }

  @Override
  public HighCardinalityJoin set(String fieldName, Object value) {
    return (HighCardinalityJoin) super.set(fieldName, value);
  }

  @Override
  public HighCardinalityJoin clone() {
    return (HighCardinalityJoin) super.clone();
  }

}
