/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.admin.reports;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.admin.reports.ReportsRequest;
import com.google.api.services.admin.reports.ReportsRequestInitializer;
import com.google.api.services.admin.reports.model.Channel;
import com.google.api.services.admin.reports.model.UsageReports;
import java.io.IOException;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reports
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "admin/reports/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/admin/reports/v1/";

    public Reports(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Reports(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Activities activities() {
        return new Activities();
    }

    public Channels channels() {
        return new Channels();
    }

    public CustomerUsageReports customerUsageReports() {
        return new CustomerUsageReports();
    }

    public UserUsageReport userUsageReport() {
        return new UserUsageReport();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.16.0-rc of the Admin Reports API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Reports.DEFAULT_ROOT_URL, Reports.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Reports build() {
            return new Reports(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setReportsRequestInitializer(ReportsRequestInitializer reportsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)reportsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class UserUsageReport {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Reports.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ReportsRequest<UsageReports> {
            private static final String REST_PATH = "usage/users/{userKey}/dates/{date}";
            private final Pattern DATE_PATTERN;
            private final Pattern PARAMETERS_PATTERN;
            private final Pattern FILTERS_PATTERN;
            private final Pattern CUSTOMERID_PATTERN;
            @Key
            private String userKey;
            @Key
            private String date;
            @Key
            private String parameters;
            @Key
            private Long maxResults;
            @Key
            private String pageToken;
            @Key
            private String filters;
            @Key
            private String customerId;

            protected Get(String string, String string2) {
                super(Reports.this, "GET", REST_PATH, null, UsageReports.class);
                this.DATE_PATTERN = Pattern.compile("(\\d){4}-(\\d){2}-(\\d){2}");
                this.PARAMETERS_PATTERN = Pattern.compile("(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+,)*(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+)");
                this.FILTERS_PATTERN = Pattern.compile("(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+[<,<=,==,>=,>,!=].+,)*(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+[<,<=,==,>=,>,!=].+)");
                this.CUSTOMERID_PATTERN = Pattern.compile("C.+");
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                this.date = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter date must be specified.");
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATE_PATTERN.matcher(string2).matches(), (Object)"Parameter date must conform to the pattern (\\d){4}-(\\d){2}-(\\d){2}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Get setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            public String getDate() {
                return this.date;
            }

            public Get setDate(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATE_PATTERN.matcher(string).matches(), (Object)"Parameter date must conform to the pattern (\\d){4}-(\\d){2}-(\\d){2}");
                }
                this.date = string;
                return this;
            }

            public String getParameters() {
                return this.parameters;
            }

            public Get setParameters(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARAMETERS_PATTERN.matcher(string).matches(), (Object)"Parameter parameters must conform to the pattern (((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+,)*(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+)");
                }
                this.parameters = string;
                return this;
            }

            public Long getMaxResults() {
                return this.maxResults;
            }

            public Get setMaxResults(Long l) {
                this.maxResults = l;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Get setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getFilters() {
                return this.filters;
            }

            public Get setFilters(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern (((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+[<,<=,==,>=,>,!=].+,)*(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+[<,<=,==,>=,>,!=].+)");
                }
                this.filters = string;
                return this;
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.CUSTOMERID_PATTERN.matcher(string).matches(), (Object)"Parameter customerId must conform to the pattern C.+");
                }
                this.customerId = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class CustomerUsageReports {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Reports.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends ReportsRequest<UsageReports> {
            private static final String REST_PATH = "usage/dates/{date}";
            private final Pattern DATE_PATTERN;
            private final Pattern CUSTOMERID_PATTERN;
            private final Pattern PARAMETERS_PATTERN;
            @Key
            private String date;
            @Key
            private String pageToken;
            @Key
            private String customerId;
            @Key
            private String parameters;

            protected Get(String string) {
                super(Reports.this, "GET", REST_PATH, null, UsageReports.class);
                this.DATE_PATTERN = Pattern.compile("(\\d){4}-(\\d){2}-(\\d){2}");
                this.CUSTOMERID_PATTERN = Pattern.compile("C.+");
                this.PARAMETERS_PATTERN = Pattern.compile("(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+,)*(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+)");
                this.date = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter date must be specified.");
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATE_PATTERN.matcher(string).matches(), (Object)"Parameter date must conform to the pattern (\\d){4}-(\\d){2}-(\\d){2}");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getDate() {
                return this.date;
            }

            public Get setDate(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.DATE_PATTERN.matcher(string).matches(), (Object)"Parameter date must conform to the pattern (\\d){4}-(\\d){2}-(\\d){2}");
                }
                this.date = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Get setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.CUSTOMERID_PATTERN.matcher(string).matches(), (Object)"Parameter customerId must conform to the pattern C.+");
                }
                this.customerId = string;
                return this;
            }

            public String getParameters() {
                return this.parameters;
            }

            public Get setParameters(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.PARAMETERS_PATTERN.matcher(string).matches(), (Object)"Parameter parameters must conform to the pattern (((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+,)*(((accounts)|(gmail)|(calendar)|(docs)|(gplus)):.+)");
                }
                this.parameters = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Channels {
        public Stop stop(Channel channel) throws IOException {
            Stop stop = new Stop(channel);
            Reports.this.initialize((AbstractGoogleClientRequest<?>)stop);
            return stop;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Stop
        extends ReportsRequest<Void> {
            private static final String REST_PATH = "/admin/reports_v1/channels/stop";

            protected Stop(Channel channel) {
                super(Reports.this, "POST", REST_PATH, (Object)channel, Void.class);
            }

            public Stop setAlt(String string) {
                return (Stop)super.setAlt(string);
            }

            public Stop setFields(String string) {
                return (Stop)super.setFields(string);
            }

            public Stop setKey(String string) {
                return (Stop)super.setKey(string);
            }

            public Stop setOauthToken(String string) {
                return (Stop)super.setOauthToken(string);
            }

            public Stop setPrettyPrint(Boolean bl) {
                return (Stop)super.setPrettyPrint(bl);
            }

            public Stop setQuotaUser(String string) {
                return (Stop)super.setQuotaUser(string);
            }

            public Stop setUserIp(String string) {
                return (Stop)super.setUserIp(string);
            }

            @Override
            public Stop set(String string, Object object) {
                return (Stop)super.set(string, object);
            }
        }
    }

    public class Activities {
        public List list(String string, String string2) throws IOException {
            List list = new List(string, string2);
            Reports.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Watch watch(String string, String string2, Channel channel) throws IOException {
            Watch watch = new Watch(string, string2, channel);
            Reports.this.initialize((AbstractGoogleClientRequest<?>)watch);
            return watch;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Watch
        extends ReportsRequest<Channel> {
            private static final String REST_PATH = "activity/users/{userKey}/applications/{applicationName}/watch";
            private final Pattern APPLICATIONNAME_PATTERN;
            private final Pattern STARTTIME_PATTERN;
            private final Pattern FILTERS_PATTERN;
            private final Pattern ENDTIME_PATTERN;
            private final Pattern CUSTOMERID_PATTERN;
            @Key
            private String userKey;
            @Key
            private String applicationName;
            @Key
            private String startTime;
            @Key
            private String actorIpAddress;
            @Key
            private Integer maxResults;
            @Key
            private String eventName;
            @Key
            private String pageToken;
            @Key
            private String filters;
            @Key
            private String endTime;
            @Key
            private String customerId;

            protected Watch(String string, String string2, Channel channel) {
                super(Reports.this, "POST", REST_PATH, (Object)channel, Channel.class);
                this.APPLICATIONNAME_PATTERN = Pattern.compile("(admin)|(docs)|(login)");
                this.STARTTIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:\\.(\\d+))?(?:(Z)|([-+])(\\d\\d):(\\d\\d))");
                this.FILTERS_PATTERN = Pattern.compile("(.+[<,<=,==,>=,>,<>].+,)*(.+[<,<=,==,>=,>,<>].+)");
                this.ENDTIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:\\.(\\d+))?(?:(Z)|([-+])(\\d\\d):(\\d\\d))");
                this.CUSTOMERID_PATTERN = Pattern.compile("C.+");
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                this.applicationName = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter applicationName must be specified.");
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.APPLICATIONNAME_PATTERN.matcher(string2).matches(), (Object)"Parameter applicationName must conform to the pattern (admin)|(docs)|(login)");
                }
            }

            public Watch setAlt(String string) {
                return (Watch)super.setAlt(string);
            }

            public Watch setFields(String string) {
                return (Watch)super.setFields(string);
            }

            public Watch setKey(String string) {
                return (Watch)super.setKey(string);
            }

            public Watch setOauthToken(String string) {
                return (Watch)super.setOauthToken(string);
            }

            public Watch setPrettyPrint(Boolean bl) {
                return (Watch)super.setPrettyPrint(bl);
            }

            public Watch setQuotaUser(String string) {
                return (Watch)super.setQuotaUser(string);
            }

            public Watch setUserIp(String string) {
                return (Watch)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Watch setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            public String getApplicationName() {
                return this.applicationName;
            }

            public Watch setApplicationName(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.APPLICATIONNAME_PATTERN.matcher(string).matches(), (Object)"Parameter applicationName must conform to the pattern (admin)|(docs)|(login)");
                }
                this.applicationName = string;
                return this;
            }

            public String getStartTime() {
                return this.startTime;
            }

            public Watch setStartTime(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.STARTTIME_PATTERN.matcher(string).matches(), (Object)"Parameter startTime must conform to the pattern (\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:\\.(\\d+))?(?:(Z)|([-+])(\\d\\d):(\\d\\d))");
                }
                this.startTime = string;
                return this;
            }

            public String getActorIpAddress() {
                return this.actorIpAddress;
            }

            public Watch setActorIpAddress(String string) {
                this.actorIpAddress = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public Watch setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getEventName() {
                return this.eventName;
            }

            public Watch setEventName(String string) {
                this.eventName = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public Watch setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getFilters() {
                return this.filters;
            }

            public Watch setFilters(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern (.+[<,<=,==,>=,>,<>].+,)*(.+[<,<=,==,>=,>,<>].+)");
                }
                this.filters = string;
                return this;
            }

            public String getEndTime() {
                return this.endTime;
            }

            public Watch setEndTime(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ENDTIME_PATTERN.matcher(string).matches(), (Object)"Parameter endTime must conform to the pattern (\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:\\.(\\d+))?(?:(Z)|([-+])(\\d\\d):(\\d\\d))");
                }
                this.endTime = string;
                return this;
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Watch setCustomerId(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.CUSTOMERID_PATTERN.matcher(string).matches(), (Object)"Parameter customerId must conform to the pattern C.+");
                }
                this.customerId = string;
                return this;
            }

            @Override
            public Watch set(String string, Object object) {
                return (Watch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends ReportsRequest<com.google.api.services.admin.reports.model.Activities> {
            private static final String REST_PATH = "activity/users/{userKey}/applications/{applicationName}";
            private final Pattern APPLICATIONNAME_PATTERN;
            private final Pattern STARTTIME_PATTERN;
            private final Pattern FILTERS_PATTERN;
            private final Pattern ENDTIME_PATTERN;
            private final Pattern CUSTOMERID_PATTERN;
            @Key
            private String userKey;
            @Key
            private String applicationName;
            @Key
            private String startTime;
            @Key
            private String actorIpAddress;
            @Key
            private Integer maxResults;
            @Key
            private String eventName;
            @Key
            private String pageToken;
            @Key
            private String filters;
            @Key
            private String endTime;
            @Key
            private String customerId;

            protected List(String string, String string2) {
                super(Reports.this, "GET", REST_PATH, null, com.google.api.services.admin.reports.model.Activities.class);
                this.APPLICATIONNAME_PATTERN = Pattern.compile("(admin)|(docs)|(login)");
                this.STARTTIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:\\.(\\d+))?(?:(Z)|([-+])(\\d\\d):(\\d\\d))");
                this.FILTERS_PATTERN = Pattern.compile("(.+[<,<=,==,>=,>,<>].+,)*(.+[<,<=,==,>=,>,<>].+)");
                this.ENDTIME_PATTERN = Pattern.compile("(\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:\\.(\\d+))?(?:(Z)|([-+])(\\d\\d):(\\d\\d))");
                this.CUSTOMERID_PATTERN = Pattern.compile("C.+");
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                this.applicationName = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter applicationName must be specified.");
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.APPLICATIONNAME_PATTERN.matcher(string2).matches(), (Object)"Parameter applicationName must conform to the pattern (admin)|(docs)|(login)");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            public String getApplicationName() {
                return this.applicationName;
            }

            public List setApplicationName(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.APPLICATIONNAME_PATTERN.matcher(string).matches(), (Object)"Parameter applicationName must conform to the pattern (admin)|(docs)|(login)");
                }
                this.applicationName = string;
                return this;
            }

            public String getStartTime() {
                return this.startTime;
            }

            public List setStartTime(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.STARTTIME_PATTERN.matcher(string).matches(), (Object)"Parameter startTime must conform to the pattern (\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:\\.(\\d+))?(?:(Z)|([-+])(\\d\\d):(\\d\\d))");
                }
                this.startTime = string;
                return this;
            }

            public String getActorIpAddress() {
                return this.actorIpAddress;
            }

            public List setActorIpAddress(String string) {
                this.actorIpAddress = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getEventName() {
                return this.eventName;
            }

            public List setEventName(String string) {
                this.eventName = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getFilters() {
                return this.filters;
            }

            public List setFilters(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.FILTERS_PATTERN.matcher(string).matches(), (Object)"Parameter filters must conform to the pattern (.+[<,<=,==,>=,>,<>].+,)*(.+[<,<=,==,>=,>,<>].+)");
                }
                this.filters = string;
                return this;
            }

            public String getEndTime() {
                return this.endTime;
            }

            public List setEndTime(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.ENDTIME_PATTERN.matcher(string).matches(), (Object)"Parameter endTime must conform to the pattern (\\d\\d\\d\\d)-(\\d\\d)-(\\d\\d)T(\\d\\d):(\\d\\d):(\\d\\d)(?:\\.(\\d+))?(?:(Z)|([-+])(\\d\\d):(\\d\\d))");
                }
                this.endTime = string;
                return this;
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String string) {
                if (!Reports.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.CUSTOMERID_PATTERN.matcher(string).matches(), (Object)"Parameter customerId must conform to the pattern C.+");
                }
                this.customerId = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }
    }
}

