/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.admin;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.admin.AdminRequest;
import com.google.api.services.admin.AdminRequestInitializer;
import com.google.api.services.admin.model.MailItem;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Admin
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "email/v2/users/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/email/v2/users/";

    public Admin(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Admin(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Mail mail() {
        return new Mail();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.15.0-rc of the Email Migration API v2 library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Admin.DEFAULT_ROOT_URL, Admin.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Admin build() {
            return new Admin(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setAdminRequestInitializer(AdminRequestInitializer adminRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)adminRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Mail {
        public Insert insert(String string, MailItem mailItem) throws IOException {
            Insert insert = new Insert(string, mailItem);
            Admin.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public Insert insert(String string, MailItem mailItem, AbstractInputStreamContent abstractInputStreamContent) throws IOException {
            Insert insert = new Insert(string, mailItem, abstractInputStreamContent);
            Admin.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends AdminRequest<Void> {
            private static final String REST_PATH = "{userKey}/mail";
            @Key
            private String userKey;

            protected Insert(String string, MailItem mailItem) {
                super(Admin.this, "POST", REST_PATH, (Object)mailItem, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            protected Insert(String string, MailItem mailItem, AbstractInputStreamContent abstractInputStreamContent) {
                super(Admin.this, "POST", "/upload/" + Admin.this.getServicePath() + REST_PATH, (Object)mailItem, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                this.initializeMediaUpload(abstractInputStreamContent);
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Insert setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }
    }
}

