/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.admin.directory;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.admin.directory.DirectoryRequest;
import com.google.api.services.admin.directory.DirectoryRequestInitializer;
import com.google.api.services.admin.directory.model.Alias;
import com.google.api.services.admin.directory.model.Aliases;
import com.google.api.services.admin.directory.model.ChromeOsDevice;
import com.google.api.services.admin.directory.model.ChromeOsDevices;
import com.google.api.services.admin.directory.model.Group;
import com.google.api.services.admin.directory.model.Member;
import com.google.api.services.admin.directory.model.MobileDevice;
import com.google.api.services.admin.directory.model.MobileDeviceAction;
import com.google.api.services.admin.directory.model.MobileDevices;
import com.google.api.services.admin.directory.model.OrgUnit;
import com.google.api.services.admin.directory.model.OrgUnits;
import com.google.api.services.admin.directory.model.User;
import com.google.api.services.admin.directory.model.UserMakeAdmin;
import com.google.api.services.admin.directory.model.UserPhoto;
import com.google.api.services.admin.directory.model.UserUndelete;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Directory
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://www.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "admin/directory/v1/";
    public static final String DEFAULT_BASE_URL = "https://www.googleapis.com/admin/directory/v1/";

    public Directory(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Directory(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public Chromeosdevices chromeosdevices() {
        return new Chromeosdevices();
    }

    public Groups groups() {
        return new Groups();
    }

    public Members members() {
        return new Members();
    }

    public Mobiledevices mobiledevices() {
        return new Mobiledevices();
    }

    public Orgunits orgunits() {
        return new Orgunits();
    }

    public Users users() {
        return new Users();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.16.0-rc of the Admin Directory API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, Directory.DEFAULT_ROOT_URL, Directory.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
        }

        public Directory build() {
            return new Directory(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setDirectoryRequestInitializer(DirectoryRequestInitializer directoryRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)directoryRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Users {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(User user) throws IOException {
            Insert insert = new Insert(user);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public MakeAdmin makeAdmin(String string, UserMakeAdmin userMakeAdmin) throws IOException {
            MakeAdmin makeAdmin = new MakeAdmin(string, userMakeAdmin);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)makeAdmin);
            return makeAdmin;
        }

        public Patch patch(String string, User user) throws IOException {
            Patch patch = new Patch(string, user);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Undelete undelete(String string, UserUndelete userUndelete) throws IOException {
            Undelete undelete = new Undelete(string, userUndelete);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)undelete);
            return undelete;
        }

        public Update update(String string, User user) throws IOException {
            Update update = new Update(string, user);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Aliases aliases() {
            return new Aliases();
        }

        public Photos photos() {
            return new Photos();
        }

        public class Photos {
            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public Patch patch(String string, UserPhoto userPhoto) throws IOException {
                Patch patch = new Patch(string, userPhoto);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Update update(String string, UserPhoto userPhoto) throws IOException {
                Update update = new Update(string, userPhoto);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Update(String string, UserPhoto userPhoto) {
                    super(Directory.this, "PUT", REST_PATH, (Object)userPhoto, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                    this.checkRequiredParameter((Object)userPhoto, "content");
                    this.checkRequiredParameter(userPhoto.getPhotoData(), "UserPhoto.getPhotoData()");
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUserIp(String string) {
                    return (Update)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Update setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Patch(String string, UserPhoto userPhoto) {
                    super(Directory.this, "PATCH", REST_PATH, (Object)userPhoto, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUserIp(String string) {
                    return (Patch)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Patch setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends DirectoryRequest<UserPhoto> {
                private static final String REST_PATH = "users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Get(String string) {
                    super(Directory.this, "GET", REST_PATH, null, UserPhoto.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUserIp(String string) {
                    return (Get)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Get setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "users/{userKey}/photos/thumbnail";
                @Key
                private String userKey;

                protected Delete(String string) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Delete setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        public class Aliases {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Insert insert(String string, Alias alias) throws IOException {
                Insert insert = new Insert(string, alias);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DirectoryRequest<com.google.api.services.admin.directory.model.Aliases> {
                private static final String REST_PATH = "users/{userKey}/aliases";
                @Key
                private String userKey;

                protected List(String string) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Aliases.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public List setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends DirectoryRequest<Alias> {
                private static final String REST_PATH = "users/{userKey}/aliases";
                @Key
                private String userKey;

                protected Insert(String string, Alias alias) {
                    super(Directory.this, "POST", REST_PATH, (Object)alias, Alias.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Insert setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "users/{userKey}/aliases/{alias}";
                @Key
                private String userKey;
                @Key
                private String alias;

                protected Delete(String string, String string2) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
                    this.alias = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter alias must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getUserKey() {
                    return this.userKey;
                }

                public Delete setUserKey(String string) {
                    this.userKey = string;
                    return this;
                }

                public String getAlias() {
                    return this.alias;
                }

                public Delete setAlias(String string) {
                    this.alias = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "users/{userKey}";
            @Key
            private String userKey;

            protected Update(String string, User user) {
                super(Directory.this, "PUT", REST_PATH, (Object)user, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Update setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Undelete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}/undelete";
            @Key
            private String userKey;

            protected Undelete(String string, UserUndelete userUndelete) {
                super(Directory.this, "POST", REST_PATH, (Object)userUndelete, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Undelete setAlt(String string) {
                return (Undelete)super.setAlt(string);
            }

            public Undelete setFields(String string) {
                return (Undelete)super.setFields(string);
            }

            public Undelete setKey(String string) {
                return (Undelete)super.setKey(string);
            }

            public Undelete setOauthToken(String string) {
                return (Undelete)super.setOauthToken(string);
            }

            public Undelete setPrettyPrint(Boolean bl) {
                return (Undelete)super.setPrettyPrint(bl);
            }

            public Undelete setQuotaUser(String string) {
                return (Undelete)super.setQuotaUser(string);
            }

            public Undelete setUserIp(String string) {
                return (Undelete)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Undelete setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Undelete set(String string, Object object) {
                return (Undelete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "users/{userKey}";
            @Key
            private String userKey;

            protected Patch(String string, User user) {
                super(Directory.this, "PATCH", REST_PATH, (Object)user, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Patch setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class MakeAdmin
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}/makeAdmin";
            @Key
            private String userKey;

            protected MakeAdmin(String string, UserMakeAdmin userMakeAdmin) {
                super(Directory.this, "POST", REST_PATH, (Object)userMakeAdmin, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public MakeAdmin setAlt(String string) {
                return (MakeAdmin)super.setAlt(string);
            }

            public MakeAdmin setFields(String string) {
                return (MakeAdmin)super.setFields(string);
            }

            public MakeAdmin setKey(String string) {
                return (MakeAdmin)super.setKey(string);
            }

            public MakeAdmin setOauthToken(String string) {
                return (MakeAdmin)super.setOauthToken(string);
            }

            public MakeAdmin setPrettyPrint(Boolean bl) {
                return (MakeAdmin)super.setPrettyPrint(bl);
            }

            public MakeAdmin setQuotaUser(String string) {
                return (MakeAdmin)super.setQuotaUser(string);
            }

            public MakeAdmin setUserIp(String string) {
                return (MakeAdmin)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public MakeAdmin setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public MakeAdmin set(String string, Object object) {
                return (MakeAdmin)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Users> {
            private static final String REST_PATH = "users";
            @Key
            private String customer;
            @Key
            private String orderBy;
            @Key
            private String domain;
            @Key
            private String showDeleted;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortOrder;
            @Key
            private String query;

            protected List() {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Users.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getDomain() {
                return this.domain;
            }

            public List setDomain(String string) {
                this.domain = string;
                return this;
            }

            public String getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(String string) {
                this.showDeleted = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String string) {
                this.query = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "users";

            protected Insert(User user) {
                super(Directory.this, "POST", REST_PATH, (Object)user, User.class);
                this.checkRequiredParameter((Object)user, "content");
                this.checkRequiredParameter(user.getPassword(), "User.getPassword()");
                this.checkRequiredParameter((Object)user, "content");
                this.checkRequiredParameter(user.getPrimaryEmail(), "User.getPrimaryEmail()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<User> {
            private static final String REST_PATH = "users/{userKey}";
            @Key
            private String userKey;

            protected Get(String string) {
                super(Directory.this, "GET", REST_PATH, null, User.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Get setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "users/{userKey}";
            @Key
            private String userKey;

            protected Delete(String string) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.userKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter userKey must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getUserKey() {
                return this.userKey;
            }

            public Delete setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Orgunits {
        public Delete delete(String string, java.util.List<String> list) throws IOException {
            Delete delete = new Delete(string, list);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, java.util.List<String> list) throws IOException {
            Get get = new Get(string, list);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, OrgUnit orgUnit) throws IOException {
            Insert insert = new Insert(string, orgUnit);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, java.util.List<String> list, OrgUnit orgUnit) throws IOException {
            Patch patch = new Patch(string, list, orgUnit);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, java.util.List<String> list, OrgUnit orgUnit) throws IOException {
            Update update = new Update(string, list, orgUnit);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "customer/{customerId}/orgunits{/orgUnitPath*}";
            @Key
            private String customerId;
            @Key
            private java.util.List<String> orgUnitPath;

            protected Update(String string, java.util.List<String> list, OrgUnit orgUnit) {
                super(Directory.this, "PUT", REST_PATH, (Object)orgUnit, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Update setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public java.util.List<String> getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Update setOrgUnitPath(java.util.List<String> list) {
                this.orgUnitPath = list;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "customer/{customerId}/orgunits{/orgUnitPath*}";
            @Key
            private String customerId;
            @Key
            private java.util.List<String> orgUnitPath;

            protected Patch(String string, java.util.List<String> list, OrgUnit orgUnit) {
                super(Directory.this, "PATCH", REST_PATH, (Object)orgUnit, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Patch setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public java.util.List<String> getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Patch setOrgUnitPath(java.util.List<String> list) {
                this.orgUnitPath = list;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<OrgUnits> {
            private static final String REST_PATH = "customer/{customerId}/orgunits";
            @Key
            private String customerId;
            @Key
            private String type;
            @Key
            private String orgUnitPath;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, OrgUnits.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getType() {
                return this.type;
            }

            public List setType(String string) {
                this.type = string;
                return this;
            }

            public String getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public List setOrgUnitPath(String string) {
                this.orgUnitPath = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "customer/{customerId}/orgunits";
            @Key
            private String customerId;

            protected Insert(String string, OrgUnit orgUnit) {
                super(Directory.this, "POST", REST_PATH, (Object)orgUnit, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.checkRequiredParameter((Object)orgUnit, "content");
                this.checkRequiredParameter(orgUnit.getName(), "OrgUnit.getName()");
                this.checkRequiredParameter((Object)orgUnit, "content");
                this.checkRequiredParameter(orgUnit.getParentOrgUnitPath(), "OrgUnit.getParentOrgUnitPath()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Insert setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<OrgUnit> {
            private static final String REST_PATH = "customer/{customerId}/orgunits{/orgUnitPath*}";
            @Key
            private String customerId;
            @Key
            private java.util.List<String> orgUnitPath;

            protected Get(String string, java.util.List<String> list) {
                super(Directory.this, "GET", REST_PATH, null, OrgUnit.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public java.util.List<String> getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Get setOrgUnitPath(java.util.List<String> list) {
                this.orgUnitPath = list;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/orgunits{/orgUnitPath*}";
            @Key
            private String customerId;
            @Key
            private java.util.List<String> orgUnitPath;

            protected Delete(String string, java.util.List<String> list) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.orgUnitPath = (java.util.List)Preconditions.checkNotNull(list, (Object)"Required parameter orgUnitPath must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Delete setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public java.util.List<String> getOrgUnitPath() {
                return this.orgUnitPath;
            }

            public Delete setOrgUnitPath(java.util.List<String> list) {
                this.orgUnitPath = list;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Mobiledevices {
        public Action action(String string, String string2, MobileDeviceAction mobileDeviceAction) throws IOException {
            Action action = new Action(string, string2, mobileDeviceAction);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)action);
            return action;
        }

        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<MobileDevices> {
            private static final String REST_PATH = "customer/{customerId}/devices/mobile";
            @Key
            private String customerId;
            @Key
            private String orderBy;
            @Key
            private String projection;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortOrder;
            @Key
            private String query;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, MobileDevices.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String string) {
                this.query = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<MobileDevice> {
            private static final String REST_PATH = "customer/{customerId}/devices/mobile/{resourceId}";
            @Key
            private String customerId;
            @Key
            private String resourceId;
            @Key
            private String projection;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, MobileDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resourceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Get setResourceId(String string) {
                this.resourceId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/devices/mobile/{resourceId}";
            @Key
            private String customerId;
            @Key
            private String resourceId;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resourceId must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Delete setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Delete setResourceId(String string) {
                this.resourceId = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Action
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "customer/{customerId}/devices/mobile/{resourceId}/action";
            @Key
            private String customerId;
            @Key
            private String resourceId;

            protected Action(String string, String string2, MobileDeviceAction mobileDeviceAction) {
                super(Directory.this, "POST", REST_PATH, (Object)mobileDeviceAction, Void.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.resourceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter resourceId must be specified.");
            }

            public Action setAlt(String string) {
                return (Action)super.setAlt(string);
            }

            public Action setFields(String string) {
                return (Action)super.setFields(string);
            }

            public Action setKey(String string) {
                return (Action)super.setKey(string);
            }

            public Action setOauthToken(String string) {
                return (Action)super.setOauthToken(string);
            }

            public Action setPrettyPrint(Boolean bl) {
                return (Action)super.setPrettyPrint(bl);
            }

            public Action setQuotaUser(String string) {
                return (Action)super.setQuotaUser(string);
            }

            public Action setUserIp(String string) {
                return (Action)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Action setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getResourceId() {
                return this.resourceId;
            }

            public Action setResourceId(String string) {
                this.resourceId = string;
                return this;
            }

            @Override
            public Action set(String string, Object object) {
                return (Action)super.set(string, object);
            }
        }
    }

    public class Members {
        public Delete delete(String string, String string2) throws IOException {
            Delete delete = new Delete(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(String string, Member member) throws IOException {
            Insert insert = new Insert(string, member);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, Member member) throws IOException {
            Patch patch = new Patch(string, string2, member);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, Member member) throws IOException {
            Update update = new Update(string, string2, member);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Update(String string, String string2, Member member) {
                super(Directory.this, "PUT", REST_PATH, (Object)member, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Update setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Update setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Patch(String string, String string2, Member member) {
                super(Directory.this, "PATCH", REST_PATH, (Object)member, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Patch setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Patch setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Members> {
            private static final String REST_PATH = "groups/{groupKey}/members";
            @Key
            private String groupKey;
            @Key
            private String pageToken;
            @Key
            private String roles;
            @Key
            private Integer maxResults;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Members.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public List setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getRoles() {
                return this.roles;
            }

            public List setRoles(String string) {
                this.roles = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "groups/{groupKey}/members";
            @Key
            private String groupKey;

            protected Insert(String string, Member member) {
                super(Directory.this, "POST", REST_PATH, (Object)member, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Insert setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Member> {
            private static final String REST_PATH = "groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, Member.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Get setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Get setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "groups/{groupKey}/members/{memberKey}";
            @Key
            private String groupKey;
            @Key
            private String memberKey;

            protected Delete(String string, String string2) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                this.memberKey = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter memberKey must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Delete setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            public String getMemberKey() {
                return this.memberKey;
            }

            public Delete setMemberKey(String string) {
                this.memberKey = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Groups {
        public Delete delete(String string) throws IOException {
            Delete delete = new Delete(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
            return delete;
        }

        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public Insert insert(Group group) throws IOException {
            Insert insert = new Insert(group);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
            return insert;
        }

        public List list() throws IOException {
            List list = new List();
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, Group group) throws IOException {
            Patch patch = new Patch(string, group);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, Group group) throws IOException {
            Update update = new Update(string, group);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        public Aliases aliases() {
            return new Aliases();
        }

        public class Aliases {
            public Delete delete(String string, String string2) throws IOException {
                Delete delete = new Delete(string, string2);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Insert insert(String string, Alias alias) throws IOException {
                Insert insert = new Insert(string, alias);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)insert);
                return insert;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends DirectoryRequest<com.google.api.services.admin.directory.model.Aliases> {
                private static final String REST_PATH = "groups/{groupKey}/aliases";
                @Key
                private String groupKey;

                protected List(String string) {
                    super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Aliases.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUserIp(String string) {
                    return (List)super.setUserIp(string);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public List setGroupKey(String string) {
                    this.groupKey = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Insert
            extends DirectoryRequest<Alias> {
                private static final String REST_PATH = "groups/{groupKey}/aliases";
                @Key
                private String groupKey;

                protected Insert(String string, Alias alias) {
                    super(Directory.this, "POST", REST_PATH, (Object)alias, Alias.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                }

                public Insert setAlt(String string) {
                    return (Insert)super.setAlt(string);
                }

                public Insert setFields(String string) {
                    return (Insert)super.setFields(string);
                }

                public Insert setKey(String string) {
                    return (Insert)super.setKey(string);
                }

                public Insert setOauthToken(String string) {
                    return (Insert)super.setOauthToken(string);
                }

                public Insert setPrettyPrint(Boolean bl) {
                    return (Insert)super.setPrettyPrint(bl);
                }

                public Insert setQuotaUser(String string) {
                    return (Insert)super.setQuotaUser(string);
                }

                public Insert setUserIp(String string) {
                    return (Insert)super.setUserIp(string);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public Insert setGroupKey(String string) {
                    this.groupKey = string;
                    return this;
                }

                @Override
                public Insert set(String string, Object object) {
                    return (Insert)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends DirectoryRequest<Void> {
                private static final String REST_PATH = "groups/{groupKey}/aliases/{alias}";
                @Key
                private String groupKey;
                @Key
                private String alias;

                protected Delete(String string, String string2) {
                    super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                    this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
                    this.alias = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter alias must be specified.");
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUserIp(String string) {
                    return (Delete)super.setUserIp(string);
                }

                public String getGroupKey() {
                    return this.groupKey;
                }

                public Delete setGroupKey(String string) {
                    this.groupKey = string;
                    return this;
                }

                public String getAlias() {
                    return this.alias;
                }

                public Delete setAlias(String string) {
                    this.alias = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "groups/{groupKey}";
            @Key
            private String groupKey;

            protected Update(String string, Group group) {
                super(Directory.this, "PUT", REST_PATH, (Object)group, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Update setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "groups/{groupKey}";
            @Key
            private String groupKey;

            protected Patch(String string, Group group) {
                super(Directory.this, "PATCH", REST_PATH, (Object)group, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Patch setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<com.google.api.services.admin.directory.model.Groups> {
            private static final String REST_PATH = "groups";
            @Key
            private String customer;
            @Key
            private String pageToken;
            @Key
            private String domain;
            @Key
            private Integer maxResults;
            @Key
            private String userKey;

            protected List() {
                super(Directory.this, "GET", REST_PATH, null, com.google.api.services.admin.directory.model.Groups.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomer() {
                return this.customer;
            }

            public List setCustomer(String string) {
                this.customer = string;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getDomain() {
                return this.domain;
            }

            public List setDomain(String string) {
                this.domain = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getUserKey() {
                return this.userKey;
            }

            public List setUserKey(String string) {
                this.userKey = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Insert
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "groups";

            protected Insert(Group group) {
                super(Directory.this, "POST", REST_PATH, (Object)group, Group.class);
                this.checkRequiredParameter((Object)group, "content");
                this.checkRequiredParameter(group.getEmail(), "Group.getEmail()");
            }

            public Insert setAlt(String string) {
                return (Insert)super.setAlt(string);
            }

            public Insert setFields(String string) {
                return (Insert)super.setFields(string);
            }

            public Insert setKey(String string) {
                return (Insert)super.setKey(string);
            }

            public Insert setOauthToken(String string) {
                return (Insert)super.setOauthToken(string);
            }

            public Insert setPrettyPrint(Boolean bl) {
                return (Insert)super.setPrettyPrint(bl);
            }

            public Insert setQuotaUser(String string) {
                return (Insert)super.setQuotaUser(string);
            }

            public Insert setUserIp(String string) {
                return (Insert)super.setUserIp(string);
            }

            @Override
            public Insert set(String string, Object object) {
                return (Insert)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<Group> {
            private static final String REST_PATH = "groups/{groupKey}";
            @Key
            private String groupKey;

            protected Get(String string) {
                super(Directory.this, "GET", REST_PATH, null, Group.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Get setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Delete
        extends DirectoryRequest<Void> {
            private static final String REST_PATH = "groups/{groupKey}";
            @Key
            private String groupKey;

            protected Delete(String string) {
                super(Directory.this, "DELETE", REST_PATH, null, Void.class);
                this.groupKey = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter groupKey must be specified.");
            }

            public Delete setAlt(String string) {
                return (Delete)super.setAlt(string);
            }

            public Delete setFields(String string) {
                return (Delete)super.setFields(string);
            }

            public Delete setKey(String string) {
                return (Delete)super.setKey(string);
            }

            public Delete setOauthToken(String string) {
                return (Delete)super.setOauthToken(string);
            }

            public Delete setPrettyPrint(Boolean bl) {
                return (Delete)super.setPrettyPrint(bl);
            }

            public Delete setQuotaUser(String string) {
                return (Delete)super.setQuotaUser(string);
            }

            public Delete setUserIp(String string) {
                return (Delete)super.setUserIp(string);
            }

            public String getGroupKey() {
                return this.groupKey;
            }

            public Delete setGroupKey(String string) {
                this.groupKey = string;
                return this;
            }

            @Override
            public Delete set(String string, Object object) {
                return (Delete)super.set(string, object);
            }
        }
    }

    public class Chromeosdevices {
        public Get get(String string, String string2) throws IOException {
            Get get = new Get(string, string2);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list(String string) throws IOException {
            List list = new List(string);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public Patch patch(String string, String string2, ChromeOsDevice chromeOsDevice) throws IOException {
            Patch patch = new Patch(string, string2, chromeOsDevice);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)patch);
            return patch;
        }

        public Update update(String string, String string2, ChromeOsDevice chromeOsDevice) throws IOException {
            Update update = new Update(string, string2, chromeOsDevice);
            Directory.this.initialize((AbstractGoogleClientRequest<?>)update);
            return update;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Update
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Update(String string, String string2, ChromeOsDevice chromeOsDevice) {
                super(Directory.this, "PUT", REST_PATH, (Object)chromeOsDevice, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deviceId must be specified.");
            }

            public Update setAlt(String string) {
                return (Update)super.setAlt(string);
            }

            public Update setFields(String string) {
                return (Update)super.setFields(string);
            }

            public Update setKey(String string) {
                return (Update)super.setKey(string);
            }

            public Update setOauthToken(String string) {
                return (Update)super.setOauthToken(string);
            }

            public Update setPrettyPrint(Boolean bl) {
                return (Update)super.setPrettyPrint(bl);
            }

            public Update setQuotaUser(String string) {
                return (Update)super.setQuotaUser(string);
            }

            public Update setUserIp(String string) {
                return (Update)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Update setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Update setDeviceId(String string) {
                this.deviceId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Update setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Update set(String string, Object object) {
                return (Update)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Patch
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Patch(String string, String string2, ChromeOsDevice chromeOsDevice) {
                super(Directory.this, "PATCH", REST_PATH, (Object)chromeOsDevice, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deviceId must be specified.");
            }

            public Patch setAlt(String string) {
                return (Patch)super.setAlt(string);
            }

            public Patch setFields(String string) {
                return (Patch)super.setFields(string);
            }

            public Patch setKey(String string) {
                return (Patch)super.setKey(string);
            }

            public Patch setOauthToken(String string) {
                return (Patch)super.setOauthToken(string);
            }

            public Patch setPrettyPrint(Boolean bl) {
                return (Patch)super.setPrettyPrint(bl);
            }

            public Patch setQuotaUser(String string) {
                return (Patch)super.setQuotaUser(string);
            }

            public Patch setUserIp(String string) {
                return (Patch)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Patch setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Patch setDeviceId(String string) {
                this.deviceId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Patch setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Patch set(String string, Object object) {
                return (Patch)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends DirectoryRequest<ChromeOsDevices> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos";
            @Key
            private String customerId;
            @Key
            private String orderBy;
            @Key
            private String projection;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private String sortOrder;
            @Key
            private String query;

            protected List(String string) {
                super(Directory.this, "GET", REST_PATH, null, ChromeOsDevices.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUserIp(String string) {
                return (List)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public List setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getOrderBy() {
                return this.orderBy;
            }

            public List setOrderBy(String string) {
                this.orderBy = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public List setProjection(String string) {
                this.projection = string;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer n) {
                this.maxResults = n;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public String getSortOrder() {
                return this.sortOrder;
            }

            public List setSortOrder(String string) {
                this.sortOrder = string;
                return this;
            }

            public String getQuery() {
                return this.query;
            }

            public List setQuery(String string) {
                this.query = string;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends DirectoryRequest<ChromeOsDevice> {
            private static final String REST_PATH = "customer/{customerId}/devices/chromeos/{deviceId}";
            @Key
            private String customerId;
            @Key
            private String deviceId;
            @Key
            private String projection;

            protected Get(String string, String string2) {
                super(Directory.this, "GET", REST_PATH, null, ChromeOsDevice.class);
                this.customerId = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter customerId must be specified.");
                this.deviceId = (String)Preconditions.checkNotNull((Object)string2, (Object)"Required parameter deviceId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUserIp(String string) {
                return (Get)super.setUserIp(string);
            }

            public String getCustomerId() {
                return this.customerId;
            }

            public Get setCustomerId(String string) {
                this.customerId = string;
                return this;
            }

            public String getDeviceId() {
                return this.deviceId;
            }

            public Get setDeviceId(String string) {
                this.deviceId = string;
                return this;
            }

            public String getProjection() {
                return this.projection;
            }

            public Get setProjection(String string) {
                this.projection = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }
}

