/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.8
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * A list of chips layed out horizontally, which can either scroll horizontally
 * or wrap to the next line.
 *
 * [Google Workspace add-ons and Chat
 * apps](https://developers.google.com/workspace/extend):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.ChipList}
 */
public final class ChipList extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.ChipList)
    ChipListOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ChipList.newBuilder() to construct.
  private ChipList(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ChipList() {
    layout_ = 0;
    chips_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ChipList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_ChipList_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_ChipList_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.ChipList.class, com.google.apps.card.v1.ChipList.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The chip list layout.
   * </pre>
   *
   * Protobuf enum {@code google.apps.card.v1.ChipList.Layout}
   */
  public enum Layout implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Don't use. Unspecified.
     * </pre>
     *
     * <code>LAYOUT_UNSPECIFIED = 0;</code>
     */
    LAYOUT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Default value. The chip list wraps to the next line if there isn't enough
     * horizontal space.
     * </pre>
     *
     * <code>WRAPPED = 1;</code>
     */
    WRAPPED(1),
    /**
     *
     *
     * <pre>
     * The chips scroll horizontally if they don't fit in the available space.
     * </pre>
     *
     * <code>HORIZONTAL_SCROLLABLE = 2;</code>
     */
    HORIZONTAL_SCROLLABLE(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Don't use. Unspecified.
     * </pre>
     *
     * <code>LAYOUT_UNSPECIFIED = 0;</code>
     */
    public static final int LAYOUT_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Default value. The chip list wraps to the next line if there isn't enough
     * horizontal space.
     * </pre>
     *
     * <code>WRAPPED = 1;</code>
     */
    public static final int WRAPPED_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The chips scroll horizontally if they don't fit in the available space.
     * </pre>
     *
     * <code>HORIZONTAL_SCROLLABLE = 2;</code>
     */
    public static final int HORIZONTAL_SCROLLABLE_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Layout valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Layout forNumber(int value) {
      switch (value) {
        case 0:
          return LAYOUT_UNSPECIFIED;
        case 1:
          return WRAPPED;
        case 2:
          return HORIZONTAL_SCROLLABLE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Layout> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Layout> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Layout>() {
          public Layout findValueByNumber(int number) {
            return Layout.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.apps.card.v1.ChipList.getDescriptor().getEnumTypes().get(0);
    }

    private static final Layout[] VALUES = values();

    public static Layout valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Layout(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.apps.card.v1.ChipList.Layout)
  }

  public static final int LAYOUT_FIELD_NUMBER = 1;
  private int layout_ = 0;

  /**
   *
   *
   * <pre>
   * Specified chip list layout.
   * </pre>
   *
   * <code>.google.apps.card.v1.ChipList.Layout layout = 1;</code>
   *
   * @return The enum numeric value on the wire for layout.
   */
  @java.lang.Override
  public int getLayoutValue() {
    return layout_;
  }

  /**
   *
   *
   * <pre>
   * Specified chip list layout.
   * </pre>
   *
   * <code>.google.apps.card.v1.ChipList.Layout layout = 1;</code>
   *
   * @return The layout.
   */
  @java.lang.Override
  public com.google.apps.card.v1.ChipList.Layout getLayout() {
    com.google.apps.card.v1.ChipList.Layout result =
        com.google.apps.card.v1.ChipList.Layout.forNumber(layout_);
    return result == null ? com.google.apps.card.v1.ChipList.Layout.UNRECOGNIZED : result;
  }

  public static final int CHIPS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.apps.card.v1.Chip> chips_;

  /**
   *
   *
   * <pre>
   * An array of chips.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.apps.card.v1.Chip> getChipsList() {
    return chips_;
  }

  /**
   *
   *
   * <pre>
   * An array of chips.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.apps.card.v1.ChipOrBuilder> getChipsOrBuilderList() {
    return chips_;
  }

  /**
   *
   *
   * <pre>
   * An array of chips.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
   */
  @java.lang.Override
  public int getChipsCount() {
    return chips_.size();
  }

  /**
   *
   *
   * <pre>
   * An array of chips.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Chip getChips(int index) {
    return chips_.get(index);
  }

  /**
   *
   *
   * <pre>
   * An array of chips.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.ChipOrBuilder getChipsOrBuilder(int index) {
    return chips_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (layout_ != com.google.apps.card.v1.ChipList.Layout.LAYOUT_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, layout_);
    }
    for (int i = 0; i < chips_.size(); i++) {
      output.writeMessage(2, chips_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (layout_ != com.google.apps.card.v1.ChipList.Layout.LAYOUT_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, layout_);
    }
    for (int i = 0; i < chips_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, chips_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.ChipList)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.ChipList other = (com.google.apps.card.v1.ChipList) obj;

    if (layout_ != other.layout_) return false;
    if (!getChipsList().equals(other.getChipsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + LAYOUT_FIELD_NUMBER;
    hash = (53 * hash) + layout_;
    if (getChipsCount() > 0) {
      hash = (37 * hash) + CHIPS_FIELD_NUMBER;
      hash = (53 * hash) + getChipsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.ChipList parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.ChipList parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.ChipList parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.ChipList parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.ChipList prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A list of chips layed out horizontally, which can either scroll horizontally
   * or wrap to the next line.
   *
   * [Google Workspace add-ons and Chat
   * apps](https://developers.google.com/workspace/extend):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.ChipList}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.ChipList)
      com.google.apps.card.v1.ChipListOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_ChipList_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_ChipList_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.ChipList.class,
              com.google.apps.card.v1.ChipList.Builder.class);
    }

    // Construct using com.google.apps.card.v1.ChipList.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      layout_ = 0;
      if (chipsBuilder_ == null) {
        chips_ = java.util.Collections.emptyList();
      } else {
        chips_ = null;
        chipsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_ChipList_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.ChipList getDefaultInstanceForType() {
      return com.google.apps.card.v1.ChipList.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.ChipList build() {
      com.google.apps.card.v1.ChipList result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.ChipList buildPartial() {
      com.google.apps.card.v1.ChipList result = new com.google.apps.card.v1.ChipList(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.apps.card.v1.ChipList result) {
      if (chipsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          chips_ = java.util.Collections.unmodifiableList(chips_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.chips_ = chips_;
      } else {
        result.chips_ = chipsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.apps.card.v1.ChipList result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.layout_ = layout_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.ChipList) {
        return mergeFrom((com.google.apps.card.v1.ChipList) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.ChipList other) {
      if (other == com.google.apps.card.v1.ChipList.getDefaultInstance()) return this;
      if (other.layout_ != 0) {
        setLayoutValue(other.getLayoutValue());
      }
      if (chipsBuilder_ == null) {
        if (!other.chips_.isEmpty()) {
          if (chips_.isEmpty()) {
            chips_ = other.chips_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureChipsIsMutable();
            chips_.addAll(other.chips_);
          }
          onChanged();
        }
      } else {
        if (!other.chips_.isEmpty()) {
          if (chipsBuilder_.isEmpty()) {
            chipsBuilder_.dispose();
            chipsBuilder_ = null;
            chips_ = other.chips_;
            bitField0_ = (bitField0_ & ~0x00000002);
            chipsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChipsFieldBuilder()
                    : null;
          } else {
            chipsBuilder_.addAllMessages(other.chips_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                layout_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                com.google.apps.card.v1.Chip m =
                    input.readMessage(com.google.apps.card.v1.Chip.parser(), extensionRegistry);
                if (chipsBuilder_ == null) {
                  ensureChipsIsMutable();
                  chips_.add(m);
                } else {
                  chipsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int layout_ = 0;

    /**
     *
     *
     * <pre>
     * Specified chip list layout.
     * </pre>
     *
     * <code>.google.apps.card.v1.ChipList.Layout layout = 1;</code>
     *
     * @return The enum numeric value on the wire for layout.
     */
    @java.lang.Override
    public int getLayoutValue() {
      return layout_;
    }

    /**
     *
     *
     * <pre>
     * Specified chip list layout.
     * </pre>
     *
     * <code>.google.apps.card.v1.ChipList.Layout layout = 1;</code>
     *
     * @param value The enum numeric value on the wire for layout to set.
     * @return This builder for chaining.
     */
    public Builder setLayoutValue(int value) {
      layout_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specified chip list layout.
     * </pre>
     *
     * <code>.google.apps.card.v1.ChipList.Layout layout = 1;</code>
     *
     * @return The layout.
     */
    @java.lang.Override
    public com.google.apps.card.v1.ChipList.Layout getLayout() {
      com.google.apps.card.v1.ChipList.Layout result =
          com.google.apps.card.v1.ChipList.Layout.forNumber(layout_);
      return result == null ? com.google.apps.card.v1.ChipList.Layout.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Specified chip list layout.
     * </pre>
     *
     * <code>.google.apps.card.v1.ChipList.Layout layout = 1;</code>
     *
     * @param value The layout to set.
     * @return This builder for chaining.
     */
    public Builder setLayout(com.google.apps.card.v1.ChipList.Layout value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      layout_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specified chip list layout.
     * </pre>
     *
     * <code>.google.apps.card.v1.ChipList.Layout layout = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLayout() {
      bitField0_ = (bitField0_ & ~0x00000001);
      layout_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.apps.card.v1.Chip> chips_ = java.util.Collections.emptyList();

    private void ensureChipsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        chips_ = new java.util.ArrayList<com.google.apps.card.v1.Chip>(chips_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.Chip,
            com.google.apps.card.v1.Chip.Builder,
            com.google.apps.card.v1.ChipOrBuilder>
        chipsBuilder_;

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public java.util.List<com.google.apps.card.v1.Chip> getChipsList() {
      if (chipsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(chips_);
      } else {
        return chipsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public int getChipsCount() {
      if (chipsBuilder_ == null) {
        return chips_.size();
      } else {
        return chipsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public com.google.apps.card.v1.Chip getChips(int index) {
      if (chipsBuilder_ == null) {
        return chips_.get(index);
      } else {
        return chipsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder setChips(int index, com.google.apps.card.v1.Chip value) {
      if (chipsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChipsIsMutable();
        chips_.set(index, value);
        onChanged();
      } else {
        chipsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder setChips(int index, com.google.apps.card.v1.Chip.Builder builderForValue) {
      if (chipsBuilder_ == null) {
        ensureChipsIsMutable();
        chips_.set(index, builderForValue.build());
        onChanged();
      } else {
        chipsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder addChips(com.google.apps.card.v1.Chip value) {
      if (chipsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChipsIsMutable();
        chips_.add(value);
        onChanged();
      } else {
        chipsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder addChips(int index, com.google.apps.card.v1.Chip value) {
      if (chipsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChipsIsMutable();
        chips_.add(index, value);
        onChanged();
      } else {
        chipsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder addChips(com.google.apps.card.v1.Chip.Builder builderForValue) {
      if (chipsBuilder_ == null) {
        ensureChipsIsMutable();
        chips_.add(builderForValue.build());
        onChanged();
      } else {
        chipsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder addChips(int index, com.google.apps.card.v1.Chip.Builder builderForValue) {
      if (chipsBuilder_ == null) {
        ensureChipsIsMutable();
        chips_.add(index, builderForValue.build());
        onChanged();
      } else {
        chipsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder addAllChips(java.lang.Iterable<? extends com.google.apps.card.v1.Chip> values) {
      if (chipsBuilder_ == null) {
        ensureChipsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, chips_);
        onChanged();
      } else {
        chipsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder clearChips() {
      if (chipsBuilder_ == null) {
        chips_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        chipsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public Builder removeChips(int index) {
      if (chipsBuilder_ == null) {
        ensureChipsIsMutable();
        chips_.remove(index);
        onChanged();
      } else {
        chipsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public com.google.apps.card.v1.Chip.Builder getChipsBuilder(int index) {
      return getChipsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public com.google.apps.card.v1.ChipOrBuilder getChipsOrBuilder(int index) {
      if (chipsBuilder_ == null) {
        return chips_.get(index);
      } else {
        return chipsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public java.util.List<? extends com.google.apps.card.v1.ChipOrBuilder> getChipsOrBuilderList() {
      if (chipsBuilder_ != null) {
        return chipsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(chips_);
      }
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public com.google.apps.card.v1.Chip.Builder addChipsBuilder() {
      return getChipsFieldBuilder().addBuilder(com.google.apps.card.v1.Chip.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public com.google.apps.card.v1.Chip.Builder addChipsBuilder(int index) {
      return getChipsFieldBuilder()
          .addBuilder(index, com.google.apps.card.v1.Chip.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * An array of chips.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Chip chips = 2;</code>
     */
    public java.util.List<com.google.apps.card.v1.Chip.Builder> getChipsBuilderList() {
      return getChipsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.Chip,
            com.google.apps.card.v1.Chip.Builder,
            com.google.apps.card.v1.ChipOrBuilder>
        getChipsFieldBuilder() {
      if (chipsBuilder_ == null) {
        chipsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.apps.card.v1.Chip,
                com.google.apps.card.v1.Chip.Builder,
                com.google.apps.card.v1.ChipOrBuilder>(
                chips_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        chips_ = null;
      }
      return chipsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.ChipList)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.ChipList)
  private static final com.google.apps.card.v1.ChipList DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.ChipList();
  }

  public static com.google.apps.card.v1.ChipList getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ChipList> PARSER =
      new com.google.protobuf.AbstractParser<ChipList>() {
        @java.lang.Override
        public ChipList parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ChipList> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ChipList> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.ChipList getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
