/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/apps/card/v1/card.proto

// Protobuf Java Version: 3.25.8
package com.google.apps.card.v1;

/**
 *
 *
 * <pre>
 * A carousel, also known as a slider, rotates and displays a list of widgets in
 * a slideshow format, with buttons navigating to the previous or next widget.
 *
 * For example, this is a JSON representation of a carousel that contains three
 * text paragraph widgets.
 *
 * ```
 * {
 *   "carouselCards": [
 *     {
 *       "widgets": [
 *         {
 *           "textParagraph": {
 *             "text": "First text paragraph in carousel",
 *           }
 *         }
 *       ]
 *     },
 *     {
 *       "widgets": [
 *         {
 *           "textParagraph": {
 *             "text": "Second text paragraph in carousel",
 *           }
 *         }
 *       ]
 *     },
 *     {
 *       "widgets": [
 *         {
 *           "textParagraph": {
 *             "text": "Third text paragraph in carousel",
 *           }
 *         }
 *       ]
 *     }
 *   ]
 * }
 * ```
 *
 * [Google Chat apps](https://developers.google.com/workspace/chat):
 * </pre>
 *
 * Protobuf type {@code google.apps.card.v1.Carousel}
 */
public final class Carousel extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.apps.card.v1.Carousel)
    CarouselOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Carousel.newBuilder() to construct.
  private Carousel(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Carousel() {
    carouselCards_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Carousel();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Carousel_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.apps.card.v1.CardProto
        .internal_static_google_apps_card_v1_Carousel_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.apps.card.v1.Carousel.class, com.google.apps.card.v1.Carousel.Builder.class);
  }

  public interface CarouselCardOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.apps.card.v1.Carousel.CarouselCard)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    java.util.List<com.google.apps.card.v1.Card.NestedWidget> getWidgetsList();

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    com.google.apps.card.v1.Card.NestedWidget getWidgets(int index);

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    int getWidgetsCount();

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    java.util.List<? extends com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
        getWidgetsOrBuilderList();

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    com.google.apps.card.v1.Card.NestedWidgetOrBuilder getWidgetsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    java.util.List<com.google.apps.card.v1.Card.NestedWidget> getFooterWidgetsList();

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    com.google.apps.card.v1.Card.NestedWidget getFooterWidgets(int index);

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    int getFooterWidgetsCount();

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    java.util.List<? extends com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
        getFooterWidgetsOrBuilderList();

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    com.google.apps.card.v1.Card.NestedWidgetOrBuilder getFooterWidgetsOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * A card that can be displayed as a carousel item.
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Carousel.CarouselCard}
   */
  public static final class CarouselCard extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.apps.card.v1.Carousel.CarouselCard)
      CarouselCardOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use CarouselCard.newBuilder() to construct.
    private CarouselCard(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CarouselCard() {
      widgets_ = java.util.Collections.emptyList();
      footerWidgets_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CarouselCard();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Carousel_CarouselCard_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Carousel_CarouselCard_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Carousel.CarouselCard.class,
              com.google.apps.card.v1.Carousel.CarouselCard.Builder.class);
    }

    public static final int WIDGETS_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.apps.card.v1.Card.NestedWidget> widgets_;

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.apps.card.v1.Card.NestedWidget> getWidgetsList() {
      return widgets_;
    }

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
        getWidgetsOrBuilderList() {
      return widgets_;
    }

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    @java.lang.Override
    public int getWidgetsCount() {
      return widgets_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.Card.NestedWidget getWidgets(int index) {
      return widgets_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of widgets displayed in the carousel card. The widgets are
     * displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.Card.NestedWidgetOrBuilder getWidgetsOrBuilder(int index) {
      return widgets_.get(index);
    }

    public static final int FOOTER_WIDGETS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.apps.card.v1.Card.NestedWidget> footerWidgets_;

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.apps.card.v1.Card.NestedWidget> getFooterWidgetsList() {
      return footerWidgets_;
    }

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
        getFooterWidgetsOrBuilderList() {
      return footerWidgets_;
    }

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    @java.lang.Override
    public int getFooterWidgetsCount() {
      return footerWidgets_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.Card.NestedWidget getFooterWidgets(int index) {
      return footerWidgets_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of widgets displayed at the bottom of the carousel card. The
     * widgets are displayed in the order that they are specified.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
     */
    @java.lang.Override
    public com.google.apps.card.v1.Card.NestedWidgetOrBuilder getFooterWidgetsOrBuilder(int index) {
      return footerWidgets_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < widgets_.size(); i++) {
        output.writeMessage(1, widgets_.get(i));
      }
      for (int i = 0; i < footerWidgets_.size(); i++) {
        output.writeMessage(2, footerWidgets_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < widgets_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, widgets_.get(i));
      }
      for (int i = 0; i < footerWidgets_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, footerWidgets_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.apps.card.v1.Carousel.CarouselCard)) {
        return super.equals(obj);
      }
      com.google.apps.card.v1.Carousel.CarouselCard other =
          (com.google.apps.card.v1.Carousel.CarouselCard) obj;

      if (!getWidgetsList().equals(other.getWidgetsList())) return false;
      if (!getFooterWidgetsList().equals(other.getFooterWidgetsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getWidgetsCount() > 0) {
        hash = (37 * hash) + WIDGETS_FIELD_NUMBER;
        hash = (53 * hash) + getWidgetsList().hashCode();
      }
      if (getFooterWidgetsCount() > 0) {
        hash = (37 * hash) + FOOTER_WIDGETS_FIELD_NUMBER;
        hash = (53 * hash) + getFooterWidgetsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(java.nio.ByteBuffer data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.apps.card.v1.Carousel.CarouselCard prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A card that can be displayed as a carousel item.
     * [Google Chat apps](https://developers.google.com/workspace/chat):
     * </pre>
     *
     * Protobuf type {@code google.apps.card.v1.Carousel.CarouselCard}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Carousel.CarouselCard)
        com.google.apps.card.v1.Carousel.CarouselCardOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Carousel_CarouselCard_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Carousel_CarouselCard_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.apps.card.v1.Carousel.CarouselCard.class,
                com.google.apps.card.v1.Carousel.CarouselCard.Builder.class);
      }

      // Construct using com.google.apps.card.v1.Carousel.CarouselCard.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (widgetsBuilder_ == null) {
          widgets_ = java.util.Collections.emptyList();
        } else {
          widgets_ = null;
          widgetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (footerWidgetsBuilder_ == null) {
          footerWidgets_ = java.util.Collections.emptyList();
        } else {
          footerWidgets_ = null;
          footerWidgetsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.apps.card.v1.CardProto
            .internal_static_google_apps_card_v1_Carousel_CarouselCard_descriptor;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Carousel.CarouselCard getDefaultInstanceForType() {
        return com.google.apps.card.v1.Carousel.CarouselCard.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.apps.card.v1.Carousel.CarouselCard build() {
        com.google.apps.card.v1.Carousel.CarouselCard result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.apps.card.v1.Carousel.CarouselCard buildPartial() {
        com.google.apps.card.v1.Carousel.CarouselCard result =
            new com.google.apps.card.v1.Carousel.CarouselCard(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.apps.card.v1.Carousel.CarouselCard result) {
        if (widgetsBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            widgets_ = java.util.Collections.unmodifiableList(widgets_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.widgets_ = widgets_;
        } else {
          result.widgets_ = widgetsBuilder_.build();
        }
        if (footerWidgetsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            footerWidgets_ = java.util.Collections.unmodifiableList(footerWidgets_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.footerWidgets_ = footerWidgets_;
        } else {
          result.footerWidgets_ = footerWidgetsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.apps.card.v1.Carousel.CarouselCard result) {
        int from_bitField0_ = bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.apps.card.v1.Carousel.CarouselCard) {
          return mergeFrom((com.google.apps.card.v1.Carousel.CarouselCard) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.apps.card.v1.Carousel.CarouselCard other) {
        if (other == com.google.apps.card.v1.Carousel.CarouselCard.getDefaultInstance())
          return this;
        if (widgetsBuilder_ == null) {
          if (!other.widgets_.isEmpty()) {
            if (widgets_.isEmpty()) {
              widgets_ = other.widgets_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureWidgetsIsMutable();
              widgets_.addAll(other.widgets_);
            }
            onChanged();
          }
        } else {
          if (!other.widgets_.isEmpty()) {
            if (widgetsBuilder_.isEmpty()) {
              widgetsBuilder_.dispose();
              widgetsBuilder_ = null;
              widgets_ = other.widgets_;
              bitField0_ = (bitField0_ & ~0x00000001);
              widgetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getWidgetsFieldBuilder()
                      : null;
            } else {
              widgetsBuilder_.addAllMessages(other.widgets_);
            }
          }
        }
        if (footerWidgetsBuilder_ == null) {
          if (!other.footerWidgets_.isEmpty()) {
            if (footerWidgets_.isEmpty()) {
              footerWidgets_ = other.footerWidgets_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureFooterWidgetsIsMutable();
              footerWidgets_.addAll(other.footerWidgets_);
            }
            onChanged();
          }
        } else {
          if (!other.footerWidgets_.isEmpty()) {
            if (footerWidgetsBuilder_.isEmpty()) {
              footerWidgetsBuilder_.dispose();
              footerWidgetsBuilder_ = null;
              footerWidgets_ = other.footerWidgets_;
              bitField0_ = (bitField0_ & ~0x00000002);
              footerWidgetsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getFooterWidgetsFieldBuilder()
                      : null;
            } else {
              footerWidgetsBuilder_.addAllMessages(other.footerWidgets_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.apps.card.v1.Card.NestedWidget m =
                      input.readMessage(
                          com.google.apps.card.v1.Card.NestedWidget.parser(), extensionRegistry);
                  if (widgetsBuilder_ == null) {
                    ensureWidgetsIsMutable();
                    widgets_.add(m);
                  } else {
                    widgetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.apps.card.v1.Card.NestedWidget m =
                      input.readMessage(
                          com.google.apps.card.v1.Card.NestedWidget.parser(), extensionRegistry);
                  if (footerWidgetsBuilder_ == null) {
                    ensureFooterWidgetsIsMutable();
                    footerWidgets_.add(m);
                  } else {
                    footerWidgetsBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.apps.card.v1.Card.NestedWidget> widgets_ =
          java.util.Collections.emptyList();

      private void ensureWidgetsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          widgets_ = new java.util.ArrayList<com.google.apps.card.v1.Card.NestedWidget>(widgets_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.apps.card.v1.Card.NestedWidget,
              com.google.apps.card.v1.Card.NestedWidget.Builder,
              com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
          widgetsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public java.util.List<com.google.apps.card.v1.Card.NestedWidget> getWidgetsList() {
        if (widgetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(widgets_);
        } else {
          return widgetsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public int getWidgetsCount() {
        if (widgetsBuilder_ == null) {
          return widgets_.size();
        } else {
          return widgetsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidget getWidgets(int index) {
        if (widgetsBuilder_ == null) {
          return widgets_.get(index);
        } else {
          return widgetsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder setWidgets(int index, com.google.apps.card.v1.Card.NestedWidget value) {
        if (widgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWidgetsIsMutable();
          widgets_.set(index, value);
          onChanged();
        } else {
          widgetsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder setWidgets(
          int index, com.google.apps.card.v1.Card.NestedWidget.Builder builderForValue) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          widgets_.set(index, builderForValue.build());
          onChanged();
        } else {
          widgetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder addWidgets(com.google.apps.card.v1.Card.NestedWidget value) {
        if (widgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWidgetsIsMutable();
          widgets_.add(value);
          onChanged();
        } else {
          widgetsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder addWidgets(int index, com.google.apps.card.v1.Card.NestedWidget value) {
        if (widgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureWidgetsIsMutable();
          widgets_.add(index, value);
          onChanged();
        } else {
          widgetsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder addWidgets(com.google.apps.card.v1.Card.NestedWidget.Builder builderForValue) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          widgets_.add(builderForValue.build());
          onChanged();
        } else {
          widgetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder addWidgets(
          int index, com.google.apps.card.v1.Card.NestedWidget.Builder builderForValue) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          widgets_.add(index, builderForValue.build());
          onChanged();
        } else {
          widgetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder addAllWidgets(
          java.lang.Iterable<? extends com.google.apps.card.v1.Card.NestedWidget> values) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, widgets_);
          onChanged();
        } else {
          widgetsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder clearWidgets() {
        if (widgetsBuilder_ == null) {
          widgets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          widgetsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public Builder removeWidgets(int index) {
        if (widgetsBuilder_ == null) {
          ensureWidgetsIsMutable();
          widgets_.remove(index);
          onChanged();
        } else {
          widgetsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidget.Builder getWidgetsBuilder(int index) {
        return getWidgetsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidgetOrBuilder getWidgetsOrBuilder(int index) {
        if (widgetsBuilder_ == null) {
          return widgets_.get(index);
        } else {
          return widgetsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public java.util.List<? extends com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
          getWidgetsOrBuilderList() {
        if (widgetsBuilder_ != null) {
          return widgetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(widgets_);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidget.Builder addWidgetsBuilder() {
        return getWidgetsFieldBuilder()
            .addBuilder(com.google.apps.card.v1.Card.NestedWidget.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidget.Builder addWidgetsBuilder(int index) {
        return getWidgetsFieldBuilder()
            .addBuilder(index, com.google.apps.card.v1.Card.NestedWidget.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed in the carousel card. The widgets are
       * displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget widgets = 1;</code>
       */
      public java.util.List<com.google.apps.card.v1.Card.NestedWidget.Builder>
          getWidgetsBuilderList() {
        return getWidgetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.apps.card.v1.Card.NestedWidget,
              com.google.apps.card.v1.Card.NestedWidget.Builder,
              com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
          getWidgetsFieldBuilder() {
        if (widgetsBuilder_ == null) {
          widgetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.apps.card.v1.Card.NestedWidget,
                  com.google.apps.card.v1.Card.NestedWidget.Builder,
                  com.google.apps.card.v1.Card.NestedWidgetOrBuilder>(
                  widgets_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          widgets_ = null;
        }
        return widgetsBuilder_;
      }

      private java.util.List<com.google.apps.card.v1.Card.NestedWidget> footerWidgets_ =
          java.util.Collections.emptyList();

      private void ensureFooterWidgetsIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          footerWidgets_ =
              new java.util.ArrayList<com.google.apps.card.v1.Card.NestedWidget>(footerWidgets_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.apps.card.v1.Card.NestedWidget,
              com.google.apps.card.v1.Card.NestedWidget.Builder,
              com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
          footerWidgetsBuilder_;

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public java.util.List<com.google.apps.card.v1.Card.NestedWidget> getFooterWidgetsList() {
        if (footerWidgetsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(footerWidgets_);
        } else {
          return footerWidgetsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public int getFooterWidgetsCount() {
        if (footerWidgetsBuilder_ == null) {
          return footerWidgets_.size();
        } else {
          return footerWidgetsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidget getFooterWidgets(int index) {
        if (footerWidgetsBuilder_ == null) {
          return footerWidgets_.get(index);
        } else {
          return footerWidgetsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder setFooterWidgets(int index, com.google.apps.card.v1.Card.NestedWidget value) {
        if (footerWidgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFooterWidgetsIsMutable();
          footerWidgets_.set(index, value);
          onChanged();
        } else {
          footerWidgetsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder setFooterWidgets(
          int index, com.google.apps.card.v1.Card.NestedWidget.Builder builderForValue) {
        if (footerWidgetsBuilder_ == null) {
          ensureFooterWidgetsIsMutable();
          footerWidgets_.set(index, builderForValue.build());
          onChanged();
        } else {
          footerWidgetsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder addFooterWidgets(com.google.apps.card.v1.Card.NestedWidget value) {
        if (footerWidgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFooterWidgetsIsMutable();
          footerWidgets_.add(value);
          onChanged();
        } else {
          footerWidgetsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder addFooterWidgets(int index, com.google.apps.card.v1.Card.NestedWidget value) {
        if (footerWidgetsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFooterWidgetsIsMutable();
          footerWidgets_.add(index, value);
          onChanged();
        } else {
          footerWidgetsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder addFooterWidgets(
          com.google.apps.card.v1.Card.NestedWidget.Builder builderForValue) {
        if (footerWidgetsBuilder_ == null) {
          ensureFooterWidgetsIsMutable();
          footerWidgets_.add(builderForValue.build());
          onChanged();
        } else {
          footerWidgetsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder addFooterWidgets(
          int index, com.google.apps.card.v1.Card.NestedWidget.Builder builderForValue) {
        if (footerWidgetsBuilder_ == null) {
          ensureFooterWidgetsIsMutable();
          footerWidgets_.add(index, builderForValue.build());
          onChanged();
        } else {
          footerWidgetsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder addAllFooterWidgets(
          java.lang.Iterable<? extends com.google.apps.card.v1.Card.NestedWidget> values) {
        if (footerWidgetsBuilder_ == null) {
          ensureFooterWidgetsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, footerWidgets_);
          onChanged();
        } else {
          footerWidgetsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder clearFooterWidgets() {
        if (footerWidgetsBuilder_ == null) {
          footerWidgets_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          footerWidgetsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public Builder removeFooterWidgets(int index) {
        if (footerWidgetsBuilder_ == null) {
          ensureFooterWidgetsIsMutable();
          footerWidgets_.remove(index);
          onChanged();
        } else {
          footerWidgetsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidget.Builder getFooterWidgetsBuilder(int index) {
        return getFooterWidgetsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidgetOrBuilder getFooterWidgetsOrBuilder(
          int index) {
        if (footerWidgetsBuilder_ == null) {
          return footerWidgets_.get(index);
        } else {
          return footerWidgetsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public java.util.List<? extends com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
          getFooterWidgetsOrBuilderList() {
        if (footerWidgetsBuilder_ != null) {
          return footerWidgetsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(footerWidgets_);
        }
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidget.Builder addFooterWidgetsBuilder() {
        return getFooterWidgetsFieldBuilder()
            .addBuilder(com.google.apps.card.v1.Card.NestedWidget.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public com.google.apps.card.v1.Card.NestedWidget.Builder addFooterWidgetsBuilder(int index) {
        return getFooterWidgetsFieldBuilder()
            .addBuilder(index, com.google.apps.card.v1.Card.NestedWidget.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * A list of widgets displayed at the bottom of the carousel card. The
       * widgets are displayed in the order that they are specified.
       * </pre>
       *
       * <code>repeated .google.apps.card.v1.Card.NestedWidget footer_widgets = 2;</code>
       */
      public java.util.List<com.google.apps.card.v1.Card.NestedWidget.Builder>
          getFooterWidgetsBuilderList() {
        return getFooterWidgetsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.apps.card.v1.Card.NestedWidget,
              com.google.apps.card.v1.Card.NestedWidget.Builder,
              com.google.apps.card.v1.Card.NestedWidgetOrBuilder>
          getFooterWidgetsFieldBuilder() {
        if (footerWidgetsBuilder_ == null) {
          footerWidgetsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.apps.card.v1.Card.NestedWidget,
                  com.google.apps.card.v1.Card.NestedWidget.Builder,
                  com.google.apps.card.v1.Card.NestedWidgetOrBuilder>(
                  footerWidgets_,
                  ((bitField0_ & 0x00000002) != 0),
                  getParentForChildren(),
                  isClean());
          footerWidgets_ = null;
        }
        return footerWidgetsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Carousel.CarouselCard)
    }

    // @@protoc_insertion_point(class_scope:google.apps.card.v1.Carousel.CarouselCard)
    private static final com.google.apps.card.v1.Carousel.CarouselCard DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.apps.card.v1.Carousel.CarouselCard();
    }

    public static com.google.apps.card.v1.Carousel.CarouselCard getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CarouselCard> PARSER =
        new com.google.protobuf.AbstractParser<CarouselCard>() {
          @java.lang.Override
          public CarouselCard parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<CarouselCard> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CarouselCard> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Carousel.CarouselCard getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CAROUSEL_CARDS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.apps.card.v1.Carousel.CarouselCard> carouselCards_;

  /**
   *
   *
   * <pre>
   * A list of cards included in the carousel.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.apps.card.v1.Carousel.CarouselCard> getCarouselCardsList() {
    return carouselCards_;
  }

  /**
   *
   *
   * <pre>
   * A list of cards included in the carousel.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.apps.card.v1.Carousel.CarouselCardOrBuilder>
      getCarouselCardsOrBuilderList() {
    return carouselCards_;
  }

  /**
   *
   *
   * <pre>
   * A list of cards included in the carousel.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
   */
  @java.lang.Override
  public int getCarouselCardsCount() {
    return carouselCards_.size();
  }

  /**
   *
   *
   * <pre>
   * A list of cards included in the carousel.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Carousel.CarouselCard getCarouselCards(int index) {
    return carouselCards_.get(index);
  }

  /**
   *
   *
   * <pre>
   * A list of cards included in the carousel.
   * </pre>
   *
   * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
   */
  @java.lang.Override
  public com.google.apps.card.v1.Carousel.CarouselCardOrBuilder getCarouselCardsOrBuilder(
      int index) {
    return carouselCards_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < carouselCards_.size(); i++) {
      output.writeMessage(4, carouselCards_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < carouselCards_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, carouselCards_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.apps.card.v1.Carousel)) {
      return super.equals(obj);
    }
    com.google.apps.card.v1.Carousel other = (com.google.apps.card.v1.Carousel) obj;

    if (!getCarouselCardsList().equals(other.getCarouselCardsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getCarouselCardsCount() > 0) {
      hash = (37 * hash) + CAROUSEL_CARDS_FIELD_NUMBER;
      hash = (53 * hash) + getCarouselCardsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.apps.card.v1.Carousel parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Carousel parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Carousel parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.apps.card.v1.Carousel parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.apps.card.v1.Carousel prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A carousel, also known as a slider, rotates and displays a list of widgets in
   * a slideshow format, with buttons navigating to the previous or next widget.
   *
   * For example, this is a JSON representation of a carousel that contains three
   * text paragraph widgets.
   *
   * ```
   * {
   *   "carouselCards": [
   *     {
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "First text paragraph in carousel",
   *           }
   *         }
   *       ]
   *     },
   *     {
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "Second text paragraph in carousel",
   *           }
   *         }
   *       ]
   *     },
   *     {
   *       "widgets": [
   *         {
   *           "textParagraph": {
   *             "text": "Third text paragraph in carousel",
   *           }
   *         }
   *       ]
   *     }
   *   ]
   * }
   * ```
   *
   * [Google Chat apps](https://developers.google.com/workspace/chat):
   * </pre>
   *
   * Protobuf type {@code google.apps.card.v1.Carousel}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.apps.card.v1.Carousel)
      com.google.apps.card.v1.CarouselOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Carousel_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Carousel_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.apps.card.v1.Carousel.class,
              com.google.apps.card.v1.Carousel.Builder.class);
    }

    // Construct using com.google.apps.card.v1.Carousel.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (carouselCardsBuilder_ == null) {
        carouselCards_ = java.util.Collections.emptyList();
      } else {
        carouselCards_ = null;
        carouselCardsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.apps.card.v1.CardProto
          .internal_static_google_apps_card_v1_Carousel_descriptor;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Carousel getDefaultInstanceForType() {
      return com.google.apps.card.v1.Carousel.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.apps.card.v1.Carousel build() {
      com.google.apps.card.v1.Carousel result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.apps.card.v1.Carousel buildPartial() {
      com.google.apps.card.v1.Carousel result = new com.google.apps.card.v1.Carousel(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.apps.card.v1.Carousel result) {
      if (carouselCardsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          carouselCards_ = java.util.Collections.unmodifiableList(carouselCards_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.carouselCards_ = carouselCards_;
      } else {
        result.carouselCards_ = carouselCardsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.apps.card.v1.Carousel result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.apps.card.v1.Carousel) {
        return mergeFrom((com.google.apps.card.v1.Carousel) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.apps.card.v1.Carousel other) {
      if (other == com.google.apps.card.v1.Carousel.getDefaultInstance()) return this;
      if (carouselCardsBuilder_ == null) {
        if (!other.carouselCards_.isEmpty()) {
          if (carouselCards_.isEmpty()) {
            carouselCards_ = other.carouselCards_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureCarouselCardsIsMutable();
            carouselCards_.addAll(other.carouselCards_);
          }
          onChanged();
        }
      } else {
        if (!other.carouselCards_.isEmpty()) {
          if (carouselCardsBuilder_.isEmpty()) {
            carouselCardsBuilder_.dispose();
            carouselCardsBuilder_ = null;
            carouselCards_ = other.carouselCards_;
            bitField0_ = (bitField0_ & ~0x00000001);
            carouselCardsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getCarouselCardsFieldBuilder()
                    : null;
          } else {
            carouselCardsBuilder_.addAllMessages(other.carouselCards_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 34:
              {
                com.google.apps.card.v1.Carousel.CarouselCard m =
                    input.readMessage(
                        com.google.apps.card.v1.Carousel.CarouselCard.parser(), extensionRegistry);
                if (carouselCardsBuilder_ == null) {
                  ensureCarouselCardsIsMutable();
                  carouselCards_.add(m);
                } else {
                  carouselCardsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.apps.card.v1.Carousel.CarouselCard> carouselCards_ =
        java.util.Collections.emptyList();

    private void ensureCarouselCardsIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        carouselCards_ =
            new java.util.ArrayList<com.google.apps.card.v1.Carousel.CarouselCard>(carouselCards_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.Carousel.CarouselCard,
            com.google.apps.card.v1.Carousel.CarouselCard.Builder,
            com.google.apps.card.v1.Carousel.CarouselCardOrBuilder>
        carouselCardsBuilder_;

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public java.util.List<com.google.apps.card.v1.Carousel.CarouselCard> getCarouselCardsList() {
      if (carouselCardsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(carouselCards_);
      } else {
        return carouselCardsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public int getCarouselCardsCount() {
      if (carouselCardsBuilder_ == null) {
        return carouselCards_.size();
      } else {
        return carouselCardsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public com.google.apps.card.v1.Carousel.CarouselCard getCarouselCards(int index) {
      if (carouselCardsBuilder_ == null) {
        return carouselCards_.get(index);
      } else {
        return carouselCardsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder setCarouselCards(
        int index, com.google.apps.card.v1.Carousel.CarouselCard value) {
      if (carouselCardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCarouselCardsIsMutable();
        carouselCards_.set(index, value);
        onChanged();
      } else {
        carouselCardsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder setCarouselCards(
        int index, com.google.apps.card.v1.Carousel.CarouselCard.Builder builderForValue) {
      if (carouselCardsBuilder_ == null) {
        ensureCarouselCardsIsMutable();
        carouselCards_.set(index, builderForValue.build());
        onChanged();
      } else {
        carouselCardsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder addCarouselCards(com.google.apps.card.v1.Carousel.CarouselCard value) {
      if (carouselCardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCarouselCardsIsMutable();
        carouselCards_.add(value);
        onChanged();
      } else {
        carouselCardsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder addCarouselCards(
        int index, com.google.apps.card.v1.Carousel.CarouselCard value) {
      if (carouselCardsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureCarouselCardsIsMutable();
        carouselCards_.add(index, value);
        onChanged();
      } else {
        carouselCardsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder addCarouselCards(
        com.google.apps.card.v1.Carousel.CarouselCard.Builder builderForValue) {
      if (carouselCardsBuilder_ == null) {
        ensureCarouselCardsIsMutable();
        carouselCards_.add(builderForValue.build());
        onChanged();
      } else {
        carouselCardsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder addCarouselCards(
        int index, com.google.apps.card.v1.Carousel.CarouselCard.Builder builderForValue) {
      if (carouselCardsBuilder_ == null) {
        ensureCarouselCardsIsMutable();
        carouselCards_.add(index, builderForValue.build());
        onChanged();
      } else {
        carouselCardsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder addAllCarouselCards(
        java.lang.Iterable<? extends com.google.apps.card.v1.Carousel.CarouselCard> values) {
      if (carouselCardsBuilder_ == null) {
        ensureCarouselCardsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, carouselCards_);
        onChanged();
      } else {
        carouselCardsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder clearCarouselCards() {
      if (carouselCardsBuilder_ == null) {
        carouselCards_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        carouselCardsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public Builder removeCarouselCards(int index) {
      if (carouselCardsBuilder_ == null) {
        ensureCarouselCardsIsMutable();
        carouselCards_.remove(index);
        onChanged();
      } else {
        carouselCardsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public com.google.apps.card.v1.Carousel.CarouselCard.Builder getCarouselCardsBuilder(
        int index) {
      return getCarouselCardsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public com.google.apps.card.v1.Carousel.CarouselCardOrBuilder getCarouselCardsOrBuilder(
        int index) {
      if (carouselCardsBuilder_ == null) {
        return carouselCards_.get(index);
      } else {
        return carouselCardsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public java.util.List<? extends com.google.apps.card.v1.Carousel.CarouselCardOrBuilder>
        getCarouselCardsOrBuilderList() {
      if (carouselCardsBuilder_ != null) {
        return carouselCardsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(carouselCards_);
      }
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public com.google.apps.card.v1.Carousel.CarouselCard.Builder addCarouselCardsBuilder() {
      return getCarouselCardsFieldBuilder()
          .addBuilder(com.google.apps.card.v1.Carousel.CarouselCard.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public com.google.apps.card.v1.Carousel.CarouselCard.Builder addCarouselCardsBuilder(
        int index) {
      return getCarouselCardsFieldBuilder()
          .addBuilder(index, com.google.apps.card.v1.Carousel.CarouselCard.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * A list of cards included in the carousel.
     * </pre>
     *
     * <code>repeated .google.apps.card.v1.Carousel.CarouselCard carousel_cards = 4;</code>
     */
    public java.util.List<com.google.apps.card.v1.Carousel.CarouselCard.Builder>
        getCarouselCardsBuilderList() {
      return getCarouselCardsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.apps.card.v1.Carousel.CarouselCard,
            com.google.apps.card.v1.Carousel.CarouselCard.Builder,
            com.google.apps.card.v1.Carousel.CarouselCardOrBuilder>
        getCarouselCardsFieldBuilder() {
      if (carouselCardsBuilder_ == null) {
        carouselCardsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.apps.card.v1.Carousel.CarouselCard,
                com.google.apps.card.v1.Carousel.CarouselCard.Builder,
                com.google.apps.card.v1.Carousel.CarouselCardOrBuilder>(
                carouselCards_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        carouselCards_ = null;
      }
      return carouselCardsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.apps.card.v1.Carousel)
  }

  // @@protoc_insertion_point(class_scope:google.apps.card.v1.Carousel)
  private static final com.google.apps.card.v1.Carousel DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.apps.card.v1.Carousel();
  }

  public static com.google.apps.card.v1.Carousel getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Carousel> PARSER =
      new com.google.protobuf.AbstractParser<Carousel>() {
        @java.lang.Override
        public Carousel parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Carousel> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Carousel> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.apps.card.v1.Carousel getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
