/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/shopping/type/types.proto

// Protobuf Java Version: 3.25.8
package com.google.shopping.type;

/**
 *
 *
 * <pre>
 * A message that represents custom attributes. Exactly one of `value` or
 * `group_values` must not be empty.
 * </pre>
 *
 * Protobuf type {@code google.shopping.type.CustomAttribute}
 */
public final class CustomAttribute extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.shopping.type.CustomAttribute)
    CustomAttributeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use CustomAttribute.newBuilder() to construct.
  private CustomAttribute(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CustomAttribute() {
    name_ = "";
    value_ = "";
    groupValues_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CustomAttribute();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.shopping.type.TypesProto
        .internal_static_google_shopping_type_CustomAttribute_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.shopping.type.TypesProto
        .internal_static_google_shopping_type_CustomAttribute_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.shopping.type.CustomAttribute.class,
            com.google.shopping.type.CustomAttribute.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * The name of the attribute.
   * </pre>
   *
   * <code>optional string name = 1;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The name of the attribute.
   * </pre>
   *
   * <code>optional string name = 1;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The name of the attribute.
   * </pre>
   *
   * <code>optional string name = 1;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALUE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object value_ = "";

  /**
   *
   *
   * <pre>
   * The value of the attribute. If `value` is not empty, `group_values` must be
   * empty.
   * </pre>
   *
   * <code>optional string value = 2;</code>
   *
   * @return Whether the value field is set.
   */
  @java.lang.Override
  public boolean hasValue() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The value of the attribute. If `value` is not empty, `group_values` must be
   * empty.
   * </pre>
   *
   * <code>optional string value = 2;</code>
   *
   * @return The value.
   */
  @java.lang.Override
  public java.lang.String getValue() {
    java.lang.Object ref = value_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      value_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The value of the attribute. If `value` is not empty, `group_values` must be
   * empty.
   * </pre>
   *
   * <code>optional string value = 2;</code>
   *
   * @return The bytes for value.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValueBytes() {
    java.lang.Object ref = value_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      value_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GROUP_VALUES_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.shopping.type.CustomAttribute> groupValues_;

  /**
   *
   *
   * <pre>
   * Subattributes within this attribute group.  If
   * `group_values` is not empty, `value` must be empty.
   * </pre>
   *
   * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.shopping.type.CustomAttribute> getGroupValuesList() {
    return groupValues_;
  }

  /**
   *
   *
   * <pre>
   * Subattributes within this attribute group.  If
   * `group_values` is not empty, `value` must be empty.
   * </pre>
   *
   * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.shopping.type.CustomAttributeOrBuilder>
      getGroupValuesOrBuilderList() {
    return groupValues_;
  }

  /**
   *
   *
   * <pre>
   * Subattributes within this attribute group.  If
   * `group_values` is not empty, `value` must be empty.
   * </pre>
   *
   * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
   */
  @java.lang.Override
  public int getGroupValuesCount() {
    return groupValues_.size();
  }

  /**
   *
   *
   * <pre>
   * Subattributes within this attribute group.  If
   * `group_values` is not empty, `value` must be empty.
   * </pre>
   *
   * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
   */
  @java.lang.Override
  public com.google.shopping.type.CustomAttribute getGroupValues(int index) {
    return groupValues_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Subattributes within this attribute group.  If
   * `group_values` is not empty, `value` must be empty.
   * </pre>
   *
   * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
   */
  @java.lang.Override
  public com.google.shopping.type.CustomAttributeOrBuilder getGroupValuesOrBuilder(int index) {
    return groupValues_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, value_);
    }
    for (int i = 0; i < groupValues_.size(); i++) {
      output.writeMessage(3, groupValues_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, value_);
    }
    for (int i = 0; i < groupValues_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, groupValues_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.shopping.type.CustomAttribute)) {
      return super.equals(obj);
    }
    com.google.shopping.type.CustomAttribute other = (com.google.shopping.type.CustomAttribute) obj;

    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasValue() != other.hasValue()) return false;
    if (hasValue()) {
      if (!getValue().equals(other.getValue())) return false;
    }
    if (!getGroupValuesList().equals(other.getGroupValuesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasValue()) {
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
    }
    if (getGroupValuesCount() > 0) {
      hash = (37 * hash) + GROUP_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getGroupValuesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.shopping.type.CustomAttribute parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.shopping.type.CustomAttribute parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.shopping.type.CustomAttribute parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.shopping.type.CustomAttribute prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A message that represents custom attributes. Exactly one of `value` or
   * `group_values` must not be empty.
   * </pre>
   *
   * Protobuf type {@code google.shopping.type.CustomAttribute}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.shopping.type.CustomAttribute)
      com.google.shopping.type.CustomAttributeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.shopping.type.TypesProto
          .internal_static_google_shopping_type_CustomAttribute_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.shopping.type.TypesProto
          .internal_static_google_shopping_type_CustomAttribute_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.shopping.type.CustomAttribute.class,
              com.google.shopping.type.CustomAttribute.Builder.class);
    }

    // Construct using com.google.shopping.type.CustomAttribute.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      value_ = "";
      if (groupValuesBuilder_ == null) {
        groupValues_ = java.util.Collections.emptyList();
      } else {
        groupValues_ = null;
        groupValuesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.shopping.type.TypesProto
          .internal_static_google_shopping_type_CustomAttribute_descriptor;
    }

    @java.lang.Override
    public com.google.shopping.type.CustomAttribute getDefaultInstanceForType() {
      return com.google.shopping.type.CustomAttribute.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.shopping.type.CustomAttribute build() {
      com.google.shopping.type.CustomAttribute result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.shopping.type.CustomAttribute buildPartial() {
      com.google.shopping.type.CustomAttribute result =
          new com.google.shopping.type.CustomAttribute(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.shopping.type.CustomAttribute result) {
      if (groupValuesBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          groupValues_ = java.util.Collections.unmodifiableList(groupValues_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.groupValues_ = groupValues_;
      } else {
        result.groupValues_ = groupValuesBuilder_.build();
      }
    }

    private void buildPartial0(com.google.shopping.type.CustomAttribute result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.value_ = value_;
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.shopping.type.CustomAttribute) {
        return mergeFrom((com.google.shopping.type.CustomAttribute) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.shopping.type.CustomAttribute other) {
      if (other == com.google.shopping.type.CustomAttribute.getDefaultInstance()) return this;
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasValue()) {
        value_ = other.value_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (groupValuesBuilder_ == null) {
        if (!other.groupValues_.isEmpty()) {
          if (groupValues_.isEmpty()) {
            groupValues_ = other.groupValues_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureGroupValuesIsMutable();
            groupValues_.addAll(other.groupValues_);
          }
          onChanged();
        }
      } else {
        if (!other.groupValues_.isEmpty()) {
          if (groupValuesBuilder_.isEmpty()) {
            groupValuesBuilder_.dispose();
            groupValuesBuilder_ = null;
            groupValues_ = other.groupValues_;
            bitField0_ = (bitField0_ & ~0x00000004);
            groupValuesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGroupValuesFieldBuilder()
                    : null;
          } else {
            groupValuesBuilder_.addAllMessages(other.groupValues_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                value_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.shopping.type.CustomAttribute m =
                    input.readMessage(
                        com.google.shopping.type.CustomAttribute.parser(), extensionRegistry);
                if (groupValuesBuilder_ == null) {
                  ensureGroupValuesIsMutable();
                  groupValues_.add(m);
                } else {
                  groupValuesBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * The name of the attribute.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The name of the attribute.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the attribute.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The name of the attribute.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the attribute.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The name of the attribute.
     * </pre>
     *
     * <code>optional string name = 1;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object value_ = "";

    /**
     *
     *
     * <pre>
     * The value of the attribute. If `value` is not empty, `group_values` must be
     * empty.
     * </pre>
     *
     * <code>optional string value = 2;</code>
     *
     * @return Whether the value field is set.
     */
    public boolean hasValue() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The value of the attribute. If `value` is not empty, `group_values` must be
     * empty.
     * </pre>
     *
     * <code>optional string value = 2;</code>
     *
     * @return The value.
     */
    public java.lang.String getValue() {
      java.lang.Object ref = value_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        value_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The value of the attribute. If `value` is not empty, `group_values` must be
     * empty.
     * </pre>
     *
     * <code>optional string value = 2;</code>
     *
     * @return The bytes for value.
     */
    public com.google.protobuf.ByteString getValueBytes() {
      java.lang.Object ref = value_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        value_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The value of the attribute. If `value` is not empty, `group_values` must be
     * empty.
     * </pre>
     *
     * <code>optional string value = 2;</code>
     *
     * @param value The value to set.
     * @return This builder for chaining.
     */
    public Builder setValue(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      value_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The value of the attribute. If `value` is not empty, `group_values` must be
     * empty.
     * </pre>
     *
     * <code>optional string value = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValue() {
      value_ = getDefaultInstance().getValue();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The value of the attribute. If `value` is not empty, `group_values` must be
     * empty.
     * </pre>
     *
     * <code>optional string value = 2;</code>
     *
     * @param value The bytes for value to set.
     * @return This builder for chaining.
     */
    public Builder setValueBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      value_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.shopping.type.CustomAttribute> groupValues_ =
        java.util.Collections.emptyList();

    private void ensureGroupValuesIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        groupValues_ =
            new java.util.ArrayList<com.google.shopping.type.CustomAttribute>(groupValues_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.shopping.type.CustomAttribute,
            com.google.shopping.type.CustomAttribute.Builder,
            com.google.shopping.type.CustomAttributeOrBuilder>
        groupValuesBuilder_;

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public java.util.List<com.google.shopping.type.CustomAttribute> getGroupValuesList() {
      if (groupValuesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(groupValues_);
      } else {
        return groupValuesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public int getGroupValuesCount() {
      if (groupValuesBuilder_ == null) {
        return groupValues_.size();
      } else {
        return groupValuesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public com.google.shopping.type.CustomAttribute getGroupValues(int index) {
      if (groupValuesBuilder_ == null) {
        return groupValues_.get(index);
      } else {
        return groupValuesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder setGroupValues(int index, com.google.shopping.type.CustomAttribute value) {
      if (groupValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupValuesIsMutable();
        groupValues_.set(index, value);
        onChanged();
      } else {
        groupValuesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder setGroupValues(
        int index, com.google.shopping.type.CustomAttribute.Builder builderForValue) {
      if (groupValuesBuilder_ == null) {
        ensureGroupValuesIsMutable();
        groupValues_.set(index, builderForValue.build());
        onChanged();
      } else {
        groupValuesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder addGroupValues(com.google.shopping.type.CustomAttribute value) {
      if (groupValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupValuesIsMutable();
        groupValues_.add(value);
        onChanged();
      } else {
        groupValuesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder addGroupValues(int index, com.google.shopping.type.CustomAttribute value) {
      if (groupValuesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGroupValuesIsMutable();
        groupValues_.add(index, value);
        onChanged();
      } else {
        groupValuesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder addGroupValues(
        com.google.shopping.type.CustomAttribute.Builder builderForValue) {
      if (groupValuesBuilder_ == null) {
        ensureGroupValuesIsMutable();
        groupValues_.add(builderForValue.build());
        onChanged();
      } else {
        groupValuesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder addGroupValues(
        int index, com.google.shopping.type.CustomAttribute.Builder builderForValue) {
      if (groupValuesBuilder_ == null) {
        ensureGroupValuesIsMutable();
        groupValues_.add(index, builderForValue.build());
        onChanged();
      } else {
        groupValuesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder addAllGroupValues(
        java.lang.Iterable<? extends com.google.shopping.type.CustomAttribute> values) {
      if (groupValuesBuilder_ == null) {
        ensureGroupValuesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, groupValues_);
        onChanged();
      } else {
        groupValuesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder clearGroupValues() {
      if (groupValuesBuilder_ == null) {
        groupValues_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        groupValuesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public Builder removeGroupValues(int index) {
      if (groupValuesBuilder_ == null) {
        ensureGroupValuesIsMutable();
        groupValues_.remove(index);
        onChanged();
      } else {
        groupValuesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public com.google.shopping.type.CustomAttribute.Builder getGroupValuesBuilder(int index) {
      return getGroupValuesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public com.google.shopping.type.CustomAttributeOrBuilder getGroupValuesOrBuilder(int index) {
      if (groupValuesBuilder_ == null) {
        return groupValues_.get(index);
      } else {
        return groupValuesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public java.util.List<? extends com.google.shopping.type.CustomAttributeOrBuilder>
        getGroupValuesOrBuilderList() {
      if (groupValuesBuilder_ != null) {
        return groupValuesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(groupValues_);
      }
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public com.google.shopping.type.CustomAttribute.Builder addGroupValuesBuilder() {
      return getGroupValuesFieldBuilder()
          .addBuilder(com.google.shopping.type.CustomAttribute.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public com.google.shopping.type.CustomAttribute.Builder addGroupValuesBuilder(int index) {
      return getGroupValuesFieldBuilder()
          .addBuilder(index, com.google.shopping.type.CustomAttribute.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Subattributes within this attribute group.  If
     * `group_values` is not empty, `value` must be empty.
     * </pre>
     *
     * <code>repeated .google.shopping.type.CustomAttribute group_values = 3;</code>
     */
    public java.util.List<com.google.shopping.type.CustomAttribute.Builder>
        getGroupValuesBuilderList() {
      return getGroupValuesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.shopping.type.CustomAttribute,
            com.google.shopping.type.CustomAttribute.Builder,
            com.google.shopping.type.CustomAttributeOrBuilder>
        getGroupValuesFieldBuilder() {
      if (groupValuesBuilder_ == null) {
        groupValuesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.shopping.type.CustomAttribute,
                com.google.shopping.type.CustomAttribute.Builder,
                com.google.shopping.type.CustomAttributeOrBuilder>(
                groupValues_, ((bitField0_ & 0x00000004) != 0), getParentForChildren(), isClean());
        groupValues_ = null;
      }
      return groupValuesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.shopping.type.CustomAttribute)
  }

  // @@protoc_insertion_point(class_scope:google.shopping.type.CustomAttribute)
  private static final com.google.shopping.type.CustomAttribute DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.shopping.type.CustomAttribute();
  }

  public static com.google.shopping.type.CustomAttribute getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomAttribute> PARSER =
      new com.google.protobuf.AbstractParser<CustomAttribute>() {
        @java.lang.Override
        public CustomAttribute parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CustomAttribute> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomAttribute> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.shopping.type.CustomAttribute getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
