/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.websecurityscanner.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FindingName
implements ResourceName {
    private static final PathTemplate PROJECT_SCAN_CONFIG_SCAN_RUN_FINDING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/scanConfigs/{scan_config}/scanRuns/{scan_run}/findings/{finding}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String scanConfig;
    private final String scanRun;
    private final String finding;

    @Deprecated
    protected FindingName() {
        this.project = null;
        this.scanConfig = null;
        this.scanRun = null;
        this.finding = null;
    }

    private FindingName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.scanConfig = (String)Preconditions.checkNotNull((Object)builder.getScanConfig());
        this.scanRun = (String)Preconditions.checkNotNull((Object)builder.getScanRun());
        this.finding = (String)Preconditions.checkNotNull((Object)builder.getFinding());
    }

    public String getProject() {
        return this.project;
    }

    public String getScanConfig() {
        return this.scanConfig;
    }

    public String getScanRun() {
        return this.scanRun;
    }

    public String getFinding() {
        return this.finding;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FindingName of(String project, String scanConfig, String scanRun, String finding) {
        return FindingName.newBuilder().setProject(project).setScanConfig(scanConfig).setScanRun(scanRun).setFinding(finding).build();
    }

    public static String format(String project, String scanConfig, String scanRun, String finding) {
        return FindingName.newBuilder().setProject(project).setScanConfig(scanConfig).setScanRun(scanRun).setFinding(finding).build().toString();
    }

    public static FindingName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_SCAN_CONFIG_SCAN_RUN_FINDING.validatedMatch(formattedString, "FindingName.parse: formattedString not in valid format");
        return FindingName.of((String)matchMap.get("project"), (String)matchMap.get("scan_config"), (String)matchMap.get("scan_run"), (String)matchMap.get("finding"));
    }

    public static List<FindingName> parseList(List<String> formattedStrings) {
        ArrayList<FindingName> list = new ArrayList<FindingName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FindingName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FindingName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FindingName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_SCAN_CONFIG_SCAN_RUN_FINDING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FindingName findingName = this;
            synchronized (findingName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.scanConfig != null) {
                        fieldMapBuilder.put((Object)"scan_config", (Object)this.scanConfig);
                    }
                    if (this.scanRun != null) {
                        fieldMapBuilder.put((Object)"scan_run", (Object)this.scanRun);
                    }
                    if (this.finding != null) {
                        fieldMapBuilder.put((Object)"finding", (Object)this.finding);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_SCAN_CONFIG_SCAN_RUN_FINDING.instantiate(new String[]{"project", this.project, "scan_config", this.scanConfig, "scan_run", this.scanRun, "finding", this.finding});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            FindingName that = (FindingName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.scanConfig, that.scanConfig) && Objects.equals(this.scanRun, that.scanRun) && Objects.equals(this.finding, that.finding);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.scanConfig);
        h *= 1000003;
        h ^= Objects.hashCode(this.scanRun);
        h *= 1000003;
        return h ^= Objects.hashCode(this.finding);
    }

    public static class Builder {
        private String project;
        private String scanConfig;
        private String scanRun;
        private String finding;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getScanConfig() {
            return this.scanConfig;
        }

        public String getScanRun() {
            return this.scanRun;
        }

        public String getFinding() {
            return this.finding;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setScanConfig(String scanConfig) {
            this.scanConfig = scanConfig;
            return this;
        }

        public Builder setScanRun(String scanRun) {
            this.scanRun = scanRun;
            return this;
        }

        public Builder setFinding(String finding) {
            this.finding = finding;
            return this;
        }

        private Builder(FindingName findingName) {
            this.project = findingName.project;
            this.scanConfig = findingName.scanConfig;
            this.scanRun = findingName.scanRun;
            this.finding = findingName.finding;
        }

        public FindingName build() {
            return new FindingName(this);
        }
    }
}

