/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NetworkPeeringName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NETWORK_PEERING = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/networkPeerings/{network_peering}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String networkPeering;

    @Deprecated
    protected NetworkPeeringName() {
        this.project = null;
        this.location = null;
        this.networkPeering = null;
    }

    private NetworkPeeringName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.networkPeering = (String)Preconditions.checkNotNull((Object)builder.getNetworkPeering());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNetworkPeering() {
        return this.networkPeering;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NetworkPeeringName of(String project, String location, String networkPeering) {
        return NetworkPeeringName.newBuilder().setProject(project).setLocation(location).setNetworkPeering(networkPeering).build();
    }

    public static String format(String project, String location, String networkPeering) {
        return NetworkPeeringName.newBuilder().setProject(project).setLocation(location).setNetworkPeering(networkPeering).build().toString();
    }

    public static NetworkPeeringName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NETWORK_PEERING.validatedMatch(formattedString, "NetworkPeeringName.parse: formattedString not in valid format");
        return NetworkPeeringName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("network_peering"));
    }

    public static List<NetworkPeeringName> parseList(List<String> formattedStrings) {
        ArrayList<NetworkPeeringName> list = new ArrayList<NetworkPeeringName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NetworkPeeringName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NetworkPeeringName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NetworkPeeringName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NETWORK_PEERING.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NetworkPeeringName networkPeeringName = this;
            synchronized (networkPeeringName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.networkPeering != null) {
                        fieldMapBuilder.put((Object)"network_peering", (Object)this.networkPeering);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NETWORK_PEERING.instantiate(new String[]{"project", this.project, "location", this.location, "network_peering", this.networkPeering});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NetworkPeeringName that = (NetworkPeeringName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.networkPeering, that.networkPeering);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.networkPeering);
    }

    public static class Builder {
        private String project;
        private String location;
        private String networkPeering;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNetworkPeering() {
            return this.networkPeering;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNetworkPeering(String networkPeering) {
            this.networkPeering = networkPeering;
            return this;
        }

        private Builder(NetworkPeeringName networkPeeringName) {
            this.project = networkPeeringName.project;
            this.location = networkPeeringName.location;
            this.networkPeering = networkPeeringName.networkPeering;
        }

        public NetworkPeeringName build() {
            return new NetworkPeeringName(this);
        }
    }
}

