/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.vmwareengine.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class PrivateCloudName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PRIVATE_CLOUD = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/privateClouds/{private_cloud}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String privateCloud;

    @Deprecated
    protected PrivateCloudName() {
        this.project = null;
        this.location = null;
        this.privateCloud = null;
    }

    private PrivateCloudName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.privateCloud = (String)Preconditions.checkNotNull((Object)builder.getPrivateCloud());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPrivateCloud() {
        return this.privateCloud;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static PrivateCloudName of(String project, String location, String privateCloud) {
        return PrivateCloudName.newBuilder().setProject(project).setLocation(location).setPrivateCloud(privateCloud).build();
    }

    public static String format(String project, String location, String privateCloud) {
        return PrivateCloudName.newBuilder().setProject(project).setLocation(location).setPrivateCloud(privateCloud).build().toString();
    }

    public static PrivateCloudName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PRIVATE_CLOUD.validatedMatch(formattedString, "PrivateCloudName.parse: formattedString not in valid format");
        return PrivateCloudName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("private_cloud"));
    }

    public static List<PrivateCloudName> parseList(List<String> formattedStrings) {
        ArrayList<PrivateCloudName> list = new ArrayList<PrivateCloudName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(PrivateCloudName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<PrivateCloudName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (PrivateCloudName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PRIVATE_CLOUD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            PrivateCloudName privateCloudName = this;
            synchronized (privateCloudName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.privateCloud != null) {
                        fieldMapBuilder.put((Object)"private_cloud", (Object)this.privateCloud);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PRIVATE_CLOUD.instantiate(new String[]{"project", this.project, "location", this.location, "private_cloud", this.privateCloud});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            PrivateCloudName that = (PrivateCloudName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.privateCloud, that.privateCloud);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.privateCloud);
    }

    public static class Builder {
        private String project;
        private String location;
        private String privateCloud;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getPrivateCloud() {
            return this.privateCloud;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setPrivateCloud(String privateCloud) {
            this.privateCloud = privateCloud;
            return this;
        }

        private Builder(PrivateCloudName privateCloudName) {
            this.project = privateCloudName.project;
            this.location = privateCloudName.location;
            this.privateCloud = privateCloudName.privateCloud;
        }

        public PrivateCloudName build() {
            return new PrivateCloudName(this);
        }
    }
}

