/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/videointelligence/v1/video_intelligence.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.videointelligence.v1;

/**
 *
 *
 * <pre>
 * Annotation results for a single video.
 * </pre>
 *
 * Protobuf type {@code google.cloud.videointelligence.v1.VideoAnnotationResults}
 */
public final class VideoAnnotationResults extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.videointelligence.v1.VideoAnnotationResults)
    VideoAnnotationResultsOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use VideoAnnotationResults.newBuilder() to construct.
  private VideoAnnotationResults(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VideoAnnotationResults() {
    inputUri_ = "";
    segmentLabelAnnotations_ = java.util.Collections.emptyList();
    segmentPresenceLabelAnnotations_ = java.util.Collections.emptyList();
    shotLabelAnnotations_ = java.util.Collections.emptyList();
    shotPresenceLabelAnnotations_ = java.util.Collections.emptyList();
    frameLabelAnnotations_ = java.util.Collections.emptyList();
    faceAnnotations_ = java.util.Collections.emptyList();
    faceDetectionAnnotations_ = java.util.Collections.emptyList();
    shotAnnotations_ = java.util.Collections.emptyList();
    speechTranscriptions_ = java.util.Collections.emptyList();
    textAnnotations_ = java.util.Collections.emptyList();
    objectAnnotations_ = java.util.Collections.emptyList();
    logoRecognitionAnnotations_ = java.util.Collections.emptyList();
    personDetectionAnnotations_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VideoAnnotationResults();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_VideoAnnotationResults_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
        .internal_static_google_cloud_videointelligence_v1_VideoAnnotationResults_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.videointelligence.v1.VideoAnnotationResults.class,
            com.google.cloud.videointelligence.v1.VideoAnnotationResults.Builder.class);
  }

  private int bitField0_;
  public static final int INPUT_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object inputUri_ = "";
  /**
   *
   *
   * <pre>
   * Video file location in
   * [Cloud Storage](https://cloud.google.com/storage/).
   * </pre>
   *
   * <code>string input_uri = 1;</code>
   *
   * @return The inputUri.
   */
  @java.lang.Override
  public java.lang.String getInputUri() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      inputUri_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Video file location in
   * [Cloud Storage](https://cloud.google.com/storage/).
   * </pre>
   *
   * <code>string input_uri = 1;</code>
   *
   * @return The bytes for inputUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInputUriBytes() {
    java.lang.Object ref = inputUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      inputUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SEGMENT_FIELD_NUMBER = 10;
  private com.google.cloud.videointelligence.v1.VideoSegment segment_;
  /**
   *
   *
   * <pre>
   * Video segment on which the annotation is run.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
   *
   * @return Whether the segment field is set.
   */
  @java.lang.Override
  public boolean hasSegment() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Video segment on which the annotation is run.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
   *
   * @return The segment.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegment getSegment() {
    return segment_ == null
        ? com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance()
        : segment_;
  }
  /**
   *
   *
   * <pre>
   * Video segment on which the annotation is run.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getSegmentOrBuilder() {
    return segment_ == null
        ? com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance()
        : segment_;
  }

  public static final int SEGMENT_LABEL_ANNOTATIONS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      segmentLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Topical label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      getSegmentLabelAnnotationsList() {
    return segmentLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Topical label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
      getSegmentLabelAnnotationsOrBuilderList() {
    return segmentLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Topical label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public int getSegmentLabelAnnotationsCount() {
    return segmentLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Topical label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotation getSegmentLabelAnnotations(
      int index) {
    return segmentLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Topical label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
      getSegmentLabelAnnotationsOrBuilder(int index) {
    return segmentLabelAnnotations_.get(index);
  }

  public static final int SEGMENT_PRESENCE_LABEL_ANNOTATIONS_FIELD_NUMBER = 23;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      segmentPresenceLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Presence label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label. Compared to the
   * existing topical `segment_label_annotations`, this field presents more
   * fine-grained, segment-level labels detected in video content and is made
   * available only when the client sets `LabelDetectionConfig.model` to
   * "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      getSegmentPresenceLabelAnnotationsList() {
    return segmentPresenceLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Presence label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label. Compared to the
   * existing topical `segment_label_annotations`, this field presents more
   * fine-grained, segment-level labels detected in video content and is made
   * available only when the client sets `LabelDetectionConfig.model` to
   * "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
      getSegmentPresenceLabelAnnotationsOrBuilderList() {
    return segmentPresenceLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Presence label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label. Compared to the
   * existing topical `segment_label_annotations`, this field presents more
   * fine-grained, segment-level labels detected in video content and is made
   * available only when the client sets `LabelDetectionConfig.model` to
   * "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
   * </code>
   */
  @java.lang.Override
  public int getSegmentPresenceLabelAnnotationsCount() {
    return segmentPresenceLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Presence label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label. Compared to the
   * existing topical `segment_label_annotations`, this field presents more
   * fine-grained, segment-level labels detected in video content and is made
   * available only when the client sets `LabelDetectionConfig.model` to
   * "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotation getSegmentPresenceLabelAnnotations(
      int index) {
    return segmentPresenceLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Presence label annotations on video level or user-specified segment level.
   * There is exactly one element for each unique label. Compared to the
   * existing topical `segment_label_annotations`, this field presents more
   * fine-grained, segment-level labels detected in video content and is made
   * available only when the client sets `LabelDetectionConfig.model` to
   * "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
      getSegmentPresenceLabelAnnotationsOrBuilder(int index) {
    return segmentPresenceLabelAnnotations_.get(index);
  }

  public static final int SHOT_LABEL_ANNOTATIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      shotLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Topical label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      getShotLabelAnnotationsList() {
    return shotLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Topical label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
      getShotLabelAnnotationsOrBuilderList() {
    return shotLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Topical label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public int getShotLabelAnnotationsCount() {
    return shotLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Topical label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotation getShotLabelAnnotations(int index) {
    return shotLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Topical label annotations on shot level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
      getShotLabelAnnotationsOrBuilder(int index) {
    return shotLabelAnnotations_.get(index);
  }

  public static final int SHOT_PRESENCE_LABEL_ANNOTATIONS_FIELD_NUMBER = 24;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      shotPresenceLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Presence label annotations on shot level. There is exactly one element for
   * each unique label. Compared to the existing topical
   * `shot_label_annotations`, this field presents more fine-grained, shot-level
   * labels detected in video content and is made available only when the client
   * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      getShotPresenceLabelAnnotationsList() {
    return shotPresenceLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Presence label annotations on shot level. There is exactly one element for
   * each unique label. Compared to the existing topical
   * `shot_label_annotations`, this field presents more fine-grained, shot-level
   * labels detected in video content and is made available only when the client
   * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
      getShotPresenceLabelAnnotationsOrBuilderList() {
    return shotPresenceLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Presence label annotations on shot level. There is exactly one element for
   * each unique label. Compared to the existing topical
   * `shot_label_annotations`, this field presents more fine-grained, shot-level
   * labels detected in video content and is made available only when the client
   * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
   * </code>
   */
  @java.lang.Override
  public int getShotPresenceLabelAnnotationsCount() {
    return shotPresenceLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Presence label annotations on shot level. There is exactly one element for
   * each unique label. Compared to the existing topical
   * `shot_label_annotations`, this field presents more fine-grained, shot-level
   * labels detected in video content and is made available only when the client
   * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotation getShotPresenceLabelAnnotations(
      int index) {
    return shotPresenceLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Presence label annotations on shot level. There is exactly one element for
   * each unique label. Compared to the existing topical
   * `shot_label_annotations`, this field presents more fine-grained, shot-level
   * labels detected in video content and is made available only when the client
   * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
      getShotPresenceLabelAnnotationsOrBuilder(int index) {
    return shotPresenceLabelAnnotations_.get(index);
  }

  public static final int FRAME_LABEL_ANNOTATIONS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      frameLabelAnnotations_;
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
      getFrameLabelAnnotationsList() {
    return frameLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
      getFrameLabelAnnotationsOrBuilderList() {
    return frameLabelAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public int getFrameLabelAnnotationsCount() {
    return frameLabelAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotation getFrameLabelAnnotations(int index) {
    return frameLabelAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Label annotations on frame level.
   * There is exactly one element for each unique label.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
      getFrameLabelAnnotationsOrBuilder(int index) {
    return frameLabelAnnotations_.get(index);
  }

  public static final int FACE_ANNOTATIONS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.FaceAnnotation> faceAnnotations_;
  /**
   *
   *
   * <pre>
   * Deprecated. Please use `face_detection_annotations` instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<com.google.cloud.videointelligence.v1.FaceAnnotation>
      getFaceAnnotationsList() {
    return faceAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Please use `face_detection_annotations` instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.List<? extends com.google.cloud.videointelligence.v1.FaceAnnotationOrBuilder>
      getFaceAnnotationsOrBuilderList() {
    return faceAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Please use `face_detection_annotations` instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public int getFaceAnnotationsCount() {
    return faceAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Please use `face_detection_annotations` instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.videointelligence.v1.FaceAnnotation getFaceAnnotations(int index) {
    return faceAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated. Please use `face_detection_annotations` instead.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
   * </code>
   */
  @java.lang.Override
  @java.lang.Deprecated
  public com.google.cloud.videointelligence.v1.FaceAnnotationOrBuilder getFaceAnnotationsOrBuilder(
      int index) {
    return faceAnnotations_.get(index);
  }

  public static final int FACE_DETECTION_ANNOTATIONS_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.FaceDetectionAnnotation>
      faceDetectionAnnotations_;
  /**
   *
   *
   * <pre>
   * Face detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.FaceDetectionAnnotation>
      getFaceDetectionAnnotationsList() {
    return faceDetectionAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Face detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1.FaceDetectionAnnotationOrBuilder>
      getFaceDetectionAnnotationsOrBuilderList() {
    return faceDetectionAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Face detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
   * </code>
   */
  @java.lang.Override
  public int getFaceDetectionAnnotationsCount() {
    return faceDetectionAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Face detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.FaceDetectionAnnotation getFaceDetectionAnnotations(
      int index) {
    return faceDetectionAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Face detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.FaceDetectionAnnotationOrBuilder
      getFaceDetectionAnnotationsOrBuilder(int index) {
    return faceDetectionAnnotations_.get(index);
  }

  public static final int SHOT_ANNOTATIONS_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> shotAnnotations_;
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment>
      getShotAnnotationsList() {
    return shotAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
      getShotAnnotationsOrBuilderList() {
    return shotAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
   */
  @java.lang.Override
  public int getShotAnnotationsCount() {
    return shotAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegment getShotAnnotations(int index) {
    return shotAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Shot annotations. Each shot is represented as a video segment.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getShotAnnotationsOrBuilder(
      int index) {
    return shotAnnotations_.get(index);
  }

  public static final int EXPLICIT_ANNOTATION_FIELD_NUMBER = 7;
  private com.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicitAnnotation_;
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   *
   * @return Whether the explicitAnnotation field is set.
   */
  @java.lang.Override
  public boolean hasExplicitAnnotation() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   *
   * @return The explicitAnnotation.
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ExplicitContentAnnotation getExplicitAnnotation() {
    return explicitAnnotation_ == null
        ? com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.getDefaultInstance()
        : explicitAnnotation_;
  }
  /**
   *
   *
   * <pre>
   * Explicit content annotation.
   * </pre>
   *
   * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ExplicitContentAnnotationOrBuilder
      getExplicitAnnotationOrBuilder() {
    return explicitAnnotation_ == null
        ? com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.getDefaultInstance()
        : explicitAnnotation_;
  }

  public static final int SPEECH_TRANSCRIPTIONS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.SpeechTranscription>
      speechTranscriptions_;
  /**
   *
   *
   * <pre>
   * Speech transcription.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.SpeechTranscription>
      getSpeechTranscriptionsList() {
    return speechTranscriptions_;
  }
  /**
   *
   *
   * <pre>
   * Speech transcription.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1.SpeechTranscriptionOrBuilder>
      getSpeechTranscriptionsOrBuilderList() {
    return speechTranscriptions_;
  }
  /**
   *
   *
   * <pre>
   * Speech transcription.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
   * </code>
   */
  @java.lang.Override
  public int getSpeechTranscriptionsCount() {
    return speechTranscriptions_.size();
  }
  /**
   *
   *
   * <pre>
   * Speech transcription.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.SpeechTranscription getSpeechTranscriptions(
      int index) {
    return speechTranscriptions_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Speech transcription.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.SpeechTranscriptionOrBuilder
      getSpeechTranscriptionsOrBuilder(int index) {
    return speechTranscriptions_.get(index);
  }

  public static final int TEXT_ANNOTATIONS_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.TextAnnotation> textAnnotations_;
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.TextAnnotation>
      getTextAnnotationsList() {
    return textAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.videointelligence.v1.TextAnnotationOrBuilder>
      getTextAnnotationsOrBuilderList() {
    return textAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;</code>
   */
  @java.lang.Override
  public int getTextAnnotationsCount() {
    return textAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.TextAnnotation getTextAnnotations(int index) {
    return textAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * OCR text detection and tracking.
   * Annotations for list of detected text snippets. Each will have list of
   * frame information associated with it.
   * </pre>
   *
   * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;</code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.TextAnnotationOrBuilder getTextAnnotationsOrBuilder(
      int index) {
    return textAnnotations_.get(index);
  }

  public static final int OBJECT_ANNOTATIONS_FIELD_NUMBER = 14;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation>
      objectAnnotations_;
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation>
      getObjectAnnotationsList() {
    return objectAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1.ObjectTrackingAnnotationOrBuilder>
      getObjectAnnotationsOrBuilderList() {
    return objectAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public int getObjectAnnotationsCount() {
    return objectAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation getObjectAnnotations(
      int index) {
    return objectAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of objects detected and tracked in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.ObjectTrackingAnnotationOrBuilder
      getObjectAnnotationsOrBuilder(int index) {
    return objectAnnotations_.get(index);
  }

  public static final int LOGO_RECOGNITION_ANNOTATIONS_FIELD_NUMBER = 19;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation>
      logoRecognitionAnnotations_;
  /**
   *
   *
   * <pre>
   * Annotations for list of logos detected, tracked and recognized in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation>
      getLogoRecognitionAnnotationsList() {
    return logoRecognitionAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of logos detected, tracked and recognized in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1.LogoRecognitionAnnotationOrBuilder>
      getLogoRecognitionAnnotationsOrBuilderList() {
    return logoRecognitionAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of logos detected, tracked and recognized in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
   * </code>
   */
  @java.lang.Override
  public int getLogoRecognitionAnnotationsCount() {
    return logoRecognitionAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of logos detected, tracked and recognized in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation
      getLogoRecognitionAnnotations(int index) {
    return logoRecognitionAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Annotations for list of logos detected, tracked and recognized in video.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotationOrBuilder
      getLogoRecognitionAnnotationsOrBuilder(int index) {
    return logoRecognitionAnnotations_.get(index);
  }

  public static final int PERSON_DETECTION_ANNOTATIONS_FIELD_NUMBER = 20;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.videointelligence.v1.PersonDetectionAnnotation>
      personDetectionAnnotations_;
  /**
   *
   *
   * <pre>
   * Person detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.videointelligence.v1.PersonDetectionAnnotation>
      getPersonDetectionAnnotationsList() {
    return personDetectionAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Person detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.videointelligence.v1.PersonDetectionAnnotationOrBuilder>
      getPersonDetectionAnnotationsOrBuilderList() {
    return personDetectionAnnotations_;
  }
  /**
   *
   *
   * <pre>
   * Person detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
   * </code>
   */
  @java.lang.Override
  public int getPersonDetectionAnnotationsCount() {
    return personDetectionAnnotations_.size();
  }
  /**
   *
   *
   * <pre>
   * Person detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.PersonDetectionAnnotation
      getPersonDetectionAnnotations(int index) {
    return personDetectionAnnotations_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Person detection annotations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.videointelligence.v1.PersonDetectionAnnotationOrBuilder
      getPersonDetectionAnnotationsOrBuilder(int index) {
    return personDetectionAnnotations_.get(index);
  }

  public static final int ERROR_FIELD_NUMBER = 9;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
   * some videos may succeed and some may fail.
   * </pre>
   *
   * <code>.google.rpc.Status error = 9;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, inputUri_);
    }
    for (int i = 0; i < segmentLabelAnnotations_.size(); i++) {
      output.writeMessage(2, segmentLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotLabelAnnotations_.size(); i++) {
      output.writeMessage(3, shotLabelAnnotations_.get(i));
    }
    for (int i = 0; i < frameLabelAnnotations_.size(); i++) {
      output.writeMessage(4, frameLabelAnnotations_.get(i));
    }
    for (int i = 0; i < faceAnnotations_.size(); i++) {
      output.writeMessage(5, faceAnnotations_.get(i));
    }
    for (int i = 0; i < shotAnnotations_.size(); i++) {
      output.writeMessage(6, shotAnnotations_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getExplicitAnnotation());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(9, getError());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(10, getSegment());
    }
    for (int i = 0; i < speechTranscriptions_.size(); i++) {
      output.writeMessage(11, speechTranscriptions_.get(i));
    }
    for (int i = 0; i < textAnnotations_.size(); i++) {
      output.writeMessage(12, textAnnotations_.get(i));
    }
    for (int i = 0; i < faceDetectionAnnotations_.size(); i++) {
      output.writeMessage(13, faceDetectionAnnotations_.get(i));
    }
    for (int i = 0; i < objectAnnotations_.size(); i++) {
      output.writeMessage(14, objectAnnotations_.get(i));
    }
    for (int i = 0; i < logoRecognitionAnnotations_.size(); i++) {
      output.writeMessage(19, logoRecognitionAnnotations_.get(i));
    }
    for (int i = 0; i < personDetectionAnnotations_.size(); i++) {
      output.writeMessage(20, personDetectionAnnotations_.get(i));
    }
    for (int i = 0; i < segmentPresenceLabelAnnotations_.size(); i++) {
      output.writeMessage(23, segmentPresenceLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotPresenceLabelAnnotations_.size(); i++) {
      output.writeMessage(24, shotPresenceLabelAnnotations_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(inputUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, inputUri_);
    }
    for (int i = 0; i < segmentLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, segmentLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, shotLabelAnnotations_.get(i));
    }
    for (int i = 0; i < frameLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, frameLabelAnnotations_.get(i));
    }
    for (int i = 0; i < faceAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, faceAnnotations_.get(i));
    }
    for (int i = 0; i < shotAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, shotAnnotations_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getExplicitAnnotation());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getError());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getSegment());
    }
    for (int i = 0; i < speechTranscriptions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11, speechTranscriptions_.get(i));
    }
    for (int i = 0; i < textAnnotations_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, textAnnotations_.get(i));
    }
    for (int i = 0; i < faceDetectionAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              13, faceDetectionAnnotations_.get(i));
    }
    for (int i = 0; i < objectAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(14, objectAnnotations_.get(i));
    }
    for (int i = 0; i < logoRecognitionAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              19, logoRecognitionAnnotations_.get(i));
    }
    for (int i = 0; i < personDetectionAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              20, personDetectionAnnotations_.get(i));
    }
    for (int i = 0; i < segmentPresenceLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              23, segmentPresenceLabelAnnotations_.get(i));
    }
    for (int i = 0; i < shotPresenceLabelAnnotations_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              24, shotPresenceLabelAnnotations_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.videointelligence.v1.VideoAnnotationResults)) {
      return super.equals(obj);
    }
    com.google.cloud.videointelligence.v1.VideoAnnotationResults other =
        (com.google.cloud.videointelligence.v1.VideoAnnotationResults) obj;

    if (!getInputUri().equals(other.getInputUri())) return false;
    if (hasSegment() != other.hasSegment()) return false;
    if (hasSegment()) {
      if (!getSegment().equals(other.getSegment())) return false;
    }
    if (!getSegmentLabelAnnotationsList().equals(other.getSegmentLabelAnnotationsList()))
      return false;
    if (!getSegmentPresenceLabelAnnotationsList()
        .equals(other.getSegmentPresenceLabelAnnotationsList())) return false;
    if (!getShotLabelAnnotationsList().equals(other.getShotLabelAnnotationsList())) return false;
    if (!getShotPresenceLabelAnnotationsList().equals(other.getShotPresenceLabelAnnotationsList()))
      return false;
    if (!getFrameLabelAnnotationsList().equals(other.getFrameLabelAnnotationsList())) return false;
    if (!getFaceAnnotationsList().equals(other.getFaceAnnotationsList())) return false;
    if (!getFaceDetectionAnnotationsList().equals(other.getFaceDetectionAnnotationsList()))
      return false;
    if (!getShotAnnotationsList().equals(other.getShotAnnotationsList())) return false;
    if (hasExplicitAnnotation() != other.hasExplicitAnnotation()) return false;
    if (hasExplicitAnnotation()) {
      if (!getExplicitAnnotation().equals(other.getExplicitAnnotation())) return false;
    }
    if (!getSpeechTranscriptionsList().equals(other.getSpeechTranscriptionsList())) return false;
    if (!getTextAnnotationsList().equals(other.getTextAnnotationsList())) return false;
    if (!getObjectAnnotationsList().equals(other.getObjectAnnotationsList())) return false;
    if (!getLogoRecognitionAnnotationsList().equals(other.getLogoRecognitionAnnotationsList()))
      return false;
    if (!getPersonDetectionAnnotationsList().equals(other.getPersonDetectionAnnotationsList()))
      return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + INPUT_URI_FIELD_NUMBER;
    hash = (53 * hash) + getInputUri().hashCode();
    if (hasSegment()) {
      hash = (37 * hash) + SEGMENT_FIELD_NUMBER;
      hash = (53 * hash) + getSegment().hashCode();
    }
    if (getSegmentLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + SEGMENT_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentLabelAnnotationsList().hashCode();
    }
    if (getSegmentPresenceLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + SEGMENT_PRESENCE_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSegmentPresenceLabelAnnotationsList().hashCode();
    }
    if (getShotLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + SHOT_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getShotLabelAnnotationsList().hashCode();
    }
    if (getShotPresenceLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + SHOT_PRESENCE_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getShotPresenceLabelAnnotationsList().hashCode();
    }
    if (getFrameLabelAnnotationsCount() > 0) {
      hash = (37 * hash) + FRAME_LABEL_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFrameLabelAnnotationsList().hashCode();
    }
    if (getFaceAnnotationsCount() > 0) {
      hash = (37 * hash) + FACE_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFaceAnnotationsList().hashCode();
    }
    if (getFaceDetectionAnnotationsCount() > 0) {
      hash = (37 * hash) + FACE_DETECTION_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getFaceDetectionAnnotationsList().hashCode();
    }
    if (getShotAnnotationsCount() > 0) {
      hash = (37 * hash) + SHOT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getShotAnnotationsList().hashCode();
    }
    if (hasExplicitAnnotation()) {
      hash = (37 * hash) + EXPLICIT_ANNOTATION_FIELD_NUMBER;
      hash = (53 * hash) + getExplicitAnnotation().hashCode();
    }
    if (getSpeechTranscriptionsCount() > 0) {
      hash = (37 * hash) + SPEECH_TRANSCRIPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getSpeechTranscriptionsList().hashCode();
    }
    if (getTextAnnotationsCount() > 0) {
      hash = (37 * hash) + TEXT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getTextAnnotationsList().hashCode();
    }
    if (getObjectAnnotationsCount() > 0) {
      hash = (37 * hash) + OBJECT_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getObjectAnnotationsList().hashCode();
    }
    if (getLogoRecognitionAnnotationsCount() > 0) {
      hash = (37 * hash) + LOGO_RECOGNITION_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getLogoRecognitionAnnotationsList().hashCode();
    }
    if (getPersonDetectionAnnotationsCount() > 0) {
      hash = (37 * hash) + PERSON_DETECTION_ANNOTATIONS_FIELD_NUMBER;
      hash = (53 * hash) + getPersonDetectionAnnotationsList().hashCode();
    }
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.videointelligence.v1.VideoAnnotationResults prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Annotation results for a single video.
   * </pre>
   *
   * Protobuf type {@code google.cloud.videointelligence.v1.VideoAnnotationResults}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.videointelligence.v1.VideoAnnotationResults)
      com.google.cloud.videointelligence.v1.VideoAnnotationResultsOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_VideoAnnotationResults_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_VideoAnnotationResults_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.videointelligence.v1.VideoAnnotationResults.class,
              com.google.cloud.videointelligence.v1.VideoAnnotationResults.Builder.class);
    }

    // Construct using com.google.cloud.videointelligence.v1.VideoAnnotationResults.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSegmentFieldBuilder();
        getSegmentLabelAnnotationsFieldBuilder();
        getSegmentPresenceLabelAnnotationsFieldBuilder();
        getShotLabelAnnotationsFieldBuilder();
        getShotPresenceLabelAnnotationsFieldBuilder();
        getFrameLabelAnnotationsFieldBuilder();
        getFaceAnnotationsFieldBuilder();
        getFaceDetectionAnnotationsFieldBuilder();
        getShotAnnotationsFieldBuilder();
        getExplicitAnnotationFieldBuilder();
        getSpeechTranscriptionsFieldBuilder();
        getTextAnnotationsFieldBuilder();
        getObjectAnnotationsFieldBuilder();
        getLogoRecognitionAnnotationsFieldBuilder();
        getPersonDetectionAnnotationsFieldBuilder();
        getErrorFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      inputUri_ = "";
      segment_ = null;
      if (segmentBuilder_ != null) {
        segmentBuilder_.dispose();
        segmentBuilder_ = null;
      }
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        segmentLabelAnnotations_ = null;
        segmentLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        segmentPresenceLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        segmentPresenceLabelAnnotations_ = null;
        segmentPresenceLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        shotLabelAnnotations_ = null;
        shotLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        shotPresenceLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        shotPresenceLabelAnnotations_ = null;
        shotPresenceLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000020);
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotations_ = java.util.Collections.emptyList();
      } else {
        frameLabelAnnotations_ = null;
        frameLabelAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000040);
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotations_ = java.util.Collections.emptyList();
      } else {
        faceAnnotations_ = null;
        faceAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000080);
      if (faceDetectionAnnotationsBuilder_ == null) {
        faceDetectionAnnotations_ = java.util.Collections.emptyList();
      } else {
        faceDetectionAnnotations_ = null;
        faceDetectionAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotations_ = java.util.Collections.emptyList();
      } else {
        shotAnnotations_ = null;
        shotAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000200);
      explicitAnnotation_ = null;
      if (explicitAnnotationBuilder_ != null) {
        explicitAnnotationBuilder_.dispose();
        explicitAnnotationBuilder_ = null;
      }
      if (speechTranscriptionsBuilder_ == null) {
        speechTranscriptions_ = java.util.Collections.emptyList();
      } else {
        speechTranscriptions_ = null;
        speechTranscriptionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000800);
      if (textAnnotationsBuilder_ == null) {
        textAnnotations_ = java.util.Collections.emptyList();
      } else {
        textAnnotations_ = null;
        textAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00001000);
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotations_ = java.util.Collections.emptyList();
      } else {
        objectAnnotations_ = null;
        objectAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00002000);
      if (logoRecognitionAnnotationsBuilder_ == null) {
        logoRecognitionAnnotations_ = java.util.Collections.emptyList();
      } else {
        logoRecognitionAnnotations_ = null;
        logoRecognitionAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00004000);
      if (personDetectionAnnotationsBuilder_ == null) {
        personDetectionAnnotations_ = java.util.Collections.emptyList();
      } else {
        personDetectionAnnotations_ = null;
        personDetectionAnnotationsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00008000);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.videointelligence.v1.VideoIntelligenceServiceProto
          .internal_static_google_cloud_videointelligence_v1_VideoAnnotationResults_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.VideoAnnotationResults
        getDefaultInstanceForType() {
      return com.google.cloud.videointelligence.v1.VideoAnnotationResults.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.VideoAnnotationResults build() {
      com.google.cloud.videointelligence.v1.VideoAnnotationResults result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.videointelligence.v1.VideoAnnotationResults buildPartial() {
      com.google.cloud.videointelligence.v1.VideoAnnotationResults result =
          new com.google.cloud.videointelligence.v1.VideoAnnotationResults(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.videointelligence.v1.VideoAnnotationResults result) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          segmentLabelAnnotations_ =
              java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.segmentLabelAnnotations_ = segmentLabelAnnotations_;
      } else {
        result.segmentLabelAnnotations_ = segmentLabelAnnotationsBuilder_.build();
      }
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          segmentPresenceLabelAnnotations_ =
              java.util.Collections.unmodifiableList(segmentPresenceLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.segmentPresenceLabelAnnotations_ = segmentPresenceLabelAnnotations_;
      } else {
        result.segmentPresenceLabelAnnotations_ = segmentPresenceLabelAnnotationsBuilder_.build();
      }
      if (shotLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          shotLabelAnnotations_ = java.util.Collections.unmodifiableList(shotLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.shotLabelAnnotations_ = shotLabelAnnotations_;
      } else {
        result.shotLabelAnnotations_ = shotLabelAnnotationsBuilder_.build();
      }
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)) {
          shotPresenceLabelAnnotations_ =
              java.util.Collections.unmodifiableList(shotPresenceLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000020);
        }
        result.shotPresenceLabelAnnotations_ = shotPresenceLabelAnnotations_;
      } else {
        result.shotPresenceLabelAnnotations_ = shotPresenceLabelAnnotationsBuilder_.build();
      }
      if (frameLabelAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)) {
          frameLabelAnnotations_ = java.util.Collections.unmodifiableList(frameLabelAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000040);
        }
        result.frameLabelAnnotations_ = frameLabelAnnotations_;
      } else {
        result.frameLabelAnnotations_ = frameLabelAnnotationsBuilder_.build();
      }
      if (faceAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)) {
          faceAnnotations_ = java.util.Collections.unmodifiableList(faceAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000080);
        }
        result.faceAnnotations_ = faceAnnotations_;
      } else {
        result.faceAnnotations_ = faceAnnotationsBuilder_.build();
      }
      if (faceDetectionAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          faceDetectionAnnotations_ =
              java.util.Collections.unmodifiableList(faceDetectionAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.faceDetectionAnnotations_ = faceDetectionAnnotations_;
      } else {
        result.faceDetectionAnnotations_ = faceDetectionAnnotationsBuilder_.build();
      }
      if (shotAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)) {
          shotAnnotations_ = java.util.Collections.unmodifiableList(shotAnnotations_);
          bitField0_ = (bitField0_ & ~0x00000200);
        }
        result.shotAnnotations_ = shotAnnotations_;
      } else {
        result.shotAnnotations_ = shotAnnotationsBuilder_.build();
      }
      if (speechTranscriptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)) {
          speechTranscriptions_ = java.util.Collections.unmodifiableList(speechTranscriptions_);
          bitField0_ = (bitField0_ & ~0x00000800);
        }
        result.speechTranscriptions_ = speechTranscriptions_;
      } else {
        result.speechTranscriptions_ = speechTranscriptionsBuilder_.build();
      }
      if (textAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)) {
          textAnnotations_ = java.util.Collections.unmodifiableList(textAnnotations_);
          bitField0_ = (bitField0_ & ~0x00001000);
        }
        result.textAnnotations_ = textAnnotations_;
      } else {
        result.textAnnotations_ = textAnnotationsBuilder_.build();
      }
      if (objectAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)) {
          objectAnnotations_ = java.util.Collections.unmodifiableList(objectAnnotations_);
          bitField0_ = (bitField0_ & ~0x00002000);
        }
        result.objectAnnotations_ = objectAnnotations_;
      } else {
        result.objectAnnotations_ = objectAnnotationsBuilder_.build();
      }
      if (logoRecognitionAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00004000) != 0)) {
          logoRecognitionAnnotations_ =
              java.util.Collections.unmodifiableList(logoRecognitionAnnotations_);
          bitField0_ = (bitField0_ & ~0x00004000);
        }
        result.logoRecognitionAnnotations_ = logoRecognitionAnnotations_;
      } else {
        result.logoRecognitionAnnotations_ = logoRecognitionAnnotationsBuilder_.build();
      }
      if (personDetectionAnnotationsBuilder_ == null) {
        if (((bitField0_ & 0x00008000) != 0)) {
          personDetectionAnnotations_ =
              java.util.Collections.unmodifiableList(personDetectionAnnotations_);
          bitField0_ = (bitField0_ & ~0x00008000);
        }
        result.personDetectionAnnotations_ = personDetectionAnnotations_;
      } else {
        result.personDetectionAnnotations_ = personDetectionAnnotationsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.videointelligence.v1.VideoAnnotationResults result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.inputUri_ = inputUri_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.segment_ = segmentBuilder_ == null ? segment_ : segmentBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.explicitAnnotation_ =
            explicitAnnotationBuilder_ == null
                ? explicitAnnotation_
                : explicitAnnotationBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.videointelligence.v1.VideoAnnotationResults) {
        return mergeFrom((com.google.cloud.videointelligence.v1.VideoAnnotationResults) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.videointelligence.v1.VideoAnnotationResults other) {
      if (other
          == com.google.cloud.videointelligence.v1.VideoAnnotationResults.getDefaultInstance())
        return this;
      if (!other.getInputUri().isEmpty()) {
        inputUri_ = other.inputUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasSegment()) {
        mergeSegment(other.getSegment());
      }
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (!other.segmentLabelAnnotations_.isEmpty()) {
          if (segmentLabelAnnotations_.isEmpty()) {
            segmentLabelAnnotations_ = other.segmentLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureSegmentLabelAnnotationsIsMutable();
            segmentLabelAnnotations_.addAll(other.segmentLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.segmentLabelAnnotations_.isEmpty()) {
          if (segmentLabelAnnotationsBuilder_.isEmpty()) {
            segmentLabelAnnotationsBuilder_.dispose();
            segmentLabelAnnotationsBuilder_ = null;
            segmentLabelAnnotations_ = other.segmentLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000004);
            segmentLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            segmentLabelAnnotationsBuilder_.addAllMessages(other.segmentLabelAnnotations_);
          }
        }
      }
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        if (!other.segmentPresenceLabelAnnotations_.isEmpty()) {
          if (segmentPresenceLabelAnnotations_.isEmpty()) {
            segmentPresenceLabelAnnotations_ = other.segmentPresenceLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureSegmentPresenceLabelAnnotationsIsMutable();
            segmentPresenceLabelAnnotations_.addAll(other.segmentPresenceLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.segmentPresenceLabelAnnotations_.isEmpty()) {
          if (segmentPresenceLabelAnnotationsBuilder_.isEmpty()) {
            segmentPresenceLabelAnnotationsBuilder_.dispose();
            segmentPresenceLabelAnnotationsBuilder_ = null;
            segmentPresenceLabelAnnotations_ = other.segmentPresenceLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000008);
            segmentPresenceLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSegmentPresenceLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            segmentPresenceLabelAnnotationsBuilder_.addAllMessages(
                other.segmentPresenceLabelAnnotations_);
          }
        }
      }
      if (shotLabelAnnotationsBuilder_ == null) {
        if (!other.shotLabelAnnotations_.isEmpty()) {
          if (shotLabelAnnotations_.isEmpty()) {
            shotLabelAnnotations_ = other.shotLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureShotLabelAnnotationsIsMutable();
            shotLabelAnnotations_.addAll(other.shotLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.shotLabelAnnotations_.isEmpty()) {
          if (shotLabelAnnotationsBuilder_.isEmpty()) {
            shotLabelAnnotationsBuilder_.dispose();
            shotLabelAnnotationsBuilder_ = null;
            shotLabelAnnotations_ = other.shotLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000010);
            shotLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShotLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            shotLabelAnnotationsBuilder_.addAllMessages(other.shotLabelAnnotations_);
          }
        }
      }
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        if (!other.shotPresenceLabelAnnotations_.isEmpty()) {
          if (shotPresenceLabelAnnotations_.isEmpty()) {
            shotPresenceLabelAnnotations_ = other.shotPresenceLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000020);
          } else {
            ensureShotPresenceLabelAnnotationsIsMutable();
            shotPresenceLabelAnnotations_.addAll(other.shotPresenceLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.shotPresenceLabelAnnotations_.isEmpty()) {
          if (shotPresenceLabelAnnotationsBuilder_.isEmpty()) {
            shotPresenceLabelAnnotationsBuilder_.dispose();
            shotPresenceLabelAnnotationsBuilder_ = null;
            shotPresenceLabelAnnotations_ = other.shotPresenceLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000020);
            shotPresenceLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShotPresenceLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            shotPresenceLabelAnnotationsBuilder_.addAllMessages(
                other.shotPresenceLabelAnnotations_);
          }
        }
      }
      if (frameLabelAnnotationsBuilder_ == null) {
        if (!other.frameLabelAnnotations_.isEmpty()) {
          if (frameLabelAnnotations_.isEmpty()) {
            frameLabelAnnotations_ = other.frameLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000040);
          } else {
            ensureFrameLabelAnnotationsIsMutable();
            frameLabelAnnotations_.addAll(other.frameLabelAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.frameLabelAnnotations_.isEmpty()) {
          if (frameLabelAnnotationsBuilder_.isEmpty()) {
            frameLabelAnnotationsBuilder_.dispose();
            frameLabelAnnotationsBuilder_ = null;
            frameLabelAnnotations_ = other.frameLabelAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000040);
            frameLabelAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFrameLabelAnnotationsFieldBuilder()
                    : null;
          } else {
            frameLabelAnnotationsBuilder_.addAllMessages(other.frameLabelAnnotations_);
          }
        }
      }
      if (faceAnnotationsBuilder_ == null) {
        if (!other.faceAnnotations_.isEmpty()) {
          if (faceAnnotations_.isEmpty()) {
            faceAnnotations_ = other.faceAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000080);
          } else {
            ensureFaceAnnotationsIsMutable();
            faceAnnotations_.addAll(other.faceAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.faceAnnotations_.isEmpty()) {
          if (faceAnnotationsBuilder_.isEmpty()) {
            faceAnnotationsBuilder_.dispose();
            faceAnnotationsBuilder_ = null;
            faceAnnotations_ = other.faceAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000080);
            faceAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFaceAnnotationsFieldBuilder()
                    : null;
          } else {
            faceAnnotationsBuilder_.addAllMessages(other.faceAnnotations_);
          }
        }
      }
      if (faceDetectionAnnotationsBuilder_ == null) {
        if (!other.faceDetectionAnnotations_.isEmpty()) {
          if (faceDetectionAnnotations_.isEmpty()) {
            faceDetectionAnnotations_ = other.faceDetectionAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureFaceDetectionAnnotationsIsMutable();
            faceDetectionAnnotations_.addAll(other.faceDetectionAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.faceDetectionAnnotations_.isEmpty()) {
          if (faceDetectionAnnotationsBuilder_.isEmpty()) {
            faceDetectionAnnotationsBuilder_.dispose();
            faceDetectionAnnotationsBuilder_ = null;
            faceDetectionAnnotations_ = other.faceDetectionAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000100);
            faceDetectionAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFaceDetectionAnnotationsFieldBuilder()
                    : null;
          } else {
            faceDetectionAnnotationsBuilder_.addAllMessages(other.faceDetectionAnnotations_);
          }
        }
      }
      if (shotAnnotationsBuilder_ == null) {
        if (!other.shotAnnotations_.isEmpty()) {
          if (shotAnnotations_.isEmpty()) {
            shotAnnotations_ = other.shotAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000200);
          } else {
            ensureShotAnnotationsIsMutable();
            shotAnnotations_.addAll(other.shotAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.shotAnnotations_.isEmpty()) {
          if (shotAnnotationsBuilder_.isEmpty()) {
            shotAnnotationsBuilder_.dispose();
            shotAnnotationsBuilder_ = null;
            shotAnnotations_ = other.shotAnnotations_;
            bitField0_ = (bitField0_ & ~0x00000200);
            shotAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getShotAnnotationsFieldBuilder()
                    : null;
          } else {
            shotAnnotationsBuilder_.addAllMessages(other.shotAnnotations_);
          }
        }
      }
      if (other.hasExplicitAnnotation()) {
        mergeExplicitAnnotation(other.getExplicitAnnotation());
      }
      if (speechTranscriptionsBuilder_ == null) {
        if (!other.speechTranscriptions_.isEmpty()) {
          if (speechTranscriptions_.isEmpty()) {
            speechTranscriptions_ = other.speechTranscriptions_;
            bitField0_ = (bitField0_ & ~0x00000800);
          } else {
            ensureSpeechTranscriptionsIsMutable();
            speechTranscriptions_.addAll(other.speechTranscriptions_);
          }
          onChanged();
        }
      } else {
        if (!other.speechTranscriptions_.isEmpty()) {
          if (speechTranscriptionsBuilder_.isEmpty()) {
            speechTranscriptionsBuilder_.dispose();
            speechTranscriptionsBuilder_ = null;
            speechTranscriptions_ = other.speechTranscriptions_;
            bitField0_ = (bitField0_ & ~0x00000800);
            speechTranscriptionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getSpeechTranscriptionsFieldBuilder()
                    : null;
          } else {
            speechTranscriptionsBuilder_.addAllMessages(other.speechTranscriptions_);
          }
        }
      }
      if (textAnnotationsBuilder_ == null) {
        if (!other.textAnnotations_.isEmpty()) {
          if (textAnnotations_.isEmpty()) {
            textAnnotations_ = other.textAnnotations_;
            bitField0_ = (bitField0_ & ~0x00001000);
          } else {
            ensureTextAnnotationsIsMutable();
            textAnnotations_.addAll(other.textAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.textAnnotations_.isEmpty()) {
          if (textAnnotationsBuilder_.isEmpty()) {
            textAnnotationsBuilder_.dispose();
            textAnnotationsBuilder_ = null;
            textAnnotations_ = other.textAnnotations_;
            bitField0_ = (bitField0_ & ~0x00001000);
            textAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getTextAnnotationsFieldBuilder()
                    : null;
          } else {
            textAnnotationsBuilder_.addAllMessages(other.textAnnotations_);
          }
        }
      }
      if (objectAnnotationsBuilder_ == null) {
        if (!other.objectAnnotations_.isEmpty()) {
          if (objectAnnotations_.isEmpty()) {
            objectAnnotations_ = other.objectAnnotations_;
            bitField0_ = (bitField0_ & ~0x00002000);
          } else {
            ensureObjectAnnotationsIsMutable();
            objectAnnotations_.addAll(other.objectAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.objectAnnotations_.isEmpty()) {
          if (objectAnnotationsBuilder_.isEmpty()) {
            objectAnnotationsBuilder_.dispose();
            objectAnnotationsBuilder_ = null;
            objectAnnotations_ = other.objectAnnotations_;
            bitField0_ = (bitField0_ & ~0x00002000);
            objectAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getObjectAnnotationsFieldBuilder()
                    : null;
          } else {
            objectAnnotationsBuilder_.addAllMessages(other.objectAnnotations_);
          }
        }
      }
      if (logoRecognitionAnnotationsBuilder_ == null) {
        if (!other.logoRecognitionAnnotations_.isEmpty()) {
          if (logoRecognitionAnnotations_.isEmpty()) {
            logoRecognitionAnnotations_ = other.logoRecognitionAnnotations_;
            bitField0_ = (bitField0_ & ~0x00004000);
          } else {
            ensureLogoRecognitionAnnotationsIsMutable();
            logoRecognitionAnnotations_.addAll(other.logoRecognitionAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.logoRecognitionAnnotations_.isEmpty()) {
          if (logoRecognitionAnnotationsBuilder_.isEmpty()) {
            logoRecognitionAnnotationsBuilder_.dispose();
            logoRecognitionAnnotationsBuilder_ = null;
            logoRecognitionAnnotations_ = other.logoRecognitionAnnotations_;
            bitField0_ = (bitField0_ & ~0x00004000);
            logoRecognitionAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getLogoRecognitionAnnotationsFieldBuilder()
                    : null;
          } else {
            logoRecognitionAnnotationsBuilder_.addAllMessages(other.logoRecognitionAnnotations_);
          }
        }
      }
      if (personDetectionAnnotationsBuilder_ == null) {
        if (!other.personDetectionAnnotations_.isEmpty()) {
          if (personDetectionAnnotations_.isEmpty()) {
            personDetectionAnnotations_ = other.personDetectionAnnotations_;
            bitField0_ = (bitField0_ & ~0x00008000);
          } else {
            ensurePersonDetectionAnnotationsIsMutable();
            personDetectionAnnotations_.addAll(other.personDetectionAnnotations_);
          }
          onChanged();
        }
      } else {
        if (!other.personDetectionAnnotations_.isEmpty()) {
          if (personDetectionAnnotationsBuilder_.isEmpty()) {
            personDetectionAnnotationsBuilder_.dispose();
            personDetectionAnnotationsBuilder_ = null;
            personDetectionAnnotations_ = other.personDetectionAnnotations_;
            bitField0_ = (bitField0_ & ~0x00008000);
            personDetectionAnnotationsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getPersonDetectionAnnotationsFieldBuilder()
                    : null;
          } else {
            personDetectionAnnotationsBuilder_.addAllMessages(other.personDetectionAnnotations_);
          }
        }
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                inputUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.videointelligence.v1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (segmentLabelAnnotationsBuilder_ == null) {
                  ensureSegmentLabelAnnotationsIsMutable();
                  segmentLabelAnnotations_.add(m);
                } else {
                  segmentLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                com.google.cloud.videointelligence.v1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (shotLabelAnnotationsBuilder_ == null) {
                  ensureShotLabelAnnotationsIsMutable();
                  shotLabelAnnotations_.add(m);
                } else {
                  shotLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.videointelligence.v1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (frameLabelAnnotationsBuilder_ == null) {
                  ensureFrameLabelAnnotationsIsMutable();
                  frameLabelAnnotations_.add(m);
                } else {
                  frameLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.videointelligence.v1.FaceAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.FaceAnnotation.parser(),
                        extensionRegistry);
                if (faceAnnotationsBuilder_ == null) {
                  ensureFaceAnnotationsIsMutable();
                  faceAnnotations_.add(m);
                } else {
                  faceAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            case 50:
              {
                com.google.cloud.videointelligence.v1.VideoSegment m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.VideoSegment.parser(),
                        extensionRegistry);
                if (shotAnnotationsBuilder_ == null) {
                  ensureShotAnnotationsIsMutable();
                  shotAnnotations_.add(m);
                } else {
                  shotAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getExplicitAnnotationFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00010000;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getSegmentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.videointelligence.v1.SpeechTranscription m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.SpeechTranscription.parser(),
                        extensionRegistry);
                if (speechTranscriptionsBuilder_ == null) {
                  ensureSpeechTranscriptionsIsMutable();
                  speechTranscriptions_.add(m);
                } else {
                  speechTranscriptionsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                com.google.cloud.videointelligence.v1.TextAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.TextAnnotation.parser(),
                        extensionRegistry);
                if (textAnnotationsBuilder_ == null) {
                  ensureTextAnnotationsIsMutable();
                  textAnnotations_.add(m);
                } else {
                  textAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 98
            case 106:
              {
                com.google.cloud.videointelligence.v1.FaceDetectionAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.parser(),
                        extensionRegistry);
                if (faceDetectionAnnotationsBuilder_ == null) {
                  ensureFaceDetectionAnnotationsIsMutable();
                  faceDetectionAnnotations_.add(m);
                } else {
                  faceDetectionAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 106
            case 114:
              {
                com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.parser(),
                        extensionRegistry);
                if (objectAnnotationsBuilder_ == null) {
                  ensureObjectAnnotationsIsMutable();
                  objectAnnotations_.add(m);
                } else {
                  objectAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 114
            case 154:
              {
                com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.parser(),
                        extensionRegistry);
                if (logoRecognitionAnnotationsBuilder_ == null) {
                  ensureLogoRecognitionAnnotationsIsMutable();
                  logoRecognitionAnnotations_.add(m);
                } else {
                  logoRecognitionAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 154
            case 162:
              {
                com.google.cloud.videointelligence.v1.PersonDetectionAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.parser(),
                        extensionRegistry);
                if (personDetectionAnnotationsBuilder_ == null) {
                  ensurePersonDetectionAnnotationsIsMutable();
                  personDetectionAnnotations_.add(m);
                } else {
                  personDetectionAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 162
            case 186:
              {
                com.google.cloud.videointelligence.v1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (segmentPresenceLabelAnnotationsBuilder_ == null) {
                  ensureSegmentPresenceLabelAnnotationsIsMutable();
                  segmentPresenceLabelAnnotations_.add(m);
                } else {
                  segmentPresenceLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 186
            case 194:
              {
                com.google.cloud.videointelligence.v1.LabelAnnotation m =
                    input.readMessage(
                        com.google.cloud.videointelligence.v1.LabelAnnotation.parser(),
                        extensionRegistry);
                if (shotPresenceLabelAnnotationsBuilder_ == null) {
                  ensureShotPresenceLabelAnnotationsIsMutable();
                  shotPresenceLabelAnnotations_.add(m);
                } else {
                  shotPresenceLabelAnnotationsBuilder_.addMessage(m);
                }
                break;
              } // case 194
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object inputUri_ = "";
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return The inputUri.
     */
    public java.lang.String getInputUri() {
      java.lang.Object ref = inputUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        inputUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return The bytes for inputUri.
     */
    public com.google.protobuf.ByteString getInputUriBytes() {
      java.lang.Object ref = inputUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        inputUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @param value The inputUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      inputUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInputUri() {
      inputUri_ = getDefaultInstance().getInputUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video file location in
     * [Cloud Storage](https://cloud.google.com/storage/).
     * </pre>
     *
     * <code>string input_uri = 1;</code>
     *
     * @param value The bytes for inputUri to set.
     * @return This builder for chaining.
     */
    public Builder setInputUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      inputUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.cloud.videointelligence.v1.VideoSegment segment_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        segmentBuilder_;
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     *
     * @return Whether the segment field is set.
     */
    public boolean hasSegment() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     *
     * @return The segment.
     */
    public com.google.cloud.videointelligence.v1.VideoSegment getSegment() {
      if (segmentBuilder_ == null) {
        return segment_ == null
            ? com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance()
            : segment_;
      } else {
        return segmentBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     */
    public Builder setSegment(com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        segment_ = value;
      } else {
        segmentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     */
    public Builder setSegment(
        com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (segmentBuilder_ == null) {
        segment_ = builderForValue.build();
      } else {
        segmentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     */
    public Builder mergeSegment(com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (segmentBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && segment_ != null
            && segment_
                != com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance()) {
          getSegmentBuilder().mergeFrom(value);
        } else {
          segment_ = value;
        }
      } else {
        segmentBuilder_.mergeFrom(value);
      }
      if (segment_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     */
    public Builder clearSegment() {
      bitField0_ = (bitField0_ & ~0x00000002);
      segment_ = null;
      if (segmentBuilder_ != null) {
        segmentBuilder_.dispose();
        segmentBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder getSegmentBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getSegmentFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getSegmentOrBuilder() {
      if (segmentBuilder_ != null) {
        return segmentBuilder_.getMessageOrBuilder();
      } else {
        return segment_ == null
            ? com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance()
            : segment_;
      }
    }
    /**
     *
     *
     * <pre>
     * Video segment on which the annotation is run.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.VideoSegment segment = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        getSegmentFieldBuilder() {
      if (segmentBuilder_ == null) {
        segmentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.VideoSegment,
                com.google.cloud.videointelligence.v1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>(
                getSegment(), getParentForChildren(), isClean());
        segment_ = null;
      }
      return segmentBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        segmentLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureSegmentLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        segmentLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.LabelAnnotation>(
                segmentLabelAnnotations_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        segmentLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        getSegmentLabelAnnotationsList() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public int getSegmentLabelAnnotationsCount() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.size();
      } else {
        return segmentLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation getSegmentLabelAnnotations(
        int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.get(index);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder setSegmentLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder setSegmentLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addSegmentLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder addAllSegmentLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.LabelAnnotation>
            values) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, segmentLabelAnnotations_);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder clearSegmentLabelAnnotations() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public Builder removeSegmentLabelAnnotations(int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        ensureSegmentLabelAnnotationsIsMutable();
        segmentLabelAnnotations_.remove(index);
        onChanged();
      } else {
        segmentLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        getSegmentLabelAnnotationsBuilder(int index) {
      return getSegmentLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
        getSegmentLabelAnnotationsOrBuilder(int index) {
      if (segmentLabelAnnotationsBuilder_ == null) {
        return segmentLabelAnnotations_.get(index);
      } else {
        return segmentLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getSegmentLabelAnnotationsOrBuilderList() {
      if (segmentLabelAnnotationsBuilder_ != null) {
        return segmentLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segmentLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addSegmentLabelAnnotationsBuilder() {
      return getSegmentLabelAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addSegmentLabelAnnotationsBuilder(int index) {
      return getSegmentLabelAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_label_annotations = 2;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation.Builder>
        getSegmentLabelAnnotationsBuilderList() {
      return getSegmentLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getSegmentLabelAnnotationsFieldBuilder() {
      if (segmentLabelAnnotationsBuilder_ == null) {
        segmentLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.LabelAnnotation,
                com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>(
                segmentLabelAnnotations_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        segmentLabelAnnotations_ = null;
      }
      return segmentLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        segmentPresenceLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureSegmentPresenceLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        segmentPresenceLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.LabelAnnotation>(
                segmentPresenceLabelAnnotations_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        segmentPresenceLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        getSegmentPresenceLabelAnnotationsList() {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(segmentPresenceLabelAnnotations_);
      } else {
        return segmentPresenceLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public int getSegmentPresenceLabelAnnotationsCount() {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        return segmentPresenceLabelAnnotations_.size();
      } else {
        return segmentPresenceLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation getSegmentPresenceLabelAnnotations(
        int index) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        return segmentPresenceLabelAnnotations_.get(index);
      } else {
        return segmentPresenceLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder setSegmentPresenceLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentPresenceLabelAnnotationsIsMutable();
        segmentPresenceLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder setSegmentPresenceLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        ensureSegmentPresenceLabelAnnotationsIsMutable();
        segmentPresenceLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder addSegmentPresenceLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentPresenceLabelAnnotationsIsMutable();
        segmentPresenceLabelAnnotations_.add(value);
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder addSegmentPresenceLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSegmentPresenceLabelAnnotationsIsMutable();
        segmentPresenceLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder addSegmentPresenceLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        ensureSegmentPresenceLabelAnnotationsIsMutable();
        segmentPresenceLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder addSegmentPresenceLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        ensureSegmentPresenceLabelAnnotationsIsMutable();
        segmentPresenceLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder addAllSegmentPresenceLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.LabelAnnotation>
            values) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        ensureSegmentPresenceLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, segmentPresenceLabelAnnotations_);
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder clearSegmentPresenceLabelAnnotations() {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        segmentPresenceLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public Builder removeSegmentPresenceLabelAnnotations(int index) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        ensureSegmentPresenceLabelAnnotationsIsMutable();
        segmentPresenceLabelAnnotations_.remove(index);
        onChanged();
      } else {
        segmentPresenceLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        getSegmentPresenceLabelAnnotationsBuilder(int index) {
      return getSegmentPresenceLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
        getSegmentPresenceLabelAnnotationsOrBuilder(int index) {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        return segmentPresenceLabelAnnotations_.get(index);
      } else {
        return segmentPresenceLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getSegmentPresenceLabelAnnotationsOrBuilderList() {
      if (segmentPresenceLabelAnnotationsBuilder_ != null) {
        return segmentPresenceLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(segmentPresenceLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addSegmentPresenceLabelAnnotationsBuilder() {
      return getSegmentPresenceLabelAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addSegmentPresenceLabelAnnotationsBuilder(int index) {
      return getSegmentPresenceLabelAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on video level or user-specified segment level.
     * There is exactly one element for each unique label. Compared to the
     * existing topical `segment_label_annotations`, this field presents more
     * fine-grained, segment-level labels detected in video content and is made
     * available only when the client sets `LabelDetectionConfig.model` to
     * "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation segment_presence_label_annotations = 23;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation.Builder>
        getSegmentPresenceLabelAnnotationsBuilderList() {
      return getSegmentPresenceLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getSegmentPresenceLabelAnnotationsFieldBuilder() {
      if (segmentPresenceLabelAnnotationsBuilder_ == null) {
        segmentPresenceLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.LabelAnnotation,
                com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>(
                segmentPresenceLabelAnnotations_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        segmentPresenceLabelAnnotations_ = null;
      }
      return segmentPresenceLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        shotLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureShotLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        shotLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.LabelAnnotation>(
                shotLabelAnnotations_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        shotLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        getShotLabelAnnotationsList() {
      if (shotLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shotLabelAnnotations_);
      } else {
        return shotLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public int getShotLabelAnnotationsCount() {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.size();
      } else {
        return shotLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation getShotLabelAnnotations(
        int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.get(index);
      } else {
        return shotLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder setShotLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder setShotLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (shotLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addShotLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder addAllShotLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.LabelAnnotation>
            values) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shotLabelAnnotations_);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder clearShotLabelAnnotations() {
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public Builder removeShotLabelAnnotations(int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        ensureShotLabelAnnotationsIsMutable();
        shotLabelAnnotations_.remove(index);
        onChanged();
      } else {
        shotLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        getShotLabelAnnotationsBuilder(int index) {
      return getShotLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
        getShotLabelAnnotationsOrBuilder(int index) {
      if (shotLabelAnnotationsBuilder_ == null) {
        return shotLabelAnnotations_.get(index);
      } else {
        return shotLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getShotLabelAnnotationsOrBuilderList() {
      if (shotLabelAnnotationsBuilder_ != null) {
        return shotLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shotLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addShotLabelAnnotationsBuilder() {
      return getShotLabelAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addShotLabelAnnotationsBuilder(int index) {
      return getShotLabelAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Topical label annotations on shot level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_label_annotations = 3;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation.Builder>
        getShotLabelAnnotationsBuilderList() {
      return getShotLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getShotLabelAnnotationsFieldBuilder() {
      if (shotLabelAnnotationsBuilder_ == null) {
        shotLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.LabelAnnotation,
                com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>(
                shotLabelAnnotations_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        shotLabelAnnotations_ = null;
      }
      return shotLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        shotPresenceLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureShotPresenceLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000020) != 0)) {
        shotPresenceLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.LabelAnnotation>(
                shotPresenceLabelAnnotations_);
        bitField0_ |= 0x00000020;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        shotPresenceLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        getShotPresenceLabelAnnotationsList() {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shotPresenceLabelAnnotations_);
      } else {
        return shotPresenceLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public int getShotPresenceLabelAnnotationsCount() {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        return shotPresenceLabelAnnotations_.size();
      } else {
        return shotPresenceLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation getShotPresenceLabelAnnotations(
        int index) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        return shotPresenceLabelAnnotations_.get(index);
      } else {
        return shotPresenceLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder setShotPresenceLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotPresenceLabelAnnotationsIsMutable();
        shotPresenceLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder setShotPresenceLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        ensureShotPresenceLabelAnnotationsIsMutable();
        shotPresenceLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder addShotPresenceLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotPresenceLabelAnnotationsIsMutable();
        shotPresenceLabelAnnotations_.add(value);
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder addShotPresenceLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotPresenceLabelAnnotationsIsMutable();
        shotPresenceLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder addShotPresenceLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        ensureShotPresenceLabelAnnotationsIsMutable();
        shotPresenceLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder addShotPresenceLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        ensureShotPresenceLabelAnnotationsIsMutable();
        shotPresenceLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder addAllShotPresenceLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.LabelAnnotation>
            values) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        ensureShotPresenceLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, shotPresenceLabelAnnotations_);
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder clearShotPresenceLabelAnnotations() {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        shotPresenceLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000020);
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public Builder removeShotPresenceLabelAnnotations(int index) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        ensureShotPresenceLabelAnnotationsIsMutable();
        shotPresenceLabelAnnotations_.remove(index);
        onChanged();
      } else {
        shotPresenceLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        getShotPresenceLabelAnnotationsBuilder(int index) {
      return getShotPresenceLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
        getShotPresenceLabelAnnotationsOrBuilder(int index) {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        return shotPresenceLabelAnnotations_.get(index);
      } else {
        return shotPresenceLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getShotPresenceLabelAnnotationsOrBuilderList() {
      if (shotPresenceLabelAnnotationsBuilder_ != null) {
        return shotPresenceLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shotPresenceLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addShotPresenceLabelAnnotationsBuilder() {
      return getShotPresenceLabelAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addShotPresenceLabelAnnotationsBuilder(int index) {
      return getShotPresenceLabelAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Presence label annotations on shot level. There is exactly one element for
     * each unique label. Compared to the existing topical
     * `shot_label_annotations`, this field presents more fine-grained, shot-level
     * labels detected in video content and is made available only when the client
     * sets `LabelDetectionConfig.model` to "builtin/latest" in the request.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation shot_presence_label_annotations = 24;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation.Builder>
        getShotPresenceLabelAnnotationsBuilderList() {
      return getShotPresenceLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getShotPresenceLabelAnnotationsFieldBuilder() {
      if (shotPresenceLabelAnnotationsBuilder_ == null) {
        shotPresenceLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.LabelAnnotation,
                com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>(
                shotPresenceLabelAnnotations_,
                ((bitField0_ & 0x00000020) != 0),
                getParentForChildren(),
                isClean());
        shotPresenceLabelAnnotations_ = null;
      }
      return shotPresenceLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        frameLabelAnnotations_ = java.util.Collections.emptyList();

    private void ensureFrameLabelAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000040) != 0)) {
        frameLabelAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.LabelAnnotation>(
                frameLabelAnnotations_);
        bitField0_ |= 0x00000040;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        frameLabelAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation>
        getFrameLabelAnnotationsList() {
      if (frameLabelAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(frameLabelAnnotations_);
      } else {
        return frameLabelAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public int getFrameLabelAnnotationsCount() {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.size();
      } else {
        return frameLabelAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation getFrameLabelAnnotations(
        int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.get(index);
      } else {
        return frameLabelAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder setFrameLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.set(index, value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder setFrameLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation value) {
      if (frameLabelAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(index, value);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addFrameLabelAnnotations(
        int index, com.google.cloud.videointelligence.v1.LabelAnnotation.Builder builderForValue) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder addAllFrameLabelAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.LabelAnnotation>
            values) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, frameLabelAnnotations_);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder clearFrameLabelAnnotations() {
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000040);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public Builder removeFrameLabelAnnotations(int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        ensureFrameLabelAnnotationsIsMutable();
        frameLabelAnnotations_.remove(index);
        onChanged();
      } else {
        frameLabelAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        getFrameLabelAnnotationsBuilder(int index) {
      return getFrameLabelAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder
        getFrameLabelAnnotationsOrBuilder(int index) {
      if (frameLabelAnnotationsBuilder_ == null) {
        return frameLabelAnnotations_.get(index);
      } else {
        return frameLabelAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getFrameLabelAnnotationsOrBuilderList() {
      if (frameLabelAnnotationsBuilder_ != null) {
        return frameLabelAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(frameLabelAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addFrameLabelAnnotationsBuilder() {
      return getFrameLabelAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LabelAnnotation.Builder
        addFrameLabelAnnotationsBuilder(int index) {
      return getFrameLabelAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.LabelAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Label annotations on frame level.
     * There is exactly one element for each unique label.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LabelAnnotation frame_label_annotations = 4;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LabelAnnotation.Builder>
        getFrameLabelAnnotationsBuilderList() {
      return getFrameLabelAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LabelAnnotation,
            com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>
        getFrameLabelAnnotationsFieldBuilder() {
      if (frameLabelAnnotationsBuilder_ == null) {
        frameLabelAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.LabelAnnotation,
                com.google.cloud.videointelligence.v1.LabelAnnotation.Builder,
                com.google.cloud.videointelligence.v1.LabelAnnotationOrBuilder>(
                frameLabelAnnotations_,
                ((bitField0_ & 0x00000040) != 0),
                getParentForChildren(),
                isClean());
        frameLabelAnnotations_ = null;
      }
      return frameLabelAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.FaceAnnotation> faceAnnotations_ =
        java.util.Collections.emptyList();

    private void ensureFaceAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000080) != 0)) {
        faceAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.FaceAnnotation>(
                faceAnnotations_);
        bitField0_ |= 0x00000080;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.FaceAnnotation,
            com.google.cloud.videointelligence.v1.FaceAnnotation.Builder,
            com.google.cloud.videointelligence.v1.FaceAnnotationOrBuilder>
        faceAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.videointelligence.v1.FaceAnnotation>
        getFaceAnnotationsList() {
      if (faceAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(faceAnnotations_);
      } else {
        return faceAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public int getFaceAnnotationsCount() {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.size();
      } else {
        return faceAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.videointelligence.v1.FaceAnnotation getFaceAnnotations(int index) {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.get(index);
      } else {
        return faceAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setFaceAnnotations(
        int index, com.google.cloud.videointelligence.v1.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.set(index, value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder setFaceAnnotations(
        int index, com.google.cloud.videointelligence.v1.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addFaceAnnotations(com.google.cloud.videointelligence.v1.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addFaceAnnotations(
        int index, com.google.cloud.videointelligence.v1.FaceAnnotation value) {
      if (faceAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(index, value);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addFaceAnnotations(
        com.google.cloud.videointelligence.v1.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addFaceAnnotations(
        int index, com.google.cloud.videointelligence.v1.FaceAnnotation.Builder builderForValue) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        faceAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder addAllFaceAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.FaceAnnotation> values) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, faceAnnotations_);
        onChanged();
      } else {
        faceAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder clearFaceAnnotations() {
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000080);
        onChanged();
      } else {
        faceAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public Builder removeFaceAnnotations(int index) {
      if (faceAnnotationsBuilder_ == null) {
        ensureFaceAnnotationsIsMutable();
        faceAnnotations_.remove(index);
        onChanged();
      } else {
        faceAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.videointelligence.v1.FaceAnnotation.Builder getFaceAnnotationsBuilder(
        int index) {
      return getFaceAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.videointelligence.v1.FaceAnnotationOrBuilder
        getFaceAnnotationsOrBuilder(int index) {
      if (faceAnnotationsBuilder_ == null) {
        return faceAnnotations_.get(index);
      } else {
        return faceAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<? extends com.google.cloud.videointelligence.v1.FaceAnnotationOrBuilder>
        getFaceAnnotationsOrBuilderList() {
      if (faceAnnotationsBuilder_ != null) {
        return faceAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(faceAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.videointelligence.v1.FaceAnnotation.Builder
        addFaceAnnotationsBuilder() {
      return getFaceAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.FaceAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public com.google.cloud.videointelligence.v1.FaceAnnotation.Builder addFaceAnnotationsBuilder(
        int index) {
      return getFaceAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.FaceAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated. Please use `face_detection_annotations` instead.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceAnnotation face_annotations = 5 [deprecated = true];
     * </code>
     */
    @java.lang.Deprecated
    public java.util.List<com.google.cloud.videointelligence.v1.FaceAnnotation.Builder>
        getFaceAnnotationsBuilderList() {
      return getFaceAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.FaceAnnotation,
            com.google.cloud.videointelligence.v1.FaceAnnotation.Builder,
            com.google.cloud.videointelligence.v1.FaceAnnotationOrBuilder>
        getFaceAnnotationsFieldBuilder() {
      if (faceAnnotationsBuilder_ == null) {
        faceAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.FaceAnnotation,
                com.google.cloud.videointelligence.v1.FaceAnnotation.Builder,
                com.google.cloud.videointelligence.v1.FaceAnnotationOrBuilder>(
                faceAnnotations_,
                ((bitField0_ & 0x00000080) != 0),
                getParentForChildren(),
                isClean());
        faceAnnotations_ = null;
      }
      return faceAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.FaceDetectionAnnotation>
        faceDetectionAnnotations_ = java.util.Collections.emptyList();

    private void ensureFaceDetectionAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        faceDetectionAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.FaceDetectionAnnotation>(
                faceDetectionAnnotations_);
        bitField0_ |= 0x00000100;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.FaceDetectionAnnotation,
            com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder,
            com.google.cloud.videointelligence.v1.FaceDetectionAnnotationOrBuilder>
        faceDetectionAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.FaceDetectionAnnotation>
        getFaceDetectionAnnotationsList() {
      if (faceDetectionAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(faceDetectionAnnotations_);
      } else {
        return faceDetectionAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public int getFaceDetectionAnnotationsCount() {
      if (faceDetectionAnnotationsBuilder_ == null) {
        return faceDetectionAnnotations_.size();
      } else {
        return faceDetectionAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.FaceDetectionAnnotation
        getFaceDetectionAnnotations(int index) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        return faceDetectionAnnotations_.get(index);
      } else {
        return faceDetectionAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder setFaceDetectionAnnotations(
        int index, com.google.cloud.videointelligence.v1.FaceDetectionAnnotation value) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceDetectionAnnotationsIsMutable();
        faceDetectionAnnotations_.set(index, value);
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder setFaceDetectionAnnotations(
        int index,
        com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder builderForValue) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        ensureFaceDetectionAnnotationsIsMutable();
        faceDetectionAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder addFaceDetectionAnnotations(
        com.google.cloud.videointelligence.v1.FaceDetectionAnnotation value) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceDetectionAnnotationsIsMutable();
        faceDetectionAnnotations_.add(value);
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder addFaceDetectionAnnotations(
        int index, com.google.cloud.videointelligence.v1.FaceDetectionAnnotation value) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFaceDetectionAnnotationsIsMutable();
        faceDetectionAnnotations_.add(index, value);
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder addFaceDetectionAnnotations(
        com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder builderForValue) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        ensureFaceDetectionAnnotationsIsMutable();
        faceDetectionAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder addFaceDetectionAnnotations(
        int index,
        com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder builderForValue) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        ensureFaceDetectionAnnotationsIsMutable();
        faceDetectionAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder addAllFaceDetectionAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.FaceDetectionAnnotation>
            values) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        ensureFaceDetectionAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, faceDetectionAnnotations_);
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder clearFaceDetectionAnnotations() {
      if (faceDetectionAnnotationsBuilder_ == null) {
        faceDetectionAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public Builder removeFaceDetectionAnnotations(int index) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        ensureFaceDetectionAnnotationsIsMutable();
        faceDetectionAnnotations_.remove(index);
        onChanged();
      } else {
        faceDetectionAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder
        getFaceDetectionAnnotationsBuilder(int index) {
      return getFaceDetectionAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.FaceDetectionAnnotationOrBuilder
        getFaceDetectionAnnotationsOrBuilder(int index) {
      if (faceDetectionAnnotationsBuilder_ == null) {
        return faceDetectionAnnotations_.get(index);
      } else {
        return faceDetectionAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1.FaceDetectionAnnotationOrBuilder>
        getFaceDetectionAnnotationsOrBuilderList() {
      if (faceDetectionAnnotationsBuilder_ != null) {
        return faceDetectionAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(faceDetectionAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder
        addFaceDetectionAnnotationsBuilder() {
      return getFaceDetectionAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder
        addFaceDetectionAnnotationsBuilder(int index) {
      return getFaceDetectionAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Face detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.FaceDetectionAnnotation face_detection_annotations = 13;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder>
        getFaceDetectionAnnotationsBuilderList() {
      return getFaceDetectionAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.FaceDetectionAnnotation,
            com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder,
            com.google.cloud.videointelligence.v1.FaceDetectionAnnotationOrBuilder>
        getFaceDetectionAnnotationsFieldBuilder() {
      if (faceDetectionAnnotationsBuilder_ == null) {
        faceDetectionAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.FaceDetectionAnnotation,
                com.google.cloud.videointelligence.v1.FaceDetectionAnnotation.Builder,
                com.google.cloud.videointelligence.v1.FaceDetectionAnnotationOrBuilder>(
                faceDetectionAnnotations_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        faceDetectionAnnotations_ = null;
      }
      return faceDetectionAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.VideoSegment> shotAnnotations_ =
        java.util.Collections.emptyList();

    private void ensureShotAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00000200) != 0)) {
        shotAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.VideoSegment>(
                shotAnnotations_);
        bitField0_ |= 0x00000200;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        shotAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment>
        getShotAnnotationsList() {
      if (shotAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(shotAnnotations_);
      } else {
        return shotAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public int getShotAnnotationsCount() {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.size();
      } else {
        return shotAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment getShotAnnotations(int index) {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.get(index);
      } else {
        return shotAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder setShotAnnotations(
        int index, com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.set(index, value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder setShotAnnotations(
        int index, com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder addShotAnnotations(com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder addShotAnnotations(
        int index, com.google.cloud.videointelligence.v1.VideoSegment value) {
      if (shotAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(index, value);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder addShotAnnotations(
        com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder addShotAnnotations(
        int index, com.google.cloud.videointelligence.v1.VideoSegment.Builder builderForValue) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        shotAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder addAllShotAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.VideoSegment> values) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, shotAnnotations_);
        onChanged();
      } else {
        shotAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder clearShotAnnotations() {
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000200);
        onChanged();
      } else {
        shotAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public Builder removeShotAnnotations(int index) {
      if (shotAnnotationsBuilder_ == null) {
        ensureShotAnnotationsIsMutable();
        shotAnnotations_.remove(index);
        onChanged();
      } else {
        shotAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder getShotAnnotationsBuilder(
        int index) {
      return getShotAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder getShotAnnotationsOrBuilder(
        int index) {
      if (shotAnnotationsBuilder_ == null) {
        return shotAnnotations_.get(index);
      } else {
        return shotAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        getShotAnnotationsOrBuilderList() {
      if (shotAnnotationsBuilder_ != null) {
        return shotAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(shotAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder addShotAnnotationsBuilder() {
      return getShotAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public com.google.cloud.videointelligence.v1.VideoSegment.Builder addShotAnnotationsBuilder(
        int index) {
      return getShotAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.VideoSegment.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Shot annotations. Each shot is represented as a video segment.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.VideoSegment shot_annotations = 6;</code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.VideoSegment.Builder>
        getShotAnnotationsBuilderList() {
      return getShotAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.VideoSegment,
            com.google.cloud.videointelligence.v1.VideoSegment.Builder,
            com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>
        getShotAnnotationsFieldBuilder() {
      if (shotAnnotationsBuilder_ == null) {
        shotAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.VideoSegment,
                com.google.cloud.videointelligence.v1.VideoSegment.Builder,
                com.google.cloud.videointelligence.v1.VideoSegmentOrBuilder>(
                shotAnnotations_,
                ((bitField0_ & 0x00000200) != 0),
                getParentForChildren(),
                isClean());
        shotAnnotations_ = null;
      }
      return shotAnnotationsBuilder_;
    }

    private com.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicitAnnotation_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ExplicitContentAnnotation,
            com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.Builder,
            com.google.cloud.videointelligence.v1.ExplicitContentAnnotationOrBuilder>
        explicitAnnotationBuilder_;
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     *
     * @return Whether the explicitAnnotation field is set.
     */
    public boolean hasExplicitAnnotation() {
      return ((bitField0_ & 0x00000400) != 0);
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     *
     * @return The explicitAnnotation.
     */
    public com.google.cloud.videointelligence.v1.ExplicitContentAnnotation getExplicitAnnotation() {
      if (explicitAnnotationBuilder_ == null) {
        return explicitAnnotation_ == null
            ? com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.getDefaultInstance()
            : explicitAnnotation_;
      } else {
        return explicitAnnotationBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder setExplicitAnnotation(
        com.google.cloud.videointelligence.v1.ExplicitContentAnnotation value) {
      if (explicitAnnotationBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explicitAnnotation_ = value;
      } else {
        explicitAnnotationBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder setExplicitAnnotation(
        com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.Builder builderForValue) {
      if (explicitAnnotationBuilder_ == null) {
        explicitAnnotation_ = builderForValue.build();
      } else {
        explicitAnnotationBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder mergeExplicitAnnotation(
        com.google.cloud.videointelligence.v1.ExplicitContentAnnotation value) {
      if (explicitAnnotationBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && explicitAnnotation_ != null
            && explicitAnnotation_
                != com.google.cloud.videointelligence.v1.ExplicitContentAnnotation
                    .getDefaultInstance()) {
          getExplicitAnnotationBuilder().mergeFrom(value);
        } else {
          explicitAnnotation_ = value;
        }
      } else {
        explicitAnnotationBuilder_.mergeFrom(value);
      }
      if (explicitAnnotation_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public Builder clearExplicitAnnotation() {
      bitField0_ = (bitField0_ & ~0x00000400);
      explicitAnnotation_ = null;
      if (explicitAnnotationBuilder_ != null) {
        explicitAnnotationBuilder_.dispose();
        explicitAnnotationBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.Builder
        getExplicitAnnotationBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getExplicitAnnotationFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ExplicitContentAnnotationOrBuilder
        getExplicitAnnotationOrBuilder() {
      if (explicitAnnotationBuilder_ != null) {
        return explicitAnnotationBuilder_.getMessageOrBuilder();
      } else {
        return explicitAnnotation_ == null
            ? com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.getDefaultInstance()
            : explicitAnnotation_;
      }
    }
    /**
     *
     *
     * <pre>
     * Explicit content annotation.
     * </pre>
     *
     * <code>.google.cloud.videointelligence.v1.ExplicitContentAnnotation explicit_annotation = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ExplicitContentAnnotation,
            com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.Builder,
            com.google.cloud.videointelligence.v1.ExplicitContentAnnotationOrBuilder>
        getExplicitAnnotationFieldBuilder() {
      if (explicitAnnotationBuilder_ == null) {
        explicitAnnotationBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.videointelligence.v1.ExplicitContentAnnotation,
                com.google.cloud.videointelligence.v1.ExplicitContentAnnotation.Builder,
                com.google.cloud.videointelligence.v1.ExplicitContentAnnotationOrBuilder>(
                getExplicitAnnotation(), getParentForChildren(), isClean());
        explicitAnnotation_ = null;
      }
      return explicitAnnotationBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.SpeechTranscription>
        speechTranscriptions_ = java.util.Collections.emptyList();

    private void ensureSpeechTranscriptionsIsMutable() {
      if (!((bitField0_ & 0x00000800) != 0)) {
        speechTranscriptions_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.SpeechTranscription>(
                speechTranscriptions_);
        bitField0_ |= 0x00000800;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.SpeechTranscription,
            com.google.cloud.videointelligence.v1.SpeechTranscription.Builder,
            com.google.cloud.videointelligence.v1.SpeechTranscriptionOrBuilder>
        speechTranscriptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.SpeechTranscription>
        getSpeechTranscriptionsList() {
      if (speechTranscriptionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(speechTranscriptions_);
      } else {
        return speechTranscriptionsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public int getSpeechTranscriptionsCount() {
      if (speechTranscriptionsBuilder_ == null) {
        return speechTranscriptions_.size();
      } else {
        return speechTranscriptionsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.SpeechTranscription getSpeechTranscriptions(
        int index) {
      if (speechTranscriptionsBuilder_ == null) {
        return speechTranscriptions_.get(index);
      } else {
        return speechTranscriptionsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder setSpeechTranscriptions(
        int index, com.google.cloud.videointelligence.v1.SpeechTranscription value) {
      if (speechTranscriptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechTranscriptionsIsMutable();
        speechTranscriptions_.set(index, value);
        onChanged();
      } else {
        speechTranscriptionsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder setSpeechTranscriptions(
        int index,
        com.google.cloud.videointelligence.v1.SpeechTranscription.Builder builderForValue) {
      if (speechTranscriptionsBuilder_ == null) {
        ensureSpeechTranscriptionsIsMutable();
        speechTranscriptions_.set(index, builderForValue.build());
        onChanged();
      } else {
        speechTranscriptionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder addSpeechTranscriptions(
        com.google.cloud.videointelligence.v1.SpeechTranscription value) {
      if (speechTranscriptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechTranscriptionsIsMutable();
        speechTranscriptions_.add(value);
        onChanged();
      } else {
        speechTranscriptionsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder addSpeechTranscriptions(
        int index, com.google.cloud.videointelligence.v1.SpeechTranscription value) {
      if (speechTranscriptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureSpeechTranscriptionsIsMutable();
        speechTranscriptions_.add(index, value);
        onChanged();
      } else {
        speechTranscriptionsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder addSpeechTranscriptions(
        com.google.cloud.videointelligence.v1.SpeechTranscription.Builder builderForValue) {
      if (speechTranscriptionsBuilder_ == null) {
        ensureSpeechTranscriptionsIsMutable();
        speechTranscriptions_.add(builderForValue.build());
        onChanged();
      } else {
        speechTranscriptionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder addSpeechTranscriptions(
        int index,
        com.google.cloud.videointelligence.v1.SpeechTranscription.Builder builderForValue) {
      if (speechTranscriptionsBuilder_ == null) {
        ensureSpeechTranscriptionsIsMutable();
        speechTranscriptions_.add(index, builderForValue.build());
        onChanged();
      } else {
        speechTranscriptionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder addAllSpeechTranscriptions(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.SpeechTranscription>
            values) {
      if (speechTranscriptionsBuilder_ == null) {
        ensureSpeechTranscriptionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, speechTranscriptions_);
        onChanged();
      } else {
        speechTranscriptionsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder clearSpeechTranscriptions() {
      if (speechTranscriptionsBuilder_ == null) {
        speechTranscriptions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
      } else {
        speechTranscriptionsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public Builder removeSpeechTranscriptions(int index) {
      if (speechTranscriptionsBuilder_ == null) {
        ensureSpeechTranscriptionsIsMutable();
        speechTranscriptions_.remove(index);
        onChanged();
      } else {
        speechTranscriptionsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.SpeechTranscription.Builder
        getSpeechTranscriptionsBuilder(int index) {
      return getSpeechTranscriptionsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.SpeechTranscriptionOrBuilder
        getSpeechTranscriptionsOrBuilder(int index) {
      if (speechTranscriptionsBuilder_ == null) {
        return speechTranscriptions_.get(index);
      } else {
        return speechTranscriptionsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1.SpeechTranscriptionOrBuilder>
        getSpeechTranscriptionsOrBuilderList() {
      if (speechTranscriptionsBuilder_ != null) {
        return speechTranscriptionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(speechTranscriptions_);
      }
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.SpeechTranscription.Builder
        addSpeechTranscriptionsBuilder() {
      return getSpeechTranscriptionsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1.SpeechTranscription.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.SpeechTranscription.Builder
        addSpeechTranscriptionsBuilder(int index) {
      return getSpeechTranscriptionsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1.SpeechTranscription.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Speech transcription.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.SpeechTranscription speech_transcriptions = 11;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.SpeechTranscription.Builder>
        getSpeechTranscriptionsBuilderList() {
      return getSpeechTranscriptionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.SpeechTranscription,
            com.google.cloud.videointelligence.v1.SpeechTranscription.Builder,
            com.google.cloud.videointelligence.v1.SpeechTranscriptionOrBuilder>
        getSpeechTranscriptionsFieldBuilder() {
      if (speechTranscriptionsBuilder_ == null) {
        speechTranscriptionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.SpeechTranscription,
                com.google.cloud.videointelligence.v1.SpeechTranscription.Builder,
                com.google.cloud.videointelligence.v1.SpeechTranscriptionOrBuilder>(
                speechTranscriptions_,
                ((bitField0_ & 0x00000800) != 0),
                getParentForChildren(),
                isClean());
        speechTranscriptions_ = null;
      }
      return speechTranscriptionsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.TextAnnotation> textAnnotations_ =
        java.util.Collections.emptyList();

    private void ensureTextAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00001000) != 0)) {
        textAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.TextAnnotation>(
                textAnnotations_);
        bitField0_ |= 0x00001000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.TextAnnotation,
            com.google.cloud.videointelligence.v1.TextAnnotation.Builder,
            com.google.cloud.videointelligence.v1.TextAnnotationOrBuilder>
        textAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.TextAnnotation>
        getTextAnnotationsList() {
      if (textAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(textAnnotations_);
      } else {
        return textAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public int getTextAnnotationsCount() {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.size();
      } else {
        return textAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TextAnnotation getTextAnnotations(int index) {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.get(index);
      } else {
        return textAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder setTextAnnotations(
        int index, com.google.cloud.videointelligence.v1.TextAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.set(index, value);
        onChanged();
      } else {
        textAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder setTextAnnotations(
        int index, com.google.cloud.videointelligence.v1.TextAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addTextAnnotations(com.google.cloud.videointelligence.v1.TextAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(value);
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addTextAnnotations(
        int index, com.google.cloud.videointelligence.v1.TextAnnotation value) {
      if (textAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(index, value);
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addTextAnnotations(
        com.google.cloud.videointelligence.v1.TextAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addTextAnnotations(
        int index, com.google.cloud.videointelligence.v1.TextAnnotation.Builder builderForValue) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        textAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder addAllTextAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.TextAnnotation> values) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, textAnnotations_);
        onChanged();
      } else {
        textAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder clearTextAnnotations() {
      if (textAnnotationsBuilder_ == null) {
        textAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00001000);
        onChanged();
      } else {
        textAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public Builder removeTextAnnotations(int index) {
      if (textAnnotationsBuilder_ == null) {
        ensureTextAnnotationsIsMutable();
        textAnnotations_.remove(index);
        onChanged();
      } else {
        textAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TextAnnotation.Builder getTextAnnotationsBuilder(
        int index) {
      return getTextAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TextAnnotationOrBuilder
        getTextAnnotationsOrBuilder(int index) {
      if (textAnnotationsBuilder_ == null) {
        return textAnnotations_.get(index);
      } else {
        return textAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public java.util.List<? extends com.google.cloud.videointelligence.v1.TextAnnotationOrBuilder>
        getTextAnnotationsOrBuilderList() {
      if (textAnnotationsBuilder_ != null) {
        return textAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(textAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TextAnnotation.Builder
        addTextAnnotationsBuilder() {
      return getTextAnnotationsFieldBuilder()
          .addBuilder(com.google.cloud.videointelligence.v1.TextAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.TextAnnotation.Builder addTextAnnotationsBuilder(
        int index) {
      return getTextAnnotationsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.videointelligence.v1.TextAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * OCR text detection and tracking.
     * Annotations for list of detected text snippets. Each will have list of
     * frame information associated with it.
     * </pre>
     *
     * <code>repeated .google.cloud.videointelligence.v1.TextAnnotation text_annotations = 12;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.TextAnnotation.Builder>
        getTextAnnotationsBuilderList() {
      return getTextAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.TextAnnotation,
            com.google.cloud.videointelligence.v1.TextAnnotation.Builder,
            com.google.cloud.videointelligence.v1.TextAnnotationOrBuilder>
        getTextAnnotationsFieldBuilder() {
      if (textAnnotationsBuilder_ == null) {
        textAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.TextAnnotation,
                com.google.cloud.videointelligence.v1.TextAnnotation.Builder,
                com.google.cloud.videointelligence.v1.TextAnnotationOrBuilder>(
                textAnnotations_,
                ((bitField0_ & 0x00001000) != 0),
                getParentForChildren(),
                isClean());
        textAnnotations_ = null;
      }
      return textAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation>
        objectAnnotations_ = java.util.Collections.emptyList();

    private void ensureObjectAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00002000) != 0)) {
        objectAnnotations_ =
            new java.util.ArrayList<com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation>(
                objectAnnotations_);
        bitField0_ |= 0x00002000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation,
            com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder,
            com.google.cloud.videointelligence.v1.ObjectTrackingAnnotationOrBuilder>
        objectAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation>
        getObjectAnnotationsList() {
      if (objectAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(objectAnnotations_);
      } else {
        return objectAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public int getObjectAnnotationsCount() {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.size();
      } else {
        return objectAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation getObjectAnnotations(
        int index) {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.get(index);
      } else {
        return objectAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder setObjectAnnotations(
        int index, com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.set(index, value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder setObjectAnnotations(
        int index,
        com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addObjectAnnotations(
        com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addObjectAnnotations(
        int index, com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation value) {
      if (objectAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(index, value);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addObjectAnnotations(
        com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addObjectAnnotations(
        int index,
        com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder builderForValue) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        objectAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder addAllObjectAnnotations(
        java.lang.Iterable<? extends com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation>
            values) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, objectAnnotations_);
        onChanged();
      } else {
        objectAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder clearObjectAnnotations() {
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00002000);
        onChanged();
      } else {
        objectAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public Builder removeObjectAnnotations(int index) {
      if (objectAnnotationsBuilder_ == null) {
        ensureObjectAnnotationsIsMutable();
        objectAnnotations_.remove(index);
        onChanged();
      } else {
        objectAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder
        getObjectAnnotationsBuilder(int index) {
      return getObjectAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ObjectTrackingAnnotationOrBuilder
        getObjectAnnotationsOrBuilder(int index) {
      if (objectAnnotationsBuilder_ == null) {
        return objectAnnotations_.get(index);
      } else {
        return objectAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1.ObjectTrackingAnnotationOrBuilder>
        getObjectAnnotationsOrBuilderList() {
      if (objectAnnotationsBuilder_ != null) {
        return objectAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(objectAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder
        addObjectAnnotationsBuilder() {
      return getObjectAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder
        addObjectAnnotationsBuilder(int index) {
      return getObjectAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of objects detected and tracked in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.ObjectTrackingAnnotation object_annotations = 14;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder>
        getObjectAnnotationsBuilderList() {
      return getObjectAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation,
            com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder,
            com.google.cloud.videointelligence.v1.ObjectTrackingAnnotationOrBuilder>
        getObjectAnnotationsFieldBuilder() {
      if (objectAnnotationsBuilder_ == null) {
        objectAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation,
                com.google.cloud.videointelligence.v1.ObjectTrackingAnnotation.Builder,
                com.google.cloud.videointelligence.v1.ObjectTrackingAnnotationOrBuilder>(
                objectAnnotations_,
                ((bitField0_ & 0x00002000) != 0),
                getParentForChildren(),
                isClean());
        objectAnnotations_ = null;
      }
      return objectAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation>
        logoRecognitionAnnotations_ = java.util.Collections.emptyList();

    private void ensureLogoRecognitionAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00004000) != 0)) {
        logoRecognitionAnnotations_ =
            new java.util.ArrayList<
                com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation>(
                logoRecognitionAnnotations_);
        bitField0_ |= 0x00004000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation,
            com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LogoRecognitionAnnotationOrBuilder>
        logoRecognitionAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation>
        getLogoRecognitionAnnotationsList() {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(logoRecognitionAnnotations_);
      } else {
        return logoRecognitionAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public int getLogoRecognitionAnnotationsCount() {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        return logoRecognitionAnnotations_.size();
      } else {
        return logoRecognitionAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation
        getLogoRecognitionAnnotations(int index) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        return logoRecognitionAnnotations_.get(index);
      } else {
        return logoRecognitionAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder setLogoRecognitionAnnotations(
        int index, com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation value) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogoRecognitionAnnotationsIsMutable();
        logoRecognitionAnnotations_.set(index, value);
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder setLogoRecognitionAnnotations(
        int index,
        com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder builderForValue) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        ensureLogoRecognitionAnnotationsIsMutable();
        logoRecognitionAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder addLogoRecognitionAnnotations(
        com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation value) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogoRecognitionAnnotationsIsMutable();
        logoRecognitionAnnotations_.add(value);
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder addLogoRecognitionAnnotations(
        int index, com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation value) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLogoRecognitionAnnotationsIsMutable();
        logoRecognitionAnnotations_.add(index, value);
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder addLogoRecognitionAnnotations(
        com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder builderForValue) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        ensureLogoRecognitionAnnotationsIsMutable();
        logoRecognitionAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder addLogoRecognitionAnnotations(
        int index,
        com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder builderForValue) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        ensureLogoRecognitionAnnotationsIsMutable();
        logoRecognitionAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder addAllLogoRecognitionAnnotations(
        java.lang.Iterable<
                ? extends com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation>
            values) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        ensureLogoRecognitionAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, logoRecognitionAnnotations_);
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder clearLogoRecognitionAnnotations() {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        logoRecognitionAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00004000);
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public Builder removeLogoRecognitionAnnotations(int index) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        ensureLogoRecognitionAnnotationsIsMutable();
        logoRecognitionAnnotations_.remove(index);
        onChanged();
      } else {
        logoRecognitionAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder
        getLogoRecognitionAnnotationsBuilder(int index) {
      return getLogoRecognitionAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotationOrBuilder
        getLogoRecognitionAnnotationsOrBuilder(int index) {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        return logoRecognitionAnnotations_.get(index);
      } else {
        return logoRecognitionAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1.LogoRecognitionAnnotationOrBuilder>
        getLogoRecognitionAnnotationsOrBuilderList() {
      if (logoRecognitionAnnotationsBuilder_ != null) {
        return logoRecognitionAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(logoRecognitionAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder
        addLogoRecognitionAnnotationsBuilder() {
      return getLogoRecognitionAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder
        addLogoRecognitionAnnotationsBuilder(int index) {
      return getLogoRecognitionAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Annotations for list of logos detected, tracked and recognized in video.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.LogoRecognitionAnnotation logo_recognition_annotations = 19;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder>
        getLogoRecognitionAnnotationsBuilderList() {
      return getLogoRecognitionAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation,
            com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder,
            com.google.cloud.videointelligence.v1.LogoRecognitionAnnotationOrBuilder>
        getLogoRecognitionAnnotationsFieldBuilder() {
      if (logoRecognitionAnnotationsBuilder_ == null) {
        logoRecognitionAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation,
                com.google.cloud.videointelligence.v1.LogoRecognitionAnnotation.Builder,
                com.google.cloud.videointelligence.v1.LogoRecognitionAnnotationOrBuilder>(
                logoRecognitionAnnotations_,
                ((bitField0_ & 0x00004000) != 0),
                getParentForChildren(),
                isClean());
        logoRecognitionAnnotations_ = null;
      }
      return logoRecognitionAnnotationsBuilder_;
    }

    private java.util.List<com.google.cloud.videointelligence.v1.PersonDetectionAnnotation>
        personDetectionAnnotations_ = java.util.Collections.emptyList();

    private void ensurePersonDetectionAnnotationsIsMutable() {
      if (!((bitField0_ & 0x00008000) != 0)) {
        personDetectionAnnotations_ =
            new java.util.ArrayList<
                com.google.cloud.videointelligence.v1.PersonDetectionAnnotation>(
                personDetectionAnnotations_);
        bitField0_ |= 0x00008000;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.PersonDetectionAnnotation,
            com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder,
            com.google.cloud.videointelligence.v1.PersonDetectionAnnotationOrBuilder>
        personDetectionAnnotationsBuilder_;

    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.PersonDetectionAnnotation>
        getPersonDetectionAnnotationsList() {
      if (personDetectionAnnotationsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(personDetectionAnnotations_);
      } else {
        return personDetectionAnnotationsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public int getPersonDetectionAnnotationsCount() {
      if (personDetectionAnnotationsBuilder_ == null) {
        return personDetectionAnnotations_.size();
      } else {
        return personDetectionAnnotationsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.PersonDetectionAnnotation
        getPersonDetectionAnnotations(int index) {
      if (personDetectionAnnotationsBuilder_ == null) {
        return personDetectionAnnotations_.get(index);
      } else {
        return personDetectionAnnotationsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder setPersonDetectionAnnotations(
        int index, com.google.cloud.videointelligence.v1.PersonDetectionAnnotation value) {
      if (personDetectionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePersonDetectionAnnotationsIsMutable();
        personDetectionAnnotations_.set(index, value);
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder setPersonDetectionAnnotations(
        int index,
        com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder builderForValue) {
      if (personDetectionAnnotationsBuilder_ == null) {
        ensurePersonDetectionAnnotationsIsMutable();
        personDetectionAnnotations_.set(index, builderForValue.build());
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder addPersonDetectionAnnotations(
        com.google.cloud.videointelligence.v1.PersonDetectionAnnotation value) {
      if (personDetectionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePersonDetectionAnnotationsIsMutable();
        personDetectionAnnotations_.add(value);
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder addPersonDetectionAnnotations(
        int index, com.google.cloud.videointelligence.v1.PersonDetectionAnnotation value) {
      if (personDetectionAnnotationsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePersonDetectionAnnotationsIsMutable();
        personDetectionAnnotations_.add(index, value);
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder addPersonDetectionAnnotations(
        com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder builderForValue) {
      if (personDetectionAnnotationsBuilder_ == null) {
        ensurePersonDetectionAnnotationsIsMutable();
        personDetectionAnnotations_.add(builderForValue.build());
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder addPersonDetectionAnnotations(
        int index,
        com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder builderForValue) {
      if (personDetectionAnnotationsBuilder_ == null) {
        ensurePersonDetectionAnnotationsIsMutable();
        personDetectionAnnotations_.add(index, builderForValue.build());
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder addAllPersonDetectionAnnotations(
        java.lang.Iterable<
                ? extends com.google.cloud.videointelligence.v1.PersonDetectionAnnotation>
            values) {
      if (personDetectionAnnotationsBuilder_ == null) {
        ensurePersonDetectionAnnotationsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, personDetectionAnnotations_);
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder clearPersonDetectionAnnotations() {
      if (personDetectionAnnotationsBuilder_ == null) {
        personDetectionAnnotations_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00008000);
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public Builder removePersonDetectionAnnotations(int index) {
      if (personDetectionAnnotationsBuilder_ == null) {
        ensurePersonDetectionAnnotationsIsMutable();
        personDetectionAnnotations_.remove(index);
        onChanged();
      } else {
        personDetectionAnnotationsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder
        getPersonDetectionAnnotationsBuilder(int index) {
      return getPersonDetectionAnnotationsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.PersonDetectionAnnotationOrBuilder
        getPersonDetectionAnnotationsOrBuilder(int index) {
      if (personDetectionAnnotationsBuilder_ == null) {
        return personDetectionAnnotations_.get(index);
      } else {
        return personDetectionAnnotationsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.videointelligence.v1.PersonDetectionAnnotationOrBuilder>
        getPersonDetectionAnnotationsOrBuilderList() {
      if (personDetectionAnnotationsBuilder_ != null) {
        return personDetectionAnnotationsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(personDetectionAnnotations_);
      }
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder
        addPersonDetectionAnnotationsBuilder() {
      return getPersonDetectionAnnotationsFieldBuilder()
          .addBuilder(
              com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder
        addPersonDetectionAnnotationsBuilder(int index) {
      return getPersonDetectionAnnotationsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Person detection annotations.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.videointelligence.v1.PersonDetectionAnnotation person_detection_annotations = 20;
     * </code>
     */
    public java.util.List<com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder>
        getPersonDetectionAnnotationsBuilderList() {
      return getPersonDetectionAnnotationsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.videointelligence.v1.PersonDetectionAnnotation,
            com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder,
            com.google.cloud.videointelligence.v1.PersonDetectionAnnotationOrBuilder>
        getPersonDetectionAnnotationsFieldBuilder() {
      if (personDetectionAnnotationsBuilder_ == null) {
        personDetectionAnnotationsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.videointelligence.v1.PersonDetectionAnnotation,
                com.google.cloud.videointelligence.v1.PersonDetectionAnnotation.Builder,
                com.google.cloud.videointelligence.v1.PersonDetectionAnnotationOrBuilder>(
                personDetectionAnnotations_,
                ((bitField0_ & 0x00008000) != 0),
                getParentForChildren(),
                isClean());
        personDetectionAnnotations_ = null;
      }
      return personDetectionAnnotationsBuilder_;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00010000) != 0);
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00010000) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00010000;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00010000);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00010000;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * If set, indicates an error. Note that for a single `AnnotateVideoRequest`
     * some videos may succeed and some may fail.
     * </pre>
     *
     * <code>.google.rpc.Status error = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.videointelligence.v1.VideoAnnotationResults)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.videointelligence.v1.VideoAnnotationResults)
  private static final com.google.cloud.videointelligence.v1.VideoAnnotationResults
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.videointelligence.v1.VideoAnnotationResults();
  }

  public static com.google.cloud.videointelligence.v1.VideoAnnotationResults getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VideoAnnotationResults> PARSER =
      new com.google.protobuf.AbstractParser<VideoAnnotationResults>() {
        @java.lang.Override
        public VideoAnnotationResults parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VideoAnnotationResults> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VideoAnnotationResults> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.videointelligence.v1.VideoAnnotationResults getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
