/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.cloudtrace.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.common.base.Preconditions;
import com.google.devtools.cloudtrace.v2.SpanNameType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpanName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/traces/{trace}/spans/{span}");
    private final String project;
    private final String trace;
    private final String span;

    public String getProject() {
        return this.project;
    }

    public String getTrace() {
        return this.trace;
    }

    public String getSpan() {
        return this.span;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private SpanName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.trace = (String)Preconditions.checkNotNull((Object)builder.getTrace());
        this.span = (String)Preconditions.checkNotNull((Object)builder.getSpan());
    }

    public static SpanName of(String project, String trace, String span) {
        return SpanName.newBuilder().setProject(project).setTrace(trace).setSpan(span).build();
    }

    @Deprecated
    public static SpanName create(String project, String trace, String span) {
        return SpanName.of(project, trace, span);
    }

    public static String format(String project, String trace, String span) {
        return SpanName.newBuilder().setProject(project).setTrace(trace).setSpan(span).build().toString();
    }

    public static SpanName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "SpanName.parse: formattedString not in valid format");
        return SpanName.of((String)matchMap.get("project"), (String)matchMap.get("trace"), (String)matchMap.get("span"));
    }

    public static List<SpanName> parseList(List<String> formattedStrings) {
        ArrayList<SpanName> list = new ArrayList<SpanName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SpanName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SpanName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SpanName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return SpanNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "trace", this.trace, "span", this.span});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpanName) {
            SpanName that = (SpanName)o;
            return this.project.equals(that.project) && this.trace.equals(that.trace) && this.span.equals(that.span);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.trace.hashCode();
        h *= 1000003;
        return h ^= this.span.hashCode();
    }

    public static class Builder {
        private String project;
        private String trace;
        private String span;

        public String getProject() {
            return this.project;
        }

        public String getTrace() {
            return this.trace;
        }

        public String getSpan() {
            return this.span;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTrace(String trace) {
            this.trace = trace;
            return this;
        }

        public Builder setSpan(String span) {
            this.span = span;
            return this;
        }

        private Builder() {
        }

        private Builder(SpanName spanName) {
            this.project = spanName.project;
            this.trace = spanName.trace;
            this.span = spanName.span;
        }

        public SpanName build() {
            return new SpanName(this);
        }
    }
}

