/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tpu.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RuntimeVersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RUNTIME_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/runtimeVersions/{runtime_version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String runtimeVersion;

    @Deprecated
    protected RuntimeVersionName() {
        this.project = null;
        this.location = null;
        this.runtimeVersion = null;
    }

    private RuntimeVersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.runtimeVersion = (String)Preconditions.checkNotNull((Object)builder.getRuntimeVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRuntimeVersion() {
        return this.runtimeVersion;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RuntimeVersionName of(String project, String location, String runtimeVersion) {
        return RuntimeVersionName.newBuilder().setProject(project).setLocation(location).setRuntimeVersion(runtimeVersion).build();
    }

    public static String format(String project, String location, String runtimeVersion) {
        return RuntimeVersionName.newBuilder().setProject(project).setLocation(location).setRuntimeVersion(runtimeVersion).build().toString();
    }

    public static RuntimeVersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RUNTIME_VERSION.validatedMatch(formattedString, "RuntimeVersionName.parse: formattedString not in valid format");
        return RuntimeVersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("runtime_version"));
    }

    public static List<RuntimeVersionName> parseList(List<String> formattedStrings) {
        ArrayList<RuntimeVersionName> list = new ArrayList<RuntimeVersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RuntimeVersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RuntimeVersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RuntimeVersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RUNTIME_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RuntimeVersionName runtimeVersionName = this;
            synchronized (runtimeVersionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.runtimeVersion != null) {
                        fieldMapBuilder.put((Object)"runtime_version", (Object)this.runtimeVersion);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RUNTIME_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "runtime_version", this.runtimeVersion});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            RuntimeVersionName that = (RuntimeVersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.runtimeVersion, that.runtimeVersion);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.runtimeVersion);
    }

    public static class Builder {
        private String project;
        private String location;
        private String runtimeVersion;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRuntimeVersion() {
            return this.runtimeVersion;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRuntimeVersion(String runtimeVersion) {
            this.runtimeVersion = runtimeVersion;
            return this;
        }

        private Builder(RuntimeVersionName runtimeVersionName) {
            this.project = runtimeVersionName.project;
            this.location = runtimeVersionName.location;
            this.runtimeVersion = runtimeVersionName.runtimeVersion;
        }

        public RuntimeVersionName build() {
            return new RuntimeVersionName(this);
        }
    }
}

