/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tasks.v2beta3;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class QueueName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/queues/{queue}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String queue;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getQueue() {
        return this.queue;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private QueueName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.queue = (String)Preconditions.checkNotNull((Object)builder.getQueue());
    }

    public static QueueName of(String project, String location, String queue) {
        return QueueName.newBuilder().setProject(project).setLocation(location).setQueue(queue).build();
    }

    public static String format(String project, String location, String queue) {
        return QueueName.newBuilder().setProject(project).setLocation(location).setQueue(queue).build().toString();
    }

    public static QueueName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "QueueName.parse: formattedString not in valid format");
        return QueueName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("queue"));
    }

    public static List<QueueName> parseList(List<String> formattedStrings) {
        ArrayList<QueueName> list = new ArrayList<QueueName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(QueueName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<QueueName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (QueueName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            QueueName queueName = this;
            synchronized (queueName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"queue", (Object)this.queue);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "queue", this.queue});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof QueueName) {
            QueueName that = (QueueName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.queue.equals(that.queue);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.queue.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String queue;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getQueue() {
            return this.queue;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setQueue(String queue) {
            this.queue = queue;
            return this;
        }

        private Builder() {
        }

        private Builder(QueueName queueName) {
            this.project = queueName.project;
            this.location = queueName.location;
            this.queue = queueName.queue;
        }

        public QueueName build() {
            return new QueueName(this);
        }
    }
}

