/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.talent.v4;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CompanyName
implements ResourceName {
    private static final PathTemplate PROJECT_TENANT_COMPANY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/tenants/{tenant}/companies/{company}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String tenant;
    private final String company;

    @Deprecated
    protected CompanyName() {
        this.project = null;
        this.tenant = null;
        this.company = null;
    }

    private CompanyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.tenant = (String)Preconditions.checkNotNull((Object)builder.getTenant());
        this.company = (String)Preconditions.checkNotNull((Object)builder.getCompany());
    }

    public String getProject() {
        return this.project;
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getCompany() {
        return this.company;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CompanyName of(String project, String tenant, String company) {
        return CompanyName.newBuilder().setProject(project).setTenant(tenant).setCompany(company).build();
    }

    public static String format(String project, String tenant, String company) {
        return CompanyName.newBuilder().setProject(project).setTenant(tenant).setCompany(company).build().toString();
    }

    public static CompanyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_TENANT_COMPANY.validatedMatch(formattedString, "CompanyName.parse: formattedString not in valid format");
        return CompanyName.of((String)matchMap.get("project"), (String)matchMap.get("tenant"), (String)matchMap.get("company"));
    }

    public static List<CompanyName> parseList(List<String> formattedStrings) {
        ArrayList<CompanyName> list = new ArrayList<CompanyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CompanyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CompanyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CompanyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TENANT_COMPANY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CompanyName companyName = this;
            synchronized (companyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.tenant != null) {
                        fieldMapBuilder.put((Object)"tenant", (Object)this.tenant);
                    }
                    if (this.company != null) {
                        fieldMapBuilder.put((Object)"company", (Object)this.company);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_TENANT_COMPANY.instantiate(new String[]{"project", this.project, "tenant", this.tenant, "company", this.company});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CompanyName that = (CompanyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.tenant, that.tenant) && Objects.equals(this.company, that.company);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.tenant);
        h *= 1000003;
        return h ^= Objects.hashCode(this.company);
    }

    public static class Builder {
        private String project;
        private String tenant;
        private String company;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTenant() {
            return this.tenant;
        }

        public String getCompany() {
            return this.company;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public Builder setCompany(String company) {
            this.company = company;
            return this;
        }

        private Builder(CompanyName companyName) {
            this.project = companyName.project;
            this.tenant = companyName.tenant;
            this.company = companyName.company;
        }

        public CompanyName build() {
            return new CompanyName(this);
        }
    }
}

