/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Request message for [MoveObject][google.storage.v2.Storage.MoveObject].
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.MoveObjectRequest}
 */
public final class MoveObjectRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.MoveObjectRequest)
    MoveObjectRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use MoveObjectRequest.newBuilder() to construct.
  private MoveObjectRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private MoveObjectRequest() {
    bucket_ = "";
    sourceObject_ = "";
    destinationObject_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new MoveObjectRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_MoveObjectRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_MoveObjectRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.MoveObjectRequest.class,
            com.google.storage.v2.MoveObjectRequest.Builder.class);
  }

  private int bitField0_;
  public static final int BUCKET_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object bucket_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the object resides.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bucket.
   */
  @java.lang.Override
  public java.lang.String getBucket() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      bucket_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the object resides.
   * </pre>
   *
   * <code>
   * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for bucket.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBucketBytes() {
    java.lang.Object ref = bucket_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      bucket_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_OBJECT_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceObject_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the source object.
   * </pre>
   *
   * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The sourceObject.
   */
  @java.lang.Override
  public java.lang.String getSourceObject() {
    java.lang.Object ref = sourceObject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceObject_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the source object.
   * </pre>
   *
   * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for sourceObject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceObjectBytes() {
    java.lang.Object ref = sourceObject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceObject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESTINATION_OBJECT_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object destinationObject_ = "";

  /**
   *
   *
   * <pre>
   * Required. Name of the destination object.
   * </pre>
   *
   * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The destinationObject.
   */
  @java.lang.Override
  public java.lang.String getDestinationObject() {
    java.lang.Object ref = destinationObject_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      destinationObject_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. Name of the destination object.
   * </pre>
   *
   * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for destinationObject.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDestinationObjectBytes() {
    java.lang.Object ref = destinationObject_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      destinationObject_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IF_SOURCE_GENERATION_MATCH_FIELD_NUMBER = 4;
  private long ifSourceGenerationMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current generation matches the given value. `if_source_generation_match`
   * and `if_source_generation_not_match` conditions are mutually exclusive:
   * it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_source_generation_match = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifSourceGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfSourceGenerationMatch() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current generation matches the given value. `if_source_generation_match`
   * and `if_source_generation_not_match` conditions are mutually exclusive:
   * it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_source_generation_match = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifSourceGenerationMatch.
   */
  @java.lang.Override
  public long getIfSourceGenerationMatch() {
    return ifSourceGenerationMatch_;
  }

  public static final int IF_SOURCE_GENERATION_NOT_MATCH_FIELD_NUMBER = 5;
  private long ifSourceGenerationNotMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current generation does not match the given value.
   * `if_source_generation_match` and `if_source_generation_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_generation_not_match = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifSourceGenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfSourceGenerationNotMatch() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current generation does not match the given value.
   * `if_source_generation_match` and `if_source_generation_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_generation_not_match = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifSourceGenerationNotMatch.
   */
  @java.lang.Override
  public long getIfSourceGenerationNotMatch() {
    return ifSourceGenerationNotMatch_;
  }

  public static final int IF_SOURCE_METAGENERATION_MATCH_FIELD_NUMBER = 6;
  private long ifSourceMetagenerationMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current metageneration matches the given value.
   * `if_source_metageneration_match` and `if_source_metageneration_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_metageneration_match = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifSourceMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfSourceMetagenerationMatch() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current metageneration matches the given value.
   * `if_source_metageneration_match` and `if_source_metageneration_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_metageneration_match = 6 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifSourceMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfSourceMetagenerationMatch() {
    return ifSourceMetagenerationMatch_;
  }

  public static final int IF_SOURCE_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 7;
  private long ifSourceMetagenerationNotMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current metageneration does not match the given value.
   * `if_source_metageneration_match` and `if_source_metageneration_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_metageneration_not_match = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifSourceMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfSourceMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the source object's
   * current metageneration does not match the given value.
   * `if_source_metageneration_match` and `if_source_metageneration_not_match`
   * conditions are mutually exclusive: it's an error for both of them to be set
   * in the request.
   * </pre>
   *
   * <code>
   * optional int64 if_source_metageneration_not_match = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifSourceMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfSourceMetagenerationNotMatch() {
    return ifSourceMetagenerationNotMatch_;
  }

  public static final int IF_GENERATION_MATCH_FIELD_NUMBER = 8;
  private long ifGenerationMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current generation matches the given value. Setting to 0 makes the
   * operation succeed only if there are no live versions of the object.
   * `if_generation_match` and `if_generation_not_match` conditions are mutually
   * exclusive: it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationMatch() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current generation matches the given value. Setting to 0 makes the
   * operation succeed only if there are no live versions of the object.
   * `if_generation_match` and `if_generation_not_match` conditions are mutually
   * exclusive: it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_generation_match = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The ifGenerationMatch.
   */
  @java.lang.Override
  public long getIfGenerationMatch() {
    return ifGenerationMatch_;
  }

  public static final int IF_GENERATION_NOT_MATCH_FIELD_NUMBER = 9;
  private long ifGenerationNotMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current generation does not match the given value. If no live
   * object exists, the precondition fails. Setting to 0 makes the operation
   * succeed only if there is a live version of the object.
   * `if_generation_match` and `if_generation_not_match` conditions are mutually
   * exclusive: it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationNotMatch() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current generation does not match the given value. If no live
   * object exists, the precondition fails. Setting to 0 makes the operation
   * succeed only if there is a live version of the object.
   * `if_generation_match` and `if_generation_not_match` conditions are mutually
   * exclusive: it's an error for both of them to be set in the request.
   * </pre>
   *
   * <code>optional int64 if_generation_not_match = 9 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifGenerationNotMatch.
   */
  @java.lang.Override
  public long getIfGenerationNotMatch() {
    return ifGenerationNotMatch_;
  }

  public static final int IF_METAGENERATION_MATCH_FIELD_NUMBER = 10;
  private long ifMetagenerationMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current metageneration matches the given value.
   * `if_metageneration_match` and `if_metageneration_not_match` conditions are
   * mutually exclusive: it's an error for both of them to be set in the
   * request.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationMatch() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current metageneration matches the given value.
   * `if_metageneration_match` and `if_metageneration_not_match` conditions are
   * mutually exclusive: it's an error for both of them to be set in the
   * request.
   * </pre>
   *
   * <code>optional int64 if_metageneration_match = 10 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationMatch() {
    return ifMetagenerationMatch_;
  }

  public static final int IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 11;
  private long ifMetagenerationNotMatch_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current metageneration does not match the given value.
   * `if_metageneration_match` and `if_metageneration_not_match` conditions are
   * mutually exclusive: it's an error for both of them to be set in the
   * request.
   * </pre>
   *
   * <code>
   * optional int64 if_metageneration_not_match = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Makes the operation conditional on whether the destination
   * object's current metageneration does not match the given value.
   * `if_metageneration_match` and `if_metageneration_not_match` conditions are
   * mutually exclusive: it's an error for both of them to be set in the
   * request.
   * </pre>
   *
   * <code>
   * optional int64 if_metageneration_not_match = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationNotMatch() {
    return ifMetagenerationNotMatch_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, bucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceObject_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, sourceObject_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationObject_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, destinationObject_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(4, ifSourceGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(5, ifSourceGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(6, ifSourceMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(7, ifSourceMetagenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeInt64(8, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeInt64(9, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeInt64(10, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeInt64(11, ifMetagenerationNotMatch_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(bucket_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, bucket_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceObject_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, sourceObject_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationObject_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, destinationObject_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, ifSourceGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(5, ifSourceGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(6, ifSourceMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt64Size(
              7, ifSourceMetagenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(10, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(11, ifMetagenerationNotMatch_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.MoveObjectRequest)) {
      return super.equals(obj);
    }
    com.google.storage.v2.MoveObjectRequest other = (com.google.storage.v2.MoveObjectRequest) obj;

    if (!getBucket().equals(other.getBucket())) return false;
    if (!getSourceObject().equals(other.getSourceObject())) return false;
    if (!getDestinationObject().equals(other.getDestinationObject())) return false;
    if (hasIfSourceGenerationMatch() != other.hasIfSourceGenerationMatch()) return false;
    if (hasIfSourceGenerationMatch()) {
      if (getIfSourceGenerationMatch() != other.getIfSourceGenerationMatch()) return false;
    }
    if (hasIfSourceGenerationNotMatch() != other.hasIfSourceGenerationNotMatch()) return false;
    if (hasIfSourceGenerationNotMatch()) {
      if (getIfSourceGenerationNotMatch() != other.getIfSourceGenerationNotMatch()) return false;
    }
    if (hasIfSourceMetagenerationMatch() != other.hasIfSourceMetagenerationMatch()) return false;
    if (hasIfSourceMetagenerationMatch()) {
      if (getIfSourceMetagenerationMatch() != other.getIfSourceMetagenerationMatch()) return false;
    }
    if (hasIfSourceMetagenerationNotMatch() != other.hasIfSourceMetagenerationNotMatch())
      return false;
    if (hasIfSourceMetagenerationNotMatch()) {
      if (getIfSourceMetagenerationNotMatch() != other.getIfSourceMetagenerationNotMatch())
        return false;
    }
    if (hasIfGenerationMatch() != other.hasIfGenerationMatch()) return false;
    if (hasIfGenerationMatch()) {
      if (getIfGenerationMatch() != other.getIfGenerationMatch()) return false;
    }
    if (hasIfGenerationNotMatch() != other.hasIfGenerationNotMatch()) return false;
    if (hasIfGenerationNotMatch()) {
      if (getIfGenerationNotMatch() != other.getIfGenerationNotMatch()) return false;
    }
    if (hasIfMetagenerationMatch() != other.hasIfMetagenerationMatch()) return false;
    if (hasIfMetagenerationMatch()) {
      if (getIfMetagenerationMatch() != other.getIfMetagenerationMatch()) return false;
    }
    if (hasIfMetagenerationNotMatch() != other.hasIfMetagenerationNotMatch()) return false;
    if (hasIfMetagenerationNotMatch()) {
      if (getIfMetagenerationNotMatch() != other.getIfMetagenerationNotMatch()) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + BUCKET_FIELD_NUMBER;
    hash = (53 * hash) + getBucket().hashCode();
    hash = (37 * hash) + SOURCE_OBJECT_FIELD_NUMBER;
    hash = (53 * hash) + getSourceObject().hashCode();
    hash = (37 * hash) + DESTINATION_OBJECT_FIELD_NUMBER;
    hash = (53 * hash) + getDestinationObject().hashCode();
    if (hasIfSourceGenerationMatch()) {
      hash = (37 * hash) + IF_SOURCE_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfSourceGenerationMatch());
    }
    if (hasIfSourceGenerationNotMatch()) {
      hash = (37 * hash) + IF_SOURCE_GENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfSourceGenerationNotMatch());
    }
    if (hasIfSourceMetagenerationMatch()) {
      hash = (37 * hash) + IF_SOURCE_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfSourceMetagenerationMatch());
    }
    if (hasIfSourceMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_SOURCE_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash =
          (53 * hash) + com.google.protobuf.Internal.hashLong(getIfSourceMetagenerationNotMatch());
    }
    if (hasIfGenerationMatch()) {
      hash = (37 * hash) + IF_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationMatch());
    }
    if (hasIfGenerationNotMatch()) {
      hash = (37 * hash) + IF_GENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationNotMatch());
    }
    if (hasIfMetagenerationMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationMatch());
    }
    if (hasIfMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationNotMatch());
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.MoveObjectRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.MoveObjectRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.MoveObjectRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.MoveObjectRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for [MoveObject][google.storage.v2.Storage.MoveObject].
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.MoveObjectRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.MoveObjectRequest)
      com.google.storage.v2.MoveObjectRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_MoveObjectRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_MoveObjectRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.MoveObjectRequest.class,
              com.google.storage.v2.MoveObjectRequest.Builder.class);
    }

    // Construct using com.google.storage.v2.MoveObjectRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      bucket_ = "";
      sourceObject_ = "";
      destinationObject_ = "";
      ifSourceGenerationMatch_ = 0L;
      ifSourceGenerationNotMatch_ = 0L;
      ifSourceMetagenerationMatch_ = 0L;
      ifSourceMetagenerationNotMatch_ = 0L;
      ifGenerationMatch_ = 0L;
      ifGenerationNotMatch_ = 0L;
      ifMetagenerationMatch_ = 0L;
      ifMetagenerationNotMatch_ = 0L;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_MoveObjectRequest_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.MoveObjectRequest getDefaultInstanceForType() {
      return com.google.storage.v2.MoveObjectRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.MoveObjectRequest build() {
      com.google.storage.v2.MoveObjectRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.MoveObjectRequest buildPartial() {
      com.google.storage.v2.MoveObjectRequest result =
          new com.google.storage.v2.MoveObjectRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.v2.MoveObjectRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.bucket_ = bucket_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.sourceObject_ = sourceObject_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.destinationObject_ = destinationObject_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ifSourceGenerationMatch_ = ifSourceGenerationMatch_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.ifSourceGenerationNotMatch_ = ifSourceGenerationNotMatch_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.ifSourceMetagenerationMatch_ = ifSourceMetagenerationMatch_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.ifSourceMetagenerationNotMatch_ = ifSourceMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.ifGenerationMatch_ = ifGenerationMatch_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.ifGenerationNotMatch_ = ifGenerationNotMatch_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.ifMetagenerationMatch_ = ifMetagenerationMatch_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.ifMetagenerationNotMatch_ = ifMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000080;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.MoveObjectRequest) {
        return mergeFrom((com.google.storage.v2.MoveObjectRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.MoveObjectRequest other) {
      if (other == com.google.storage.v2.MoveObjectRequest.getDefaultInstance()) return this;
      if (!other.getBucket().isEmpty()) {
        bucket_ = other.bucket_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getSourceObject().isEmpty()) {
        sourceObject_ = other.sourceObject_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDestinationObject().isEmpty()) {
        destinationObject_ = other.destinationObject_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasIfSourceGenerationMatch()) {
        setIfSourceGenerationMatch(other.getIfSourceGenerationMatch());
      }
      if (other.hasIfSourceGenerationNotMatch()) {
        setIfSourceGenerationNotMatch(other.getIfSourceGenerationNotMatch());
      }
      if (other.hasIfSourceMetagenerationMatch()) {
        setIfSourceMetagenerationMatch(other.getIfSourceMetagenerationMatch());
      }
      if (other.hasIfSourceMetagenerationNotMatch()) {
        setIfSourceMetagenerationNotMatch(other.getIfSourceMetagenerationNotMatch());
      }
      if (other.hasIfGenerationMatch()) {
        setIfGenerationMatch(other.getIfGenerationMatch());
      }
      if (other.hasIfGenerationNotMatch()) {
        setIfGenerationNotMatch(other.getIfGenerationNotMatch());
      }
      if (other.hasIfMetagenerationMatch()) {
        setIfMetagenerationMatch(other.getIfMetagenerationMatch());
      }
      if (other.hasIfMetagenerationNotMatch()) {
        setIfMetagenerationNotMatch(other.getIfMetagenerationNotMatch());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                bucket_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                sourceObject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                destinationObject_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                ifSourceGenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                ifSourceGenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                ifSourceMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 56:
              {
                ifSourceMetagenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 64:
              {
                ifGenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 72:
              {
                ifGenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000100;
                break;
              } // case 72
            case 80:
              {
                ifMetagenerationMatch_ = input.readInt64();
                bitField0_ |= 0x00000200;
                break;
              } // case 80
            case 88:
              {
                ifMetagenerationNotMatch_ = input.readInt64();
                bitField0_ |= 0x00000400;
                break;
              } // case 88
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object bucket_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bucket.
     */
    public java.lang.String getBucket() {
      java.lang.Object ref = bucket_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        bucket_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for bucket.
     */
    public com.google.protobuf.ByteString getBucketBytes() {
      java.lang.Object ref = bucket_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        bucket_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucket(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBucket() {
      bucket_ = getDefaultInstance().getBucket();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the bucket in which the object resides.
     * </pre>
     *
     * <code>
     * string bucket = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for bucket to set.
     * @return This builder for chaining.
     */
    public Builder setBucketBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      bucket_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object sourceObject_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The sourceObject.
     */
    public java.lang.String getSourceObject() {
      java.lang.Object ref = sourceObject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceObject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for sourceObject.
     */
    public com.google.protobuf.ByteString getSourceObjectBytes() {
      java.lang.Object ref = sourceObject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceObject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The sourceObject to set.
     * @return This builder for chaining.
     */
    public Builder setSourceObject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceObject_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceObject() {
      sourceObject_ = getDefaultInstance().getSourceObject();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the source object.
     * </pre>
     *
     * <code>string source_object = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for sourceObject to set.
     * @return This builder for chaining.
     */
    public Builder setSourceObjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceObject_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object destinationObject_ = "";

    /**
     *
     *
     * <pre>
     * Required. Name of the destination object.
     * </pre>
     *
     * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The destinationObject.
     */
    public java.lang.String getDestinationObject() {
      java.lang.Object ref = destinationObject_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        destinationObject_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the destination object.
     * </pre>
     *
     * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for destinationObject.
     */
    public com.google.protobuf.ByteString getDestinationObjectBytes() {
      java.lang.Object ref = destinationObject_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        destinationObject_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the destination object.
     * </pre>
     *
     * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The destinationObject to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationObject(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      destinationObject_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the destination object.
     * </pre>
     *
     * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDestinationObject() {
      destinationObject_ = getDefaultInstance().getDestinationObject();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Name of the destination object.
     * </pre>
     *
     * <code>string destination_object = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for destinationObject to set.
     * @return This builder for chaining.
     */
    public Builder setDestinationObjectBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      destinationObject_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private long ifSourceGenerationMatch_;

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current generation matches the given value. `if_source_generation_match`
     * and `if_source_generation_not_match` conditions are mutually exclusive:
     * it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_generation_match = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ifSourceGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfSourceGenerationMatch() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current generation matches the given value. `if_source_generation_match`
     * and `if_source_generation_not_match` conditions are mutually exclusive:
     * it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_generation_match = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ifSourceGenerationMatch.
     */
    @java.lang.Override
    public long getIfSourceGenerationMatch() {
      return ifSourceGenerationMatch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current generation matches the given value. `if_source_generation_match`
     * and `if_source_generation_not_match` conditions are mutually exclusive:
     * it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_generation_match = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The ifSourceGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfSourceGenerationMatch(long value) {

      ifSourceGenerationMatch_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current generation matches the given value. `if_source_generation_match`
     * and `if_source_generation_not_match` conditions are mutually exclusive:
     * it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_generation_match = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfSourceGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ifSourceGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifSourceGenerationNotMatch_;

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current generation does not match the given value.
     * `if_source_generation_match` and `if_source_generation_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_generation_not_match = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ifSourceGenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfSourceGenerationNotMatch() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current generation does not match the given value.
     * `if_source_generation_match` and `if_source_generation_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_generation_not_match = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ifSourceGenerationNotMatch.
     */
    @java.lang.Override
    public long getIfSourceGenerationNotMatch() {
      return ifSourceGenerationNotMatch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current generation does not match the given value.
     * `if_source_generation_match` and `if_source_generation_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_generation_not_match = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The ifSourceGenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfSourceGenerationNotMatch(long value) {

      ifSourceGenerationNotMatch_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current generation does not match the given value.
     * `if_source_generation_match` and `if_source_generation_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_generation_not_match = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfSourceGenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000010);
      ifSourceGenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifSourceMetagenerationMatch_;

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current metageneration matches the given value.
     * `if_source_metageneration_match` and `if_source_metageneration_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_metageneration_match = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ifSourceMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfSourceMetagenerationMatch() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current metageneration matches the given value.
     * `if_source_metageneration_match` and `if_source_metageneration_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_metageneration_match = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ifSourceMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfSourceMetagenerationMatch() {
      return ifSourceMetagenerationMatch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current metageneration matches the given value.
     * `if_source_metageneration_match` and `if_source_metageneration_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_metageneration_match = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The ifSourceMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfSourceMetagenerationMatch(long value) {

      ifSourceMetagenerationMatch_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current metageneration matches the given value.
     * `if_source_metageneration_match` and `if_source_metageneration_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_metageneration_match = 6 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfSourceMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000020);
      ifSourceMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifSourceMetagenerationNotMatch_;

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current metageneration does not match the given value.
     * `if_source_metageneration_match` and `if_source_metageneration_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_metageneration_not_match = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ifSourceMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfSourceMetagenerationNotMatch() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current metageneration does not match the given value.
     * `if_source_metageneration_match` and `if_source_metageneration_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_metageneration_not_match = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ifSourceMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfSourceMetagenerationNotMatch() {
      return ifSourceMetagenerationNotMatch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current metageneration does not match the given value.
     * `if_source_metageneration_match` and `if_source_metageneration_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_metageneration_not_match = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The ifSourceMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfSourceMetagenerationNotMatch(long value) {

      ifSourceMetagenerationNotMatch_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the source object's
     * current metageneration does not match the given value.
     * `if_source_metageneration_match` and `if_source_metageneration_not_match`
     * conditions are mutually exclusive: it's an error for both of them to be set
     * in the request.
     * </pre>
     *
     * <code>
     * optional int64 if_source_metageneration_not_match = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfSourceMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000040);
      ifSourceMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifGenerationMatch_;

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current generation matches the given value. Setting to 0 makes the
     * operation succeed only if there are no live versions of the object.
     * `if_generation_match` and `if_generation_not_match` conditions are mutually
     * exclusive: it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ifGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationMatch() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current generation matches the given value. Setting to 0 makes the
     * operation succeed only if there are no live versions of the object.
     * `if_generation_match` and `if_generation_not_match` conditions are mutually
     * exclusive: it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ifGenerationMatch.
     */
    @java.lang.Override
    public long getIfGenerationMatch() {
      return ifGenerationMatch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current generation matches the given value. Setting to 0 makes the
     * operation succeed only if there are no live versions of the object.
     * `if_generation_match` and `if_generation_not_match` conditions are mutually
     * exclusive: it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The ifGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationMatch(long value) {

      ifGenerationMatch_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current generation matches the given value. Setting to 0 makes the
     * operation succeed only if there are no live versions of the object.
     * `if_generation_match` and `if_generation_not_match` conditions are mutually
     * exclusive: it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>optional int64 if_generation_match = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000080);
      ifGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifGenerationNotMatch_;

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current generation does not match the given value. If no live
     * object exists, the precondition fails. Setting to 0 makes the operation
     * succeed only if there is a live version of the object.
     * `if_generation_match` and `if_generation_not_match` conditions are mutually
     * exclusive: it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ifGenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationNotMatch() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current generation does not match the given value. If no live
     * object exists, the precondition fails. Setting to 0 makes the operation
     * succeed only if there is a live version of the object.
     * `if_generation_match` and `if_generation_not_match` conditions are mutually
     * exclusive: it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ifGenerationNotMatch.
     */
    @java.lang.Override
    public long getIfGenerationNotMatch() {
      return ifGenerationNotMatch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current generation does not match the given value. If no live
     * object exists, the precondition fails. Setting to 0 makes the operation
     * succeed only if there is a live version of the object.
     * `if_generation_match` and `if_generation_not_match` conditions are mutually
     * exclusive: it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The ifGenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationNotMatch(long value) {

      ifGenerationNotMatch_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current generation does not match the given value. If no live
     * object exists, the precondition fails. Setting to 0 makes the operation
     * succeed only if there is a live version of the object.
     * `if_generation_match` and `if_generation_not_match` conditions are mutually
     * exclusive: it's an error for both of them to be set in the request.
     * </pre>
     *
     * <code>optional int64 if_generation_not_match = 9 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000100);
      ifGenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationMatch_;

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current metageneration matches the given value.
     * `if_metageneration_match` and `if_metageneration_not_match` conditions are
     * mutually exclusive: it's an error for both of them to be set in the
     * request.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ifMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationMatch() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current metageneration matches the given value.
     * `if_metageneration_match` and `if_metageneration_not_match` conditions are
     * mutually exclusive: it's an error for both of them to be set in the
     * request.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ifMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationMatch() {
      return ifMetagenerationMatch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current metageneration matches the given value.
     * `if_metageneration_match` and `if_metageneration_not_match` conditions are
     * mutually exclusive: it's an error for both of them to be set in the
     * request.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The ifMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationMatch(long value) {

      ifMetagenerationMatch_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current metageneration matches the given value.
     * `if_metageneration_match` and `if_metageneration_not_match` conditions are
     * mutually exclusive: it's an error for both of them to be set in the
     * request.
     * </pre>
     *
     * <code>optional int64 if_metageneration_match = 10 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000200);
      ifMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationNotMatch_;

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current metageneration does not match the given value.
     * `if_metageneration_match` and `if_metageneration_not_match` conditions are
     * mutually exclusive: it's an error for both of them to be set in the
     * request.
     * </pre>
     *
     * <code>
     * optional int64 if_metageneration_not_match = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the ifMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationNotMatch() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current metageneration does not match the given value.
     * `if_metageneration_match` and `if_metageneration_not_match` conditions are
     * mutually exclusive: it's an error for both of them to be set in the
     * request.
     * </pre>
     *
     * <code>
     * optional int64 if_metageneration_not_match = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The ifMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationNotMatch() {
      return ifMetagenerationNotMatch_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current metageneration does not match the given value.
     * `if_metageneration_match` and `if_metageneration_not_match` conditions are
     * mutually exclusive: it's an error for both of them to be set in the
     * request.
     * </pre>
     *
     * <code>
     * optional int64 if_metageneration_not_match = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The ifMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationNotMatch(long value) {

      ifMetagenerationNotMatch_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Makes the operation conditional on whether the destination
     * object's current metageneration does not match the given value.
     * `if_metageneration_match` and `if_metageneration_not_match` conditions are
     * mutually exclusive: it's an error for both of them to be set in the
     * request.
     * </pre>
     *
     * <code>
     * optional int64 if_metageneration_not_match = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000400);
      ifMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.MoveObjectRequest)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.MoveObjectRequest)
  private static final com.google.storage.v2.MoveObjectRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.MoveObjectRequest();
  }

  public static com.google.storage.v2.MoveObjectRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<MoveObjectRequest> PARSER =
      new com.google.protobuf.AbstractParser<MoveObjectRequest>() {
        @java.lang.Override
        public MoveObjectRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<MoveObjectRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<MoveObjectRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.MoveObjectRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
