/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/v2/storage.proto

package com.google.storage.v2;

/**
 *
 *
 * <pre>
 * Describes an attempt to insert an object, possibly over multiple requests.
 * </pre>
 *
 * Protobuf type {@code google.storage.v2.WriteObjectSpec}
 */
public final class WriteObjectSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.v2.WriteObjectSpec)
    WriteObjectSpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use WriteObjectSpec.newBuilder() to construct.
  private WriteObjectSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private WriteObjectSpec() {
    predefinedAcl_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new WriteObjectSpec();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private WriteObjectSpec(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.storage.v2.Object.Builder subBuilder = null;
              if (resource_ != null) {
                subBuilder = resource_.toBuilder();
              }
              resource_ =
                  input.readMessage(com.google.storage.v2.Object.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(resource_);
                resource_ = subBuilder.buildPartial();
              }

              break;
            }
          case 16:
            {
              int rawValue = input.readEnum();

              predefinedAcl_ = rawValue;
              break;
            }
          case 24:
            {
              bitField0_ |= 0x00000001;
              ifGenerationMatch_ = input.readInt64();
              break;
            }
          case 32:
            {
              bitField0_ |= 0x00000002;
              ifGenerationNotMatch_ = input.readInt64();
              break;
            }
          case 40:
            {
              bitField0_ |= 0x00000004;
              ifMetagenerationMatch_ = input.readInt64();
              break;
            }
          case 48:
            {
              bitField0_ |= 0x00000008;
              ifMetagenerationNotMatch_ = input.readInt64();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_WriteObjectSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.v2.StorageProto
        .internal_static_google_storage_v2_WriteObjectSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.v2.WriteObjectSpec.class,
            com.google.storage.v2.WriteObjectSpec.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_FIELD_NUMBER = 1;
  private com.google.storage.v2.Object resource_;
  /**
   *
   *
   * <pre>
   * Destination object, including its name and its metadata.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 1;</code>
   *
   * @return Whether the resource field is set.
   */
  @java.lang.Override
  public boolean hasResource() {
    return resource_ != null;
  }
  /**
   *
   *
   * <pre>
   * Destination object, including its name and its metadata.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 1;</code>
   *
   * @return The resource.
   */
  @java.lang.Override
  public com.google.storage.v2.Object getResource() {
    return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
  }
  /**
   *
   *
   * <pre>
   * Destination object, including its name and its metadata.
   * </pre>
   *
   * <code>.google.storage.v2.Object resource = 1;</code>
   */
  @java.lang.Override
  public com.google.storage.v2.ObjectOrBuilder getResourceOrBuilder() {
    return getResource();
  }

  public static final int PREDEFINED_ACL_FIELD_NUMBER = 2;
  private int predefinedAcl_;
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to this object.
   * </pre>
   *
   * <code>.google.storage.v2.PredefinedObjectAcl predefined_acl = 2;</code>
   *
   * @return The enum numeric value on the wire for predefinedAcl.
   */
  @java.lang.Override
  public int getPredefinedAclValue() {
    return predefinedAcl_;
  }
  /**
   *
   *
   * <pre>
   * Apply a predefined set of access controls to this object.
   * </pre>
   *
   * <code>.google.storage.v2.PredefinedObjectAcl predefined_acl = 2;</code>
   *
   * @return The predefinedAcl.
   */
  @java.lang.Override
  public com.google.storage.v2.PredefinedObjectAcl getPredefinedAcl() {
    @SuppressWarnings("deprecation")
    com.google.storage.v2.PredefinedObjectAcl result =
        com.google.storage.v2.PredefinedObjectAcl.valueOf(predefinedAcl_);
    return result == null ? com.google.storage.v2.PredefinedObjectAcl.UNRECOGNIZED : result;
  }

  public static final int IF_GENERATION_MATCH_FIELD_NUMBER = 3;
  private long ifGenerationMatch_;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * generation matches the given value. Setting to 0 makes the operation
   * succeed only if there are no live versions of the object.
   * </pre>
   *
   * <code>int64 if_generation_match = 3;</code>
   *
   * @return Whether the ifGenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationMatch() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * generation matches the given value. Setting to 0 makes the operation
   * succeed only if there are no live versions of the object.
   * </pre>
   *
   * <code>int64 if_generation_match = 3;</code>
   *
   * @return The ifGenerationMatch.
   */
  @java.lang.Override
  public long getIfGenerationMatch() {
    return ifGenerationMatch_;
  }

  public static final int IF_GENERATION_NOT_MATCH_FIELD_NUMBER = 4;
  private long ifGenerationNotMatch_;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * generation does not match the given value. If no live object exists, the
   * precondition fails. Setting to 0 makes the operation succeed only if
   * there is a live version of the object.
   * </pre>
   *
   * <code>int64 if_generation_not_match = 4;</code>
   *
   * @return Whether the ifGenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfGenerationNotMatch() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * generation does not match the given value. If no live object exists, the
   * precondition fails. Setting to 0 makes the operation succeed only if
   * there is a live version of the object.
   * </pre>
   *
   * <code>int64 if_generation_not_match = 4;</code>
   *
   * @return The ifGenerationNotMatch.
   */
  @java.lang.Override
  public long getIfGenerationNotMatch() {
    return ifGenerationNotMatch_;
  }

  public static final int IF_METAGENERATION_MATCH_FIELD_NUMBER = 5;
  private long ifMetagenerationMatch_;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>int64 if_metageneration_match = 5;</code>
   *
   * @return Whether the ifMetagenerationMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationMatch() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration matches the given value.
   * </pre>
   *
   * <code>int64 if_metageneration_match = 5;</code>
   *
   * @return The ifMetagenerationMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationMatch() {
    return ifMetagenerationMatch_;
  }

  public static final int IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER = 6;
  private long ifMetagenerationNotMatch_;
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>int64 if_metageneration_not_match = 6;</code>
   *
   * @return Whether the ifMetagenerationNotMatch field is set.
   */
  @java.lang.Override
  public boolean hasIfMetagenerationNotMatch() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   *
   *
   * <pre>
   * Makes the operation conditional on whether the object's current
   * metageneration does not match the given value.
   * </pre>
   *
   * <code>int64 if_metageneration_not_match = 6;</code>
   *
   * @return The ifMetagenerationNotMatch.
   */
  @java.lang.Override
  public long getIfMetagenerationNotMatch() {
    return ifMetagenerationNotMatch_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (resource_ != null) {
      output.writeMessage(1, getResource());
    }
    if (predefinedAcl_
        != com.google.storage.v2.PredefinedObjectAcl.PREDEFINED_OBJECT_ACL_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, predefinedAcl_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeInt64(3, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeInt64(4, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(5, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeInt64(6, ifMetagenerationNotMatch_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (resource_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getResource());
    }
    if (predefinedAcl_
        != com.google.storage.v2.PredefinedObjectAcl.PREDEFINED_OBJECT_ACL_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, predefinedAcl_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, ifGenerationMatch_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, ifGenerationNotMatch_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(5, ifMetagenerationMatch_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(6, ifMetagenerationNotMatch_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.v2.WriteObjectSpec)) {
      return super.equals(obj);
    }
    com.google.storage.v2.WriteObjectSpec other = (com.google.storage.v2.WriteObjectSpec) obj;

    if (hasResource() != other.hasResource()) return false;
    if (hasResource()) {
      if (!getResource().equals(other.getResource())) return false;
    }
    if (predefinedAcl_ != other.predefinedAcl_) return false;
    if (hasIfGenerationMatch() != other.hasIfGenerationMatch()) return false;
    if (hasIfGenerationMatch()) {
      if (getIfGenerationMatch() != other.getIfGenerationMatch()) return false;
    }
    if (hasIfGenerationNotMatch() != other.hasIfGenerationNotMatch()) return false;
    if (hasIfGenerationNotMatch()) {
      if (getIfGenerationNotMatch() != other.getIfGenerationNotMatch()) return false;
    }
    if (hasIfMetagenerationMatch() != other.hasIfMetagenerationMatch()) return false;
    if (hasIfMetagenerationMatch()) {
      if (getIfMetagenerationMatch() != other.getIfMetagenerationMatch()) return false;
    }
    if (hasIfMetagenerationNotMatch() != other.hasIfMetagenerationNotMatch()) return false;
    if (hasIfMetagenerationNotMatch()) {
      if (getIfMetagenerationNotMatch() != other.getIfMetagenerationNotMatch()) return false;
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasResource()) {
      hash = (37 * hash) + RESOURCE_FIELD_NUMBER;
      hash = (53 * hash) + getResource().hashCode();
    }
    hash = (37 * hash) + PREDEFINED_ACL_FIELD_NUMBER;
    hash = (53 * hash) + predefinedAcl_;
    if (hasIfGenerationMatch()) {
      hash = (37 * hash) + IF_GENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationMatch());
    }
    if (hasIfGenerationNotMatch()) {
      hash = (37 * hash) + IF_GENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfGenerationNotMatch());
    }
    if (hasIfMetagenerationMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationMatch());
    }
    if (hasIfMetagenerationNotMatch()) {
      hash = (37 * hash) + IF_METAGENERATION_NOT_MATCH_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getIfMetagenerationNotMatch());
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.WriteObjectSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.v2.WriteObjectSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.v2.WriteObjectSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Describes an attempt to insert an object, possibly over multiple requests.
   * </pre>
   *
   * Protobuf type {@code google.storage.v2.WriteObjectSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.v2.WriteObjectSpec)
      com.google.storage.v2.WriteObjectSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_WriteObjectSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_WriteObjectSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.v2.WriteObjectSpec.class,
              com.google.storage.v2.WriteObjectSpec.Builder.class);
    }

    // Construct using com.google.storage.v2.WriteObjectSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (resourceBuilder_ == null) {
        resource_ = null;
      } else {
        resource_ = null;
        resourceBuilder_ = null;
      }
      predefinedAcl_ = 0;

      ifGenerationMatch_ = 0L;
      bitField0_ = (bitField0_ & ~0x00000001);
      ifGenerationNotMatch_ = 0L;
      bitField0_ = (bitField0_ & ~0x00000002);
      ifMetagenerationMatch_ = 0L;
      bitField0_ = (bitField0_ & ~0x00000004);
      ifMetagenerationNotMatch_ = 0L;
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.v2.StorageProto
          .internal_static_google_storage_v2_WriteObjectSpec_descriptor;
    }

    @java.lang.Override
    public com.google.storage.v2.WriteObjectSpec getDefaultInstanceForType() {
      return com.google.storage.v2.WriteObjectSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.v2.WriteObjectSpec build() {
      com.google.storage.v2.WriteObjectSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.v2.WriteObjectSpec buildPartial() {
      com.google.storage.v2.WriteObjectSpec result =
          new com.google.storage.v2.WriteObjectSpec(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (resourceBuilder_ == null) {
        result.resource_ = resource_;
      } else {
        result.resource_ = resourceBuilder_.build();
      }
      result.predefinedAcl_ = predefinedAcl_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.ifGenerationMatch_ = ifGenerationMatch_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.ifGenerationNotMatch_ = ifGenerationNotMatch_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ifMetagenerationMatch_ = ifMetagenerationMatch_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ifMetagenerationNotMatch_ = ifMetagenerationNotMatch_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.v2.WriteObjectSpec) {
        return mergeFrom((com.google.storage.v2.WriteObjectSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.v2.WriteObjectSpec other) {
      if (other == com.google.storage.v2.WriteObjectSpec.getDefaultInstance()) return this;
      if (other.hasResource()) {
        mergeResource(other.getResource());
      }
      if (other.predefinedAcl_ != 0) {
        setPredefinedAclValue(other.getPredefinedAclValue());
      }
      if (other.hasIfGenerationMatch()) {
        setIfGenerationMatch(other.getIfGenerationMatch());
      }
      if (other.hasIfGenerationNotMatch()) {
        setIfGenerationNotMatch(other.getIfGenerationNotMatch());
      }
      if (other.hasIfMetagenerationMatch()) {
        setIfMetagenerationMatch(other.getIfMetagenerationMatch());
      }
      if (other.hasIfMetagenerationNotMatch()) {
        setIfMetagenerationNotMatch(other.getIfMetagenerationNotMatch());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.storage.v2.WriteObjectSpec parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.storage.v2.WriteObjectSpec) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.storage.v2.Object resource_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        resourceBuilder_;
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     *
     * @return Whether the resource field is set.
     */
    public boolean hasResource() {
      return resourceBuilder_ != null || resource_ != null;
    }
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     *
     * @return The resource.
     */
    public com.google.storage.v2.Object getResource() {
      if (resourceBuilder_ == null) {
        return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
      } else {
        return resourceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     */
    public Builder setResource(com.google.storage.v2.Object value) {
      if (resourceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resource_ = value;
        onChanged();
      } else {
        resourceBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     */
    public Builder setResource(com.google.storage.v2.Object.Builder builderForValue) {
      if (resourceBuilder_ == null) {
        resource_ = builderForValue.build();
        onChanged();
      } else {
        resourceBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     */
    public Builder mergeResource(com.google.storage.v2.Object value) {
      if (resourceBuilder_ == null) {
        if (resource_ != null) {
          resource_ =
              com.google.storage.v2.Object.newBuilder(resource_).mergeFrom(value).buildPartial();
        } else {
          resource_ = value;
        }
        onChanged();
      } else {
        resourceBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     */
    public Builder clearResource() {
      if (resourceBuilder_ == null) {
        resource_ = null;
        onChanged();
      } else {
        resource_ = null;
        resourceBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     */
    public com.google.storage.v2.Object.Builder getResourceBuilder() {

      onChanged();
      return getResourceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     */
    public com.google.storage.v2.ObjectOrBuilder getResourceOrBuilder() {
      if (resourceBuilder_ != null) {
        return resourceBuilder_.getMessageOrBuilder();
      } else {
        return resource_ == null ? com.google.storage.v2.Object.getDefaultInstance() : resource_;
      }
    }
    /**
     *
     *
     * <pre>
     * Destination object, including its name and its metadata.
     * </pre>
     *
     * <code>.google.storage.v2.Object resource = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.storage.v2.Object,
            com.google.storage.v2.Object.Builder,
            com.google.storage.v2.ObjectOrBuilder>
        getResourceFieldBuilder() {
      if (resourceBuilder_ == null) {
        resourceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.storage.v2.Object,
                com.google.storage.v2.Object.Builder,
                com.google.storage.v2.ObjectOrBuilder>(
                getResource(), getParentForChildren(), isClean());
        resource_ = null;
      }
      return resourceBuilder_;
    }

    private int predefinedAcl_ = 0;
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * </pre>
     *
     * <code>.google.storage.v2.PredefinedObjectAcl predefined_acl = 2;</code>
     *
     * @return The enum numeric value on the wire for predefinedAcl.
     */
    @java.lang.Override
    public int getPredefinedAclValue() {
      return predefinedAcl_;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * </pre>
     *
     * <code>.google.storage.v2.PredefinedObjectAcl predefined_acl = 2;</code>
     *
     * @param value The enum numeric value on the wire for predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAclValue(int value) {

      predefinedAcl_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * </pre>
     *
     * <code>.google.storage.v2.PredefinedObjectAcl predefined_acl = 2;</code>
     *
     * @return The predefinedAcl.
     */
    @java.lang.Override
    public com.google.storage.v2.PredefinedObjectAcl getPredefinedAcl() {
      @SuppressWarnings("deprecation")
      com.google.storage.v2.PredefinedObjectAcl result =
          com.google.storage.v2.PredefinedObjectAcl.valueOf(predefinedAcl_);
      return result == null ? com.google.storage.v2.PredefinedObjectAcl.UNRECOGNIZED : result;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * </pre>
     *
     * <code>.google.storage.v2.PredefinedObjectAcl predefined_acl = 2;</code>
     *
     * @param value The predefinedAcl to set.
     * @return This builder for chaining.
     */
    public Builder setPredefinedAcl(com.google.storage.v2.PredefinedObjectAcl value) {
      if (value == null) {
        throw new NullPointerException();
      }

      predefinedAcl_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Apply a predefined set of access controls to this object.
     * </pre>
     *
     * <code>.google.storage.v2.PredefinedObjectAcl predefined_acl = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPredefinedAcl() {

      predefinedAcl_ = 0;
      onChanged();
      return this;
    }

    private long ifGenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation matches the given value. Setting to 0 makes the operation
     * succeed only if there are no live versions of the object.
     * </pre>
     *
     * <code>int64 if_generation_match = 3;</code>
     *
     * @return Whether the ifGenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationMatch() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation matches the given value. Setting to 0 makes the operation
     * succeed only if there are no live versions of the object.
     * </pre>
     *
     * <code>int64 if_generation_match = 3;</code>
     *
     * @return The ifGenerationMatch.
     */
    @java.lang.Override
    public long getIfGenerationMatch() {
      return ifGenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation matches the given value. Setting to 0 makes the operation
     * succeed only if there are no live versions of the object.
     * </pre>
     *
     * <code>int64 if_generation_match = 3;</code>
     *
     * @param value The ifGenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationMatch(long value) {
      bitField0_ |= 0x00000001;
      ifGenerationMatch_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation matches the given value. Setting to 0 makes the operation
     * succeed only if there are no live versions of the object.
     * </pre>
     *
     * <code>int64 if_generation_match = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000001);
      ifGenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifGenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation does not match the given value. If no live object exists, the
     * precondition fails. Setting to 0 makes the operation succeed only if
     * there is a live version of the object.
     * </pre>
     *
     * <code>int64 if_generation_not_match = 4;</code>
     *
     * @return Whether the ifGenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfGenerationNotMatch() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation does not match the given value. If no live object exists, the
     * precondition fails. Setting to 0 makes the operation succeed only if
     * there is a live version of the object.
     * </pre>
     *
     * <code>int64 if_generation_not_match = 4;</code>
     *
     * @return The ifGenerationNotMatch.
     */
    @java.lang.Override
    public long getIfGenerationNotMatch() {
      return ifGenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation does not match the given value. If no live object exists, the
     * precondition fails. Setting to 0 makes the operation succeed only if
     * there is a live version of the object.
     * </pre>
     *
     * <code>int64 if_generation_not_match = 4;</code>
     *
     * @param value The ifGenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfGenerationNotMatch(long value) {
      bitField0_ |= 0x00000002;
      ifGenerationNotMatch_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * generation does not match the given value. If no live object exists, the
     * precondition fails. Setting to 0 makes the operation succeed only if
     * there is a live version of the object.
     * </pre>
     *
     * <code>int64 if_generation_not_match = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfGenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000002);
      ifGenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>int64 if_metageneration_match = 5;</code>
     *
     * @return Whether the ifMetagenerationMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationMatch() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>int64 if_metageneration_match = 5;</code>
     *
     * @return The ifMetagenerationMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationMatch() {
      return ifMetagenerationMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>int64 if_metageneration_match = 5;</code>
     *
     * @param value The ifMetagenerationMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationMatch(long value) {
      bitField0_ |= 0x00000004;
      ifMetagenerationMatch_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration matches the given value.
     * </pre>
     *
     * <code>int64 if_metageneration_match = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationMatch() {
      bitField0_ = (bitField0_ & ~0x00000004);
      ifMetagenerationMatch_ = 0L;
      onChanged();
      return this;
    }

    private long ifMetagenerationNotMatch_;
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>int64 if_metageneration_not_match = 6;</code>
     *
     * @return Whether the ifMetagenerationNotMatch field is set.
     */
    @java.lang.Override
    public boolean hasIfMetagenerationNotMatch() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>int64 if_metageneration_not_match = 6;</code>
     *
     * @return The ifMetagenerationNotMatch.
     */
    @java.lang.Override
    public long getIfMetagenerationNotMatch() {
      return ifMetagenerationNotMatch_;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>int64 if_metageneration_not_match = 6;</code>
     *
     * @param value The ifMetagenerationNotMatch to set.
     * @return This builder for chaining.
     */
    public Builder setIfMetagenerationNotMatch(long value) {
      bitField0_ |= 0x00000008;
      ifMetagenerationNotMatch_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Makes the operation conditional on whether the object's current
     * metageneration does not match the given value.
     * </pre>
     *
     * <code>int64 if_metageneration_not_match = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIfMetagenerationNotMatch() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ifMetagenerationNotMatch_ = 0L;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.v2.WriteObjectSpec)
  }

  // @@protoc_insertion_point(class_scope:google.storage.v2.WriteObjectSpec)
  private static final com.google.storage.v2.WriteObjectSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.v2.WriteObjectSpec();
  }

  public static com.google.storage.v2.WriteObjectSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<WriteObjectSpec> PARSER =
      new com.google.protobuf.AbstractParser<WriteObjectSpec>() {
        @java.lang.Override
        public WriteObjectSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new WriteObjectSpec(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<WriteObjectSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<WriteObjectSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.v2.WriteObjectSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
