/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.control.v2;

public interface ListFoldersRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.control.v2.ListFoldersRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which to look for folders. The bucket must
   * be a hierarchical namespace enabled bucket.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which to look for folders. The bucket must
   * be a hierarchical namespace enabled bucket.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Optional. Maximum number of folders to return in a single response. The
   * service will use this parameter or 1,000 items, whichever is smaller.
   * </pre>
   *
   * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * Optional. A previously-returned page token representing part of the larger
   * set of results to view.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();

  /**
   *
   *
   * <pre>
   * Optional. A previously-returned page token representing part of the larger
   * set of results to view.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names begin with this prefix.
   * If set, the value must either be an empty string or end with a '/'.
   * </pre>
   *
   * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The prefix.
   */
  java.lang.String getPrefix();

  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names begin with this prefix.
   * If set, the value must either be an empty string or end with a '/'.
   * </pre>
   *
   * <code>string prefix = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for prefix.
   */
  com.google.protobuf.ByteString getPrefixBytes();

  /**
   *
   *
   * <pre>
   * Optional. If set, returns results in a directory-like mode. The results
   * will only include folders that either exactly match the above prefix, or
   * are one level below the prefix. The only supported value is '/'.
   * </pre>
   *
   * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The delimiter.
   */
  java.lang.String getDelimiter();

  /**
   *
   *
   * <pre>
   * Optional. If set, returns results in a directory-like mode. The results
   * will only include folders that either exactly match the above prefix, or
   * are one level below the prefix. The only supported value is '/'.
   * </pre>
   *
   * <code>string delimiter = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for delimiter.
   */
  com.google.protobuf.ByteString getDelimiterBytes();

  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names are lexicographically equal
   * to or after lexicographic_start. If lexicographic_end is also set, the
   * folders listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The lexicographicStart.
   */
  java.lang.String getLexicographicStart();

  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names are lexicographically equal
   * to or after lexicographic_start. If lexicographic_end is also set, the
   * folders listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_start = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for lexicographicStart.
   */
  com.google.protobuf.ByteString getLexicographicStartBytes();

  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names are lexicographically
   * before lexicographic_end. If lexicographic_start is also set, the folders
   * listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The lexicographicEnd.
   */
  java.lang.String getLexicographicEnd();

  /**
   *
   *
   * <pre>
   * Optional. Filter results to folders whose names are lexicographically
   * before lexicographic_end. If lexicographic_start is also set, the folders
   * listed have names between lexicographic_start (inclusive) and
   * lexicographic_end (exclusive).
   * </pre>
   *
   * <code>string lexicographic_end = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for lexicographicEnd.
   */
  com.google.protobuf.ByteString getLexicographicEndBytes();

  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request. UUID is the recommended
   * format, but other formats are still accepted.
   * </pre>
   *
   * <code>
   * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The requestId.
   */
  java.lang.String getRequestId();

  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request. UUID is the recommended
   * format, but other formats are still accepted.
   * </pre>
   *
   * <code>
   * string request_id = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The bytes for requestId.
   */
  com.google.protobuf.ByteString getRequestIdBytes();
}
