/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.8
package com.google.storage.control.v2;

/**
 *
 *
 * <pre>
 * An Anywhere Cache Instance.
 * </pre>
 *
 * Protobuf type {@code google.storage.control.v2.AnywhereCache}
 */
public final class AnywhereCache extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.storage.control.v2.AnywhereCache)
    AnywhereCacheOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AnywhereCache.newBuilder() to construct.
  private AnywhereCache(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AnywhereCache() {
    name_ = "";
    zone_ = "";
    admissionPolicy_ = "";
    state_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AnywhereCache();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_AnywhereCache_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.storage.control.v2.StorageControlProto
        .internal_static_google_storage_control_v2_AnywhereCache_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.storage.control.v2.AnywhereCache.class,
            com.google.storage.control.v2.AnywhereCache.Builder.class);
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of this AnywhereCache.
   * Format:
   * `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The resource name of this AnywhereCache.
   * Format:
   * `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ZONE_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object zone_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. The zone in which the cache instance is running. For example,
   * us-central1-a.
   * </pre>
   *
   * <code>string zone = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The zone.
   */
  @java.lang.Override
  public java.lang.String getZone() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      zone_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. The zone in which the cache instance is running. For example,
   * us-central1-a.
   * </pre>
   *
   * <code>string zone = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for zone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getZoneBytes() {
    java.lang.Object ref = zone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      zone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TTL_FIELD_NUMBER = 3;
  private com.google.protobuf.Duration ttl_;

  /**
   *
   *
   * <pre>
   * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
   * that defines how long a cache entry can live. Default ttl value (24hrs)
   * is applied if not specified in the create request. TTL must be in whole
   * seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 3;</code>
   *
   * @return Whether the ttl field is set.
   */
  @java.lang.Override
  public boolean hasTtl() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
   * that defines how long a cache entry can live. Default ttl value (24hrs)
   * is applied if not specified in the create request. TTL must be in whole
   * seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 3;</code>
   *
   * @return The ttl.
   */
  @java.lang.Override
  public com.google.protobuf.Duration getTtl() {
    return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
  }

  /**
   *
   *
   * <pre>
   * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
   * that defines how long a cache entry can live. Default ttl value (24hrs)
   * is applied if not specified in the create request. TTL must be in whole
   * seconds.
   * </pre>
   *
   * <code>.google.protobuf.Duration ttl = 3;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
    return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
  }

  public static final int ADMISSION_POLICY_FIELD_NUMBER = 9;

  @SuppressWarnings("serial")
  private volatile java.lang.Object admissionPolicy_ = "";

  /**
   *
   *
   * <pre>
   * Cache admission policy. Valid policies includes:
   * `admit-on-first-miss` and `admit-on-second-miss`. Defaults to
   * `admit-on-first-miss`. Default value is applied if not specified in the
   * create request.
   * </pre>
   *
   * <code>string admission_policy = 9;</code>
   *
   * @return The admissionPolicy.
   */
  @java.lang.Override
  public java.lang.String getAdmissionPolicy() {
    java.lang.Object ref = admissionPolicy_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      admissionPolicy_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Cache admission policy. Valid policies includes:
   * `admit-on-first-miss` and `admit-on-second-miss`. Defaults to
   * `admit-on-first-miss`. Default value is applied if not specified in the
   * create request.
   * </pre>
   *
   * <code>string admission_policy = 9;</code>
   *
   * @return The bytes for admissionPolicy.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAdmissionPolicyBytes() {
    java.lang.Object ref = admissionPolicy_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      admissionPolicy_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATE_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object state_ = "";

  /**
   *
   *
   * <pre>
   * Output only. Cache state including RUNNING, CREATING, DISABLED and PAUSED.
   * </pre>
   *
   * <code>string state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The state.
   */
  @java.lang.Override
  public java.lang.String getState() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      state_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. Cache state including RUNNING, CREATING, DISABLED and PAUSED.
   * </pre>
   *
   * <code>string state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for state.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStateBytes() {
    java.lang.Object ref = state_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      state_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when Anywhere cache instance is allocated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when Anywhere cache instance is allocated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when Anywhere cache instance is allocated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when Anywhere cache instance is last updated, including
   * creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when Anywhere cache instance is last updated, including
   * creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when Anywhere cache instance is last updated, including
   * creation.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int PENDING_UPDATE_FIELD_NUMBER = 8;
  private boolean pendingUpdate_ = false;

  /**
   *
   *
   * <pre>
   * Output only. True if there is an active update operation against this cache
   * instance. Subsequential update requests will be rejected if this field is
   * true. Output only.
   * </pre>
   *
   * <code>bool pending_update = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The pendingUpdate.
   */
  @java.lang.Override
  public boolean getPendingUpdate() {
    return pendingUpdate_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getTtl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(state_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (pendingUpdate_ != false) {
      output.writeBool(8, pendingUpdate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(admissionPolicy_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, admissionPolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, zone_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getTtl());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(state_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, state_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (pendingUpdate_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(8, pendingUpdate_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(admissionPolicy_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, admissionPolicy_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(zone_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, zone_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.storage.control.v2.AnywhereCache)) {
      return super.equals(obj);
    }
    com.google.storage.control.v2.AnywhereCache other =
        (com.google.storage.control.v2.AnywhereCache) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getZone().equals(other.getZone())) return false;
    if (hasTtl() != other.hasTtl()) return false;
    if (hasTtl()) {
      if (!getTtl().equals(other.getTtl())) return false;
    }
    if (!getAdmissionPolicy().equals(other.getAdmissionPolicy())) return false;
    if (!getState().equals(other.getState())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getPendingUpdate() != other.getPendingUpdate()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + ZONE_FIELD_NUMBER;
    hash = (53 * hash) + getZone().hashCode();
    if (hasTtl()) {
      hash = (37 * hash) + TTL_FIELD_NUMBER;
      hash = (53 * hash) + getTtl().hashCode();
    }
    hash = (37 * hash) + ADMISSION_POLICY_FIELD_NUMBER;
    hash = (53 * hash) + getAdmissionPolicy().hashCode();
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + getState().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + PENDING_UPDATE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getPendingUpdate());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.AnywhereCache parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.AnywhereCache parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.storage.control.v2.AnywhereCache parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.storage.control.v2.AnywhereCache prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An Anywhere Cache Instance.
   * </pre>
   *
   * Protobuf type {@code google.storage.control.v2.AnywhereCache}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.storage.control.v2.AnywhereCache)
      com.google.storage.control.v2.AnywhereCacheOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_AnywhereCache_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_AnywhereCache_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.storage.control.v2.AnywhereCache.class,
              com.google.storage.control.v2.AnywhereCache.Builder.class);
    }

    // Construct using com.google.storage.control.v2.AnywhereCache.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getTtlFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      zone_ = "";
      ttl_ = null;
      if (ttlBuilder_ != null) {
        ttlBuilder_.dispose();
        ttlBuilder_ = null;
      }
      admissionPolicy_ = "";
      state_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      pendingUpdate_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.storage.control.v2.StorageControlProto
          .internal_static_google_storage_control_v2_AnywhereCache_descriptor;
    }

    @java.lang.Override
    public com.google.storage.control.v2.AnywhereCache getDefaultInstanceForType() {
      return com.google.storage.control.v2.AnywhereCache.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.storage.control.v2.AnywhereCache build() {
      com.google.storage.control.v2.AnywhereCache result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.storage.control.v2.AnywhereCache buildPartial() {
      com.google.storage.control.v2.AnywhereCache result =
          new com.google.storage.control.v2.AnywhereCache(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.storage.control.v2.AnywhereCache result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.zone_ = zone_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.ttl_ = ttlBuilder_ == null ? ttl_ : ttlBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.admissionPolicy_ = admissionPolicy_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.state_ = state_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.pendingUpdate_ = pendingUpdate_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.storage.control.v2.AnywhereCache) {
        return mergeFrom((com.google.storage.control.v2.AnywhereCache) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.storage.control.v2.AnywhereCache other) {
      if (other == com.google.storage.control.v2.AnywhereCache.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getZone().isEmpty()) {
        zone_ = other.zone_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasTtl()) {
        mergeTtl(other.getTtl());
      }
      if (!other.getAdmissionPolicy().isEmpty()) {
        admissionPolicy_ = other.admissionPolicy_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getState().isEmpty()) {
        state_ = other.state_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getPendingUpdate() != false) {
        setPendingUpdate(other.getPendingUpdate());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 26:
              {
                input.readMessage(getTtlFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                state_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 64:
              {
                pendingUpdate_ = input.readBool();
                bitField0_ |= 0x00000080;
                break;
              } // case 64
            case 74:
              {
                admissionPolicy_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 74
            case 82:
              {
                zone_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 82
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of this AnywhereCache.
     * Format:
     * `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of this AnywhereCache.
     * Format:
     * `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of this AnywhereCache.
     * Format:
     * `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of this AnywhereCache.
     * Format:
     * `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The resource name of this AnywhereCache.
     * Format:
     * `projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}`
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object zone_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>string zone = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The zone.
     */
    public java.lang.String getZone() {
      java.lang.Object ref = zone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        zone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>string zone = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for zone.
     */
    public com.google.protobuf.ByteString getZoneBytes() {
      java.lang.Object ref = zone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        zone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>string zone = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The zone to set.
     * @return This builder for chaining.
     */
    public Builder setZone(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>string zone = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearZone() {
      zone_ = getDefaultInstance().getZone();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. The zone in which the cache instance is running. For example,
     * us-central1-a.
     * </pre>
     *
     * <code>string zone = 10 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for zone to set.
     * @return This builder for chaining.
     */
    public Builder setZoneBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      zone_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.Duration ttl_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        ttlBuilder_;

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     *
     * @return Whether the ttl field is set.
     */
    public boolean hasTtl() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     *
     * @return The ttl.
     */
    public com.google.protobuf.Duration getTtl() {
      if (ttlBuilder_ == null) {
        return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
      } else {
        return ttlBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public Builder setTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ttl_ = value;
      } else {
        ttlBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public Builder setTtl(com.google.protobuf.Duration.Builder builderForValue) {
      if (ttlBuilder_ == null) {
        ttl_ = builderForValue.build();
      } else {
        ttlBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public Builder mergeTtl(com.google.protobuf.Duration value) {
      if (ttlBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && ttl_ != null
            && ttl_ != com.google.protobuf.Duration.getDefaultInstance()) {
          getTtlBuilder().mergeFrom(value);
        } else {
          ttl_ = value;
        }
      } else {
        ttlBuilder_.mergeFrom(value);
      }
      if (ttl_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public Builder clearTtl() {
      bitField0_ = (bitField0_ & ~0x00000004);
      ttl_ = null;
      if (ttlBuilder_ != null) {
        ttlBuilder_.dispose();
        ttlBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public com.google.protobuf.Duration.Builder getTtlBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getTtlFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    public com.google.protobuf.DurationOrBuilder getTtlOrBuilder() {
      if (ttlBuilder_ != null) {
        return ttlBuilder_.getMessageOrBuilder();
      } else {
        return ttl_ == null ? com.google.protobuf.Duration.getDefaultInstance() : ttl_;
      }
    }

    /**
     *
     *
     * <pre>
     * Cache entry TTL (ranges between 1h to 7d). This is a cache-level config
     * that defines how long a cache entry can live. Default ttl value (24hrs)
     * is applied if not specified in the create request. TTL must be in whole
     * seconds.
     * </pre>
     *
     * <code>.google.protobuf.Duration ttl = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Duration,
            com.google.protobuf.Duration.Builder,
            com.google.protobuf.DurationOrBuilder>
        getTtlFieldBuilder() {
      if (ttlBuilder_ == null) {
        ttlBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Duration,
                com.google.protobuf.Duration.Builder,
                com.google.protobuf.DurationOrBuilder>(getTtl(), getParentForChildren(), isClean());
        ttl_ = null;
      }
      return ttlBuilder_;
    }

    private java.lang.Object admissionPolicy_ = "";

    /**
     *
     *
     * <pre>
     * Cache admission policy. Valid policies includes:
     * `admit-on-first-miss` and `admit-on-second-miss`. Defaults to
     * `admit-on-first-miss`. Default value is applied if not specified in the
     * create request.
     * </pre>
     *
     * <code>string admission_policy = 9;</code>
     *
     * @return The admissionPolicy.
     */
    public java.lang.String getAdmissionPolicy() {
      java.lang.Object ref = admissionPolicy_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        admissionPolicy_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Cache admission policy. Valid policies includes:
     * `admit-on-first-miss` and `admit-on-second-miss`. Defaults to
     * `admit-on-first-miss`. Default value is applied if not specified in the
     * create request.
     * </pre>
     *
     * <code>string admission_policy = 9;</code>
     *
     * @return The bytes for admissionPolicy.
     */
    public com.google.protobuf.ByteString getAdmissionPolicyBytes() {
      java.lang.Object ref = admissionPolicy_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        admissionPolicy_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Cache admission policy. Valid policies includes:
     * `admit-on-first-miss` and `admit-on-second-miss`. Defaults to
     * `admit-on-first-miss`. Default value is applied if not specified in the
     * create request.
     * </pre>
     *
     * <code>string admission_policy = 9;</code>
     *
     * @param value The admissionPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setAdmissionPolicy(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      admissionPolicy_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cache admission policy. Valid policies includes:
     * `admit-on-first-miss` and `admit-on-second-miss`. Defaults to
     * `admit-on-first-miss`. Default value is applied if not specified in the
     * create request.
     * </pre>
     *
     * <code>string admission_policy = 9;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdmissionPolicy() {
      admissionPolicy_ = getDefaultInstance().getAdmissionPolicy();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Cache admission policy. Valid policies includes:
     * `admit-on-first-miss` and `admit-on-second-miss`. Defaults to
     * `admit-on-first-miss`. Default value is applied if not specified in the
     * create request.
     * </pre>
     *
     * <code>string admission_policy = 9;</code>
     *
     * @param value The bytes for admissionPolicy to set.
     * @return This builder for chaining.
     */
    public Builder setAdmissionPolicyBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      admissionPolicy_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object state_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Cache state including RUNNING, CREATING, DISABLED and PAUSED.
     * </pre>
     *
     * <code>string state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The state.
     */
    public java.lang.String getState() {
      java.lang.Object ref = state_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        state_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Cache state including RUNNING, CREATING, DISABLED and PAUSED.
     * </pre>
     *
     * <code>string state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for state.
     */
    public com.google.protobuf.ByteString getStateBytes() {
      java.lang.Object ref = state_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        state_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Cache state including RUNNING, CREATING, DISABLED and PAUSED.
     * </pre>
     *
     * <code>string state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Cache state including RUNNING, CREATING, DISABLED and PAUSED.
     * </pre>
     *
     * <code>string state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      state_ = getDefaultInstance().getState();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Cache state including RUNNING, CREATING, DISABLED and PAUSED.
     * </pre>
     *
     * <code>string state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      state_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is allocated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when Anywhere cache instance is last updated, including
     * creation.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private boolean pendingUpdate_;

    /**
     *
     *
     * <pre>
     * Output only. True if there is an active update operation against this cache
     * instance. Subsequential update requests will be rejected if this field is
     * true. Output only.
     * </pre>
     *
     * <code>bool pending_update = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The pendingUpdate.
     */
    @java.lang.Override
    public boolean getPendingUpdate() {
      return pendingUpdate_;
    }

    /**
     *
     *
     * <pre>
     * Output only. True if there is an active update operation against this cache
     * instance. Subsequential update requests will be rejected if this field is
     * true. Output only.
     * </pre>
     *
     * <code>bool pending_update = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The pendingUpdate to set.
     * @return This builder for chaining.
     */
    public Builder setPendingUpdate(boolean value) {

      pendingUpdate_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. True if there is an active update operation against this cache
     * instance. Subsequential update requests will be rejected if this field is
     * true. Output only.
     * </pre>
     *
     * <code>bool pending_update = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPendingUpdate() {
      bitField0_ = (bitField0_ & ~0x00000080);
      pendingUpdate_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.storage.control.v2.AnywhereCache)
  }

  // @@protoc_insertion_point(class_scope:google.storage.control.v2.AnywhereCache)
  private static final com.google.storage.control.v2.AnywhereCache DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.storage.control.v2.AnywhereCache();
  }

  public static com.google.storage.control.v2.AnywhereCache getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AnywhereCache> PARSER =
      new com.google.protobuf.AbstractParser<AnywhereCache>() {
        @java.lang.Override
        public AnywhereCache parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AnywhereCache> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AnywhereCache> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.storage.control.v2.AnywhereCache getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
