/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/storage/control/v2/storage_control.proto

// Protobuf Java Version: 3.25.5
package com.google.storage.control.v2;

public interface CreateFolderRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.storage.control.v2.CreateFolderRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the folder will reside. The bucket
   * must be a hierarchical namespace enabled bucket.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. Name of the bucket in which the folder will reside. The bucket
   * must be a hierarchical namespace enabled bucket.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. Properties of the new folder being created.
   * The bucket and name of the folder are specified in the parent and folder_id
   * fields, respectively. Populating those fields in `folder` will result in an
   * error.
   * </pre>
   *
   * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the folder field is set.
   */
  boolean hasFolder();
  /**
   *
   *
   * <pre>
   * Required. Properties of the new folder being created.
   * The bucket and name of the folder are specified in the parent and folder_id
   * fields, respectively. Populating those fields in `folder` will result in an
   * error.
   * </pre>
   *
   * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The folder.
   */
  com.google.storage.control.v2.Folder getFolder();
  /**
   *
   *
   * <pre>
   * Required. Properties of the new folder being created.
   * The bucket and name of the folder are specified in the parent and folder_id
   * fields, respectively. Populating those fields in `folder` will result in an
   * error.
   * </pre>
   *
   * <code>.google.storage.control.v2.Folder folder = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.storage.control.v2.FolderOrBuilder getFolderOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The full name of a folder, including all its parent folders.
   * Folders use single '/' characters as a delimiter.
   * The folder_id must end with a slash.
   * For example, the folder_id of "books/biographies/" would create a new
   * "biographies/" folder under the "books/" folder.
   * </pre>
   *
   * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The folderId.
   */
  java.lang.String getFolderId();
  /**
   *
   *
   * <pre>
   * Required. The full name of a folder, including all its parent folders.
   * Folders use single '/' characters as a delimiter.
   * The folder_id must end with a slash.
   * For example, the folder_id of "books/biographies/" would create a new
   * "biographies/" folder under the "books/" folder.
   * </pre>
   *
   * <code>string folder_id = 3 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for folderId.
   */
  com.google.protobuf.ByteString getFolderIdBytes();

  /**
   *
   *
   * <pre>
   * Optional. If true, parent folder doesn't have to be present and all missing
   * ancestor folders will be created atomically.
   * </pre>
   *
   * <code>bool recursive = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The recursive.
   */
  boolean getRecursive();

  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request. UUID is the recommended
   * format, but other formats are still accepted.
   * </pre>
   *
   * <code>
   * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The requestId.
   */
  java.lang.String getRequestId();
  /**
   *
   *
   * <pre>
   * Optional. A unique identifier for this request. UUID is the recommended
   * format, but other formats are still accepted.
   * </pre>
   *
   * <code>
   * string request_id = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_info) = { ... }
   * </code>
   *
   * @return The bytes for requestId.
   */
  com.google.protobuf.ByteString getRequestIdBytes();
}
