// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/speech/v1beta1/cloud_speech.proto

package com.google.cloud.speech.v1beta1;

/**
 *
 *
 * <pre>
 * `StreamingRecognizeResponse` is the only message returned to the client by
 * `StreamingRecognize`. A series of one or more `StreamingRecognizeResponse`
 * messages are streamed back to the client.
 * Here's an example of a series of ten `StreamingRecognizeResponse`s that might
 * be returned while processing audio:
 * 1. endpointer_type: START_OF_SPEECH
 * 2. results { alternatives { transcript: "tube" } stability: 0.01 }
 *    result_index: 0
 * 3. results { alternatives { transcript: "to be a" } stability: 0.01 }
 *    result_index: 0
 * 4. results { alternatives { transcript: "to be" } stability: 0.9 }
 *    results { alternatives { transcript: " or not to be" } stability: 0.01 }
 *    result_index: 0
 * 5. results { alternatives { transcript: "to be or not to be"
 *                             confidence: 0.92 }
 *              alternatives { transcript: "to bee or not to bee" }
 *              is_final: true }
 *    result_index: 0
 * 6. results { alternatives { transcript: " that's" } stability: 0.01 }
 *    result_index: 1
 * 7. results { alternatives { transcript: " that is" } stability: 0.9 }
 *    results { alternatives { transcript: " the question" } stability: 0.01 }
 *    result_index: 1
 * 8. endpointer_type: END_OF_SPEECH
 * 9. results { alternatives { transcript: " that is the question"
 *                             confidence: 0.98 }
 *              alternatives { transcript: " that was the question" }
 *              is_final: true }
 *    result_index: 1
 * 10. endpointer_type: END_OF_AUDIO
 * Notes:
 * - Only two of the above responses #5 and #9 contain final results, they are
 *   indicated by `is_final: true`. Concatenating these together generates the
 *   full transcript: "to be or not to be that is the question".
 * - The others contain interim `results`. #4 and #7 contain two interim
 *   `results`, the first portion has a high stability and is less likely to
 *   change, the second portion has a low stability and is very likely to
 *   change. A UI designer might choose to show only high stability `results`.
 * - The specific `stability` and `confidence` values shown above are only for
 *   illustrative purposes. Actual values may vary.
 * - The `result_index` indicates the portion of audio that has had final
 *   results returned, and is no longer being processed. For example, the
 *   `results` in #6 and later correspond to the portion of audio after
 *   "to be or not to be".
 * </pre>
 *
 * Protobuf type {@code google.cloud.speech.v1beta1.StreamingRecognizeResponse}
 */
public final class StreamingRecognizeResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.speech.v1beta1.StreamingRecognizeResponse)
    StreamingRecognizeResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StreamingRecognizeResponse.newBuilder() to construct.
  private StreamingRecognizeResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StreamingRecognizeResponse() {
    results_ = java.util.Collections.emptyList();
    resultIndex_ = 0;
    endpointerType_ = 0;
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private StreamingRecognizeResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          default:
            {
              if (!parseUnknownFieldProto3(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
          case 10:
            {
              com.google.rpc.Status.Builder subBuilder = null;
              if (error_ != null) {
                subBuilder = error_.toBuilder();
              }
              error_ = input.readMessage(com.google.rpc.Status.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(error_);
                error_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                results_ =
                    new java.util.ArrayList<
                        com.google.cloud.speech.v1beta1.StreamingRecognitionResult>();
                mutable_bitField0_ |= 0x00000002;
              }
              results_.add(
                  input.readMessage(
                      com.google.cloud.speech.v1beta1.StreamingRecognitionResult.parser(),
                      extensionRegistry));
              break;
            }
          case 24:
            {
              resultIndex_ = input.readInt32();
              break;
            }
          case 32:
            {
              int rawValue = input.readEnum();

              endpointerType_ = rawValue;
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
        results_ = java.util.Collections.unmodifiableList(results_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.speech.v1beta1.SpeechProto
        .internal_static_google_cloud_speech_v1beta1_StreamingRecognizeResponse_descriptor;
  }

  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.speech.v1beta1.SpeechProto
        .internal_static_google_cloud_speech_v1beta1_StreamingRecognizeResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.class,
            com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Indicates the type of endpointer event.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType}
   */
  public enum EndpointerType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * No endpointer event specified.
     * </pre>
     *
     * <code>ENDPOINTER_EVENT_UNSPECIFIED = 0;</code>
     */
    ENDPOINTER_EVENT_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Speech has been detected in the audio stream, and the service is
     * beginning to process it.
     * </pre>
     *
     * <code>START_OF_SPEECH = 1;</code>
     */
    START_OF_SPEECH(1),
    /**
     *
     *
     * <pre>
     * Speech has ceased to be detected in the audio stream. (For example, the
     * user may have paused after speaking.) If `single_utterance` is `false`,
     * the service will continue to process audio, and if subsequent speech is
     * detected, will send another START_OF_SPEECH event.
     * </pre>
     *
     * <code>END_OF_SPEECH = 2;</code>
     */
    END_OF_SPEECH(2),
    /**
     *
     *
     * <pre>
     * This event is sent after the client has half-closed the input stream gRPC
     * connection and the server has received all of the audio. (The server may
     * still be processing the audio and may subsequently return additional
     * results.)
     * </pre>
     *
     * <code>END_OF_AUDIO = 3;</code>
     */
    END_OF_AUDIO(3),
    /**
     *
     *
     * <pre>
     * This event is only sent when `single_utterance` is `true`. It indicates
     * that the server has detected the end of the user's speech utterance and
     * expects no additional speech. Therefore, the server will not process
     * additional audio (although it may subsequently return additional
     * results). The client should stop sending additional audio data,
     * half-close the gRPC connection, and wait for any additional results
     * until the server closes the gRPC connection.
     * </pre>
     *
     * <code>END_OF_UTTERANCE = 4;</code>
     */
    END_OF_UTTERANCE(4),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * No endpointer event specified.
     * </pre>
     *
     * <code>ENDPOINTER_EVENT_UNSPECIFIED = 0;</code>
     */
    public static final int ENDPOINTER_EVENT_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Speech has been detected in the audio stream, and the service is
     * beginning to process it.
     * </pre>
     *
     * <code>START_OF_SPEECH = 1;</code>
     */
    public static final int START_OF_SPEECH_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Speech has ceased to be detected in the audio stream. (For example, the
     * user may have paused after speaking.) If `single_utterance` is `false`,
     * the service will continue to process audio, and if subsequent speech is
     * detected, will send another START_OF_SPEECH event.
     * </pre>
     *
     * <code>END_OF_SPEECH = 2;</code>
     */
    public static final int END_OF_SPEECH_VALUE = 2;
    /**
     *
     *
     * <pre>
     * This event is sent after the client has half-closed the input stream gRPC
     * connection and the server has received all of the audio. (The server may
     * still be processing the audio and may subsequently return additional
     * results.)
     * </pre>
     *
     * <code>END_OF_AUDIO = 3;</code>
     */
    public static final int END_OF_AUDIO_VALUE = 3;
    /**
     *
     *
     * <pre>
     * This event is only sent when `single_utterance` is `true`. It indicates
     * that the server has detected the end of the user's speech utterance and
     * expects no additional speech. Therefore, the server will not process
     * additional audio (although it may subsequently return additional
     * results). The client should stop sending additional audio data,
     * half-close the gRPC connection, and wait for any additional results
     * until the server closes the gRPC connection.
     * </pre>
     *
     * <code>END_OF_UTTERANCE = 4;</code>
     */
    public static final int END_OF_UTTERANCE_VALUE = 4;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /** @deprecated Use {@link #forNumber(int)} instead. */
    @java.lang.Deprecated
    public static EndpointerType valueOf(int value) {
      return forNumber(value);
    }

    public static EndpointerType forNumber(int value) {
      switch (value) {
        case 0:
          return ENDPOINTER_EVENT_UNSPECIFIED;
        case 1:
          return START_OF_SPEECH;
        case 2:
          return END_OF_SPEECH;
        case 3:
          return END_OF_AUDIO;
        case 4:
          return END_OF_UTTERANCE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<EndpointerType> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<EndpointerType> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<EndpointerType>() {
          public EndpointerType findValueByNumber(int number) {
            return EndpointerType.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final EndpointerType[] VALUES = values();

    public static EndpointerType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private EndpointerType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType)
  }

  private int bitField0_;
  public static final int ERROR_FIELD_NUMBER = 1;
  private com.google.rpc.Status error_;
  /**
   *
   *
   * <pre>
   * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   */
  public boolean hasError() {
    return error_ != null;
  }
  /**
   *
   *
   * <pre>
   * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   */
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }
  /**
   *
   *
   * <pre>
   * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
   * specifies the error for the operation.
   * </pre>
   *
   * <code>.google.rpc.Status error = 1;</code>
   */
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return getError();
  }

  public static final int RESULTS_FIELD_NUMBER = 2;
  private java.util.List<com.google.cloud.speech.v1beta1.StreamingRecognitionResult> results_;
  /**
   *
   *
   * <pre>
   * *Output-only* This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
   */
  public java.util.List<com.google.cloud.speech.v1beta1.StreamingRecognitionResult>
      getResultsList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * *Output-only* This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
   */
  public java.util.List<
          ? extends com.google.cloud.speech.v1beta1.StreamingRecognitionResultOrBuilder>
      getResultsOrBuilderList() {
    return results_;
  }
  /**
   *
   *
   * <pre>
   * *Output-only* This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
   */
  public int getResultsCount() {
    return results_.size();
  }
  /**
   *
   *
   * <pre>
   * *Output-only* This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
   */
  public com.google.cloud.speech.v1beta1.StreamingRecognitionResult getResults(int index) {
    return results_.get(index);
  }
  /**
   *
   *
   * <pre>
   * *Output-only* This repeated list contains zero or more results that
   * correspond to consecutive portions of the audio currently being processed.
   * It contains zero or one `is_final=true` result (the newly settled portion),
   * followed by zero or more `is_final=false` results.
   * </pre>
   *
   * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
   */
  public com.google.cloud.speech.v1beta1.StreamingRecognitionResultOrBuilder getResultsOrBuilder(
      int index) {
    return results_.get(index);
  }

  public static final int RESULT_INDEX_FIELD_NUMBER = 3;
  private int resultIndex_;
  /**
   *
   *
   * <pre>
   * *Output-only* Indicates the lowest index in the `results` array that has
   * changed. The repeated `StreamingRecognitionResult` results overwrite past
   * results at this index and higher.
   * </pre>
   *
   * <code>int32 result_index = 3;</code>
   */
  public int getResultIndex() {
    return resultIndex_;
  }

  public static final int ENDPOINTER_TYPE_FIELD_NUMBER = 4;
  private int endpointerType_;
  /**
   *
   *
   * <pre>
   * *Output-only* Indicates the type of endpointer event.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType endpointer_type = 4;
   * </code>
   */
  public int getEndpointerTypeValue() {
    return endpointerType_;
  }
  /**
   *
   *
   * <pre>
   * *Output-only* Indicates the type of endpointer event.
   * </pre>
   *
   * <code>
   * .google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType endpointer_type = 4;
   * </code>
   */
  public com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType
      getEndpointerType() {
    com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType result =
        com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType.valueOf(
            endpointerType_);
    return result == null
        ? com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (error_ != null) {
      output.writeMessage(1, getError());
    }
    for (int i = 0; i < results_.size(); i++) {
      output.writeMessage(2, results_.get(i));
    }
    if (resultIndex_ != 0) {
      output.writeInt32(3, resultIndex_);
    }
    if (endpointerType_
        != com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType
            .ENDPOINTER_EVENT_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, endpointerType_);
    }
    unknownFields.writeTo(output);
  }

  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (error_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getError());
    }
    for (int i = 0; i < results_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, results_.get(i));
    }
    if (resultIndex_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, resultIndex_);
    }
    if (endpointerType_
        != com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType
            .ENDPOINTER_EVENT_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, endpointerType_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.speech.v1beta1.StreamingRecognizeResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.speech.v1beta1.StreamingRecognizeResponse other =
        (com.google.cloud.speech.v1beta1.StreamingRecognizeResponse) obj;

    boolean result = true;
    result = result && (hasError() == other.hasError());
    if (hasError()) {
      result = result && getError().equals(other.getError());
    }
    result = result && getResultsList().equals(other.getResultsList());
    result = result && (getResultIndex() == other.getResultIndex());
    result = result && endpointerType_ == other.endpointerType_;
    result = result && unknownFields.equals(other.unknownFields);
    return result;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (getResultsCount() > 0) {
      hash = (37 * hash) + RESULTS_FIELD_NUMBER;
      hash = (53 * hash) + getResultsList().hashCode();
    }
    hash = (37 * hash) + RESULT_INDEX_FIELD_NUMBER;
    hash = (53 * hash) + getResultIndex();
    hash = (37 * hash) + ENDPOINTER_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + endpointerType_;
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.speech.v1beta1.StreamingRecognizeResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * `StreamingRecognizeResponse` is the only message returned to the client by
   * `StreamingRecognize`. A series of one or more `StreamingRecognizeResponse`
   * messages are streamed back to the client.
   * Here's an example of a series of ten `StreamingRecognizeResponse`s that might
   * be returned while processing audio:
   * 1. endpointer_type: START_OF_SPEECH
   * 2. results { alternatives { transcript: "tube" } stability: 0.01 }
   *    result_index: 0
   * 3. results { alternatives { transcript: "to be a" } stability: 0.01 }
   *    result_index: 0
   * 4. results { alternatives { transcript: "to be" } stability: 0.9 }
   *    results { alternatives { transcript: " or not to be" } stability: 0.01 }
   *    result_index: 0
   * 5. results { alternatives { transcript: "to be or not to be"
   *                             confidence: 0.92 }
   *              alternatives { transcript: "to bee or not to bee" }
   *              is_final: true }
   *    result_index: 0
   * 6. results { alternatives { transcript: " that's" } stability: 0.01 }
   *    result_index: 1
   * 7. results { alternatives { transcript: " that is" } stability: 0.9 }
   *    results { alternatives { transcript: " the question" } stability: 0.01 }
   *    result_index: 1
   * 8. endpointer_type: END_OF_SPEECH
   * 9. results { alternatives { transcript: " that is the question"
   *                             confidence: 0.98 }
   *              alternatives { transcript: " that was the question" }
   *              is_final: true }
   *    result_index: 1
   * 10. endpointer_type: END_OF_AUDIO
   * Notes:
   * - Only two of the above responses #5 and #9 contain final results, they are
   *   indicated by `is_final: true`. Concatenating these together generates the
   *   full transcript: "to be or not to be that is the question".
   * - The others contain interim `results`. #4 and #7 contain two interim
   *   `results`, the first portion has a high stability and is less likely to
   *   change, the second portion has a low stability and is very likely to
   *   change. A UI designer might choose to show only high stability `results`.
   * - The specific `stability` and `confidence` values shown above are only for
   *   illustrative purposes. Actual values may vary.
   * - The `result_index` indicates the portion of audio that has had final
   *   results returned, and is no longer being processed. For example, the
   *   `results` in #6 and later correspond to the portion of audio after
   *   "to be or not to be".
   * </pre>
   *
   * Protobuf type {@code google.cloud.speech.v1beta1.StreamingRecognizeResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.speech.v1beta1.StreamingRecognizeResponse)
      com.google.cloud.speech.v1beta1.StreamingRecognizeResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.speech.v1beta1.SpeechProto
          .internal_static_google_cloud_speech_v1beta1_StreamingRecognizeResponse_descriptor;
    }

    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.speech.v1beta1.SpeechProto
          .internal_static_google_cloud_speech_v1beta1_StreamingRecognizeResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.class,
              com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.Builder.class);
    }

    // Construct using com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResultsFieldBuilder();
      }
    }

    public Builder clear() {
      super.clear();
      if (errorBuilder_ == null) {
        error_ = null;
      } else {
        error_ = null;
        errorBuilder_ = null;
      }
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        resultsBuilder_.clear();
      }
      resultIndex_ = 0;

      endpointerType_ = 0;

      return this;
    }

    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.speech.v1beta1.SpeechProto
          .internal_static_google_cloud_speech_v1beta1_StreamingRecognizeResponse_descriptor;
    }

    public com.google.cloud.speech.v1beta1.StreamingRecognizeResponse getDefaultInstanceForType() {
      return com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.getDefaultInstance();
    }

    public com.google.cloud.speech.v1beta1.StreamingRecognizeResponse build() {
      com.google.cloud.speech.v1beta1.StreamingRecognizeResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    public com.google.cloud.speech.v1beta1.StreamingRecognizeResponse buildPartial() {
      com.google.cloud.speech.v1beta1.StreamingRecognizeResponse result =
          new com.google.cloud.speech.v1beta1.StreamingRecognizeResponse(this);
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (errorBuilder_ == null) {
        result.error_ = error_;
      } else {
        result.error_ = errorBuilder_.build();
      }
      if (resultsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) == 0x00000002)) {
          results_ = java.util.Collections.unmodifiableList(results_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.results_ = results_;
      } else {
        result.results_ = resultsBuilder_.build();
      }
      result.resultIndex_ = resultIndex_;
      result.endpointerType_ = endpointerType_;
      result.bitField0_ = to_bitField0_;
      onBuilt();
      return result;
    }

    public Builder clone() {
      return (Builder) super.clone();
    }

    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return (Builder) super.setField(field, value);
    }

    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return (Builder) super.clearField(field);
    }

    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return (Builder) super.clearOneof(oneof);
    }

    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return (Builder) super.setRepeatedField(field, index, value);
    }

    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return (Builder) super.addRepeatedField(field, value);
    }

    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.speech.v1beta1.StreamingRecognizeResponse) {
        return mergeFrom((com.google.cloud.speech.v1beta1.StreamingRecognizeResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.speech.v1beta1.StreamingRecognizeResponse other) {
      if (other == com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.getDefaultInstance())
        return this;
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (resultsBuilder_ == null) {
        if (!other.results_.isEmpty()) {
          if (results_.isEmpty()) {
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureResultsIsMutable();
            results_.addAll(other.results_);
          }
          onChanged();
        }
      } else {
        if (!other.results_.isEmpty()) {
          if (resultsBuilder_.isEmpty()) {
            resultsBuilder_.dispose();
            resultsBuilder_ = null;
            results_ = other.results_;
            bitField0_ = (bitField0_ & ~0x00000002);
            resultsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResultsFieldBuilder()
                    : null;
          } else {
            resultsBuilder_.addAllMessages(other.results_);
          }
        }
      }
      if (other.getResultIndex() != 0) {
        setResultIndex(other.getResultIndex());
      }
      if (other.endpointerType_ != 0) {
        setEndpointerTypeValue(other.getEndpointerTypeValue());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    public final boolean isInitialized() {
      return true;
    }

    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.speech.v1beta1.StreamingRecognizeResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.speech.v1beta1.StreamingRecognizeResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private com.google.rpc.Status error_ = null;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public boolean hasError() {
      return errorBuilder_ != null || error_ != null;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
        onChanged();
      } else {
        errorBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
        onChanged();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (error_ != null) {
          error_ = com.google.rpc.Status.newBuilder(error_).mergeFrom(value).buildPartial();
        } else {
          error_ = value;
        }
        onChanged();
      } else {
        errorBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public Builder clearError() {
      if (errorBuilder_ == null) {
        error_ = null;
        onChanged();
      } else {
        error_ = null;
        errorBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {

      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }
    /**
     *
     *
     * <pre>
     * *Output-only* If set, returns a [google.rpc.Status][google.rpc.Status] message that
     * specifies the error for the operation.
     * </pre>
     *
     * <code>.google.rpc.Status error = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private java.util.List<com.google.cloud.speech.v1beta1.StreamingRecognitionResult> results_ =
        java.util.Collections.emptyList();

    private void ensureResultsIsMutable() {
      if (!((bitField0_ & 0x00000002) == 0x00000002)) {
        results_ =
            new java.util.ArrayList<com.google.cloud.speech.v1beta1.StreamingRecognitionResult>(
                results_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1beta1.StreamingRecognitionResult,
            com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder,
            com.google.cloud.speech.v1beta1.StreamingRecognitionResultOrBuilder>
        resultsBuilder_;

    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1beta1.StreamingRecognitionResult>
        getResultsList() {
      if (resultsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(results_);
      } else {
        return resultsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public int getResultsCount() {
      if (resultsBuilder_ == null) {
        return results_.size();
      } else {
        return resultsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1beta1.StreamingRecognitionResult getResults(int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder setResults(
        int index, com.google.cloud.speech.v1beta1.StreamingRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.set(index, value);
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder setResults(
        int index,
        com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.set(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addResults(com.google.cloud.speech.v1beta1.StreamingRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        int index, com.google.cloud.speech.v1beta1.StreamingRecognitionResult value) {
      if (resultsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResultsIsMutable();
        results_.add(index, value);
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addResults(
        int index,
        com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder builderForValue) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.add(index, builderForValue.build());
        onChanged();
      } else {
        resultsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder addAllResults(
        java.lang.Iterable<? extends com.google.cloud.speech.v1beta1.StreamingRecognitionResult>
            values) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, results_);
        onChanged();
      } else {
        resultsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder clearResults() {
      if (resultsBuilder_ == null) {
        results_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        resultsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public Builder removeResults(int index) {
      if (resultsBuilder_ == null) {
        ensureResultsIsMutable();
        results_.remove(index);
        onChanged();
      } else {
        resultsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder getResultsBuilder(
        int index) {
      return getResultsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1beta1.StreamingRecognitionResultOrBuilder getResultsOrBuilder(
        int index) {
      if (resultsBuilder_ == null) {
        return results_.get(index);
      } else {
        return resultsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.speech.v1beta1.StreamingRecognitionResultOrBuilder>
        getResultsOrBuilderList() {
      if (resultsBuilder_ != null) {
        return resultsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(results_);
      }
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder addResultsBuilder() {
      return getResultsFieldBuilder()
          .addBuilder(
              com.google.cloud.speech.v1beta1.StreamingRecognitionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder addResultsBuilder(
        int index) {
      return getResultsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.speech.v1beta1.StreamingRecognitionResult.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * *Output-only* This repeated list contains zero or more results that
     * correspond to consecutive portions of the audio currently being processed.
     * It contains zero or one `is_final=true` result (the newly settled portion),
     * followed by zero or more `is_final=false` results.
     * </pre>
     *
     * <code>repeated .google.cloud.speech.v1beta1.StreamingRecognitionResult results = 2;</code>
     */
    public java.util.List<com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder>
        getResultsBuilderList() {
      return getResultsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.speech.v1beta1.StreamingRecognitionResult,
            com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder,
            com.google.cloud.speech.v1beta1.StreamingRecognitionResultOrBuilder>
        getResultsFieldBuilder() {
      if (resultsBuilder_ == null) {
        resultsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.speech.v1beta1.StreamingRecognitionResult,
                com.google.cloud.speech.v1beta1.StreamingRecognitionResult.Builder,
                com.google.cloud.speech.v1beta1.StreamingRecognitionResultOrBuilder>(
                results_,
                ((bitField0_ & 0x00000002) == 0x00000002),
                getParentForChildren(),
                isClean());
        results_ = null;
      }
      return resultsBuilder_;
    }

    private int resultIndex_;
    /**
     *
     *
     * <pre>
     * *Output-only* Indicates the lowest index in the `results` array that has
     * changed. The repeated `StreamingRecognitionResult` results overwrite past
     * results at this index and higher.
     * </pre>
     *
     * <code>int32 result_index = 3;</code>
     */
    public int getResultIndex() {
      return resultIndex_;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* Indicates the lowest index in the `results` array that has
     * changed. The repeated `StreamingRecognitionResult` results overwrite past
     * results at this index and higher.
     * </pre>
     *
     * <code>int32 result_index = 3;</code>
     */
    public Builder setResultIndex(int value) {

      resultIndex_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* Indicates the lowest index in the `results` array that has
     * changed. The repeated `StreamingRecognitionResult` results overwrite past
     * results at this index and higher.
     * </pre>
     *
     * <code>int32 result_index = 3;</code>
     */
    public Builder clearResultIndex() {

      resultIndex_ = 0;
      onChanged();
      return this;
    }

    private int endpointerType_ = 0;
    /**
     *
     *
     * <pre>
     * *Output-only* Indicates the type of endpointer event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType endpointer_type = 4;
     * </code>
     */
    public int getEndpointerTypeValue() {
      return endpointerType_;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* Indicates the type of endpointer event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType endpointer_type = 4;
     * </code>
     */
    public Builder setEndpointerTypeValue(int value) {
      endpointerType_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* Indicates the type of endpointer event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType endpointer_type = 4;
     * </code>
     */
    public com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType
        getEndpointerType() {
      com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType result =
          com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType.valueOf(
              endpointerType_);
      return result == null
          ? com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* Indicates the type of endpointer event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType endpointer_type = 4;
     * </code>
     */
    public Builder setEndpointerType(
        com.google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType value) {
      if (value == null) {
        throw new NullPointerException();
      }

      endpointerType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * *Output-only* Indicates the type of endpointer event.
     * </pre>
     *
     * <code>
     * .google.cloud.speech.v1beta1.StreamingRecognizeResponse.EndpointerType endpointer_type = 4;
     * </code>
     */
    public Builder clearEndpointerType() {

      endpointerType_ = 0;
      onChanged();
      return this;
    }

    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFieldsProto3(unknownFields);
    }

    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.speech.v1beta1.StreamingRecognizeResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.speech.v1beta1.StreamingRecognizeResponse)
  private static final com.google.cloud.speech.v1beta1.StreamingRecognizeResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.speech.v1beta1.StreamingRecognizeResponse();
  }

  public static com.google.cloud.speech.v1beta1.StreamingRecognizeResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StreamingRecognizeResponse> PARSER =
      new com.google.protobuf.AbstractParser<StreamingRecognizeResponse>() {
        public StreamingRecognizeResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new StreamingRecognizeResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<StreamingRecognizeResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StreamingRecognizeResponse> getParserForType() {
    return PARSER;
  }

  public com.google.cloud.speech.v1beta1.StreamingRecognizeResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
