/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/type.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * `Type` indicates the type of a Cloud Spanner value, as might be stored in a
 * table cell or returned from an SQL query.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.Type}
 */
public final class Type extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.Type)
    TypeOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use Type.newBuilder() to construct.
  private Type(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private Type() {
    code_ = 0;
    typeAnnotation_ = 0;
    protoTypeFqn_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new Type();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.TypeProto.internal_static_google_spanner_v1_Type_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.TypeProto.internal_static_google_spanner_v1_Type_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.Type.class, com.google.spanner.v1.Type.Builder.class);
  }

  private int bitField0_;
  public static final int CODE_FIELD_NUMBER = 1;
  private int code_ = 0;

  /**
   *
   *
   * <pre>
   * Required. The [TypeCode][google.spanner.v1.TypeCode] for this type.
   * </pre>
   *
   * <code>.google.spanner.v1.TypeCode code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The enum numeric value on the wire for code.
   */
  @java.lang.Override
  public int getCodeValue() {
    return code_;
  }

  /**
   *
   *
   * <pre>
   * Required. The [TypeCode][google.spanner.v1.TypeCode] for this type.
   * </pre>
   *
   * <code>.google.spanner.v1.TypeCode code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The code.
   */
  @java.lang.Override
  public com.google.spanner.v1.TypeCode getCode() {
    com.google.spanner.v1.TypeCode result = com.google.spanner.v1.TypeCode.forNumber(code_);
    return result == null ? com.google.spanner.v1.TypeCode.UNRECOGNIZED : result;
  }

  public static final int ARRAY_ELEMENT_TYPE_FIELD_NUMBER = 2;
  private com.google.spanner.v1.Type arrayElementType_;

  /**
   *
   *
   * <pre>
   * If [code][google.spanner.v1.Type.code] ==
   * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
   * type of the array elements.
   * </pre>
   *
   * <code>.google.spanner.v1.Type array_element_type = 2;</code>
   *
   * @return Whether the arrayElementType field is set.
   */
  @java.lang.Override
  public boolean hasArrayElementType() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * If [code][google.spanner.v1.Type.code] ==
   * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
   * type of the array elements.
   * </pre>
   *
   * <code>.google.spanner.v1.Type array_element_type = 2;</code>
   *
   * @return The arrayElementType.
   */
  @java.lang.Override
  public com.google.spanner.v1.Type getArrayElementType() {
    return arrayElementType_ == null
        ? com.google.spanner.v1.Type.getDefaultInstance()
        : arrayElementType_;
  }

  /**
   *
   *
   * <pre>
   * If [code][google.spanner.v1.Type.code] ==
   * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
   * type of the array elements.
   * </pre>
   *
   * <code>.google.spanner.v1.Type array_element_type = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.TypeOrBuilder getArrayElementTypeOrBuilder() {
    return arrayElementType_ == null
        ? com.google.spanner.v1.Type.getDefaultInstance()
        : arrayElementType_;
  }

  public static final int STRUCT_TYPE_FIELD_NUMBER = 3;
  private com.google.spanner.v1.StructType structType_;

  /**
   *
   *
   * <pre>
   * If [code][google.spanner.v1.Type.code] ==
   * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
   * type information for the struct's fields.
   * </pre>
   *
   * <code>.google.spanner.v1.StructType struct_type = 3;</code>
   *
   * @return Whether the structType field is set.
   */
  @java.lang.Override
  public boolean hasStructType() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * If [code][google.spanner.v1.Type.code] ==
   * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
   * type information for the struct's fields.
   * </pre>
   *
   * <code>.google.spanner.v1.StructType struct_type = 3;</code>
   *
   * @return The structType.
   */
  @java.lang.Override
  public com.google.spanner.v1.StructType getStructType() {
    return structType_ == null
        ? com.google.spanner.v1.StructType.getDefaultInstance()
        : structType_;
  }

  /**
   *
   *
   * <pre>
   * If [code][google.spanner.v1.Type.code] ==
   * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
   * type information for the struct's fields.
   * </pre>
   *
   * <code>.google.spanner.v1.StructType struct_type = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.StructTypeOrBuilder getStructTypeOrBuilder() {
    return structType_ == null
        ? com.google.spanner.v1.StructType.getDefaultInstance()
        : structType_;
  }

  public static final int TYPE_ANNOTATION_FIELD_NUMBER = 4;
  private int typeAnnotation_ = 0;

  /**
   *
   *
   * <pre>
   * The [TypeAnnotationCode][google.spanner.v1.TypeAnnotationCode] that
   * disambiguates SQL type that Spanner will use to represent values of this
   * type during query processing. This is necessary for some type codes because
   * a single [TypeCode][google.spanner.v1.TypeCode] can be mapped to different
   * SQL types depending on the SQL dialect.
   * [type_annotation][google.spanner.v1.Type.type_annotation] typically is not
   * needed to process the content of a value (it doesn't affect serialization)
   * and clients can ignore it on the read path.
   * </pre>
   *
   * <code>.google.spanner.v1.TypeAnnotationCode type_annotation = 4;</code>
   *
   * @return The enum numeric value on the wire for typeAnnotation.
   */
  @java.lang.Override
  public int getTypeAnnotationValue() {
    return typeAnnotation_;
  }

  /**
   *
   *
   * <pre>
   * The [TypeAnnotationCode][google.spanner.v1.TypeAnnotationCode] that
   * disambiguates SQL type that Spanner will use to represent values of this
   * type during query processing. This is necessary for some type codes because
   * a single [TypeCode][google.spanner.v1.TypeCode] can be mapped to different
   * SQL types depending on the SQL dialect.
   * [type_annotation][google.spanner.v1.Type.type_annotation] typically is not
   * needed to process the content of a value (it doesn't affect serialization)
   * and clients can ignore it on the read path.
   * </pre>
   *
   * <code>.google.spanner.v1.TypeAnnotationCode type_annotation = 4;</code>
   *
   * @return The typeAnnotation.
   */
  @java.lang.Override
  public com.google.spanner.v1.TypeAnnotationCode getTypeAnnotation() {
    com.google.spanner.v1.TypeAnnotationCode result =
        com.google.spanner.v1.TypeAnnotationCode.forNumber(typeAnnotation_);
    return result == null ? com.google.spanner.v1.TypeAnnotationCode.UNRECOGNIZED : result;
  }

  public static final int PROTO_TYPE_FQN_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object protoTypeFqn_ = "";

  /**
   *
   *
   * <pre>
   * If [code][google.spanner.v1.Type.code] ==
   * [PROTO][google.spanner.v1.TypeCode.PROTO] or
   * [code][google.spanner.v1.Type.code] ==
   * [ENUM][google.spanner.v1.TypeCode.ENUM], then `proto_type_fqn` is the fully
   * qualified name of the proto type representing the proto/enum definition.
   * </pre>
   *
   * <code>string proto_type_fqn = 5;</code>
   *
   * @return The protoTypeFqn.
   */
  @java.lang.Override
  public java.lang.String getProtoTypeFqn() {
    java.lang.Object ref = protoTypeFqn_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      protoTypeFqn_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * If [code][google.spanner.v1.Type.code] ==
   * [PROTO][google.spanner.v1.TypeCode.PROTO] or
   * [code][google.spanner.v1.Type.code] ==
   * [ENUM][google.spanner.v1.TypeCode.ENUM], then `proto_type_fqn` is the fully
   * qualified name of the proto type representing the proto/enum definition.
   * </pre>
   *
   * <code>string proto_type_fqn = 5;</code>
   *
   * @return The bytes for protoTypeFqn.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProtoTypeFqnBytes() {
    java.lang.Object ref = protoTypeFqn_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      protoTypeFqn_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (code_ != com.google.spanner.v1.TypeCode.TYPE_CODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(1, code_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getArrayElementType());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getStructType());
    }
    if (typeAnnotation_
        != com.google.spanner.v1.TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED.getNumber()) {
      output.writeEnum(4, typeAnnotation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protoTypeFqn_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, protoTypeFqn_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (code_ != com.google.spanner.v1.TypeCode.TYPE_CODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, code_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getArrayElementType());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStructType());
    }
    if (typeAnnotation_
        != com.google.spanner.v1.TypeAnnotationCode.TYPE_ANNOTATION_CODE_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, typeAnnotation_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(protoTypeFqn_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, protoTypeFqn_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.Type)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.Type other = (com.google.spanner.v1.Type) obj;

    if (code_ != other.code_) return false;
    if (hasArrayElementType() != other.hasArrayElementType()) return false;
    if (hasArrayElementType()) {
      if (!getArrayElementType().equals(other.getArrayElementType())) return false;
    }
    if (hasStructType() != other.hasStructType()) return false;
    if (hasStructType()) {
      if (!getStructType().equals(other.getStructType())) return false;
    }
    if (typeAnnotation_ != other.typeAnnotation_) return false;
    if (!getProtoTypeFqn().equals(other.getProtoTypeFqn())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + CODE_FIELD_NUMBER;
    hash = (53 * hash) + code_;
    if (hasArrayElementType()) {
      hash = (37 * hash) + ARRAY_ELEMENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getArrayElementType().hashCode();
    }
    if (hasStructType()) {
      hash = (37 * hash) + STRUCT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getStructType().hashCode();
    }
    hash = (37 * hash) + TYPE_ANNOTATION_FIELD_NUMBER;
    hash = (53 * hash) + typeAnnotation_;
    hash = (37 * hash) + PROTO_TYPE_FQN_FIELD_NUMBER;
    hash = (53 * hash) + getProtoTypeFqn().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.Type parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.Type parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.Type parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.Type parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.Type parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.Type parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.Type parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.Type parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.Type parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.Type parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.Type parseFrom(com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.Type parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.Type prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * `Type` indicates the type of a Cloud Spanner value, as might be stored in a
   * table cell or returned from an SQL query.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.Type}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.Type)
      com.google.spanner.v1.TypeOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.TypeProto.internal_static_google_spanner_v1_Type_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.TypeProto
          .internal_static_google_spanner_v1_Type_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.Type.class, com.google.spanner.v1.Type.Builder.class);
    }

    // Construct using com.google.spanner.v1.Type.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getArrayElementTypeFieldBuilder();
        getStructTypeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      code_ = 0;
      arrayElementType_ = null;
      if (arrayElementTypeBuilder_ != null) {
        arrayElementTypeBuilder_.dispose();
        arrayElementTypeBuilder_ = null;
      }
      structType_ = null;
      if (structTypeBuilder_ != null) {
        structTypeBuilder_.dispose();
        structTypeBuilder_ = null;
      }
      typeAnnotation_ = 0;
      protoTypeFqn_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.TypeProto.internal_static_google_spanner_v1_Type_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.Type getDefaultInstanceForType() {
      return com.google.spanner.v1.Type.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.Type build() {
      com.google.spanner.v1.Type result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.Type buildPartial() {
      com.google.spanner.v1.Type result = new com.google.spanner.v1.Type(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.Type result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.code_ = code_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.arrayElementType_ =
            arrayElementTypeBuilder_ == null ? arrayElementType_ : arrayElementTypeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.structType_ = structTypeBuilder_ == null ? structType_ : structTypeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.typeAnnotation_ = typeAnnotation_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.protoTypeFqn_ = protoTypeFqn_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.Type) {
        return mergeFrom((com.google.spanner.v1.Type) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.Type other) {
      if (other == com.google.spanner.v1.Type.getDefaultInstance()) return this;
      if (other.code_ != 0) {
        setCodeValue(other.getCodeValue());
      }
      if (other.hasArrayElementType()) {
        mergeArrayElementType(other.getArrayElementType());
      }
      if (other.hasStructType()) {
        mergeStructType(other.getStructType());
      }
      if (other.typeAnnotation_ != 0) {
        setTypeAnnotationValue(other.getTypeAnnotationValue());
      }
      if (!other.getProtoTypeFqn().isEmpty()) {
        protoTypeFqn_ = other.protoTypeFqn_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 8:
              {
                code_ = input.readEnum();
                bitField0_ |= 0x00000001;
                break;
              } // case 8
            case 18:
              {
                input.readMessage(
                    getArrayElementTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getStructTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                typeAnnotation_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 42:
              {
                protoTypeFqn_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private int code_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.spanner.v1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeCode code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The enum numeric value on the wire for code.
     */
    @java.lang.Override
    public int getCodeValue() {
      return code_;
    }

    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.spanner.v1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeCode code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The enum numeric value on the wire for code to set.
     * @return This builder for chaining.
     */
    public Builder setCodeValue(int value) {
      code_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.spanner.v1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeCode code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The code.
     */
    @java.lang.Override
    public com.google.spanner.v1.TypeCode getCode() {
      com.google.spanner.v1.TypeCode result = com.google.spanner.v1.TypeCode.forNumber(code_);
      return result == null ? com.google.spanner.v1.TypeCode.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.spanner.v1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeCode code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The code to set.
     * @return This builder for chaining.
     */
    public Builder setCode(com.google.spanner.v1.TypeCode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000001;
      code_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The [TypeCode][google.spanner.v1.TypeCode] for this type.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeCode code = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCode() {
      bitField0_ = (bitField0_ & ~0x00000001);
      code_ = 0;
      onChanged();
      return this;
    }

    private com.google.spanner.v1.Type arrayElementType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Type,
            com.google.spanner.v1.Type.Builder,
            com.google.spanner.v1.TypeOrBuilder>
        arrayElementTypeBuilder_;

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     *
     * @return Whether the arrayElementType field is set.
     */
    public boolean hasArrayElementType() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     *
     * @return The arrayElementType.
     */
    public com.google.spanner.v1.Type getArrayElementType() {
      if (arrayElementTypeBuilder_ == null) {
        return arrayElementType_ == null
            ? com.google.spanner.v1.Type.getDefaultInstance()
            : arrayElementType_;
      } else {
        return arrayElementTypeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     */
    public Builder setArrayElementType(com.google.spanner.v1.Type value) {
      if (arrayElementTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        arrayElementType_ = value;
      } else {
        arrayElementTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     */
    public Builder setArrayElementType(com.google.spanner.v1.Type.Builder builderForValue) {
      if (arrayElementTypeBuilder_ == null) {
        arrayElementType_ = builderForValue.build();
      } else {
        arrayElementTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     */
    public Builder mergeArrayElementType(com.google.spanner.v1.Type value) {
      if (arrayElementTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && arrayElementType_ != null
            && arrayElementType_ != com.google.spanner.v1.Type.getDefaultInstance()) {
          getArrayElementTypeBuilder().mergeFrom(value);
        } else {
          arrayElementType_ = value;
        }
      } else {
        arrayElementTypeBuilder_.mergeFrom(value);
      }
      if (arrayElementType_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     */
    public Builder clearArrayElementType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      arrayElementType_ = null;
      if (arrayElementTypeBuilder_ != null) {
        arrayElementTypeBuilder_.dispose();
        arrayElementTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     */
    public com.google.spanner.v1.Type.Builder getArrayElementTypeBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getArrayElementTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     */
    public com.google.spanner.v1.TypeOrBuilder getArrayElementTypeOrBuilder() {
      if (arrayElementTypeBuilder_ != null) {
        return arrayElementTypeBuilder_.getMessageOrBuilder();
      } else {
        return arrayElementType_ == null
            ? com.google.spanner.v1.Type.getDefaultInstance()
            : arrayElementType_;
      }
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [ARRAY][google.spanner.v1.TypeCode.ARRAY], then `array_element_type` is the
     * type of the array elements.
     * </pre>
     *
     * <code>.google.spanner.v1.Type array_element_type = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.Type,
            com.google.spanner.v1.Type.Builder,
            com.google.spanner.v1.TypeOrBuilder>
        getArrayElementTypeFieldBuilder() {
      if (arrayElementTypeBuilder_ == null) {
        arrayElementTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Type,
                com.google.spanner.v1.Type.Builder,
                com.google.spanner.v1.TypeOrBuilder>(
                getArrayElementType(), getParentForChildren(), isClean());
        arrayElementType_ = null;
      }
      return arrayElementTypeBuilder_;
    }

    private com.google.spanner.v1.StructType structType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.StructType,
            com.google.spanner.v1.StructType.Builder,
            com.google.spanner.v1.StructTypeOrBuilder>
        structTypeBuilder_;

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     *
     * @return Whether the structType field is set.
     */
    public boolean hasStructType() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     *
     * @return The structType.
     */
    public com.google.spanner.v1.StructType getStructType() {
      if (structTypeBuilder_ == null) {
        return structType_ == null
            ? com.google.spanner.v1.StructType.getDefaultInstance()
            : structType_;
      } else {
        return structTypeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     */
    public Builder setStructType(com.google.spanner.v1.StructType value) {
      if (structTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        structType_ = value;
      } else {
        structTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     */
    public Builder setStructType(com.google.spanner.v1.StructType.Builder builderForValue) {
      if (structTypeBuilder_ == null) {
        structType_ = builderForValue.build();
      } else {
        structTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     */
    public Builder mergeStructType(com.google.spanner.v1.StructType value) {
      if (structTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && structType_ != null
            && structType_ != com.google.spanner.v1.StructType.getDefaultInstance()) {
          getStructTypeBuilder().mergeFrom(value);
        } else {
          structType_ = value;
        }
      } else {
        structTypeBuilder_.mergeFrom(value);
      }
      if (structType_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     */
    public Builder clearStructType() {
      bitField0_ = (bitField0_ & ~0x00000004);
      structType_ = null;
      if (structTypeBuilder_ != null) {
        structTypeBuilder_.dispose();
        structTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     */
    public com.google.spanner.v1.StructType.Builder getStructTypeBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStructTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     */
    public com.google.spanner.v1.StructTypeOrBuilder getStructTypeOrBuilder() {
      if (structTypeBuilder_ != null) {
        return structTypeBuilder_.getMessageOrBuilder();
      } else {
        return structType_ == null
            ? com.google.spanner.v1.StructType.getDefaultInstance()
            : structType_;
      }
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [STRUCT][google.spanner.v1.TypeCode.STRUCT], then `struct_type` provides
     * type information for the struct's fields.
     * </pre>
     *
     * <code>.google.spanner.v1.StructType struct_type = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.StructType,
            com.google.spanner.v1.StructType.Builder,
            com.google.spanner.v1.StructTypeOrBuilder>
        getStructTypeFieldBuilder() {
      if (structTypeBuilder_ == null) {
        structTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.StructType,
                com.google.spanner.v1.StructType.Builder,
                com.google.spanner.v1.StructTypeOrBuilder>(
                getStructType(), getParentForChildren(), isClean());
        structType_ = null;
      }
      return structTypeBuilder_;
    }

    private int typeAnnotation_ = 0;

    /**
     *
     *
     * <pre>
     * The [TypeAnnotationCode][google.spanner.v1.TypeAnnotationCode] that
     * disambiguates SQL type that Spanner will use to represent values of this
     * type during query processing. This is necessary for some type codes because
     * a single [TypeCode][google.spanner.v1.TypeCode] can be mapped to different
     * SQL types depending on the SQL dialect.
     * [type_annotation][google.spanner.v1.Type.type_annotation] typically is not
     * needed to process the content of a value (it doesn't affect serialization)
     * and clients can ignore it on the read path.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeAnnotationCode type_annotation = 4;</code>
     *
     * @return The enum numeric value on the wire for typeAnnotation.
     */
    @java.lang.Override
    public int getTypeAnnotationValue() {
      return typeAnnotation_;
    }

    /**
     *
     *
     * <pre>
     * The [TypeAnnotationCode][google.spanner.v1.TypeAnnotationCode] that
     * disambiguates SQL type that Spanner will use to represent values of this
     * type during query processing. This is necessary for some type codes because
     * a single [TypeCode][google.spanner.v1.TypeCode] can be mapped to different
     * SQL types depending on the SQL dialect.
     * [type_annotation][google.spanner.v1.Type.type_annotation] typically is not
     * needed to process the content of a value (it doesn't affect serialization)
     * and clients can ignore it on the read path.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeAnnotationCode type_annotation = 4;</code>
     *
     * @param value The enum numeric value on the wire for typeAnnotation to set.
     * @return This builder for chaining.
     */
    public Builder setTypeAnnotationValue(int value) {
      typeAnnotation_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [TypeAnnotationCode][google.spanner.v1.TypeAnnotationCode] that
     * disambiguates SQL type that Spanner will use to represent values of this
     * type during query processing. This is necessary for some type codes because
     * a single [TypeCode][google.spanner.v1.TypeCode] can be mapped to different
     * SQL types depending on the SQL dialect.
     * [type_annotation][google.spanner.v1.Type.type_annotation] typically is not
     * needed to process the content of a value (it doesn't affect serialization)
     * and clients can ignore it on the read path.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeAnnotationCode type_annotation = 4;</code>
     *
     * @return The typeAnnotation.
     */
    @java.lang.Override
    public com.google.spanner.v1.TypeAnnotationCode getTypeAnnotation() {
      com.google.spanner.v1.TypeAnnotationCode result =
          com.google.spanner.v1.TypeAnnotationCode.forNumber(typeAnnotation_);
      return result == null ? com.google.spanner.v1.TypeAnnotationCode.UNRECOGNIZED : result;
    }

    /**
     *
     *
     * <pre>
     * The [TypeAnnotationCode][google.spanner.v1.TypeAnnotationCode] that
     * disambiguates SQL type that Spanner will use to represent values of this
     * type during query processing. This is necessary for some type codes because
     * a single [TypeCode][google.spanner.v1.TypeCode] can be mapped to different
     * SQL types depending on the SQL dialect.
     * [type_annotation][google.spanner.v1.Type.type_annotation] typically is not
     * needed to process the content of a value (it doesn't affect serialization)
     * and clients can ignore it on the read path.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeAnnotationCode type_annotation = 4;</code>
     *
     * @param value The typeAnnotation to set.
     * @return This builder for chaining.
     */
    public Builder setTypeAnnotation(com.google.spanner.v1.TypeAnnotationCode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      typeAnnotation_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The [TypeAnnotationCode][google.spanner.v1.TypeAnnotationCode] that
     * disambiguates SQL type that Spanner will use to represent values of this
     * type during query processing. This is necessary for some type codes because
     * a single [TypeCode][google.spanner.v1.TypeCode] can be mapped to different
     * SQL types depending on the SQL dialect.
     * [type_annotation][google.spanner.v1.Type.type_annotation] typically is not
     * needed to process the content of a value (it doesn't affect serialization)
     * and clients can ignore it on the read path.
     * </pre>
     *
     * <code>.google.spanner.v1.TypeAnnotationCode type_annotation = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTypeAnnotation() {
      bitField0_ = (bitField0_ & ~0x00000008);
      typeAnnotation_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object protoTypeFqn_ = "";

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [PROTO][google.spanner.v1.TypeCode.PROTO] or
     * [code][google.spanner.v1.Type.code] ==
     * [ENUM][google.spanner.v1.TypeCode.ENUM], then `proto_type_fqn` is the fully
     * qualified name of the proto type representing the proto/enum definition.
     * </pre>
     *
     * <code>string proto_type_fqn = 5;</code>
     *
     * @return The protoTypeFqn.
     */
    public java.lang.String getProtoTypeFqn() {
      java.lang.Object ref = protoTypeFqn_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        protoTypeFqn_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [PROTO][google.spanner.v1.TypeCode.PROTO] or
     * [code][google.spanner.v1.Type.code] ==
     * [ENUM][google.spanner.v1.TypeCode.ENUM], then `proto_type_fqn` is the fully
     * qualified name of the proto type representing the proto/enum definition.
     * </pre>
     *
     * <code>string proto_type_fqn = 5;</code>
     *
     * @return The bytes for protoTypeFqn.
     */
    public com.google.protobuf.ByteString getProtoTypeFqnBytes() {
      java.lang.Object ref = protoTypeFqn_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        protoTypeFqn_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [PROTO][google.spanner.v1.TypeCode.PROTO] or
     * [code][google.spanner.v1.Type.code] ==
     * [ENUM][google.spanner.v1.TypeCode.ENUM], then `proto_type_fqn` is the fully
     * qualified name of the proto type representing the proto/enum definition.
     * </pre>
     *
     * <code>string proto_type_fqn = 5;</code>
     *
     * @param value The protoTypeFqn to set.
     * @return This builder for chaining.
     */
    public Builder setProtoTypeFqn(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      protoTypeFqn_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [PROTO][google.spanner.v1.TypeCode.PROTO] or
     * [code][google.spanner.v1.Type.code] ==
     * [ENUM][google.spanner.v1.TypeCode.ENUM], then `proto_type_fqn` is the fully
     * qualified name of the proto type representing the proto/enum definition.
     * </pre>
     *
     * <code>string proto_type_fqn = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProtoTypeFqn() {
      protoTypeFqn_ = getDefaultInstance().getProtoTypeFqn();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If [code][google.spanner.v1.Type.code] ==
     * [PROTO][google.spanner.v1.TypeCode.PROTO] or
     * [code][google.spanner.v1.Type.code] ==
     * [ENUM][google.spanner.v1.TypeCode.ENUM], then `proto_type_fqn` is the fully
     * qualified name of the proto type representing the proto/enum definition.
     * </pre>
     *
     * <code>string proto_type_fqn = 5;</code>
     *
     * @param value The bytes for protoTypeFqn to set.
     * @return This builder for chaining.
     */
    public Builder setProtoTypeFqnBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      protoTypeFqn_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.Type)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.Type)
  private static final com.google.spanner.v1.Type DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.Type();
  }

  public static com.google.spanner.v1.Type getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Type> PARSER =
      new com.google.protobuf.AbstractParser<Type>() {
        @java.lang.Override
        public Type parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<Type> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Type> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.Type getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
