/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/result_set.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * Results from [Read][google.spanner.v1.Spanner.Read] or
 * [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.ResultSet}
 */
public final class ResultSet extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.ResultSet)
    ResultSetOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ResultSet.newBuilder() to construct.
  private ResultSet(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ResultSet() {
    rows_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ResultSet();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.ResultSetProto
        .internal_static_google_spanner_v1_ResultSet_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.ResultSetProto
        .internal_static_google_spanner_v1_ResultSet_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.ResultSet.class, com.google.spanner.v1.ResultSet.Builder.class);
  }

  private int bitField0_;
  public static final int METADATA_FIELD_NUMBER = 1;
  private com.google.spanner.v1.ResultSetMetadata metadata_;

  /**
   *
   *
   * <pre>
   * Metadata about the result set, such as row type information.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
   *
   * @return Whether the metadata field is set.
   */
  @java.lang.Override
  public boolean hasMetadata() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Metadata about the result set, such as row type information.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
   *
   * @return The metadata.
   */
  @java.lang.Override
  public com.google.spanner.v1.ResultSetMetadata getMetadata() {
    return metadata_ == null
        ? com.google.spanner.v1.ResultSetMetadata.getDefaultInstance()
        : metadata_;
  }

  /**
   *
   *
   * <pre>
   * Metadata about the result set, such as row type information.
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ResultSetMetadataOrBuilder getMetadataOrBuilder() {
    return metadata_ == null
        ? com.google.spanner.v1.ResultSetMetadata.getDefaultInstance()
        : metadata_;
  }

  public static final int ROWS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.ListValue> rows_;

  /**
   *
   *
   * <pre>
   * Each element in `rows` is a row whose format is defined by
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
   * element in each row matches the ith field in
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
   * are encoded based on type as described [here][google.spanner.v1.TypeCode].
   * </pre>
   *
   * <code>repeated .google.protobuf.ListValue rows = 2;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.ListValue> getRowsList() {
    return rows_;
  }

  /**
   *
   *
   * <pre>
   * Each element in `rows` is a row whose format is defined by
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
   * element in each row matches the ith field in
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
   * are encoded based on type as described [here][google.spanner.v1.TypeCode].
   * </pre>
   *
   * <code>repeated .google.protobuf.ListValue rows = 2;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.ListValueOrBuilder> getRowsOrBuilderList() {
    return rows_;
  }

  /**
   *
   *
   * <pre>
   * Each element in `rows` is a row whose format is defined by
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
   * element in each row matches the ith field in
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
   * are encoded based on type as described [here][google.spanner.v1.TypeCode].
   * </pre>
   *
   * <code>repeated .google.protobuf.ListValue rows = 2;</code>
   */
  @java.lang.Override
  public int getRowsCount() {
    return rows_.size();
  }

  /**
   *
   *
   * <pre>
   * Each element in `rows` is a row whose format is defined by
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
   * element in each row matches the ith field in
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
   * are encoded based on type as described [here][google.spanner.v1.TypeCode].
   * </pre>
   *
   * <code>repeated .google.protobuf.ListValue rows = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ListValue getRows(int index) {
    return rows_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Each element in `rows` is a row whose format is defined by
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
   * element in each row matches the ith field in
   * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
   * are encoded based on type as described [here][google.spanner.v1.TypeCode].
   * </pre>
   *
   * <code>repeated .google.protobuf.ListValue rows = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ListValueOrBuilder getRowsOrBuilder(int index) {
    return rows_.get(index);
  }

  public static final int STATS_FIELD_NUMBER = 3;
  private com.google.spanner.v1.ResultSetStats stats_;

  /**
   *
   *
   * <pre>
   * Query plan and execution statistics for the SQL statement that
   * produced this result set. These can be requested by setting
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * DML statements always produce stats containing the number of rows
   * modified, unless executed using the
   * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * Other fields might or might not be populated, based on the
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
   *
   * @return Whether the stats field is set.
   */
  @java.lang.Override
  public boolean hasStats() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Query plan and execution statistics for the SQL statement that
   * produced this result set. These can be requested by setting
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * DML statements always produce stats containing the number of rows
   * modified, unless executed using the
   * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * Other fields might or might not be populated, based on the
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
   *
   * @return The stats.
   */
  @java.lang.Override
  public com.google.spanner.v1.ResultSetStats getStats() {
    return stats_ == null ? com.google.spanner.v1.ResultSetStats.getDefaultInstance() : stats_;
  }

  /**
   *
   *
   * <pre>
   * Query plan and execution statistics for the SQL statement that
   * produced this result set. These can be requested by setting
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * DML statements always produce stats containing the number of rows
   * modified, unless executed using the
   * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * Other fields might or might not be populated, based on the
   * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
   * </pre>
   *
   * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ResultSetStatsOrBuilder getStatsOrBuilder() {
    return stats_ == null ? com.google.spanner.v1.ResultSetStats.getDefaultInstance() : stats_;
  }

  public static final int PRECOMMIT_TOKEN_FIELD_NUMBER = 5;
  private com.google.spanner.v1.MultiplexedSessionPrecommitToken precommitToken_;

  /**
   *
   *
   * <pre>
   * Optional. A precommit token is included if the read-write transaction is on
   * a multiplexed session. Pass the precommit token with the highest sequence
   * number from this transaction attempt to the
   * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
   * </pre>
   *
   * <code>
   * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the precommitToken field is set.
   */
  @java.lang.Override
  public boolean hasPrecommitToken() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. A precommit token is included if the read-write transaction is on
   * a multiplexed session. Pass the precommit token with the highest sequence
   * number from this transaction attempt to the
   * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
   * </pre>
   *
   * <code>
   * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The precommitToken.
   */
  @java.lang.Override
  public com.google.spanner.v1.MultiplexedSessionPrecommitToken getPrecommitToken() {
    return precommitToken_ == null
        ? com.google.spanner.v1.MultiplexedSessionPrecommitToken.getDefaultInstance()
        : precommitToken_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A precommit token is included if the read-write transaction is on
   * a multiplexed session. Pass the precommit token with the highest sequence
   * number from this transaction attempt to the
   * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
   * </pre>
   *
   * <code>
   * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.v1.MultiplexedSessionPrecommitTokenOrBuilder
      getPrecommitTokenOrBuilder() {
    return precommitToken_ == null
        ? com.google.spanner.v1.MultiplexedSessionPrecommitToken.getDefaultInstance()
        : precommitToken_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getMetadata());
    }
    for (int i = 0; i < rows_.size(); i++) {
      output.writeMessage(2, rows_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(3, getStats());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(5, getPrecommitToken());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMetadata());
    }
    for (int i = 0; i < rows_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, rows_.get(i));
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getStats());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getPrecommitToken());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.ResultSet)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.ResultSet other = (com.google.spanner.v1.ResultSet) obj;

    if (hasMetadata() != other.hasMetadata()) return false;
    if (hasMetadata()) {
      if (!getMetadata().equals(other.getMetadata())) return false;
    }
    if (!getRowsList().equals(other.getRowsList())) return false;
    if (hasStats() != other.hasStats()) return false;
    if (hasStats()) {
      if (!getStats().equals(other.getStats())) return false;
    }
    if (hasPrecommitToken() != other.hasPrecommitToken()) return false;
    if (hasPrecommitToken()) {
      if (!getPrecommitToken().equals(other.getPrecommitToken())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasMetadata()) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadata().hashCode();
    }
    if (getRowsCount() > 0) {
      hash = (37 * hash) + ROWS_FIELD_NUMBER;
      hash = (53 * hash) + getRowsList().hashCode();
    }
    if (hasStats()) {
      hash = (37 * hash) + STATS_FIELD_NUMBER;
      hash = (53 * hash) + getStats().hashCode();
    }
    if (hasPrecommitToken()) {
      hash = (37 * hash) + PRECOMMIT_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPrecommitToken().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.ResultSet parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ResultSet parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ResultSet parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ResultSet parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.ResultSet prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Results from [Read][google.spanner.v1.Spanner.Read] or
   * [ExecuteSql][google.spanner.v1.Spanner.ExecuteSql].
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ResultSet}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.ResultSet)
      com.google.spanner.v1.ResultSetOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.ResultSetProto
          .internal_static_google_spanner_v1_ResultSet_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.ResultSetProto
          .internal_static_google_spanner_v1_ResultSet_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ResultSet.class, com.google.spanner.v1.ResultSet.Builder.class);
    }

    // Construct using com.google.spanner.v1.ResultSet.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetadataFieldBuilder();
        getRowsFieldBuilder();
        getStatsFieldBuilder();
        getPrecommitTokenFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      if (rowsBuilder_ == null) {
        rows_ = java.util.Collections.emptyList();
      } else {
        rows_ = null;
        rowsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      stats_ = null;
      if (statsBuilder_ != null) {
        statsBuilder_.dispose();
        statsBuilder_ = null;
      }
      precommitToken_ = null;
      if (precommitTokenBuilder_ != null) {
        precommitTokenBuilder_.dispose();
        precommitTokenBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.ResultSetProto
          .internal_static_google_spanner_v1_ResultSet_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.ResultSet getDefaultInstanceForType() {
      return com.google.spanner.v1.ResultSet.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.ResultSet build() {
      com.google.spanner.v1.ResultSet result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.ResultSet buildPartial() {
      com.google.spanner.v1.ResultSet result = new com.google.spanner.v1.ResultSet(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.spanner.v1.ResultSet result) {
      if (rowsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          rows_ = java.util.Collections.unmodifiableList(rows_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.rows_ = rows_;
      } else {
        result.rows_ = rowsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.v1.ResultSet result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.metadata_ = metadataBuilder_ == null ? metadata_ : metadataBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.stats_ = statsBuilder_ == null ? stats_ : statsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.precommitToken_ =
            precommitTokenBuilder_ == null ? precommitToken_ : precommitTokenBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.ResultSet) {
        return mergeFrom((com.google.spanner.v1.ResultSet) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.ResultSet other) {
      if (other == com.google.spanner.v1.ResultSet.getDefaultInstance()) return this;
      if (other.hasMetadata()) {
        mergeMetadata(other.getMetadata());
      }
      if (rowsBuilder_ == null) {
        if (!other.rows_.isEmpty()) {
          if (rows_.isEmpty()) {
            rows_ = other.rows_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureRowsIsMutable();
            rows_.addAll(other.rows_);
          }
          onChanged();
        }
      } else {
        if (!other.rows_.isEmpty()) {
          if (rowsBuilder_.isEmpty()) {
            rowsBuilder_.dispose();
            rowsBuilder_ = null;
            rows_ = other.rows_;
            bitField0_ = (bitField0_ & ~0x00000002);
            rowsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRowsFieldBuilder()
                    : null;
          } else {
            rowsBuilder_.addAllMessages(other.rows_);
          }
        }
      }
      if (other.hasStats()) {
        mergeStats(other.getStats());
      }
      if (other.hasPrecommitToken()) {
        mergePrecommitToken(other.getPrecommitToken());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getMetadataFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.protobuf.ListValue m =
                    input.readMessage(com.google.protobuf.ListValue.parser(), extensionRegistry);
                if (rowsBuilder_ == null) {
                  ensureRowsIsMutable();
                  rows_.add(m);
                } else {
                  rowsBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 26:
              {
                input.readMessage(getStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getPrecommitTokenFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.spanner.v1.ResultSetMetadata metadata_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ResultSetMetadata,
            com.google.spanner.v1.ResultSetMetadata.Builder,
            com.google.spanner.v1.ResultSetMetadataOrBuilder>
        metadataBuilder_;

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     *
     * @return Whether the metadata field is set.
     */
    public boolean hasMetadata() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     *
     * @return The metadata.
     */
    public com.google.spanner.v1.ResultSetMetadata getMetadata() {
      if (metadataBuilder_ == null) {
        return metadata_ == null
            ? com.google.spanner.v1.ResultSetMetadata.getDefaultInstance()
            : metadata_;
      } else {
        return metadataBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public Builder setMetadata(com.google.spanner.v1.ResultSetMetadata value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        metadata_ = value;
      } else {
        metadataBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public Builder setMetadata(com.google.spanner.v1.ResultSetMetadata.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        metadata_ = builderForValue.build();
      } else {
        metadataBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public Builder mergeMetadata(com.google.spanner.v1.ResultSetMetadata value) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && metadata_ != null
            && metadata_ != com.google.spanner.v1.ResultSetMetadata.getDefaultInstance()) {
          getMetadataBuilder().mergeFrom(value);
        } else {
          metadata_ = value;
        }
      } else {
        metadataBuilder_.mergeFrom(value);
      }
      if (metadata_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public Builder clearMetadata() {
      bitField0_ = (bitField0_ & ~0x00000001);
      metadata_ = null;
      if (metadataBuilder_ != null) {
        metadataBuilder_.dispose();
        metadataBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public com.google.spanner.v1.ResultSetMetadata.Builder getMetadataBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getMetadataFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    public com.google.spanner.v1.ResultSetMetadataOrBuilder getMetadataOrBuilder() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilder();
      } else {
        return metadata_ == null
            ? com.google.spanner.v1.ResultSetMetadata.getDefaultInstance()
            : metadata_;
      }
    }

    /**
     *
     *
     * <pre>
     * Metadata about the result set, such as row type information.
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetMetadata metadata = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ResultSetMetadata,
            com.google.spanner.v1.ResultSetMetadata.Builder,
            com.google.spanner.v1.ResultSetMetadataOrBuilder>
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ResultSetMetadata,
                com.google.spanner.v1.ResultSetMetadata.Builder,
                com.google.spanner.v1.ResultSetMetadataOrBuilder>(
                getMetadata(), getParentForChildren(), isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    private java.util.List<com.google.protobuf.ListValue> rows_ = java.util.Collections.emptyList();

    private void ensureRowsIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        rows_ = new java.util.ArrayList<com.google.protobuf.ListValue>(rows_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.ListValue,
            com.google.protobuf.ListValue.Builder,
            com.google.protobuf.ListValueOrBuilder>
        rowsBuilder_;

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public java.util.List<com.google.protobuf.ListValue> getRowsList() {
      if (rowsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(rows_);
      } else {
        return rowsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public int getRowsCount() {
      if (rowsBuilder_ == null) {
        return rows_.size();
      } else {
        return rowsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public com.google.protobuf.ListValue getRows(int index) {
      if (rowsBuilder_ == null) {
        return rows_.get(index);
      } else {
        return rowsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder setRows(int index, com.google.protobuf.ListValue value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.set(index, value);
        onChanged();
      } else {
        rowsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder setRows(int index, com.google.protobuf.ListValue.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.set(index, builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder addRows(com.google.protobuf.ListValue value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.add(value);
        onChanged();
      } else {
        rowsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder addRows(int index, com.google.protobuf.ListValue value) {
      if (rowsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRowsIsMutable();
        rows_.add(index, value);
        onChanged();
      } else {
        rowsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder addRows(com.google.protobuf.ListValue.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.add(builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder addRows(int index, com.google.protobuf.ListValue.Builder builderForValue) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.add(index, builderForValue.build());
        onChanged();
      } else {
        rowsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder addAllRows(java.lang.Iterable<? extends com.google.protobuf.ListValue> values) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, rows_);
        onChanged();
      } else {
        rowsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder clearRows() {
      if (rowsBuilder_ == null) {
        rows_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        rowsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public Builder removeRows(int index) {
      if (rowsBuilder_ == null) {
        ensureRowsIsMutable();
        rows_.remove(index);
        onChanged();
      } else {
        rowsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public com.google.protobuf.ListValue.Builder getRowsBuilder(int index) {
      return getRowsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public com.google.protobuf.ListValueOrBuilder getRowsOrBuilder(int index) {
      if (rowsBuilder_ == null) {
        return rows_.get(index);
      } else {
        return rowsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public java.util.List<? extends com.google.protobuf.ListValueOrBuilder> getRowsOrBuilderList() {
      if (rowsBuilder_ != null) {
        return rowsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(rows_);
      }
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public com.google.protobuf.ListValue.Builder addRowsBuilder() {
      return getRowsFieldBuilder().addBuilder(com.google.protobuf.ListValue.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public com.google.protobuf.ListValue.Builder addRowsBuilder(int index) {
      return getRowsFieldBuilder()
          .addBuilder(index, com.google.protobuf.ListValue.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Each element in `rows` is a row whose format is defined by
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. The ith
     * element in each row matches the ith field in
     * [metadata.row_type][google.spanner.v1.ResultSetMetadata.row_type]. Elements
     * are encoded based on type as described [here][google.spanner.v1.TypeCode].
     * </pre>
     *
     * <code>repeated .google.protobuf.ListValue rows = 2;</code>
     */
    public java.util.List<com.google.protobuf.ListValue.Builder> getRowsBuilderList() {
      return getRowsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.ListValue,
            com.google.protobuf.ListValue.Builder,
            com.google.protobuf.ListValueOrBuilder>
        getRowsFieldBuilder() {
      if (rowsBuilder_ == null) {
        rowsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.ListValue,
                com.google.protobuf.ListValue.Builder,
                com.google.protobuf.ListValueOrBuilder>(
                rows_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        rows_ = null;
      }
      return rowsBuilder_;
    }

    private com.google.spanner.v1.ResultSetStats stats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ResultSetStats,
            com.google.spanner.v1.ResultSetStats.Builder,
            com.google.spanner.v1.ResultSetStatsOrBuilder>
        statsBuilder_;

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     *
     * @return Whether the stats field is set.
     */
    public boolean hasStats() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     *
     * @return The stats.
     */
    public com.google.spanner.v1.ResultSetStats getStats() {
      if (statsBuilder_ == null) {
        return stats_ == null ? com.google.spanner.v1.ResultSetStats.getDefaultInstance() : stats_;
      } else {
        return statsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     */
    public Builder setStats(com.google.spanner.v1.ResultSetStats value) {
      if (statsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        stats_ = value;
      } else {
        statsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     */
    public Builder setStats(com.google.spanner.v1.ResultSetStats.Builder builderForValue) {
      if (statsBuilder_ == null) {
        stats_ = builderForValue.build();
      } else {
        statsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     */
    public Builder mergeStats(com.google.spanner.v1.ResultSetStats value) {
      if (statsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && stats_ != null
            && stats_ != com.google.spanner.v1.ResultSetStats.getDefaultInstance()) {
          getStatsBuilder().mergeFrom(value);
        } else {
          stats_ = value;
        }
      } else {
        statsBuilder_.mergeFrom(value);
      }
      if (stats_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     */
    public Builder clearStats() {
      bitField0_ = (bitField0_ & ~0x00000004);
      stats_ = null;
      if (statsBuilder_ != null) {
        statsBuilder_.dispose();
        statsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     */
    public com.google.spanner.v1.ResultSetStats.Builder getStatsBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getStatsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     */
    public com.google.spanner.v1.ResultSetStatsOrBuilder getStatsOrBuilder() {
      if (statsBuilder_ != null) {
        return statsBuilder_.getMessageOrBuilder();
      } else {
        return stats_ == null ? com.google.spanner.v1.ResultSetStats.getDefaultInstance() : stats_;
      }
    }

    /**
     *
     *
     * <pre>
     * Query plan and execution statistics for the SQL statement that
     * produced this result set. These can be requested by setting
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * DML statements always produce stats containing the number of rows
     * modified, unless executed using the
     * [ExecuteSqlRequest.QueryMode.PLAN][google.spanner.v1.ExecuteSqlRequest.QueryMode.PLAN]
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * Other fields might or might not be populated, based on the
     * [ExecuteSqlRequest.query_mode][google.spanner.v1.ExecuteSqlRequest.query_mode].
     * </pre>
     *
     * <code>.google.spanner.v1.ResultSetStats stats = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ResultSetStats,
            com.google.spanner.v1.ResultSetStats.Builder,
            com.google.spanner.v1.ResultSetStatsOrBuilder>
        getStatsFieldBuilder() {
      if (statsBuilder_ == null) {
        statsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ResultSetStats,
                com.google.spanner.v1.ResultSetStats.Builder,
                com.google.spanner.v1.ResultSetStatsOrBuilder>(
                getStats(), getParentForChildren(), isClean());
        stats_ = null;
      }
      return statsBuilder_;
    }

    private com.google.spanner.v1.MultiplexedSessionPrecommitToken precommitToken_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.MultiplexedSessionPrecommitToken,
            com.google.spanner.v1.MultiplexedSessionPrecommitToken.Builder,
            com.google.spanner.v1.MultiplexedSessionPrecommitTokenOrBuilder>
        precommitTokenBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the precommitToken field is set.
     */
    public boolean hasPrecommitToken() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The precommitToken.
     */
    public com.google.spanner.v1.MultiplexedSessionPrecommitToken getPrecommitToken() {
      if (precommitTokenBuilder_ == null) {
        return precommitToken_ == null
            ? com.google.spanner.v1.MultiplexedSessionPrecommitToken.getDefaultInstance()
            : precommitToken_;
      } else {
        return precommitTokenBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrecommitToken(com.google.spanner.v1.MultiplexedSessionPrecommitToken value) {
      if (precommitTokenBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        precommitToken_ = value;
      } else {
        precommitTokenBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPrecommitToken(
        com.google.spanner.v1.MultiplexedSessionPrecommitToken.Builder builderForValue) {
      if (precommitTokenBuilder_ == null) {
        precommitToken_ = builderForValue.build();
      } else {
        precommitTokenBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePrecommitToken(
        com.google.spanner.v1.MultiplexedSessionPrecommitToken value) {
      if (precommitTokenBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && precommitToken_ != null
            && precommitToken_
                != com.google.spanner.v1.MultiplexedSessionPrecommitToken.getDefaultInstance()) {
          getPrecommitTokenBuilder().mergeFrom(value);
        } else {
          precommitToken_ = value;
        }
      } else {
        precommitTokenBuilder_.mergeFrom(value);
      }
      if (precommitToken_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPrecommitToken() {
      bitField0_ = (bitField0_ & ~0x00000008);
      precommitToken_ = null;
      if (precommitTokenBuilder_ != null) {
        precommitTokenBuilder_.dispose();
        precommitTokenBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.v1.MultiplexedSessionPrecommitToken.Builder
        getPrecommitTokenBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getPrecommitTokenFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.v1.MultiplexedSessionPrecommitTokenOrBuilder
        getPrecommitTokenOrBuilder() {
      if (precommitTokenBuilder_ != null) {
        return precommitTokenBuilder_.getMessageOrBuilder();
      } else {
        return precommitToken_ == null
            ? com.google.spanner.v1.MultiplexedSessionPrecommitToken.getDefaultInstance()
            : precommitToken_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A precommit token is included if the read-write transaction is on
     * a multiplexed session. Pass the precommit token with the highest sequence
     * number from this transaction attempt to the
     * [Commit][google.spanner.v1.Spanner.Commit] request for this transaction.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.MultiplexedSessionPrecommitToken precommit_token = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.MultiplexedSessionPrecommitToken,
            com.google.spanner.v1.MultiplexedSessionPrecommitToken.Builder,
            com.google.spanner.v1.MultiplexedSessionPrecommitTokenOrBuilder>
        getPrecommitTokenFieldBuilder() {
      if (precommitTokenBuilder_ == null) {
        precommitTokenBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.MultiplexedSessionPrecommitToken,
                com.google.spanner.v1.MultiplexedSessionPrecommitToken.Builder,
                com.google.spanner.v1.MultiplexedSessionPrecommitTokenOrBuilder>(
                getPrecommitToken(), getParentForChildren(), isClean());
        precommitToken_ = null;
      }
      return precommitTokenBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.ResultSet)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.ResultSet)
  private static final com.google.spanner.v1.ResultSet DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.ResultSet();
  }

  public static com.google.spanner.v1.ResultSet getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ResultSet> PARSER =
      new com.google.protobuf.AbstractParser<ResultSet>() {
        @java.lang.Override
        public ResultSet parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ResultSet> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ResultSet> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.ResultSet getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
