/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/v1/change_stream.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.v1;

/**
 *
 *
 * <pre>
 * Spanner Change Streams enable customers to capture and stream out changes to
 * their Spanner databases in real-time. A change stream
 * can be created with option partition_mode='IMMUTABLE_KEY_RANGE' or
 * partition_mode='MUTABLE_KEY_RANGE'.
 *
 * This message is only used in Change Streams created with the option
 * partition_mode='MUTABLE_KEY_RANGE'. Spanner automatically creates a special
 * Table-Valued Function (TVF) along with each Change Streams. The function
 * provides access to the change stream's records. The function is named
 * READ_&lt;change_stream_name&gt; (where &lt;change_stream_name&gt; is the
 * name of the change stream), and it returns a table with only one column
 * called ChangeRecord.
 * </pre>
 *
 * Protobuf type {@code google.spanner.v1.ChangeStreamRecord}
 */
public final class ChangeStreamRecord extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord)
    ChangeStreamRecordOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ChangeStreamRecord.newBuilder() to construct.
  private ChangeStreamRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ChangeStreamRecord() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ChangeStreamRecord();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.v1.ChangeStreamProto
        .internal_static_google_spanner_v1_ChangeStreamRecord_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.v1.ChangeStreamProto
        .internal_static_google_spanner_v1_ChangeStreamRecord_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.v1.ChangeStreamRecord.class,
            com.google.spanner.v1.ChangeStreamRecord.Builder.class);
  }

  public interface DataChangeRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.DataChangeRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return Whether the commitTimestamp field is set.
     */
    boolean hasCommitTimestamp();

    /**
     *
     *
     * <pre>
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return The commitTimestamp.
     */
    com.google.protobuf.Timestamp getCommitTimestamp();

    /**
     *
     *
     * <pre>
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * The record sequence number ordering across partitions is only meaningful
     * in the context of a specific transaction. Record sequence numbers are
     * unique across partitions for a specific transaction. Sort the
     * DataChangeRecords for the same
     * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
     * by
     * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
     * to reconstruct the ordering of the changes within the transaction.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    java.lang.String getRecordSequence();

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * The record sequence number ordering across partitions is only meaningful
     * in the context of a specific transaction. Record sequence numbers are
     * unique across partitions for a specific transaction. Sort the
     * DataChangeRecords for the same
     * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
     * by
     * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
     * to reconstruct the ordering of the changes within the transaction.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    com.google.protobuf.ByteString getRecordSequenceBytes();

    /**
     *
     *
     * <pre>
     * Provides a globally unique string that represents the transaction in
     * which the change was committed. Multiple transactions can have the same
     * commit timestamp, but each transaction has a unique
     * server_transaction_id.
     * </pre>
     *
     * <code>string server_transaction_id = 3;</code>
     *
     * @return The serverTransactionId.
     */
    java.lang.String getServerTransactionId();

    /**
     *
     *
     * <pre>
     * Provides a globally unique string that represents the transaction in
     * which the change was committed. Multiple transactions can have the same
     * commit timestamp, but each transaction has a unique
     * server_transaction_id.
     * </pre>
     *
     * <code>string server_transaction_id = 3;</code>
     *
     * @return The bytes for serverTransactionId.
     */
    com.google.protobuf.ByteString getServerTransactionIdBytes();

    /**
     *
     *
     * <pre>
     * Indicates whether this is the last record for a transaction in the
     *  current partition. Clients can use this field to determine when all
     *  records for a transaction in the current partition have been received.
     * </pre>
     *
     * <code>bool is_last_record_in_transaction_in_partition = 4;</code>
     *
     * @return The isLastRecordInTransactionInPartition.
     */
    boolean getIsLastRecordInTransactionInPartition();

    /**
     *
     *
     * <pre>
     * Name of the table affected by the change.
     * </pre>
     *
     * <code>string table = 5;</code>
     *
     * @return The table.
     */
    java.lang.String getTable();

    /**
     *
     *
     * <pre>
     * Name of the table affected by the change.
     * </pre>
     *
     * <code>string table = 5;</code>
     *
     * @return The bytes for table.
     */
    com.google.protobuf.ByteString getTableBytes();

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata>
        getColumnMetadataList();

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata getColumnMetadata(
        int index);

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    int getColumnMetadataCount();

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder>
        getColumnMetadataOrBuilderList();

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder
        getColumnMetadataOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod> getModsList();

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod getMods(int index);

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    int getModsCount();

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    java.util.List<? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder>
        getModsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder getModsOrBuilder(
        int index);

    /**
     *
     *
     * <pre>
     * Describes the type of change.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
     *
     * @return The enum numeric value on the wire for modType.
     */
    int getModTypeValue();

    /**
     *
     *
     * <pre>
     * Describes the type of change.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
     *
     * @return The modType.
     */
    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType getModType();

    /**
     *
     *
     * <pre>
     * Describes the value capture type that was specified in the change stream
     * configuration when this change was captured.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
     * </code>
     *
     * @return The enum numeric value on the wire for valueCaptureType.
     */
    int getValueCaptureTypeValue();

    /**
     *
     *
     * <pre>
     * Describes the value capture type that was specified in the change stream
     * configuration when this change was captured.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
     * </code>
     *
     * @return The valueCaptureType.
     */
    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType
        getValueCaptureType();

    /**
     *
     *
     * <pre>
     * Indicates the number of data change records that are part of this
     * transaction across all change stream partitions. This value can be used
     * to assemble all the records associated with a particular transaction.
     * </pre>
     *
     * <code>int32 number_of_records_in_transaction = 10;</code>
     *
     * @return The numberOfRecordsInTransaction.
     */
    int getNumberOfRecordsInTransaction();

    /**
     *
     *
     * <pre>
     * Indicates the number of partitions that return data change records for
     * this transaction. This value can be helpful in assembling all records
     * associated with a particular transaction.
     * </pre>
     *
     * <code>int32 number_of_partitions_in_transaction = 11;</code>
     *
     * @return The numberOfPartitionsInTransaction.
     */
    int getNumberOfPartitionsInTransaction();

    /**
     *
     *
     * <pre>
     * Indicates the transaction tag associated with this transaction.
     * </pre>
     *
     * <code>string transaction_tag = 12;</code>
     *
     * @return The transactionTag.
     */
    java.lang.String getTransactionTag();

    /**
     *
     *
     * <pre>
     * Indicates the transaction tag associated with this transaction.
     * </pre>
     *
     * <code>string transaction_tag = 12;</code>
     *
     * @return The bytes for transactionTag.
     */
    com.google.protobuf.ByteString getTransactionTagBytes();

    /**
     *
     *
     * <pre>
     * Indicates whether the transaction is a system transaction. System
     * transactions include those issued by time-to-live (TTL), column backfill,
     * etc.
     * </pre>
     *
     * <code>bool is_system_transaction = 13;</code>
     *
     * @return The isSystemTransaction.
     */
    boolean getIsSystemTransaction();
  }

  /**
   *
   *
   * <pre>
   * A data change record contains a set of changes to a table with the same
   * modification type (insert, update, or delete) committed at the same commit
   * timestamp in one change stream partition for the same transaction. Multiple
   * data change records can be returned for the same transaction across
   * multiple change stream partitions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord}
   */
  public static final class DataChangeRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.DataChangeRecord)
      DataChangeRecordOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DataChangeRecord.newBuilder() to construct.
    private DataChangeRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataChangeRecord() {
      recordSequence_ = "";
      serverTransactionId_ = "";
      table_ = "";
      columnMetadata_ = java.util.Collections.emptyList();
      mods_ = java.util.Collections.emptyList();
      modType_ = 0;
      valueCaptureType_ = 0;
      transactionTag_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataChangeRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.class,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Mod type describes the type of change Spanner applied to the data. For
     * example, if the client submits an INSERT_OR_UPDATE request, Spanner will
     * perform an insert if there is no existing row and return ModType INSERT.
     * Alternatively, if there is an existing row, Spanner will perform an
     * update and return ModType UPDATE.
     * </pre>
     *
     * Protobuf enum {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType}
     */
    public enum ModType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>MOD_TYPE_UNSPECIFIED = 0;</code>
       */
      MOD_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Indicates data was inserted.
       * </pre>
       *
       * <code>INSERT = 10;</code>
       */
      INSERT(10),
      /**
       *
       *
       * <pre>
       * Indicates existing data was updated.
       * </pre>
       *
       * <code>UPDATE = 20;</code>
       */
      UPDATE(20),
      /**
       *
       *
       * <pre>
       * Indicates existing data was deleted.
       * </pre>
       *
       * <code>DELETE = 30;</code>
       */
      DELETE(30),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>MOD_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int MOD_TYPE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Indicates data was inserted.
       * </pre>
       *
       * <code>INSERT = 10;</code>
       */
      public static final int INSERT_VALUE = 10;

      /**
       *
       *
       * <pre>
       * Indicates existing data was updated.
       * </pre>
       *
       * <code>UPDATE = 20;</code>
       */
      public static final int UPDATE_VALUE = 20;

      /**
       *
       *
       * <pre>
       * Indicates existing data was deleted.
       * </pre>
       *
       * <code>DELETE = 30;</code>
       */
      public static final int DELETE_VALUE = 30;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ModType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ModType forNumber(int value) {
        switch (value) {
          case 0:
            return MOD_TYPE_UNSPECIFIED;
          case 10:
            return INSERT;
          case 20:
            return UPDATE;
          case 30:
            return DELETE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ModType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ModType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ModType>() {
            public ModType findValueByNumber(int number) {
              return ModType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ModType[] VALUES = values();

      public static ModType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ModType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType)
    }

    /**
     *
     *
     * <pre>
     * Value capture type describes which values are recorded in the data
     * change record.
     * </pre>
     *
     * Protobuf enum {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType}
     */
    public enum ValueCaptureType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>VALUE_CAPTURE_TYPE_UNSPECIFIED = 0;</code>
       */
      VALUE_CAPTURE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Records both old and new values of the modified watched columns.
       * </pre>
       *
       * <code>OLD_AND_NEW_VALUES = 10;</code>
       */
      OLD_AND_NEW_VALUES(10),
      /**
       *
       *
       * <pre>
       * Records only new values of the modified watched columns.
       * </pre>
       *
       * <code>NEW_VALUES = 20;</code>
       */
      NEW_VALUES(20),
      /**
       *
       *
       * <pre>
       * Records new values of all watched columns, including modified and
       * unmodified columns.
       * </pre>
       *
       * <code>NEW_ROW = 30;</code>
       */
      NEW_ROW(30),
      /**
       *
       *
       * <pre>
       * Records the new values of all watched columns, including modified and
       * unmodified columns. Also records the old values of the modified
       * columns.
       * </pre>
       *
       * <code>NEW_ROW_AND_OLD_VALUES = 40;</code>
       */
      NEW_ROW_AND_OLD_VALUES(40),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Not specified.
       * </pre>
       *
       * <code>VALUE_CAPTURE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int VALUE_CAPTURE_TYPE_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Records both old and new values of the modified watched columns.
       * </pre>
       *
       * <code>OLD_AND_NEW_VALUES = 10;</code>
       */
      public static final int OLD_AND_NEW_VALUES_VALUE = 10;

      /**
       *
       *
       * <pre>
       * Records only new values of the modified watched columns.
       * </pre>
       *
       * <code>NEW_VALUES = 20;</code>
       */
      public static final int NEW_VALUES_VALUE = 20;

      /**
       *
       *
       * <pre>
       * Records new values of all watched columns, including modified and
       * unmodified columns.
       * </pre>
       *
       * <code>NEW_ROW = 30;</code>
       */
      public static final int NEW_ROW_VALUE = 30;

      /**
       *
       *
       * <pre>
       * Records the new values of all watched columns, including modified and
       * unmodified columns. Also records the old values of the modified
       * columns.
       * </pre>
       *
       * <code>NEW_ROW_AND_OLD_VALUES = 40;</code>
       */
      public static final int NEW_ROW_AND_OLD_VALUES_VALUE = 40;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCaptureType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ValueCaptureType forNumber(int value) {
        switch (value) {
          case 0:
            return VALUE_CAPTURE_TYPE_UNSPECIFIED;
          case 10:
            return OLD_AND_NEW_VALUES;
          case 20:
            return NEW_VALUES;
          case 30:
            return NEW_ROW;
          case 40:
            return NEW_ROW_AND_OLD_VALUES;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ValueCaptureType>
          internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ValueCaptureType>
          internalValueMap =
              new com.google.protobuf.Internal.EnumLiteMap<ValueCaptureType>() {
                public ValueCaptureType findValueByNumber(int number) {
                  return ValueCaptureType.forNumber(number);
                }
              };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDescriptor()
            .getEnumTypes()
            .get(1);
      }

      private static final ValueCaptureType[] VALUES = values();

      public static ValueCaptureType valueOf(
          com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ValueCaptureType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType)
    }

    public interface ColumnMetadataOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Name of the column.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      java.lang.String getName();

      /**
       *
       *
       * <pre>
       * Name of the column.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      com.google.protobuf.ByteString getNameBytes();

      /**
       *
       *
       * <pre>
       * Type of the column.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       *
       * @return Whether the type field is set.
       */
      boolean hasType();

      /**
       *
       *
       * <pre>
       * Type of the column.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       *
       * @return The type.
       */
      com.google.spanner.v1.Type getType();

      /**
       *
       *
       * <pre>
       * Type of the column.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      com.google.spanner.v1.TypeOrBuilder getTypeOrBuilder();

      /**
       *
       *
       * <pre>
       * Indicates whether the column is a primary key column.
       * </pre>
       *
       * <code>bool is_primary_key = 3;</code>
       *
       * @return The isPrimaryKey.
       */
      boolean getIsPrimaryKey();

      /**
       *
       *
       * <pre>
       * Ordinal position of the column based on the original table definition
       * in the schema starting with a value of 1.
       * </pre>
       *
       * <code>int64 ordinal_position = 4;</code>
       *
       * @return The ordinalPosition.
       */
      long getOrdinalPosition();
    }

    /**
     *
     *
     * <pre>
     * Metadata for a column.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata}
     */
    public static final class ColumnMetadata extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata)
        ColumnMetadataOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ColumnMetadata.newBuilder() to construct.
      private ColumnMetadata(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ColumnMetadata() {
        name_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ColumnMetadata();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ColumnMetadata_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ColumnMetadata_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.class,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder
                    .class);
      }

      private int bitField0_;
      public static final int NAME_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Name of the column.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The name.
       */
      @java.lang.Override
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the column.
       * </pre>
       *
       * <code>string name = 1;</code>
       *
       * @return The bytes for name.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int TYPE_FIELD_NUMBER = 2;
      private com.google.spanner.v1.Type type_;

      /**
       *
       *
       * <pre>
       * Type of the column.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       *
       * @return Whether the type field is set.
       */
      @java.lang.Override
      public boolean hasType() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Type of the column.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.spanner.v1.Type getType() {
        return type_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : type_;
      }

      /**
       *
       *
       * <pre>
       * Type of the column.
       * </pre>
       *
       * <code>.google.spanner.v1.Type type = 2;</code>
       */
      @java.lang.Override
      public com.google.spanner.v1.TypeOrBuilder getTypeOrBuilder() {
        return type_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : type_;
      }

      public static final int IS_PRIMARY_KEY_FIELD_NUMBER = 3;
      private boolean isPrimaryKey_ = false;

      /**
       *
       *
       * <pre>
       * Indicates whether the column is a primary key column.
       * </pre>
       *
       * <code>bool is_primary_key = 3;</code>
       *
       * @return The isPrimaryKey.
       */
      @java.lang.Override
      public boolean getIsPrimaryKey() {
        return isPrimaryKey_;
      }

      public static final int ORDINAL_POSITION_FIELD_NUMBER = 4;
      private long ordinalPosition_ = 0L;

      /**
       *
       *
       * <pre>
       * Ordinal position of the column based on the original table definition
       * in the schema starting with a value of 1.
       * </pre>
       *
       * <code>int64 ordinal_position = 4;</code>
       *
       * @return The ordinalPosition.
       */
      @java.lang.Override
      public long getOrdinalPosition() {
        return ordinalPosition_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getType());
        }
        if (isPrimaryKey_ != false) {
          output.writeBool(3, isPrimaryKey_);
        }
        if (ordinalPosition_ != 0L) {
          output.writeInt64(4, ordinalPosition_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getType());
        }
        if (isPrimaryKey_ != false) {
          size += com.google.protobuf.CodedOutputStream.computeBoolSize(3, isPrimaryKey_);
        }
        if (ordinalPosition_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, ordinalPosition_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata)) {
          return super.equals(obj);
        }
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata other =
            (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata) obj;

        if (!getName().equals(other.getName())) return false;
        if (hasType() != other.hasType()) return false;
        if (hasType()) {
          if (!getType().equals(other.getType())) return false;
        }
        if (getIsPrimaryKey() != other.getIsPrimaryKey()) return false;
        if (getOrdinalPosition() != other.getOrdinalPosition()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + NAME_FIELD_NUMBER;
        hash = (53 * hash) + getName().hashCode();
        if (hasType()) {
          hash = (37 * hash) + TYPE_FIELD_NUMBER;
          hash = (53 * hash) + getType().hashCode();
        }
        hash = (37 * hash) + IS_PRIMARY_KEY_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsPrimaryKey());
        hash = (37 * hash) + ORDINAL_POSITION_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getOrdinalPosition());
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Metadata for a column.
       * </pre>
       *
       * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata)
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ColumnMetadata_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ColumnMetadata_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.class,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder
                      .class);
        }

        // Construct using
        // com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getTypeFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          name_ = "";
          type_ = null;
          if (typeBuilder_ != null) {
            typeBuilder_.dispose();
            typeBuilder_ = null;
          }
          isPrimaryKey_ = false;
          ordinalPosition_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ColumnMetadata_descriptor;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
            getDefaultInstanceForType() {
          return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata build() {
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
            buildPartial() {
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata result =
              new com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.name_ = name_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.type_ = typeBuilder_ == null ? type_ : typeBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.isPrimaryKey_ = isPrimaryKey_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.ordinalPosition_ = ordinalPosition_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata) {
            return mergeFrom(
                (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata other) {
          if (other
              == com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
                  .getDefaultInstance()) return this;
          if (!other.getName().isEmpty()) {
            name_ = other.name_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (other.hasType()) {
            mergeType(other.getType());
          }
          if (other.getIsPrimaryKey() != false) {
            setIsPrimaryKey(other.getIsPrimaryKey());
          }
          if (other.getOrdinalPosition() != 0L) {
            setOrdinalPosition(other.getOrdinalPosition());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    name_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(getTypeFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 24:
                  {
                    isPrimaryKey_ = input.readBool();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 24
                case 32:
                  {
                    ordinalPosition_ = input.readInt64();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object name_ = "";

        /**
         *
         *
         * <pre>
         * Name of the column.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The name.
         */
        public java.lang.String getName() {
          java.lang.Object ref = name_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            name_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Name of the column.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return The bytes for name.
         */
        public com.google.protobuf.ByteString getNameBytes() {
          java.lang.Object ref = name_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            name_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Name of the column.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The name to set.
         * @return This builder for chaining.
         */
        public Builder setName(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Name of the column.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearName() {
          name_ = getDefaultInstance().getName();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Name of the column.
         * </pre>
         *
         * <code>string name = 1;</code>
         *
         * @param value The bytes for name to set.
         * @return This builder for chaining.
         */
        public Builder setNameBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          name_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private com.google.spanner.v1.Type type_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Type,
                com.google.spanner.v1.Type.Builder,
                com.google.spanner.v1.TypeOrBuilder>
            typeBuilder_;

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         *
         * @return Whether the type field is set.
         */
        public boolean hasType() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         *
         * @return The type.
         */
        public com.google.spanner.v1.Type getType() {
          if (typeBuilder_ == null) {
            return type_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : type_;
          } else {
            return typeBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         */
        public Builder setType(com.google.spanner.v1.Type value) {
          if (typeBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            type_ = value;
          } else {
            typeBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         */
        public Builder setType(com.google.spanner.v1.Type.Builder builderForValue) {
          if (typeBuilder_ == null) {
            type_ = builderForValue.build();
          } else {
            typeBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         */
        public Builder mergeType(com.google.spanner.v1.Type value) {
          if (typeBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && type_ != null
                && type_ != com.google.spanner.v1.Type.getDefaultInstance()) {
              getTypeBuilder().mergeFrom(value);
            } else {
              type_ = value;
            }
          } else {
            typeBuilder_.mergeFrom(value);
          }
          if (type_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         */
        public Builder clearType() {
          bitField0_ = (bitField0_ & ~0x00000002);
          type_ = null;
          if (typeBuilder_ != null) {
            typeBuilder_.dispose();
            typeBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         */
        public com.google.spanner.v1.Type.Builder getTypeBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getTypeFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         */
        public com.google.spanner.v1.TypeOrBuilder getTypeOrBuilder() {
          if (typeBuilder_ != null) {
            return typeBuilder_.getMessageOrBuilder();
          } else {
            return type_ == null ? com.google.spanner.v1.Type.getDefaultInstance() : type_;
          }
        }

        /**
         *
         *
         * <pre>
         * Type of the column.
         * </pre>
         *
         * <code>.google.spanner.v1.Type type = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.Type,
                com.google.spanner.v1.Type.Builder,
                com.google.spanner.v1.TypeOrBuilder>
            getTypeFieldBuilder() {
          if (typeBuilder_ == null) {
            typeBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.spanner.v1.Type,
                    com.google.spanner.v1.Type.Builder,
                    com.google.spanner.v1.TypeOrBuilder>(
                    getType(), getParentForChildren(), isClean());
            type_ = null;
          }
          return typeBuilder_;
        }

        private boolean isPrimaryKey_;

        /**
         *
         *
         * <pre>
         * Indicates whether the column is a primary key column.
         * </pre>
         *
         * <code>bool is_primary_key = 3;</code>
         *
         * @return The isPrimaryKey.
         */
        @java.lang.Override
        public boolean getIsPrimaryKey() {
          return isPrimaryKey_;
        }

        /**
         *
         *
         * <pre>
         * Indicates whether the column is a primary key column.
         * </pre>
         *
         * <code>bool is_primary_key = 3;</code>
         *
         * @param value The isPrimaryKey to set.
         * @return This builder for chaining.
         */
        public Builder setIsPrimaryKey(boolean value) {

          isPrimaryKey_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Indicates whether the column is a primary key column.
         * </pre>
         *
         * <code>bool is_primary_key = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearIsPrimaryKey() {
          bitField0_ = (bitField0_ & ~0x00000004);
          isPrimaryKey_ = false;
          onChanged();
          return this;
        }

        private long ordinalPosition_;

        /**
         *
         *
         * <pre>
         * Ordinal position of the column based on the original table definition
         * in the schema starting with a value of 1.
         * </pre>
         *
         * <code>int64 ordinal_position = 4;</code>
         *
         * @return The ordinalPosition.
         */
        @java.lang.Override
        public long getOrdinalPosition() {
          return ordinalPosition_;
        }

        /**
         *
         *
         * <pre>
         * Ordinal position of the column based on the original table definition
         * in the schema starting with a value of 1.
         * </pre>
         *
         * <code>int64 ordinal_position = 4;</code>
         *
         * @param value The ordinalPosition to set.
         * @return This builder for chaining.
         */
        public Builder setOrdinalPosition(long value) {

          ordinalPosition_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Ordinal position of the column based on the original table definition
         * in the schema starting with a value of 1.
         * </pre>
         *
         * <code>int64 ordinal_position = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearOrdinalPosition() {
          bitField0_ = (bitField0_ & ~0x00000008);
          ordinalPosition_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata)
      }

      // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata)
      private static final com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata();
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ColumnMetadata> PARSER =
          new com.google.protobuf.AbstractParser<ColumnMetadata>() {
            @java.lang.Override
            public ColumnMetadata parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ColumnMetadata> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ColumnMetadata> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ModValueOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Index within the repeated
       * [column_metadata][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.column_metadata]
       * field, to obtain the column metadata for the column that was modified.
       * </pre>
       *
       * <code>int32 column_metadata_index = 1;</code>
       *
       * @return The columnMetadataIndex.
       */
      int getColumnMetadataIndex();

      /**
       *
       *
       * <pre>
       * The value of the column.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       *
       * @return Whether the value field is set.
       */
      boolean hasValue();

      /**
       *
       *
       * <pre>
       * The value of the column.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       *
       * @return The value.
       */
      com.google.protobuf.Value getValue();

      /**
       *
       *
       * <pre>
       * The value of the column.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      com.google.protobuf.ValueOrBuilder getValueOrBuilder();
    }

    /**
     *
     *
     * <pre>
     * Returns the value and associated metadata for a particular field of the
     * [Mod][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod].
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue}
     */
    public static final class ModValue extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue)
        ModValueOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use ModValue.newBuilder() to construct.
      private ModValue(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ModValue() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ModValue();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ModValue_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ModValue_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.class,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder.class);
      }

      private int bitField0_;
      public static final int COLUMN_METADATA_INDEX_FIELD_NUMBER = 1;
      private int columnMetadataIndex_ = 0;

      /**
       *
       *
       * <pre>
       * Index within the repeated
       * [column_metadata][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.column_metadata]
       * field, to obtain the column metadata for the column that was modified.
       * </pre>
       *
       * <code>int32 column_metadata_index = 1;</code>
       *
       * @return The columnMetadataIndex.
       */
      @java.lang.Override
      public int getColumnMetadataIndex() {
        return columnMetadataIndex_;
      }

      public static final int VALUE_FIELD_NUMBER = 2;
      private com.google.protobuf.Value value_;

      /**
       *
       *
       * <pre>
       * The value of the column.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       *
       * @return Whether the value field is set.
       */
      @java.lang.Override
      public boolean hasValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The value of the column.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.Value getValue() {
        return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
      }

      /**
       *
       *
       * <pre>
       * The value of the column.
       * </pre>
       *
       * <code>.google.protobuf.Value value = 2;</code>
       */
      @java.lang.Override
      public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
        return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (columnMetadataIndex_ != 0) {
          output.writeInt32(1, columnMetadataIndex_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(2, getValue());
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (columnMetadataIndex_ != 0) {
          size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, columnMetadataIndex_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getValue());
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue)) {
          return super.equals(obj);
        }
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue other =
            (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue) obj;

        if (getColumnMetadataIndex() != other.getColumnMetadataIndex()) return false;
        if (hasValue() != other.hasValue()) return false;
        if (hasValue()) {
          if (!getValue().equals(other.getValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + COLUMN_METADATA_INDEX_FIELD_NUMBER;
        hash = (53 * hash) + getColumnMetadataIndex();
        if (hasValue()) {
          hash = (37 * hash) + VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getValue().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Returns the value and associated metadata for a particular field of the
       * [Mod][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod].
       * </pre>
       *
       * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue)
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ModValue_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ModValue_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.class,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder.class);
        }

        // Construct using
        // com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getValueFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          columnMetadataIndex_ = 0;
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_ModValue_descriptor;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
            getDefaultInstanceForType() {
          return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue build() {
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue buildPartial() {
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue result =
              new com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.columnMetadataIndex_ = columnMetadataIndex_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.value_ = valueBuilder_ == null ? value_ : valueBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue) {
            return mergeFrom(
                (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue other) {
          if (other
              == com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                  .getDefaultInstance()) return this;
          if (other.getColumnMetadataIndex() != 0) {
            setColumnMetadataIndex(other.getColumnMetadataIndex());
          }
          if (other.hasValue()) {
            mergeValue(other.getValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    columnMetadataIndex_ = input.readInt32();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 18:
                  {
                    input.readMessage(getValueFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private int columnMetadataIndex_;

        /**
         *
         *
         * <pre>
         * Index within the repeated
         * [column_metadata][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.column_metadata]
         * field, to obtain the column metadata for the column that was modified.
         * </pre>
         *
         * <code>int32 column_metadata_index = 1;</code>
         *
         * @return The columnMetadataIndex.
         */
        @java.lang.Override
        public int getColumnMetadataIndex() {
          return columnMetadataIndex_;
        }

        /**
         *
         *
         * <pre>
         * Index within the repeated
         * [column_metadata][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.column_metadata]
         * field, to obtain the column metadata for the column that was modified.
         * </pre>
         *
         * <code>int32 column_metadata_index = 1;</code>
         *
         * @param value The columnMetadataIndex to set.
         * @return This builder for chaining.
         */
        public Builder setColumnMetadataIndex(int value) {

          columnMetadataIndex_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Index within the repeated
         * [column_metadata][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.column_metadata]
         * field, to obtain the column metadata for the column that was modified.
         * </pre>
         *
         * <code>int32 column_metadata_index = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearColumnMetadataIndex() {
          bitField0_ = (bitField0_ & ~0x00000001);
          columnMetadataIndex_ = 0;
          onChanged();
          return this;
        }

        private com.google.protobuf.Value value_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>
            valueBuilder_;

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         *
         * @return Whether the value field is set.
         */
        public boolean hasValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         *
         * @return The value.
         */
        public com.google.protobuf.Value getValue() {
          if (valueBuilder_ == null) {
            return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
          } else {
            return valueBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         */
        public Builder setValue(com.google.protobuf.Value value) {
          if (valueBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            value_ = value;
          } else {
            valueBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         */
        public Builder setValue(com.google.protobuf.Value.Builder builderForValue) {
          if (valueBuilder_ == null) {
            value_ = builderForValue.build();
          } else {
            valueBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         */
        public Builder mergeValue(com.google.protobuf.Value value) {
          if (valueBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)
                && value_ != null
                && value_ != com.google.protobuf.Value.getDefaultInstance()) {
              getValueBuilder().mergeFrom(value);
            } else {
              value_ = value;
            }
          } else {
            valueBuilder_.mergeFrom(value);
          }
          if (value_ != null) {
            bitField0_ |= 0x00000002;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         */
        public Builder clearValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          value_ = null;
          if (valueBuilder_ != null) {
            valueBuilder_.dispose();
            valueBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         */
        public com.google.protobuf.Value.Builder getValueBuilder() {
          bitField0_ |= 0x00000002;
          onChanged();
          return getValueFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         */
        public com.google.protobuf.ValueOrBuilder getValueOrBuilder() {
          if (valueBuilder_ != null) {
            return valueBuilder_.getMessageOrBuilder();
          } else {
            return value_ == null ? com.google.protobuf.Value.getDefaultInstance() : value_;
          }
        }

        /**
         *
         *
         * <pre>
         * The value of the column.
         * </pre>
         *
         * <code>.google.protobuf.Value value = 2;</code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>
            getValueFieldBuilder() {
          if (valueBuilder_ == null) {
            valueBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.protobuf.Value,
                    com.google.protobuf.Value.Builder,
                    com.google.protobuf.ValueOrBuilder>(
                    getValue(), getParentForChildren(), isClean());
            value_ = null;
          }
          return valueBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue)
      }

      // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue)
      private static final com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue();
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ModValue> PARSER =
          new com.google.protobuf.AbstractParser<ModValue>() {
            @java.lang.Override
            public ModValue parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ModValue> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ModValue> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ModOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          getKeysList();

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getKeys(int index);

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      int getKeysCount();

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      java.util.List<
              ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
          getKeysOrBuilderList();

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder getKeysOrBuilder(
          int index);

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          getOldValuesList();

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getOldValues(int index);

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      int getOldValuesCount();

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      java.util.List<
              ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
          getOldValuesOrBuilderList();

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder
          getOldValuesOrBuilder(int index);

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          getNewValuesList();

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getNewValues(int index);

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      int getNewValuesCount();

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      java.util.List<
              ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
          getNewValuesOrBuilderList();

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder
          getNewValuesOrBuilder(int index);
    }

    /**
     *
     *
     * <pre>
     * A mod describes all data changes in a watched table row.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod}
     */
    public static final class Mod extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod)
        ModOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use Mod.newBuilder() to construct.
      private Mod(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private Mod() {
        keys_ = java.util.Collections.emptyList();
        oldValues_ = java.util.Collections.emptyList();
        newValues_ = java.util.Collections.emptyList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new Mod();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_Mod_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_Mod_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.class,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder.class);
      }

      public static final int KEYS_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          keys_;

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          getKeysList() {
        return keys_;
      }

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
          getKeysOrBuilderList() {
        return keys_;
      }

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      @java.lang.Override
      public int getKeysCount() {
        return keys_.size();
      }

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getKeys(int index) {
        return keys_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Returns the value of the primary key of the modified row.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder
          getKeysOrBuilder(int index) {
        return keys_.get(index);
      }

      public static final int OLD_VALUES_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          oldValues_;

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          getOldValuesList() {
        return oldValues_;
      }

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
          getOldValuesOrBuilderList() {
        return oldValues_;
      }

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      @java.lang.Override
      public int getOldValuesCount() {
        return oldValues_.size();
      }

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getOldValues(
          int index) {
        return oldValues_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Returns the old values before the change for the modified columns.
       * Always empty for
       * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
       * or if old values are not being captured specified by
       * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder
          getOldValuesOrBuilder(int index) {
        return oldValues_.get(index);
      }

      public static final int NEW_VALUES_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          newValues_;

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
          getNewValuesList() {
        return newValues_;
      }

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      @java.lang.Override
      public java.util.List<
              ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
          getNewValuesOrBuilderList() {
        return newValues_;
      }

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      @java.lang.Override
      public int getNewValuesCount() {
        return newValues_.size();
      }

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getNewValues(
          int index) {
        return newValues_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Returns the new values after the change for the modified columns.
       * Always empty for
       * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder
          getNewValuesOrBuilder(int index) {
        return newValues_.get(index);
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < keys_.size(); i++) {
          output.writeMessage(1, keys_.get(i));
        }
        for (int i = 0; i < oldValues_.size(); i++) {
          output.writeMessage(2, oldValues_.get(i));
        }
        for (int i = 0; i < newValues_.size(); i++) {
          output.writeMessage(3, newValues_.get(i));
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        for (int i = 0; i < keys_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, keys_.get(i));
        }
        for (int i = 0; i < oldValues_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, oldValues_.get(i));
        }
        for (int i = 0; i < newValues_.size(); i++) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, newValues_.get(i));
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj instanceof com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod)) {
          return super.equals(obj);
        }
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod other =
            (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod) obj;

        if (!getKeysList().equals(other.getKeysList())) return false;
        if (!getOldValuesList().equals(other.getOldValuesList())) return false;
        if (!getNewValuesList().equals(other.getNewValuesList())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getKeysCount() > 0) {
          hash = (37 * hash) + KEYS_FIELD_NUMBER;
          hash = (53 * hash) + getKeysList().hashCode();
        }
        if (getOldValuesCount() > 0) {
          hash = (37 * hash) + OLD_VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getOldValuesList().hashCode();
        }
        if (getNewValuesCount() > 0) {
          hash = (37 * hash) + NEW_VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getNewValuesList().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * A mod describes all data changes in a watched table row.
       * </pre>
       *
       * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod)
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_Mod_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_Mod_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.class,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder.class);
        }

        // Construct using
        // com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (keysBuilder_ == null) {
            keys_ = java.util.Collections.emptyList();
          } else {
            keys_ = null;
            keysBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000001);
          if (oldValuesBuilder_ == null) {
            oldValues_ = java.util.Collections.emptyList();
          } else {
            oldValues_ = null;
            oldValuesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000002);
          if (newValuesBuilder_ == null) {
            newValues_ = java.util.Collections.emptyList();
          } else {
            newValues_ = null;
            newValuesBuilder_.clear();
          }
          bitField0_ = (bitField0_ & ~0x00000004);
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_Mod_descriptor;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod
            getDefaultInstanceForType() {
          return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod build() {
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod buildPartial() {
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod result =
              new com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod result) {
          if (keysBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)) {
              keys_ = java.util.Collections.unmodifiableList(keys_);
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.keys_ = keys_;
          } else {
            result.keys_ = keysBuilder_.build();
          }
          if (oldValuesBuilder_ == null) {
            if (((bitField0_ & 0x00000002) != 0)) {
              oldValues_ = java.util.Collections.unmodifiableList(oldValues_);
              bitField0_ = (bitField0_ & ~0x00000002);
            }
            result.oldValues_ = oldValues_;
          } else {
            result.oldValues_ = oldValuesBuilder_.build();
          }
          if (newValuesBuilder_ == null) {
            if (((bitField0_ & 0x00000004) != 0)) {
              newValues_ = java.util.Collections.unmodifiableList(newValues_);
              bitField0_ = (bitField0_ & ~0x00000004);
            }
            result.newValues_ = newValues_;
          } else {
            result.newValues_ = newValuesBuilder_.build();
          }
        }

        private void buildPartial0(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod result) {
          int from_bitField0_ = bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other instanceof com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod) {
            return mergeFrom((com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod other) {
          if (other
              == com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.getDefaultInstance())
            return this;
          if (keysBuilder_ == null) {
            if (!other.keys_.isEmpty()) {
              if (keys_.isEmpty()) {
                keys_ = other.keys_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureKeysIsMutable();
                keys_.addAll(other.keys_);
              }
              onChanged();
            }
          } else {
            if (!other.keys_.isEmpty()) {
              if (keysBuilder_.isEmpty()) {
                keysBuilder_.dispose();
                keysBuilder_ = null;
                keys_ = other.keys_;
                bitField0_ = (bitField0_ & ~0x00000001);
                keysBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getKeysFieldBuilder()
                        : null;
              } else {
                keysBuilder_.addAllMessages(other.keys_);
              }
            }
          }
          if (oldValuesBuilder_ == null) {
            if (!other.oldValues_.isEmpty()) {
              if (oldValues_.isEmpty()) {
                oldValues_ = other.oldValues_;
                bitField0_ = (bitField0_ & ~0x00000002);
              } else {
                ensureOldValuesIsMutable();
                oldValues_.addAll(other.oldValues_);
              }
              onChanged();
            }
          } else {
            if (!other.oldValues_.isEmpty()) {
              if (oldValuesBuilder_.isEmpty()) {
                oldValuesBuilder_.dispose();
                oldValuesBuilder_ = null;
                oldValues_ = other.oldValues_;
                bitField0_ = (bitField0_ & ~0x00000002);
                oldValuesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getOldValuesFieldBuilder()
                        : null;
              } else {
                oldValuesBuilder_.addAllMessages(other.oldValues_);
              }
            }
          }
          if (newValuesBuilder_ == null) {
            if (!other.newValues_.isEmpty()) {
              if (newValues_.isEmpty()) {
                newValues_ = other.newValues_;
                bitField0_ = (bitField0_ & ~0x00000004);
              } else {
                ensureNewValuesIsMutable();
                newValues_.addAll(other.newValues_);
              }
              onChanged();
            }
          } else {
            if (!other.newValues_.isEmpty()) {
              if (newValuesBuilder_.isEmpty()) {
                newValuesBuilder_.dispose();
                newValuesBuilder_ = null;
                newValues_ = other.newValues_;
                bitField0_ = (bitField0_ & ~0x00000004);
                newValuesBuilder_ =
                    com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                        ? getNewValuesFieldBuilder()
                        : null;
              } else {
                newValuesBuilder_.addAllMessages(other.newValues_);
              }
            }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue m =
                        input.readMessage(
                            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                                .parser(),
                            extensionRegistry);
                    if (keysBuilder_ == null) {
                      ensureKeysIsMutable();
                      keys_.add(m);
                    } else {
                      keysBuilder_.addMessage(m);
                    }
                    break;
                  } // case 10
                case 18:
                  {
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue m =
                        input.readMessage(
                            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                                .parser(),
                            extensionRegistry);
                    if (oldValuesBuilder_ == null) {
                      ensureOldValuesIsMutable();
                      oldValues_.add(m);
                    } else {
                      oldValuesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 18
                case 26:
                  {
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue m =
                        input.readMessage(
                            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                                .parser(),
                            extensionRegistry);
                    if (newValuesBuilder_ == null) {
                      ensureNewValuesIsMutable();
                      newValues_.add(m);
                    } else {
                      newValuesBuilder_.addMessage(m);
                    }
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
            keys_ = java.util.Collections.emptyList();

        private void ensureKeysIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            keys_ =
                new java.util.ArrayList<
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>(keys_);
            bitField0_ |= 0x00000001;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            keysBuilder_;

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
            getKeysList() {
          if (keysBuilder_ == null) {
            return java.util.Collections.unmodifiableList(keys_);
          } else {
            return keysBuilder_.getMessageList();
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public int getKeysCount() {
          if (keysBuilder_ == null) {
            return keys_.size();
          } else {
            return keysBuilder_.getCount();
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getKeys(
            int index) {
          if (keysBuilder_ == null) {
            return keys_.get(index);
          } else {
            return keysBuilder_.getMessage(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder setKeys(
            int index, com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (keysBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureKeysIsMutable();
            keys_.set(index, value);
            onChanged();
          } else {
            keysBuilder_.setMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder setKeys(
            int index,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (keysBuilder_ == null) {
            ensureKeysIsMutable();
            keys_.set(index, builderForValue.build());
            onChanged();
          } else {
            keysBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder addKeys(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (keysBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureKeysIsMutable();
            keys_.add(value);
            onChanged();
          } else {
            keysBuilder_.addMessage(value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder addKeys(
            int index, com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (keysBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureKeysIsMutable();
            keys_.add(index, value);
            onChanged();
          } else {
            keysBuilder_.addMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder addKeys(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (keysBuilder_ == null) {
            ensureKeysIsMutable();
            keys_.add(builderForValue.build());
            onChanged();
          } else {
            keysBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder addKeys(
            int index,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (keysBuilder_ == null) {
            ensureKeysIsMutable();
            keys_.add(index, builderForValue.build());
            onChanged();
          } else {
            keysBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder addAllKeys(
            java.lang.Iterable<
                    ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
                values) {
          if (keysBuilder_ == null) {
            ensureKeysIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, keys_);
            onChanged();
          } else {
            keysBuilder_.addAllMessages(values);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder clearKeys() {
          if (keysBuilder_ == null) {
            keys_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
          } else {
            keysBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public Builder removeKeys(int index) {
          if (keysBuilder_ == null) {
            ensureKeysIsMutable();
            keys_.remove(index);
            onChanged();
          } else {
            keysBuilder_.remove(index);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            getKeysBuilder(int index) {
          return getKeysFieldBuilder().getBuilder(index);
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder
            getKeysOrBuilder(int index) {
          if (keysBuilder_ == null) {
            return keys_.get(index);
          } else {
            return keysBuilder_.getMessageOrBuilder(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            getKeysOrBuilderList() {
          if (keysBuilder_ != null) {
            return keysBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(keys_);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            addKeysBuilder() {
          return getKeysFieldBuilder()
              .addBuilder(
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                      .getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            addKeysBuilder(int index) {
          return getKeysFieldBuilder()
              .addBuilder(
                  index,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                      .getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Returns the value of the primary key of the modified row.
         * </pre>
         *
         * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue keys = 1;
         * </code>
         */
        public java.util.List<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder>
            getKeysBuilderList() {
          return getKeysFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            getKeysFieldBuilder() {
          if (keysBuilder_ == null) {
            keysBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>(
                    keys_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
            keys_ = null;
          }
          return keysBuilder_;
        }

        private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
            oldValues_ = java.util.Collections.emptyList();

        private void ensureOldValuesIsMutable() {
          if (!((bitField0_ & 0x00000002) != 0)) {
            oldValues_ =
                new java.util.ArrayList<
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>(oldValues_);
            bitField0_ |= 0x00000002;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            oldValuesBuilder_;

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
            getOldValuesList() {
          if (oldValuesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(oldValues_);
          } else {
            return oldValuesBuilder_.getMessageList();
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public int getOldValuesCount() {
          if (oldValuesBuilder_ == null) {
            return oldValues_.size();
          } else {
            return oldValuesBuilder_.getCount();
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getOldValues(
            int index) {
          if (oldValuesBuilder_ == null) {
            return oldValues_.get(index);
          } else {
            return oldValuesBuilder_.getMessage(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder setOldValues(
            int index, com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (oldValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureOldValuesIsMutable();
            oldValues_.set(index, value);
            onChanged();
          } else {
            oldValuesBuilder_.setMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder setOldValues(
            int index,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (oldValuesBuilder_ == null) {
            ensureOldValuesIsMutable();
            oldValues_.set(index, builderForValue.build());
            onChanged();
          } else {
            oldValuesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder addOldValues(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (oldValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureOldValuesIsMutable();
            oldValues_.add(value);
            onChanged();
          } else {
            oldValuesBuilder_.addMessage(value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder addOldValues(
            int index, com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (oldValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureOldValuesIsMutable();
            oldValues_.add(index, value);
            onChanged();
          } else {
            oldValuesBuilder_.addMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder addOldValues(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (oldValuesBuilder_ == null) {
            ensureOldValuesIsMutable();
            oldValues_.add(builderForValue.build());
            onChanged();
          } else {
            oldValuesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder addOldValues(
            int index,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (oldValuesBuilder_ == null) {
            ensureOldValuesIsMutable();
            oldValues_.add(index, builderForValue.build());
            onChanged();
          } else {
            oldValuesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder addAllOldValues(
            java.lang.Iterable<
                    ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
                values) {
          if (oldValuesBuilder_ == null) {
            ensureOldValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, oldValues_);
            onChanged();
          } else {
            oldValuesBuilder_.addAllMessages(values);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder clearOldValues() {
          if (oldValuesBuilder_ == null) {
            oldValues_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000002);
            onChanged();
          } else {
            oldValuesBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public Builder removeOldValues(int index) {
          if (oldValuesBuilder_ == null) {
            ensureOldValuesIsMutable();
            oldValues_.remove(index);
            onChanged();
          } else {
            oldValuesBuilder_.remove(index);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            getOldValuesBuilder(int index) {
          return getOldValuesFieldBuilder().getBuilder(index);
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder
            getOldValuesOrBuilder(int index) {
          if (oldValuesBuilder_ == null) {
            return oldValues_.get(index);
          } else {
            return oldValuesBuilder_.getMessageOrBuilder(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            getOldValuesOrBuilderList() {
          if (oldValuesBuilder_ != null) {
            return oldValuesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(oldValues_);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            addOldValuesBuilder() {
          return getOldValuesFieldBuilder()
              .addBuilder(
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                      .getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            addOldValuesBuilder(int index) {
          return getOldValuesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                      .getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Returns the old values before the change for the modified columns.
         * Always empty for
         * [INSERT][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.INSERT],
         * or if old values are not being captured specified by
         * [value_capture_type][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue old_values = 2;
         * </code>
         */
        public java.util.List<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder>
            getOldValuesBuilderList() {
          return getOldValuesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            getOldValuesFieldBuilder() {
          if (oldValuesBuilder_ == null) {
            oldValuesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>(
                    oldValues_,
                    ((bitField0_ & 0x00000002) != 0),
                    getParentForChildren(),
                    isClean());
            oldValues_ = null;
          }
          return oldValuesBuilder_;
        }

        private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
            newValues_ = java.util.Collections.emptyList();

        private void ensureNewValuesIsMutable() {
          if (!((bitField0_ & 0x00000004) != 0)) {
            newValues_ =
                new java.util.ArrayList<
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>(newValues_);
            bitField0_ |= 0x00000004;
          }
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            newValuesBuilder_;

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
            getNewValuesList() {
          if (newValuesBuilder_ == null) {
            return java.util.Collections.unmodifiableList(newValues_);
          } else {
            return newValuesBuilder_.getMessageList();
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public int getNewValuesCount() {
          if (newValuesBuilder_ == null) {
            return newValues_.size();
          } else {
            return newValuesBuilder_.getCount();
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue getNewValues(
            int index) {
          if (newValuesBuilder_ == null) {
            return newValues_.get(index);
          } else {
            return newValuesBuilder_.getMessage(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder setNewValues(
            int index, com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (newValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNewValuesIsMutable();
            newValues_.set(index, value);
            onChanged();
          } else {
            newValuesBuilder_.setMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder setNewValues(
            int index,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (newValuesBuilder_ == null) {
            ensureNewValuesIsMutable();
            newValues_.set(index, builderForValue.build());
            onChanged();
          } else {
            newValuesBuilder_.setMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder addNewValues(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (newValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNewValuesIsMutable();
            newValues_.add(value);
            onChanged();
          } else {
            newValuesBuilder_.addMessage(value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder addNewValues(
            int index, com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue value) {
          if (newValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureNewValuesIsMutable();
            newValues_.add(index, value);
            onChanged();
          } else {
            newValuesBuilder_.addMessage(index, value);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder addNewValues(
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (newValuesBuilder_ == null) {
            ensureNewValuesIsMutable();
            newValues_.add(builderForValue.build());
            onChanged();
          } else {
            newValuesBuilder_.addMessage(builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder addNewValues(
            int index,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
                builderForValue) {
          if (newValuesBuilder_ == null) {
            ensureNewValuesIsMutable();
            newValues_.add(index, builderForValue.build());
            onChanged();
          } else {
            newValuesBuilder_.addMessage(index, builderForValue.build());
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder addAllNewValues(
            java.lang.Iterable<
                    ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue>
                values) {
          if (newValuesBuilder_ == null) {
            ensureNewValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, newValues_);
            onChanged();
          } else {
            newValuesBuilder_.addAllMessages(values);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder clearNewValues() {
          if (newValuesBuilder_ == null) {
            newValues_ = java.util.Collections.emptyList();
            bitField0_ = (bitField0_ & ~0x00000004);
            onChanged();
          } else {
            newValuesBuilder_.clear();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public Builder removeNewValues(int index) {
          if (newValuesBuilder_ == null) {
            ensureNewValuesIsMutable();
            newValues_.remove(index);
            onChanged();
          } else {
            newValuesBuilder_.remove(index);
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            getNewValuesBuilder(int index) {
          return getNewValuesFieldBuilder().getBuilder(index);
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder
            getNewValuesOrBuilder(int index) {
          if (newValuesBuilder_ == null) {
            return newValues_.get(index);
          } else {
            return newValuesBuilder_.getMessageOrBuilder(index);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public java.util.List<
                ? extends
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            getNewValuesOrBuilderList() {
          if (newValuesBuilder_ != null) {
            return newValuesBuilder_.getMessageOrBuilderList();
          } else {
            return java.util.Collections.unmodifiableList(newValues_);
          }
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            addNewValuesBuilder() {
          return getNewValuesFieldBuilder()
              .addBuilder(
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                      .getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder
            addNewValuesBuilder(int index) {
          return getNewValuesFieldBuilder()
              .addBuilder(
                  index,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue
                      .getDefaultInstance());
        }

        /**
         *
         *
         * <pre>
         * Returns the new values after the change for the modified columns.
         * Always empty for
         * [DELETE][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.DELETE].
         * </pre>
         *
         * <code>
         * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue new_values = 3;
         * </code>
         */
        public java.util.List<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder>
            getNewValuesBuilderList() {
          return getNewValuesFieldBuilder().getBuilderList();
        }

        private com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>
            getNewValuesFieldBuilder() {
          if (newValuesBuilder_ == null) {
            newValuesBuilder_ =
                new com.google.protobuf.RepeatedFieldBuilderV3<
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue,
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValue.Builder,
                    com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModValueOrBuilder>(
                    newValues_,
                    ((bitField0_ & 0x00000004) != 0),
                    getParentForChildren(),
                    isClean());
            newValues_ = null;
          }
          return newValuesBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod)
      }

      // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod)
      private static final com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE = new com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod();
      }

      public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<Mod> PARSER =
          new com.google.protobuf.AbstractParser<Mod>() {
            @java.lang.Override
            public Mod parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<Mod> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<Mod> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int COMMIT_TIMESTAMP_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp commitTimestamp_;

    /**
     *
     *
     * <pre>
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return Whether the commitTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasCommitTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return The commitTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCommitTimestamp() {
      return commitTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : commitTimestamp_;
    }

    /**
     *
     *
     * <pre>
     * Indicates the timestamp in which the change was committed.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder() {
      return commitTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : commitTimestamp_;
    }

    public static final int RECORD_SEQUENCE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object recordSequence_ = "";

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * The record sequence number ordering across partitions is only meaningful
     * in the context of a specific transaction. Record sequence numbers are
     * unique across partitions for a specific transaction. Sort the
     * DataChangeRecords for the same
     * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
     * by
     * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
     * to reconstruct the ordering of the changes within the transaction.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    @java.lang.Override
    public java.lang.String getRecordSequence() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recordSequence_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     *
     * The record sequence number ordering across partitions is only meaningful
     * in the context of a specific transaction. Record sequence numbers are
     * unique across partitions for a specific transaction. Sort the
     * DataChangeRecords for the same
     * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
     * by
     * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
     * to reconstruct the ordering of the changes within the transaction.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRecordSequenceBytes() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recordSequence_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SERVER_TRANSACTION_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object serverTransactionId_ = "";

    /**
     *
     *
     * <pre>
     * Provides a globally unique string that represents the transaction in
     * which the change was committed. Multiple transactions can have the same
     * commit timestamp, but each transaction has a unique
     * server_transaction_id.
     * </pre>
     *
     * <code>string server_transaction_id = 3;</code>
     *
     * @return The serverTransactionId.
     */
    @java.lang.Override
    public java.lang.String getServerTransactionId() {
      java.lang.Object ref = serverTransactionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serverTransactionId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Provides a globally unique string that represents the transaction in
     * which the change was committed. Multiple transactions can have the same
     * commit timestamp, but each transaction has a unique
     * server_transaction_id.
     * </pre>
     *
     * <code>string server_transaction_id = 3;</code>
     *
     * @return The bytes for serverTransactionId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getServerTransactionIdBytes() {
      java.lang.Object ref = serverTransactionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serverTransactionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_LAST_RECORD_IN_TRANSACTION_IN_PARTITION_FIELD_NUMBER = 4;
    private boolean isLastRecordInTransactionInPartition_ = false;

    /**
     *
     *
     * <pre>
     * Indicates whether this is the last record for a transaction in the
     *  current partition. Clients can use this field to determine when all
     *  records for a transaction in the current partition have been received.
     * </pre>
     *
     * <code>bool is_last_record_in_transaction_in_partition = 4;</code>
     *
     * @return The isLastRecordInTransactionInPartition.
     */
    @java.lang.Override
    public boolean getIsLastRecordInTransactionInPartition() {
      return isLastRecordInTransactionInPartition_;
    }

    public static final int TABLE_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private volatile java.lang.Object table_ = "";

    /**
     *
     *
     * <pre>
     * Name of the table affected by the change.
     * </pre>
     *
     * <code>string table = 5;</code>
     *
     * @return The table.
     */
    @java.lang.Override
    public java.lang.String getTable() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        table_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the table affected by the change.
     * </pre>
     *
     * <code>string table = 5;</code>
     *
     * @return The bytes for table.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTableBytes() {
      java.lang.Object ref = table_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        table_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int COLUMN_METADATA_FIELD_NUMBER = 6;

    @SuppressWarnings("serial")
    private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata>
        columnMetadata_;

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata>
        getColumnMetadataList() {
      return columnMetadata_;
    }

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder>
        getColumnMetadataOrBuilderList() {
      return columnMetadata_;
    }

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    @java.lang.Override
    public int getColumnMetadataCount() {
      return columnMetadata_.size();
    }

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
        getColumnMetadata(int index) {
      return columnMetadata_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Provides metadata describing the columns associated with the
     * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
     * below.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder
        getColumnMetadataOrBuilder(int index) {
      return columnMetadata_.get(index);
    }

    public static final int MODS_FIELD_NUMBER = 7;

    @SuppressWarnings("serial")
    private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod> mods_;

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    @java.lang.Override
    public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod>
        getModsList() {
      return mods_;
    }

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder>
        getModsOrBuilderList() {
      return mods_;
    }

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    @java.lang.Override
    public int getModsCount() {
      return mods_.size();
    }

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod getMods(int index) {
      return mods_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Describes the changes that were made.
     * </pre>
     *
     * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder getModsOrBuilder(
        int index) {
      return mods_.get(index);
    }

    public static final int MOD_TYPE_FIELD_NUMBER = 8;
    private int modType_ = 0;

    /**
     *
     *
     * <pre>
     * Describes the type of change.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
     *
     * @return The enum numeric value on the wire for modType.
     */
    @java.lang.Override
    public int getModTypeValue() {
      return modType_;
    }

    /**
     *
     *
     * <pre>
     * Describes the type of change.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
     *
     * @return The modType.
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType getModType() {
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType result =
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.forNumber(modType_);
      return result == null
          ? com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.UNRECOGNIZED
          : result;
    }

    public static final int VALUE_CAPTURE_TYPE_FIELD_NUMBER = 9;
    private int valueCaptureType_ = 0;

    /**
     *
     *
     * <pre>
     * Describes the value capture type that was specified in the change stream
     * configuration when this change was captured.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
     * </code>
     *
     * @return The enum numeric value on the wire for valueCaptureType.
     */
    @java.lang.Override
    public int getValueCaptureTypeValue() {
      return valueCaptureType_;
    }

    /**
     *
     *
     * <pre>
     * Describes the value capture type that was specified in the change stream
     * configuration when this change was captured.
     * </pre>
     *
     * <code>
     * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
     * </code>
     *
     * @return The valueCaptureType.
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType
        getValueCaptureType() {
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType result =
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType.forNumber(
              valueCaptureType_);
      return result == null
          ? com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType.UNRECOGNIZED
          : result;
    }

    public static final int NUMBER_OF_RECORDS_IN_TRANSACTION_FIELD_NUMBER = 10;
    private int numberOfRecordsInTransaction_ = 0;

    /**
     *
     *
     * <pre>
     * Indicates the number of data change records that are part of this
     * transaction across all change stream partitions. This value can be used
     * to assemble all the records associated with a particular transaction.
     * </pre>
     *
     * <code>int32 number_of_records_in_transaction = 10;</code>
     *
     * @return The numberOfRecordsInTransaction.
     */
    @java.lang.Override
    public int getNumberOfRecordsInTransaction() {
      return numberOfRecordsInTransaction_;
    }

    public static final int NUMBER_OF_PARTITIONS_IN_TRANSACTION_FIELD_NUMBER = 11;
    private int numberOfPartitionsInTransaction_ = 0;

    /**
     *
     *
     * <pre>
     * Indicates the number of partitions that return data change records for
     * this transaction. This value can be helpful in assembling all records
     * associated with a particular transaction.
     * </pre>
     *
     * <code>int32 number_of_partitions_in_transaction = 11;</code>
     *
     * @return The numberOfPartitionsInTransaction.
     */
    @java.lang.Override
    public int getNumberOfPartitionsInTransaction() {
      return numberOfPartitionsInTransaction_;
    }

    public static final int TRANSACTION_TAG_FIELD_NUMBER = 12;

    @SuppressWarnings("serial")
    private volatile java.lang.Object transactionTag_ = "";

    /**
     *
     *
     * <pre>
     * Indicates the transaction tag associated with this transaction.
     * </pre>
     *
     * <code>string transaction_tag = 12;</code>
     *
     * @return The transactionTag.
     */
    @java.lang.Override
    public java.lang.String getTransactionTag() {
      java.lang.Object ref = transactionTag_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        transactionTag_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Indicates the transaction tag associated with this transaction.
     * </pre>
     *
     * <code>string transaction_tag = 12;</code>
     *
     * @return The bytes for transactionTag.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getTransactionTagBytes() {
      java.lang.Object ref = transactionTag_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        transactionTag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int IS_SYSTEM_TRANSACTION_FIELD_NUMBER = 13;
    private boolean isSystemTransaction_ = false;

    /**
     *
     *
     * <pre>
     * Indicates whether the transaction is a system transaction. System
     * transactions include those issued by time-to-live (TTL), column backfill,
     * etc.
     * </pre>
     *
     * <code>bool is_system_transaction = 13;</code>
     *
     * @return The isSystemTransaction.
     */
    @java.lang.Override
    public boolean getIsSystemTransaction() {
      return isSystemTransaction_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getCommitTimestamp());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, recordSequence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverTransactionId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, serverTransactionId_);
      }
      if (isLastRecordInTransactionInPartition_ != false) {
        output.writeBool(4, isLastRecordInTransactionInPartition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, table_);
      }
      for (int i = 0; i < columnMetadata_.size(); i++) {
        output.writeMessage(6, columnMetadata_.get(i));
      }
      for (int i = 0; i < mods_.size(); i++) {
        output.writeMessage(7, mods_.get(i));
      }
      if (modType_
          != com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.MOD_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(8, modType_);
      }
      if (valueCaptureType_
          != com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType
              .VALUE_CAPTURE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(9, valueCaptureType_);
      }
      if (numberOfRecordsInTransaction_ != 0) {
        output.writeInt32(10, numberOfRecordsInTransaction_);
      }
      if (numberOfPartitionsInTransaction_ != 0) {
        output.writeInt32(11, numberOfPartitionsInTransaction_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transactionTag_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 12, transactionTag_);
      }
      if (isSystemTransaction_ != false) {
        output.writeBool(13, isSystemTransaction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommitTimestamp());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, recordSequence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(serverTransactionId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, serverTransactionId_);
      }
      if (isLastRecordInTransactionInPartition_ != false) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                4, isLastRecordInTransactionInPartition_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(table_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, table_);
      }
      for (int i = 0; i < columnMetadata_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, columnMetadata_.get(i));
      }
      for (int i = 0; i < mods_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, mods_.get(i));
      }
      if (modType_
          != com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.MOD_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(8, modType_);
      }
      if (valueCaptureType_
          != com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType
              .VALUE_CAPTURE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(9, valueCaptureType_);
      }
      if (numberOfRecordsInTransaction_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                10, numberOfRecordsInTransaction_);
      }
      if (numberOfPartitionsInTransaction_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                11, numberOfPartitionsInTransaction_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(transactionTag_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, transactionTag_);
      }
      if (isSystemTransaction_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(13, isSystemTransaction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord other =
          (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) obj;

      if (hasCommitTimestamp() != other.hasCommitTimestamp()) return false;
      if (hasCommitTimestamp()) {
        if (!getCommitTimestamp().equals(other.getCommitTimestamp())) return false;
      }
      if (!getRecordSequence().equals(other.getRecordSequence())) return false;
      if (!getServerTransactionId().equals(other.getServerTransactionId())) return false;
      if (getIsLastRecordInTransactionInPartition()
          != other.getIsLastRecordInTransactionInPartition()) return false;
      if (!getTable().equals(other.getTable())) return false;
      if (!getColumnMetadataList().equals(other.getColumnMetadataList())) return false;
      if (!getModsList().equals(other.getModsList())) return false;
      if (modType_ != other.modType_) return false;
      if (valueCaptureType_ != other.valueCaptureType_) return false;
      if (getNumberOfRecordsInTransaction() != other.getNumberOfRecordsInTransaction())
        return false;
      if (getNumberOfPartitionsInTransaction() != other.getNumberOfPartitionsInTransaction())
        return false;
      if (!getTransactionTag().equals(other.getTransactionTag())) return false;
      if (getIsSystemTransaction() != other.getIsSystemTransaction()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCommitTimestamp()) {
        hash = (37 * hash) + COMMIT_TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getCommitTimestamp().hashCode();
      }
      hash = (37 * hash) + RECORD_SEQUENCE_FIELD_NUMBER;
      hash = (53 * hash) + getRecordSequence().hashCode();
      hash = (37 * hash) + SERVER_TRANSACTION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getServerTransactionId().hashCode();
      hash = (37 * hash) + IS_LAST_RECORD_IN_TRANSACTION_IN_PARTITION_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashBoolean(getIsLastRecordInTransactionInPartition());
      hash = (37 * hash) + TABLE_FIELD_NUMBER;
      hash = (53 * hash) + getTable().hashCode();
      if (getColumnMetadataCount() > 0) {
        hash = (37 * hash) + COLUMN_METADATA_FIELD_NUMBER;
        hash = (53 * hash) + getColumnMetadataList().hashCode();
      }
      if (getModsCount() > 0) {
        hash = (37 * hash) + MODS_FIELD_NUMBER;
        hash = (53 * hash) + getModsList().hashCode();
      }
      hash = (37 * hash) + MOD_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + modType_;
      hash = (37 * hash) + VALUE_CAPTURE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + valueCaptureType_;
      hash = (37 * hash) + NUMBER_OF_RECORDS_IN_TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + getNumberOfRecordsInTransaction();
      hash = (37 * hash) + NUMBER_OF_PARTITIONS_IN_TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + getNumberOfPartitionsInTransaction();
      hash = (37 * hash) + TRANSACTION_TAG_FIELD_NUMBER;
      hash = (53 * hash) + getTransactionTag().hashCode();
      hash = (37 * hash) + IS_SYSTEM_TRANSACTION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getIsSystemTransaction());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A data change record contains a set of changes to a table with the same
     * modification type (insert, update, or delete) committed at the same commit
     * timestamp in one change stream partition for the same transaction. Multiple
     * data change records can be returned for the same transaction across
     * multiple change stream partitions.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.DataChangeRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.DataChangeRecord)
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.class,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Builder.class);
      }

      // Construct using com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getCommitTimestampFieldBuilder();
          getColumnMetadataFieldBuilder();
          getModsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        commitTimestamp_ = null;
        if (commitTimestampBuilder_ != null) {
          commitTimestampBuilder_.dispose();
          commitTimestampBuilder_ = null;
        }
        recordSequence_ = "";
        serverTransactionId_ = "";
        isLastRecordInTransactionInPartition_ = false;
        table_ = "";
        if (columnMetadataBuilder_ == null) {
          columnMetadata_ = java.util.Collections.emptyList();
        } else {
          columnMetadata_ = null;
          columnMetadataBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000020);
        if (modsBuilder_ == null) {
          mods_ = java.util.Collections.emptyList();
        } else {
          mods_ = null;
          modsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        modType_ = 0;
        valueCaptureType_ = 0;
        numberOfRecordsInTransaction_ = 0;
        numberOfPartitionsInTransaction_ = 0;
        transactionTag_ = "";
        isSystemTransaction_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_DataChangeRecord_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord getDefaultInstanceForType() {
        return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord build() {
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord buildPartial() {
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord result =
            new com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord result) {
        if (columnMetadataBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)) {
            columnMetadata_ = java.util.Collections.unmodifiableList(columnMetadata_);
            bitField0_ = (bitField0_ & ~0x00000020);
          }
          result.columnMetadata_ = columnMetadata_;
        } else {
          result.columnMetadata_ = columnMetadataBuilder_.build();
        }
        if (modsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)) {
            mods_ = java.util.Collections.unmodifiableList(mods_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.mods_ = mods_;
        } else {
          result.mods_ = modsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.commitTimestamp_ =
              commitTimestampBuilder_ == null ? commitTimestamp_ : commitTimestampBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.recordSequence_ = recordSequence_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.serverTransactionId_ = serverTransactionId_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.isLastRecordInTransactionInPartition_ = isLastRecordInTransactionInPartition_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.table_ = table_;
        }
        if (((from_bitField0_ & 0x00000080) != 0)) {
          result.modType_ = modType_;
        }
        if (((from_bitField0_ & 0x00000100) != 0)) {
          result.valueCaptureType_ = valueCaptureType_;
        }
        if (((from_bitField0_ & 0x00000200) != 0)) {
          result.numberOfRecordsInTransaction_ = numberOfRecordsInTransaction_;
        }
        if (((from_bitField0_ & 0x00000400) != 0)) {
          result.numberOfPartitionsInTransaction_ = numberOfPartitionsInTransaction_;
        }
        if (((from_bitField0_ & 0x00000800) != 0)) {
          result.transactionTag_ = transactionTag_;
        }
        if (((from_bitField0_ & 0x00001000) != 0)) {
          result.isSystemTransaction_ = isSystemTransaction_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) {
          return mergeFrom((com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord other) {
        if (other == com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance())
          return this;
        if (other.hasCommitTimestamp()) {
          mergeCommitTimestamp(other.getCommitTimestamp());
        }
        if (!other.getRecordSequence().isEmpty()) {
          recordSequence_ = other.recordSequence_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getServerTransactionId().isEmpty()) {
          serverTransactionId_ = other.serverTransactionId_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (other.getIsLastRecordInTransactionInPartition() != false) {
          setIsLastRecordInTransactionInPartition(other.getIsLastRecordInTransactionInPartition());
        }
        if (!other.getTable().isEmpty()) {
          table_ = other.table_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (columnMetadataBuilder_ == null) {
          if (!other.columnMetadata_.isEmpty()) {
            if (columnMetadata_.isEmpty()) {
              columnMetadata_ = other.columnMetadata_;
              bitField0_ = (bitField0_ & ~0x00000020);
            } else {
              ensureColumnMetadataIsMutable();
              columnMetadata_.addAll(other.columnMetadata_);
            }
            onChanged();
          }
        } else {
          if (!other.columnMetadata_.isEmpty()) {
            if (columnMetadataBuilder_.isEmpty()) {
              columnMetadataBuilder_.dispose();
              columnMetadataBuilder_ = null;
              columnMetadata_ = other.columnMetadata_;
              bitField0_ = (bitField0_ & ~0x00000020);
              columnMetadataBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getColumnMetadataFieldBuilder()
                      : null;
            } else {
              columnMetadataBuilder_.addAllMessages(other.columnMetadata_);
            }
          }
        }
        if (modsBuilder_ == null) {
          if (!other.mods_.isEmpty()) {
            if (mods_.isEmpty()) {
              mods_ = other.mods_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureModsIsMutable();
              mods_.addAll(other.mods_);
            }
            onChanged();
          }
        } else {
          if (!other.mods_.isEmpty()) {
            if (modsBuilder_.isEmpty()) {
              modsBuilder_.dispose();
              modsBuilder_ = null;
              mods_ = other.mods_;
              bitField0_ = (bitField0_ & ~0x00000040);
              modsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getModsFieldBuilder()
                      : null;
            } else {
              modsBuilder_.addAllMessages(other.mods_);
            }
          }
        }
        if (other.modType_ != 0) {
          setModTypeValue(other.getModTypeValue());
        }
        if (other.valueCaptureType_ != 0) {
          setValueCaptureTypeValue(other.getValueCaptureTypeValue());
        }
        if (other.getNumberOfRecordsInTransaction() != 0) {
          setNumberOfRecordsInTransaction(other.getNumberOfRecordsInTransaction());
        }
        if (other.getNumberOfPartitionsInTransaction() != 0) {
          setNumberOfPartitionsInTransaction(other.getNumberOfPartitionsInTransaction());
        }
        if (!other.getTransactionTag().isEmpty()) {
          transactionTag_ = other.transactionTag_;
          bitField0_ |= 0x00000800;
          onChanged();
        }
        if (other.getIsSystemTransaction() != false) {
          setIsSystemTransaction(other.getIsSystemTransaction());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getCommitTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  recordSequence_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  serverTransactionId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 32:
                {
                  isLastRecordInTransactionInPartition_ = input.readBool();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 32
              case 42:
                {
                  table_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata m =
                      input.readMessage(
                          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
                              .parser(),
                          extensionRegistry);
                  if (columnMetadataBuilder_ == null) {
                    ensureColumnMetadataIsMutable();
                    columnMetadata_.add(m);
                  } else {
                    columnMetadataBuilder_.addMessage(m);
                  }
                  break;
                } // case 50
              case 58:
                {
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod m =
                      input.readMessage(
                          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.parser(),
                          extensionRegistry);
                  if (modsBuilder_ == null) {
                    ensureModsIsMutable();
                    mods_.add(m);
                  } else {
                    modsBuilder_.addMessage(m);
                  }
                  break;
                } // case 58
              case 64:
                {
                  modType_ = input.readEnum();
                  bitField0_ |= 0x00000080;
                  break;
                } // case 64
              case 72:
                {
                  valueCaptureType_ = input.readEnum();
                  bitField0_ |= 0x00000100;
                  break;
                } // case 72
              case 80:
                {
                  numberOfRecordsInTransaction_ = input.readInt32();
                  bitField0_ |= 0x00000200;
                  break;
                } // case 80
              case 88:
                {
                  numberOfPartitionsInTransaction_ = input.readInt32();
                  bitField0_ |= 0x00000400;
                  break;
                } // case 88
              case 98:
                {
                  transactionTag_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000800;
                  break;
                } // case 98
              case 104:
                {
                  isSystemTransaction_ = input.readBool();
                  bitField0_ |= 0x00001000;
                  break;
                } // case 104
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp commitTimestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          commitTimestampBuilder_;

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       *
       * @return Whether the commitTimestamp field is set.
       */
      public boolean hasCommitTimestamp() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       *
       * @return The commitTimestamp.
       */
      public com.google.protobuf.Timestamp getCommitTimestamp() {
        if (commitTimestampBuilder_ == null) {
          return commitTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTimestamp_;
        } else {
          return commitTimestampBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public Builder setCommitTimestamp(com.google.protobuf.Timestamp value) {
        if (commitTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          commitTimestamp_ = value;
        } else {
          commitTimestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public Builder setCommitTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (commitTimestampBuilder_ == null) {
          commitTimestamp_ = builderForValue.build();
        } else {
          commitTimestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public Builder mergeCommitTimestamp(com.google.protobuf.Timestamp value) {
        if (commitTimestampBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && commitTimestamp_ != null
              && commitTimestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getCommitTimestampBuilder().mergeFrom(value);
          } else {
            commitTimestamp_ = value;
          }
        } else {
          commitTimestampBuilder_.mergeFrom(value);
        }
        if (commitTimestamp_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public Builder clearCommitTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        commitTimestamp_ = null;
        if (commitTimestampBuilder_ != null) {
          commitTimestampBuilder_.dispose();
          commitTimestampBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCommitTimestampBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCommitTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder() {
        if (commitTimestampBuilder_ != null) {
          return commitTimestampBuilder_.getMessageOrBuilder();
        } else {
          return commitTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTimestamp_;
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp in which the change was committed.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCommitTimestampFieldBuilder() {
        if (commitTimestampBuilder_ == null) {
          commitTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCommitTimestamp(), getParentForChildren(), isClean());
          commitTimestamp_ = null;
        }
        return commitTimestampBuilder_;
      }

      private java.lang.Object recordSequence_ = "";

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       *
       * The record sequence number ordering across partitions is only meaningful
       * in the context of a specific transaction. Record sequence numbers are
       * unique across partitions for a specific transaction. Sort the
       * DataChangeRecords for the same
       * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
       * by
       * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
       * to reconstruct the ordering of the changes within the transaction.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return The recordSequence.
       */
      public java.lang.String getRecordSequence() {
        java.lang.Object ref = recordSequence_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          recordSequence_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       *
       * The record sequence number ordering across partitions is only meaningful
       * in the context of a specific transaction. Record sequence numbers are
       * unique across partitions for a specific transaction. Sort the
       * DataChangeRecords for the same
       * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
       * by
       * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
       * to reconstruct the ordering of the changes within the transaction.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return The bytes for recordSequence.
       */
      public com.google.protobuf.ByteString getRecordSequenceBytes() {
        java.lang.Object ref = recordSequence_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          recordSequence_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       *
       * The record sequence number ordering across partitions is only meaningful
       * in the context of a specific transaction. Record sequence numbers are
       * unique across partitions for a specific transaction. Sort the
       * DataChangeRecords for the same
       * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
       * by
       * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
       * to reconstruct the ordering of the changes within the transaction.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @param value The recordSequence to set.
       * @return This builder for chaining.
       */
      public Builder setRecordSequence(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        recordSequence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       *
       * The record sequence number ordering across partitions is only meaningful
       * in the context of a specific transaction. Record sequence numbers are
       * unique across partitions for a specific transaction. Sort the
       * DataChangeRecords for the same
       * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
       * by
       * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
       * to reconstruct the ordering of the changes within the transaction.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecordSequence() {
        recordSequence_ = getDefaultInstance().getRecordSequence();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       *
       * The record sequence number ordering across partitions is only meaningful
       * in the context of a specific transaction. Record sequence numbers are
       * unique across partitions for a specific transaction. Sort the
       * DataChangeRecords for the same
       * [server_transaction_id][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.server_transaction_id]
       * by
       * [record_sequence][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.record_sequence]
       * to reconstruct the ordering of the changes within the transaction.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @param value The bytes for recordSequence to set.
       * @return This builder for chaining.
       */
      public Builder setRecordSequenceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        recordSequence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object serverTransactionId_ = "";

      /**
       *
       *
       * <pre>
       * Provides a globally unique string that represents the transaction in
       * which the change was committed. Multiple transactions can have the same
       * commit timestamp, but each transaction has a unique
       * server_transaction_id.
       * </pre>
       *
       * <code>string server_transaction_id = 3;</code>
       *
       * @return The serverTransactionId.
       */
      public java.lang.String getServerTransactionId() {
        java.lang.Object ref = serverTransactionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          serverTransactionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Provides a globally unique string that represents the transaction in
       * which the change was committed. Multiple transactions can have the same
       * commit timestamp, but each transaction has a unique
       * server_transaction_id.
       * </pre>
       *
       * <code>string server_transaction_id = 3;</code>
       *
       * @return The bytes for serverTransactionId.
       */
      public com.google.protobuf.ByteString getServerTransactionIdBytes() {
        java.lang.Object ref = serverTransactionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          serverTransactionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Provides a globally unique string that represents the transaction in
       * which the change was committed. Multiple transactions can have the same
       * commit timestamp, but each transaction has a unique
       * server_transaction_id.
       * </pre>
       *
       * <code>string server_transaction_id = 3;</code>
       *
       * @param value The serverTransactionId to set.
       * @return This builder for chaining.
       */
      public Builder setServerTransactionId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        serverTransactionId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides a globally unique string that represents the transaction in
       * which the change was committed. Multiple transactions can have the same
       * commit timestamp, but each transaction has a unique
       * server_transaction_id.
       * </pre>
       *
       * <code>string server_transaction_id = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearServerTransactionId() {
        serverTransactionId_ = getDefaultInstance().getServerTransactionId();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides a globally unique string that represents the transaction in
       * which the change was committed. Multiple transactions can have the same
       * commit timestamp, but each transaction has a unique
       * server_transaction_id.
       * </pre>
       *
       * <code>string server_transaction_id = 3;</code>
       *
       * @param value The bytes for serverTransactionId to set.
       * @return This builder for chaining.
       */
      public Builder setServerTransactionIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        serverTransactionId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private boolean isLastRecordInTransactionInPartition_;

      /**
       *
       *
       * <pre>
       * Indicates whether this is the last record for a transaction in the
       *  current partition. Clients can use this field to determine when all
       *  records for a transaction in the current partition have been received.
       * </pre>
       *
       * <code>bool is_last_record_in_transaction_in_partition = 4;</code>
       *
       * @return The isLastRecordInTransactionInPartition.
       */
      @java.lang.Override
      public boolean getIsLastRecordInTransactionInPartition() {
        return isLastRecordInTransactionInPartition_;
      }

      /**
       *
       *
       * <pre>
       * Indicates whether this is the last record for a transaction in the
       *  current partition. Clients can use this field to determine when all
       *  records for a transaction in the current partition have been received.
       * </pre>
       *
       * <code>bool is_last_record_in_transaction_in_partition = 4;</code>
       *
       * @param value The isLastRecordInTransactionInPartition to set.
       * @return This builder for chaining.
       */
      public Builder setIsLastRecordInTransactionInPartition(boolean value) {

        isLastRecordInTransactionInPartition_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates whether this is the last record for a transaction in the
       *  current partition. Clients can use this field to determine when all
       *  records for a transaction in the current partition have been received.
       * </pre>
       *
       * <code>bool is_last_record_in_transaction_in_partition = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsLastRecordInTransactionInPartition() {
        bitField0_ = (bitField0_ & ~0x00000008);
        isLastRecordInTransactionInPartition_ = false;
        onChanged();
        return this;
      }

      private java.lang.Object table_ = "";

      /**
       *
       *
       * <pre>
       * Name of the table affected by the change.
       * </pre>
       *
       * <code>string table = 5;</code>
       *
       * @return The table.
       */
      public java.lang.String getTable() {
        java.lang.Object ref = table_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          table_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the table affected by the change.
       * </pre>
       *
       * <code>string table = 5;</code>
       *
       * @return The bytes for table.
       */
      public com.google.protobuf.ByteString getTableBytes() {
        java.lang.Object ref = table_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          table_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Name of the table affected by the change.
       * </pre>
       *
       * <code>string table = 5;</code>
       *
       * @param value The table to set.
       * @return This builder for chaining.
       */
      public Builder setTable(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        table_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of the table affected by the change.
       * </pre>
       *
       * <code>string table = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTable() {
        table_ = getDefaultInstance().getTable();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Name of the table affected by the change.
       * </pre>
       *
       * <code>string table = 5;</code>
       *
       * @param value The bytes for table to set.
       * @return This builder for chaining.
       */
      public Builder setTableBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        table_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata>
          columnMetadata_ = java.util.Collections.emptyList();

      private void ensureColumnMetadataIsMutable() {
        if (!((bitField0_ & 0x00000020) != 0)) {
          columnMetadata_ =
              new java.util.ArrayList<
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata>(
                  columnMetadata_);
          bitField0_ |= 0x00000020;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder>
          columnMetadataBuilder_;

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata>
          getColumnMetadataList() {
        if (columnMetadataBuilder_ == null) {
          return java.util.Collections.unmodifiableList(columnMetadata_);
        } else {
          return columnMetadataBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public int getColumnMetadataCount() {
        if (columnMetadataBuilder_ == null) {
          return columnMetadata_.size();
        } else {
          return columnMetadataBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
          getColumnMetadata(int index) {
        if (columnMetadataBuilder_ == null) {
          return columnMetadata_.get(index);
        } else {
          return columnMetadataBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder setColumnMetadata(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata value) {
        if (columnMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnMetadataIsMutable();
          columnMetadata_.set(index, value);
          onChanged();
        } else {
          columnMetadataBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder setColumnMetadata(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder
              builderForValue) {
        if (columnMetadataBuilder_ == null) {
          ensureColumnMetadataIsMutable();
          columnMetadata_.set(index, builderForValue.build());
          onChanged();
        } else {
          columnMetadataBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder addColumnMetadata(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata value) {
        if (columnMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnMetadataIsMutable();
          columnMetadata_.add(value);
          onChanged();
        } else {
          columnMetadataBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder addColumnMetadata(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata value) {
        if (columnMetadataBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureColumnMetadataIsMutable();
          columnMetadata_.add(index, value);
          onChanged();
        } else {
          columnMetadataBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder addColumnMetadata(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder
              builderForValue) {
        if (columnMetadataBuilder_ == null) {
          ensureColumnMetadataIsMutable();
          columnMetadata_.add(builderForValue.build());
          onChanged();
        } else {
          columnMetadataBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder addColumnMetadata(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder
              builderForValue) {
        if (columnMetadataBuilder_ == null) {
          ensureColumnMetadataIsMutable();
          columnMetadata_.add(index, builderForValue.build());
          onChanged();
        } else {
          columnMetadataBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder addAllColumnMetadata(
          java.lang.Iterable<
                  ? extends
                      com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata>
              values) {
        if (columnMetadataBuilder_ == null) {
          ensureColumnMetadataIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, columnMetadata_);
          onChanged();
        } else {
          columnMetadataBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder clearColumnMetadata() {
        if (columnMetadataBuilder_ == null) {
          columnMetadata_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000020);
          onChanged();
        } else {
          columnMetadataBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public Builder removeColumnMetadata(int index) {
        if (columnMetadataBuilder_ == null) {
          ensureColumnMetadataIsMutable();
          columnMetadata_.remove(index);
          onChanged();
        } else {
          columnMetadataBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder
          getColumnMetadataBuilder(int index) {
        return getColumnMetadataFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder
          getColumnMetadataOrBuilder(int index) {
        if (columnMetadataBuilder_ == null) {
          return columnMetadata_.get(index);
        } else {
          return columnMetadataBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder>
          getColumnMetadataOrBuilderList() {
        if (columnMetadataBuilder_ != null) {
          return columnMetadataBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(columnMetadata_);
        }
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder
          addColumnMetadataBuilder() {
        return getColumnMetadataFieldBuilder()
            .addBuilder(
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder
          addColumnMetadataBuilder(int index) {
        return getColumnMetadataFieldBuilder()
            .addBuilder(
                index,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Provides metadata describing the columns associated with the
       * [mods][google.spanner.v1.ChangeStreamRecord.DataChangeRecord.mods] listed
       * below.
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata column_metadata = 6;
       * </code>
       */
      public java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder>
          getColumnMetadataBuilderList() {
        return getColumnMetadataFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadataOrBuilder>
          getColumnMetadataFieldBuilder() {
        if (columnMetadataBuilder_ == null) {
          columnMetadataBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ColumnMetadata.Builder,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord
                      .ColumnMetadataOrBuilder>(
                  columnMetadata_,
                  ((bitField0_ & 0x00000020) != 0),
                  getParentForChildren(),
                  isClean());
          columnMetadata_ = null;
        }
        return columnMetadataBuilder_;
      }

      private java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod> mods_ =
          java.util.Collections.emptyList();

      private void ensureModsIsMutable() {
        if (!((bitField0_ & 0x00000040) != 0)) {
          mods_ =
              new java.util.ArrayList<
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod>(mods_);
          bitField0_ |= 0x00000040;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder>
          modsBuilder_;

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod>
          getModsList() {
        if (modsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(mods_);
        } else {
          return modsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public int getModsCount() {
        if (modsBuilder_ == null) {
          return mods_.size();
        } else {
          return modsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod getMods(int index) {
        if (modsBuilder_ == null) {
          return mods_.get(index);
        } else {
          return modsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder setMods(
          int index, com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod value) {
        if (modsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureModsIsMutable();
          mods_.set(index, value);
          onChanged();
        } else {
          modsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder setMods(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder builderForValue) {
        if (modsBuilder_ == null) {
          ensureModsIsMutable();
          mods_.set(index, builderForValue.build());
          onChanged();
        } else {
          modsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder addMods(com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod value) {
        if (modsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureModsIsMutable();
          mods_.add(value);
          onChanged();
        } else {
          modsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder addMods(
          int index, com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod value) {
        if (modsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureModsIsMutable();
          mods_.add(index, value);
          onChanged();
        } else {
          modsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder addMods(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder builderForValue) {
        if (modsBuilder_ == null) {
          ensureModsIsMutable();
          mods_.add(builderForValue.build());
          onChanged();
        } else {
          modsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder addMods(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder builderForValue) {
        if (modsBuilder_ == null) {
          ensureModsIsMutable();
          mods_.add(index, builderForValue.build());
          onChanged();
        } else {
          modsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder addAllMods(
          java.lang.Iterable<
                  ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod>
              values) {
        if (modsBuilder_ == null) {
          ensureModsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, mods_);
          onChanged();
        } else {
          modsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder clearMods() {
        if (modsBuilder_ == null) {
          mods_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          modsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public Builder removeMods(int index) {
        if (modsBuilder_ == null) {
          ensureModsIsMutable();
          mods_.remove(index);
          onChanged();
        } else {
          modsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder getModsBuilder(
          int index) {
        return getModsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder
          getModsOrBuilder(int index) {
        if (modsBuilder_ == null) {
          return mods_.get(index);
        } else {
          return modsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public java.util.List<
              ? extends com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder>
          getModsOrBuilderList() {
        if (modsBuilder_ != null) {
          return modsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(mods_);
        }
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder
          addModsBuilder() {
        return getModsFieldBuilder()
            .addBuilder(
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder addModsBuilder(
          int index) {
        return getModsFieldBuilder()
            .addBuilder(
                index,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Describes the changes that were made.
       * </pre>
       *
       * <code>repeated .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod mods = 7;</code>
       */
      public java.util.List<com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder>
          getModsBuilderList() {
        return getModsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder,
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder>
          getModsFieldBuilder() {
        if (modsBuilder_ == null) {
          modsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Mod.Builder,
                  com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModOrBuilder>(
                  mods_, ((bitField0_ & 0x00000040) != 0), getParentForChildren(), isClean());
          mods_ = null;
        }
        return modsBuilder_;
      }

      private int modType_ = 0;

      /**
       *
       *
       * <pre>
       * Describes the type of change.
       * </pre>
       *
       * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
       *
       * @return The enum numeric value on the wire for modType.
       */
      @java.lang.Override
      public int getModTypeValue() {
        return modType_;
      }

      /**
       *
       *
       * <pre>
       * Describes the type of change.
       * </pre>
       *
       * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
       *
       * @param value The enum numeric value on the wire for modType to set.
       * @return This builder for chaining.
       */
      public Builder setModTypeValue(int value) {
        modType_ = value;
        bitField0_ |= 0x00000080;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the type of change.
       * </pre>
       *
       * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
       *
       * @return The modType.
       */
      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType getModType() {
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType result =
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.forNumber(modType_);
        return result == null
            ? com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Describes the type of change.
       * </pre>
       *
       * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
       *
       * @param value The modType to set.
       * @return This builder for chaining.
       */
      public Builder setModType(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000080;
        modType_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the type of change.
       * </pre>
       *
       * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ModType mod_type = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModType() {
        bitField0_ = (bitField0_ & ~0x00000080);
        modType_ = 0;
        onChanged();
        return this;
      }

      private int valueCaptureType_ = 0;

      /**
       *
       *
       * <pre>
       * Describes the value capture type that was specified in the change stream
       * configuration when this change was captured.
       * </pre>
       *
       * <code>
       * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
       * </code>
       *
       * @return The enum numeric value on the wire for valueCaptureType.
       */
      @java.lang.Override
      public int getValueCaptureTypeValue() {
        return valueCaptureType_;
      }

      /**
       *
       *
       * <pre>
       * Describes the value capture type that was specified in the change stream
       * configuration when this change was captured.
       * </pre>
       *
       * <code>
       * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
       * </code>
       *
       * @param value The enum numeric value on the wire for valueCaptureType to set.
       * @return This builder for chaining.
       */
      public Builder setValueCaptureTypeValue(int value) {
        valueCaptureType_ = value;
        bitField0_ |= 0x00000100;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the value capture type that was specified in the change stream
       * configuration when this change was captured.
       * </pre>
       *
       * <code>
       * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
       * </code>
       *
       * @return The valueCaptureType.
       */
      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType
          getValueCaptureType() {
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType result =
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType.forNumber(
                valueCaptureType_);
        return result == null
            ? com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Describes the value capture type that was specified in the change stream
       * configuration when this change was captured.
       * </pre>
       *
       * <code>
       * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
       * </code>
       *
       * @param value The valueCaptureType to set.
       * @return This builder for chaining.
       */
      public Builder setValueCaptureType(
          com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000100;
        valueCaptureType_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Describes the value capture type that was specified in the change stream
       * configuration when this change was captured.
       * </pre>
       *
       * <code>
       * .google.spanner.v1.ChangeStreamRecord.DataChangeRecord.ValueCaptureType value_capture_type = 9;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueCaptureType() {
        bitField0_ = (bitField0_ & ~0x00000100);
        valueCaptureType_ = 0;
        onChanged();
        return this;
      }

      private int numberOfRecordsInTransaction_;

      /**
       *
       *
       * <pre>
       * Indicates the number of data change records that are part of this
       * transaction across all change stream partitions. This value can be used
       * to assemble all the records associated with a particular transaction.
       * </pre>
       *
       * <code>int32 number_of_records_in_transaction = 10;</code>
       *
       * @return The numberOfRecordsInTransaction.
       */
      @java.lang.Override
      public int getNumberOfRecordsInTransaction() {
        return numberOfRecordsInTransaction_;
      }

      /**
       *
       *
       * <pre>
       * Indicates the number of data change records that are part of this
       * transaction across all change stream partitions. This value can be used
       * to assemble all the records associated with a particular transaction.
       * </pre>
       *
       * <code>int32 number_of_records_in_transaction = 10;</code>
       *
       * @param value The numberOfRecordsInTransaction to set.
       * @return This builder for chaining.
       */
      public Builder setNumberOfRecordsInTransaction(int value) {

        numberOfRecordsInTransaction_ = value;
        bitField0_ |= 0x00000200;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the number of data change records that are part of this
       * transaction across all change stream partitions. This value can be used
       * to assemble all the records associated with a particular transaction.
       * </pre>
       *
       * <code>int32 number_of_records_in_transaction = 10;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNumberOfRecordsInTransaction() {
        bitField0_ = (bitField0_ & ~0x00000200);
        numberOfRecordsInTransaction_ = 0;
        onChanged();
        return this;
      }

      private int numberOfPartitionsInTransaction_;

      /**
       *
       *
       * <pre>
       * Indicates the number of partitions that return data change records for
       * this transaction. This value can be helpful in assembling all records
       * associated with a particular transaction.
       * </pre>
       *
       * <code>int32 number_of_partitions_in_transaction = 11;</code>
       *
       * @return The numberOfPartitionsInTransaction.
       */
      @java.lang.Override
      public int getNumberOfPartitionsInTransaction() {
        return numberOfPartitionsInTransaction_;
      }

      /**
       *
       *
       * <pre>
       * Indicates the number of partitions that return data change records for
       * this transaction. This value can be helpful in assembling all records
       * associated with a particular transaction.
       * </pre>
       *
       * <code>int32 number_of_partitions_in_transaction = 11;</code>
       *
       * @param value The numberOfPartitionsInTransaction to set.
       * @return This builder for chaining.
       */
      public Builder setNumberOfPartitionsInTransaction(int value) {

        numberOfPartitionsInTransaction_ = value;
        bitField0_ |= 0x00000400;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the number of partitions that return data change records for
       * this transaction. This value can be helpful in assembling all records
       * associated with a particular transaction.
       * </pre>
       *
       * <code>int32 number_of_partitions_in_transaction = 11;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearNumberOfPartitionsInTransaction() {
        bitField0_ = (bitField0_ & ~0x00000400);
        numberOfPartitionsInTransaction_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object transactionTag_ = "";

      /**
       *
       *
       * <pre>
       * Indicates the transaction tag associated with this transaction.
       * </pre>
       *
       * <code>string transaction_tag = 12;</code>
       *
       * @return The transactionTag.
       */
      public java.lang.String getTransactionTag() {
        java.lang.Object ref = transactionTag_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          transactionTag_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates the transaction tag associated with this transaction.
       * </pre>
       *
       * <code>string transaction_tag = 12;</code>
       *
       * @return The bytes for transactionTag.
       */
      public com.google.protobuf.ByteString getTransactionTagBytes() {
        java.lang.Object ref = transactionTag_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          transactionTag_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates the transaction tag associated with this transaction.
       * </pre>
       *
       * <code>string transaction_tag = 12;</code>
       *
       * @param value The transactionTag to set.
       * @return This builder for chaining.
       */
      public Builder setTransactionTag(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        transactionTag_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the transaction tag associated with this transaction.
       * </pre>
       *
       * <code>string transaction_tag = 12;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTransactionTag() {
        transactionTag_ = getDefaultInstance().getTransactionTag();
        bitField0_ = (bitField0_ & ~0x00000800);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the transaction tag associated with this transaction.
       * </pre>
       *
       * <code>string transaction_tag = 12;</code>
       *
       * @param value The bytes for transactionTag to set.
       * @return This builder for chaining.
       */
      public Builder setTransactionTagBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        transactionTag_ = value;
        bitField0_ |= 0x00000800;
        onChanged();
        return this;
      }

      private boolean isSystemTransaction_;

      /**
       *
       *
       * <pre>
       * Indicates whether the transaction is a system transaction. System
       * transactions include those issued by time-to-live (TTL), column backfill,
       * etc.
       * </pre>
       *
       * <code>bool is_system_transaction = 13;</code>
       *
       * @return The isSystemTransaction.
       */
      @java.lang.Override
      public boolean getIsSystemTransaction() {
        return isSystemTransaction_;
      }

      /**
       *
       *
       * <pre>
       * Indicates whether the transaction is a system transaction. System
       * transactions include those issued by time-to-live (TTL), column backfill,
       * etc.
       * </pre>
       *
       * <code>bool is_system_transaction = 13;</code>
       *
       * @param value The isSystemTransaction to set.
       * @return This builder for chaining.
       */
      public Builder setIsSystemTransaction(boolean value) {

        isSystemTransaction_ = value;
        bitField0_ |= 0x00001000;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates whether the transaction is a system transaction. System
       * transactions include those issued by time-to-live (TTL), column backfill,
       * etc.
       * </pre>
       *
       * <code>bool is_system_transaction = 13;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearIsSystemTransaction() {
        bitField0_ = (bitField0_ & ~0x00001000);
        isSystemTransaction_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.DataChangeRecord)
    private static final com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord();
    }

    public static com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataChangeRecord> PARSER =
        new com.google.protobuf.AbstractParser<DataChangeRecord>() {
          @java.lang.Override
          public DataChangeRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataChangeRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataChangeRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface HeartbeatRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.HeartbeatRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates the timestamp at which the query has returned all the records
     * in the change stream partition with timestamp &lt;= heartbeat timestamp.
     * The heartbeat timestamp will not be the same as the timestamps of other
     * record types in the same partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     *
     * @return Whether the timestamp field is set.
     */
    boolean hasTimestamp();

    /**
     *
     *
     * <pre>
     * Indicates the timestamp at which the query has returned all the records
     * in the change stream partition with timestamp &lt;= heartbeat timestamp.
     * The heartbeat timestamp will not be the same as the timestamps of other
     * record types in the same partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     *
     * @return The timestamp.
     */
    com.google.protobuf.Timestamp getTimestamp();

    /**
     *
     *
     * <pre>
     * Indicates the timestamp at which the query has returned all the records
     * in the change stream partition with timestamp &lt;= heartbeat timestamp.
     * The heartbeat timestamp will not be the same as the timestamps of other
     * record types in the same partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * A heartbeat record is returned as a progress indicator, when there are no
   * data changes or any other partition record types in the change stream
   * partition.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.HeartbeatRecord}
   */
  public static final class HeartbeatRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.HeartbeatRecord)
      HeartbeatRecordOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use HeartbeatRecord.newBuilder() to construct.
    private HeartbeatRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private HeartbeatRecord() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new HeartbeatRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_HeartbeatRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_HeartbeatRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.class,
              com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.Builder.class);
    }

    private int bitField0_;
    public static final int TIMESTAMP_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp timestamp_;

    /**
     *
     *
     * <pre>
     * Indicates the timestamp at which the query has returned all the records
     * in the change stream partition with timestamp &lt;= heartbeat timestamp.
     * The heartbeat timestamp will not be the same as the timestamps of other
     * record types in the same partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     *
     * @return Whether the timestamp field is set.
     */
    @java.lang.Override
    public boolean hasTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates the timestamp at which the query has returned all the records
     * in the change stream partition with timestamp &lt;= heartbeat timestamp.
     * The heartbeat timestamp will not be the same as the timestamps of other
     * record types in the same partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     *
     * @return The timestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getTimestamp() {
      return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
    }

    /**
     *
     *
     * <pre>
     * Indicates the timestamp at which the query has returned all the records
     * in the change stream partition with timestamp &lt;= heartbeat timestamp.
     * The heartbeat timestamp will not be the same as the timestamps of other
     * record types in the same partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp timestamp = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
      return timestamp_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : timestamp_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getTimestamp());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getTimestamp());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord other =
          (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) obj;

      if (hasTimestamp() != other.hasTimestamp()) return false;
      if (hasTimestamp()) {
        if (!getTimestamp().equals(other.getTimestamp())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasTimestamp()) {
        hash = (37 * hash) + TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getTimestamp().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A heartbeat record is returned as a progress indicator, when there are no
     * data changes or any other partition record types in the change stream
     * partition.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.HeartbeatRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.HeartbeatRecord)
        com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_HeartbeatRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_HeartbeatRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.class,
                com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.Builder.class);
      }

      // Construct using com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getTimestampFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        timestamp_ = null;
        if (timestampBuilder_ != null) {
          timestampBuilder_.dispose();
          timestampBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_HeartbeatRecord_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord getDefaultInstanceForType() {
        return com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord build() {
        com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord buildPartial() {
        com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord result =
            new com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.timestamp_ = timestampBuilder_ == null ? timestamp_ : timestampBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) {
          return mergeFrom((com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord other) {
        if (other == com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance())
          return this;
        if (other.hasTimestamp()) {
          mergeTimestamp(other.getTimestamp());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp timestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          timestampBuilder_;

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       *
       * @return Whether the timestamp field is set.
       */
      public boolean hasTimestamp() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       *
       * @return The timestamp.
       */
      public com.google.protobuf.Timestamp getTimestamp() {
        if (timestampBuilder_ == null) {
          return timestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : timestamp_;
        } else {
          return timestampBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       */
      public Builder setTimestamp(com.google.protobuf.Timestamp value) {
        if (timestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          timestamp_ = value;
        } else {
          timestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       */
      public Builder setTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (timestampBuilder_ == null) {
          timestamp_ = builderForValue.build();
        } else {
          timestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       */
      public Builder mergeTimestamp(com.google.protobuf.Timestamp value) {
        if (timestampBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && timestamp_ != null
              && timestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getTimestampBuilder().mergeFrom(value);
          } else {
            timestamp_ = value;
          }
        } else {
          timestampBuilder_.mergeFrom(value);
        }
        if (timestamp_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       */
      public Builder clearTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        timestamp_ = null;
        if (timestampBuilder_ != null) {
          timestampBuilder_.dispose();
          timestampBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getTimestampBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getTimestampOrBuilder() {
        if (timestampBuilder_ != null) {
          return timestampBuilder_.getMessageOrBuilder();
        } else {
          return timestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : timestamp_;
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates the timestamp at which the query has returned all the records
       * in the change stream partition with timestamp &lt;= heartbeat timestamp.
       * The heartbeat timestamp will not be the same as the timestamps of other
       * record types in the same partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp timestamp = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getTimestampFieldBuilder() {
        if (timestampBuilder_ == null) {
          timestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getTimestamp(), getParentForChildren(), isClean());
          timestamp_ = null;
        }
        return timestampBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.HeartbeatRecord)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.HeartbeatRecord)
    private static final com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord();
    }

    public static com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<HeartbeatRecord> PARSER =
        new com.google.protobuf.AbstractParser<HeartbeatRecord>() {
          @java.lang.Override
          public HeartbeatRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<HeartbeatRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<HeartbeatRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PartitionStartRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.PartitionStartRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps &gt;= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     *
     * @return Whether the startTimestamp field is set.
     */
    boolean hasStartTimestamp();

    /**
     *
     *
     * <pre>
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps &gt;= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     *
     * @return The startTimestamp.
     */
    com.google.protobuf.Timestamp getStartTimestamp();

    /**
     *
     *
     * <pre>
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps &gt;= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getStartTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    java.lang.String getRecordSequence();

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    com.google.protobuf.ByteString getRecordSequenceBytes();

    /**
     *
     *
     * <pre>
     * Unique partition identifiers to be used in queries.
     * </pre>
     *
     * <code>repeated string partition_tokens = 3;</code>
     *
     * @return A list containing the partitionTokens.
     */
    java.util.List<java.lang.String> getPartitionTokensList();

    /**
     *
     *
     * <pre>
     * Unique partition identifiers to be used in queries.
     * </pre>
     *
     * <code>repeated string partition_tokens = 3;</code>
     *
     * @return The count of partitionTokens.
     */
    int getPartitionTokensCount();

    /**
     *
     *
     * <pre>
     * Unique partition identifiers to be used in queries.
     * </pre>
     *
     * <code>repeated string partition_tokens = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The partitionTokens at the given index.
     */
    java.lang.String getPartitionTokens(int index);

    /**
     *
     *
     * <pre>
     * Unique partition identifiers to be used in queries.
     * </pre>
     *
     * <code>repeated string partition_tokens = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the partitionTokens at the given index.
     */
    com.google.protobuf.ByteString getPartitionTokensBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * A partition start record serves as a notification that the client should
   * schedule the partitions to be queried. PartitionStartRecord returns
   * information about one or more partitions.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionStartRecord}
   */
  public static final class PartitionStartRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.PartitionStartRecord)
      PartitionStartRecordOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PartitionStartRecord.newBuilder() to construct.
    private PartitionStartRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PartitionStartRecord() {
      recordSequence_ = "";
      partitionTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PartitionStartRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionStartRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionStartRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.class,
              com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.Builder.class);
    }

    private int bitField0_;
    public static final int START_TIMESTAMP_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp startTimestamp_;

    /**
     *
     *
     * <pre>
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps &gt;= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     *
     * @return Whether the startTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasStartTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps &gt;= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     *
     * @return The startTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getStartTimestamp() {
      return startTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : startTimestamp_;
    }

    /**
     *
     *
     * <pre>
     * Start timestamp at which the partitions should be queried to return
     * change stream records with timestamps &gt;= start_timestamp.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getStartTimestampOrBuilder() {
      return startTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : startTimestamp_;
    }

    public static final int RECORD_SEQUENCE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object recordSequence_ = "";

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    @java.lang.Override
    public java.lang.String getRecordSequence() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recordSequence_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRecordSequenceBytes() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recordSequence_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARTITION_TOKENS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList partitionTokens_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Unique partition identifiers to be used in queries.
     * </pre>
     *
     * <code>repeated string partition_tokens = 3;</code>
     *
     * @return A list containing the partitionTokens.
     */
    public com.google.protobuf.ProtocolStringList getPartitionTokensList() {
      return partitionTokens_;
    }

    /**
     *
     *
     * <pre>
     * Unique partition identifiers to be used in queries.
     * </pre>
     *
     * <code>repeated string partition_tokens = 3;</code>
     *
     * @return The count of partitionTokens.
     */
    public int getPartitionTokensCount() {
      return partitionTokens_.size();
    }

    /**
     *
     *
     * <pre>
     * Unique partition identifiers to be used in queries.
     * </pre>
     *
     * <code>repeated string partition_tokens = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The partitionTokens at the given index.
     */
    public java.lang.String getPartitionTokens(int index) {
      return partitionTokens_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Unique partition identifiers to be used in queries.
     * </pre>
     *
     * <code>repeated string partition_tokens = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the partitionTokens at the given index.
     */
    public com.google.protobuf.ByteString getPartitionTokensBytes(int index) {
      return partitionTokens_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getStartTimestamp());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, recordSequence_);
      }
      for (int i = 0; i < partitionTokens_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, partitionTokens_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStartTimestamp());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, recordSequence_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < partitionTokens_.size(); i++) {
          dataSize += computeStringSizeNoTag(partitionTokens_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getPartitionTokensList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord other =
          (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) obj;

      if (hasStartTimestamp() != other.hasStartTimestamp()) return false;
      if (hasStartTimestamp()) {
        if (!getStartTimestamp().equals(other.getStartTimestamp())) return false;
      }
      if (!getRecordSequence().equals(other.getRecordSequence())) return false;
      if (!getPartitionTokensList().equals(other.getPartitionTokensList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasStartTimestamp()) {
        hash = (37 * hash) + START_TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getStartTimestamp().hashCode();
      }
      hash = (37 * hash) + RECORD_SEQUENCE_FIELD_NUMBER;
      hash = (53 * hash) + getRecordSequence().hashCode();
      if (getPartitionTokensCount() > 0) {
        hash = (37 * hash) + PARTITION_TOKENS_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionTokensList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A partition start record serves as a notification that the client should
     * schedule the partitions to be queried. PartitionStartRecord returns
     * information about one or more partitions.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionStartRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.PartitionStartRecord)
        com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionStartRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionStartRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.class,
                com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.Builder.class);
      }

      // Construct using com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getStartTimestampFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        startTimestamp_ = null;
        if (startTimestampBuilder_ != null) {
          startTimestampBuilder_.dispose();
          startTimestampBuilder_ = null;
        }
        recordSequence_ = "";
        partitionTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionStartRecord_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord
          getDefaultInstanceForType() {
        return com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord build() {
        com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord buildPartial() {
        com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord result =
            new com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.startTimestamp_ =
              startTimestampBuilder_ == null ? startTimestamp_ : startTimestampBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.recordSequence_ = recordSequence_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          partitionTokens_.makeImmutable();
          result.partitionTokens_ = partitionTokens_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) {
          return mergeFrom((com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord other) {
        if (other
            == com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.getDefaultInstance())
          return this;
        if (other.hasStartTimestamp()) {
          mergeStartTimestamp(other.getStartTimestamp());
        }
        if (!other.getRecordSequence().isEmpty()) {
          recordSequence_ = other.recordSequence_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.partitionTokens_.isEmpty()) {
          if (partitionTokens_.isEmpty()) {
            partitionTokens_ = other.partitionTokens_;
            bitField0_ |= 0x00000004;
          } else {
            ensurePartitionTokensIsMutable();
            partitionTokens_.addAll(other.partitionTokens_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getStartTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  recordSequence_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensurePartitionTokensIsMutable();
                  partitionTokens_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp startTimestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          startTimestampBuilder_;

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       *
       * @return Whether the startTimestamp field is set.
       */
      public boolean hasStartTimestamp() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       *
       * @return The startTimestamp.
       */
      public com.google.protobuf.Timestamp getStartTimestamp() {
        if (startTimestampBuilder_ == null) {
          return startTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTimestamp_;
        } else {
          return startTimestampBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       */
      public Builder setStartTimestamp(com.google.protobuf.Timestamp value) {
        if (startTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          startTimestamp_ = value;
        } else {
          startTimestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       */
      public Builder setStartTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (startTimestampBuilder_ == null) {
          startTimestamp_ = builderForValue.build();
        } else {
          startTimestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       */
      public Builder mergeStartTimestamp(com.google.protobuf.Timestamp value) {
        if (startTimestampBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && startTimestamp_ != null
              && startTimestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getStartTimestampBuilder().mergeFrom(value);
          } else {
            startTimestamp_ = value;
          }
        } else {
          startTimestampBuilder_.mergeFrom(value);
        }
        if (startTimestamp_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       */
      public Builder clearStartTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        startTimestamp_ = null;
        if (startTimestampBuilder_ != null) {
          startTimestampBuilder_.dispose();
          startTimestampBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getStartTimestampBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getStartTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getStartTimestampOrBuilder() {
        if (startTimestampBuilder_ != null) {
          return startTimestampBuilder_.getMessageOrBuilder();
        } else {
          return startTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : startTimestamp_;
        }
      }

      /**
       *
       *
       * <pre>
       * Start timestamp at which the partitions should be queried to return
       * change stream records with timestamps &gt;= start_timestamp.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp start_timestamp = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getStartTimestampFieldBuilder() {
        if (startTimestampBuilder_ == null) {
          startTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getStartTimestamp(), getParentForChildren(), isClean());
          startTimestamp_ = null;
        }
        return startTimestampBuilder_;
      }

      private java.lang.Object recordSequence_ = "";

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return The recordSequence.
       */
      public java.lang.String getRecordSequence() {
        java.lang.Object ref = recordSequence_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          recordSequence_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return The bytes for recordSequence.
       */
      public com.google.protobuf.ByteString getRecordSequenceBytes() {
        java.lang.Object ref = recordSequence_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          recordSequence_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @param value The recordSequence to set.
       * @return This builder for chaining.
       */
      public Builder setRecordSequence(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        recordSequence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecordSequence() {
        recordSequence_ = getDefaultInstance().getRecordSequence();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @param value The bytes for recordSequence to set.
       * @return This builder for chaining.
       */
      public Builder setRecordSequenceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        recordSequence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList partitionTokens_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensurePartitionTokensIsMutable() {
        if (!partitionTokens_.isModifiable()) {
          partitionTokens_ = new com.google.protobuf.LazyStringArrayList(partitionTokens_);
        }
        bitField0_ |= 0x00000004;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @return A list containing the partitionTokens.
       */
      public com.google.protobuf.ProtocolStringList getPartitionTokensList() {
        partitionTokens_.makeImmutable();
        return partitionTokens_;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @return The count of partitionTokens.
       */
      public int getPartitionTokensCount() {
        return partitionTokens_.size();
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @param index The index of the element to return.
       * @return The partitionTokens at the given index.
       */
      public java.lang.String getPartitionTokens(int index) {
        return partitionTokens_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the partitionTokens at the given index.
       */
      public com.google.protobuf.ByteString getPartitionTokensBytes(int index) {
        return partitionTokens_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @param index The index to set the value at.
       * @param value The partitionTokens to set.
       * @return This builder for chaining.
       */
      public Builder setPartitionTokens(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartitionTokensIsMutable();
        partitionTokens_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @param value The partitionTokens to add.
       * @return This builder for chaining.
       */
      public Builder addPartitionTokens(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensurePartitionTokensIsMutable();
        partitionTokens_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @param values The partitionTokens to add.
       * @return This builder for chaining.
       */
      public Builder addAllPartitionTokens(java.lang.Iterable<java.lang.String> values) {
        ensurePartitionTokensIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, partitionTokens_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPartitionTokens() {
        partitionTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifiers to be used in queries.
       * </pre>
       *
       * <code>repeated string partition_tokens = 3;</code>
       *
       * @param value The bytes of the partitionTokens to add.
       * @return This builder for chaining.
       */
      public Builder addPartitionTokensBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensurePartitionTokensIsMutable();
        partitionTokens_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.PartitionStartRecord)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.PartitionStartRecord)
    private static final com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord();
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PartitionStartRecord> PARSER =
        new com.google.protobuf.AbstractParser<PartitionStartRecord>() {
          @java.lang.Override
          public PartitionStartRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PartitionStartRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PartitionStartRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PartitionEndRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.PartitionEndRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps &lt;=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     *
     * @return Whether the endTimestamp field is set.
     */
    boolean hasEndTimestamp();

    /**
     *
     *
     * <pre>
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps &lt;=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     *
     * @return The endTimestamp.
     */
    com.google.protobuf.Timestamp getEndTimestamp();

    /**
     *
     *
     * <pre>
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps &lt;=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getEndTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    java.lang.String getRecordSequence();

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    com.google.protobuf.ByteString getRecordSequenceBytes();

    /**
     *
     *
     * <pre>
     * Unique partition identifier describing the terminated change stream
     * partition.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEndRecord.
     * </pre>
     *
     * <code>string partition_token = 3;</code>
     *
     * @return The partitionToken.
     */
    java.lang.String getPartitionToken();

    /**
     *
     *
     * <pre>
     * Unique partition identifier describing the terminated change stream
     * partition.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEndRecord.
     * </pre>
     *
     * <code>string partition_token = 3;</code>
     *
     * @return The bytes for partitionToken.
     */
    com.google.protobuf.ByteString getPartitionTokenBytes();
  }

  /**
   *
   *
   * <pre>
   * A partition end record serves as a notification that the client should stop
   * reading the partition. No further records are expected to be retrieved on
   * it.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionEndRecord}
   */
  public static final class PartitionEndRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.PartitionEndRecord)
      PartitionEndRecordOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PartitionEndRecord.newBuilder() to construct.
    private PartitionEndRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PartitionEndRecord() {
      recordSequence_ = "";
      partitionToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PartitionEndRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEndRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEndRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.class,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.Builder.class);
    }

    private int bitField0_;
    public static final int END_TIMESTAMP_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp endTimestamp_;

    /**
     *
     *
     * <pre>
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps &lt;=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     *
     * @return Whether the endTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasEndTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps &lt;=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     *
     * @return The endTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getEndTimestamp() {
      return endTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : endTimestamp_;
    }

    /**
     *
     *
     * <pre>
     * End timestamp at which the change stream partition is terminated. All
     * changes generated by this partition will have timestamps &lt;=
     * end_timestamp. DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition. PartitionEndRecord is the last record returned for a
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getEndTimestampOrBuilder() {
      return endTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : endTimestamp_;
    }

    public static final int RECORD_SEQUENCE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object recordSequence_ = "";

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    @java.lang.Override
    public java.lang.String getRecordSequence() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recordSequence_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRecordSequenceBytes() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recordSequence_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARTITION_TOKEN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object partitionToken_ = "";

    /**
     *
     *
     * <pre>
     * Unique partition identifier describing the terminated change stream
     * partition.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEndRecord.
     * </pre>
     *
     * <code>string partition_token = 3;</code>
     *
     * @return The partitionToken.
     */
    @java.lang.Override
    public java.lang.String getPartitionToken() {
      java.lang.Object ref = partitionToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partitionToken_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Unique partition identifier describing the terminated change stream
     * partition.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEndRecord.
     * </pre>
     *
     * <code>string partition_token = 3;</code>
     *
     * @return The bytes for partitionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPartitionTokenBytes() {
      java.lang.Object ref = partitionToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        partitionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getEndTimestamp());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, recordSequence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(partitionToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, partitionToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getEndTimestamp());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, recordSequence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(partitionToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, partitionToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord other =
          (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) obj;

      if (hasEndTimestamp() != other.hasEndTimestamp()) return false;
      if (hasEndTimestamp()) {
        if (!getEndTimestamp().equals(other.getEndTimestamp())) return false;
      }
      if (!getRecordSequence().equals(other.getRecordSequence())) return false;
      if (!getPartitionToken().equals(other.getPartitionToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasEndTimestamp()) {
        hash = (37 * hash) + END_TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getEndTimestamp().hashCode();
      }
      hash = (37 * hash) + RECORD_SEQUENCE_FIELD_NUMBER;
      hash = (53 * hash) + getRecordSequence().hashCode();
      hash = (37 * hash) + PARTITION_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A partition end record serves as a notification that the client should stop
     * reading the partition. No further records are expected to be retrieved on
     * it.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionEndRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.PartitionEndRecord)
        com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEndRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEndRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.class,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.Builder.class);
      }

      // Construct using com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEndTimestampFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endTimestamp_ = null;
        if (endTimestampBuilder_ != null) {
          endTimestampBuilder_.dispose();
          endTimestampBuilder_ = null;
        }
        recordSequence_ = "";
        partitionToken_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEndRecord_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord
          getDefaultInstanceForType() {
        return com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord build() {
        com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord buildPartial() {
        com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord result =
            new com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.endTimestamp_ =
              endTimestampBuilder_ == null ? endTimestamp_ : endTimestampBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.recordSequence_ = recordSequence_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.partitionToken_ = partitionToken_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) {
          return mergeFrom((com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord other) {
        if (other
            == com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.getDefaultInstance())
          return this;
        if (other.hasEndTimestamp()) {
          mergeEndTimestamp(other.getEndTimestamp());
        }
        if (!other.getRecordSequence().isEmpty()) {
          recordSequence_ = other.recordSequence_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPartitionToken().isEmpty()) {
          partitionToken_ = other.partitionToken_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getEndTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  recordSequence_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  partitionToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp endTimestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          endTimestampBuilder_;

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       *
       * @return Whether the endTimestamp field is set.
       */
      public boolean hasEndTimestamp() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       *
       * @return The endTimestamp.
       */
      public com.google.protobuf.Timestamp getEndTimestamp() {
        if (endTimestampBuilder_ == null) {
          return endTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : endTimestamp_;
        } else {
          return endTimestampBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       */
      public Builder setEndTimestamp(com.google.protobuf.Timestamp value) {
        if (endTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          endTimestamp_ = value;
        } else {
          endTimestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       */
      public Builder setEndTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (endTimestampBuilder_ == null) {
          endTimestamp_ = builderForValue.build();
        } else {
          endTimestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       */
      public Builder mergeEndTimestamp(com.google.protobuf.Timestamp value) {
        if (endTimestampBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && endTimestamp_ != null
              && endTimestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getEndTimestampBuilder().mergeFrom(value);
          } else {
            endTimestamp_ = value;
          }
        } else {
          endTimestampBuilder_.mergeFrom(value);
        }
        if (endTimestamp_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       */
      public Builder clearEndTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        endTimestamp_ = null;
        if (endTimestampBuilder_ != null) {
          endTimestampBuilder_.dispose();
          endTimestampBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getEndTimestampBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getEndTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getEndTimestampOrBuilder() {
        if (endTimestampBuilder_ != null) {
          return endTimestampBuilder_.getMessageOrBuilder();
        } else {
          return endTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : endTimestamp_;
        }
      }

      /**
       *
       *
       * <pre>
       * End timestamp at which the change stream partition is terminated. All
       * changes generated by this partition will have timestamps &lt;=
       * end_timestamp. DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition. PartitionEndRecord is the last record returned for a
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp end_timestamp = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getEndTimestampFieldBuilder() {
        if (endTimestampBuilder_ == null) {
          endTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getEndTimestamp(), getParentForChildren(), isClean());
          endTimestamp_ = null;
        }
        return endTimestampBuilder_;
      }

      private java.lang.Object recordSequence_ = "";

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return The recordSequence.
       */
      public java.lang.String getRecordSequence() {
        java.lang.Object ref = recordSequence_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          recordSequence_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return The bytes for recordSequence.
       */
      public com.google.protobuf.ByteString getRecordSequenceBytes() {
        java.lang.Object ref = recordSequence_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          recordSequence_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @param value The recordSequence to set.
       * @return This builder for chaining.
       */
      public Builder setRecordSequence(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        recordSequence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecordSequence() {
        recordSequence_ = getDefaultInstance().getRecordSequence();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @param value The bytes for recordSequence to set.
       * @return This builder for chaining.
       */
      public Builder setRecordSequenceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        recordSequence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object partitionToken_ = "";

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the terminated change stream
       * partition.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEndRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @return The partitionToken.
       */
      public java.lang.String getPartitionToken() {
        java.lang.Object ref = partitionToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partitionToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the terminated change stream
       * partition.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEndRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @return The bytes for partitionToken.
       */
      public com.google.protobuf.ByteString getPartitionTokenBytes() {
        java.lang.Object ref = partitionToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          partitionToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the terminated change stream
       * partition.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEndRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @param value The partitionToken to set.
       * @return This builder for chaining.
       */
      public Builder setPartitionToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        partitionToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the terminated change stream
       * partition.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEndRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPartitionToken() {
        partitionToken_ = getDefaultInstance().getPartitionToken();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the terminated change stream
       * partition.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEndRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @param value The bytes for partitionToken to set.
       * @return This builder for chaining.
       */
      public Builder setPartitionTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        partitionToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.PartitionEndRecord)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.PartitionEndRecord)
    private static final com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord();
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PartitionEndRecord> PARSER =
        new com.google.protobuf.AbstractParser<PartitionEndRecord>() {
          @java.lang.Override
          public PartitionEndRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PartitionEndRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PartitionEndRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface PartitionEventRecordOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return Whether the commitTimestamp field is set.
     */
    boolean hasCommitTimestamp();

    /**
     *
     *
     * <pre>
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return The commitTimestamp.
     */
    com.google.protobuf.Timestamp getCommitTimestamp();

    /**
     *
     *
     * <pre>
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder();

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    java.lang.String getRecordSequence();

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    com.google.protobuf.ByteString getRecordSequenceBytes();

    /**
     *
     *
     * <pre>
     * Unique partition identifier describing the partition this event
     * occurred on.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEventRecord.
     * </pre>
     *
     * <code>string partition_token = 3;</code>
     *
     * @return The partitionToken.
     */
    java.lang.String getPartitionToken();

    /**
     *
     *
     * <pre>
     * Unique partition identifier describing the partition this event
     * occurred on.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEventRecord.
     * </pre>
     *
     * <code>string partition_token = 3;</code>
     *
     * @return The bytes for partitionToken.
     */
    com.google.protobuf.ByteString getPartitionTokenBytes();

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    java.util.List<com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent>
        getMoveInEventsList();

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent getMoveInEvents(
        int index);

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    int getMoveInEventsCount();

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEventOrBuilder>
        getMoveInEventsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEventOrBuilder
        getMoveInEventsOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    java.util.List<com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent>
        getMoveOutEventsList();

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent getMoveOutEvents(
        int index);

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    int getMoveOutEventsCount();

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEventOrBuilder>
        getMoveOutEventsOrBuilderList();

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEventOrBuilder
        getMoveOutEventsOrBuilder(int index);
  }

  /**
   *
   *
   * <pre>
   * A partition event record describes key range changes for a change stream
   * partition. The changes to a row defined by its primary key can be captured
   * in one change stream partition for a specific time range, and then be
   * captured in a different change stream partition for a different time range.
   * This movement of key ranges across change stream partitions is a reflection
   * of activities, such as Spanner's dynamic splitting and load balancing, etc.
   * Processing this event is needed if users want to guarantee processing of
   * the changes for any key in timestamp order. If time ordered processing of
   * changes for a primary key is not needed, this event can be ignored.
   * To guarantee time ordered processing for each primary key, if the event
   * describes move-ins, the reader of this partition needs to wait until the
   * readers of the source partitions have processed all records with timestamps
   * &lt;= this PartitionEventRecord.commit_timestamp, before advancing beyond this
   * PartitionEventRecord. If the event describes move-outs, the reader can
   * notify the readers of the destination partitions that they can continue
   * processing.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionEventRecord}
   */
  public static final class PartitionEventRecord extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord)
      PartitionEventRecordOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PartitionEventRecord.newBuilder() to construct.
    private PartitionEventRecord(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PartitionEventRecord() {
      recordSequence_ = "";
      partitionToken_ = "";
      moveInEvents_ = java.util.Collections.emptyList();
      moveOutEvents_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PartitionEventRecord();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.class,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.Builder.class);
    }

    public interface MoveInEventOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * An unique partition identifier describing the source change stream
       * partition that recorded changes for the key range that is moving
       * into this partition.
       * </pre>
       *
       * <code>string source_partition_token = 1;</code>
       *
       * @return The sourcePartitionToken.
       */
      java.lang.String getSourcePartitionToken();

      /**
       *
       *
       * <pre>
       * An unique partition identifier describing the source change stream
       * partition that recorded changes for the key range that is moving
       * into this partition.
       * </pre>
       *
       * <code>string source_partition_token = 1;</code>
       *
       * @return The bytes for sourcePartitionToken.
       */
      com.google.protobuf.ByteString getSourcePartitionTokenBytes();
    }

    /**
     *
     *
     * <pre>
     * Describes move-in of the key ranges into the change stream partition
     * identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * To maintain processing the changes for a particular key in timestamp
     * order, the query processing the change stream partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * should not advance beyond the partition event record commit timestamp
     * until the queries processing the source change stream partitions have
     * processed all change stream records with timestamps &lt;= the partition
     * event record commit timestamp.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent}
     */
    public static final class MoveInEvent extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent)
        MoveInEventOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use MoveInEvent.newBuilder() to construct.
      private MoveInEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MoveInEvent() {
        sourcePartitionToken_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MoveInEvent();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveInEvent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveInEvent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.class,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder
                    .class);
      }

      public static final int SOURCE_PARTITION_TOKEN_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object sourcePartitionToken_ = "";

      /**
       *
       *
       * <pre>
       * An unique partition identifier describing the source change stream
       * partition that recorded changes for the key range that is moving
       * into this partition.
       * </pre>
       *
       * <code>string source_partition_token = 1;</code>
       *
       * @return The sourcePartitionToken.
       */
      @java.lang.Override
      public java.lang.String getSourcePartitionToken() {
        java.lang.Object ref = sourcePartitionToken_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          sourcePartitionToken_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * An unique partition identifier describing the source change stream
       * partition that recorded changes for the key range that is moving
       * into this partition.
       * </pre>
       *
       * <code>string source_partition_token = 1;</code>
       *
       * @return The bytes for sourcePartitionToken.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSourcePartitionTokenBytes() {
        java.lang.Object ref = sourcePartitionToken_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          sourcePartitionToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourcePartitionToken_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, sourcePartitionToken_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourcePartitionToken_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(1, sourcePartitionToken_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent)) {
          return super.equals(obj);
        }
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent other =
            (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent) obj;

        if (!getSourcePartitionToken().equals(other.getSourcePartitionToken())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SOURCE_PARTITION_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getSourcePartitionToken().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Describes move-in of the key ranges into the change stream partition
       * identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * To maintain processing the changes for a particular key in timestamp
       * order, the query processing the change stream partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
       * should not advance beyond the partition event record commit timestamp
       * until the queries processing the source change stream partitions have
       * processed all change stream records with timestamps &lt;= the partition
       * event record commit timestamp.
       * </pre>
       *
       * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent)
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEventOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveInEvent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveInEvent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.class,
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder
                      .class);
        }

        // Construct using
        // com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          sourcePartitionToken_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveInEvent_descriptor;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
            getDefaultInstanceForType() {
          return com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent build() {
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
            buildPartial() {
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent result =
              new com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.sourcePartitionToken_ = sourcePartitionToken_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent) {
            return mergeFrom(
                (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent other) {
          if (other
              == com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
                  .getDefaultInstance()) return this;
          if (!other.getSourcePartitionToken().isEmpty()) {
            sourcePartitionToken_ = other.sourcePartitionToken_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    sourcePartitionToken_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object sourcePartitionToken_ = "";

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the source change stream
         * partition that recorded changes for the key range that is moving
         * into this partition.
         * </pre>
         *
         * <code>string source_partition_token = 1;</code>
         *
         * @return The sourcePartitionToken.
         */
        public java.lang.String getSourcePartitionToken() {
          java.lang.Object ref = sourcePartitionToken_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            sourcePartitionToken_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the source change stream
         * partition that recorded changes for the key range that is moving
         * into this partition.
         * </pre>
         *
         * <code>string source_partition_token = 1;</code>
         *
         * @return The bytes for sourcePartitionToken.
         */
        public com.google.protobuf.ByteString getSourcePartitionTokenBytes() {
          java.lang.Object ref = sourcePartitionToken_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            sourcePartitionToken_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the source change stream
         * partition that recorded changes for the key range that is moving
         * into this partition.
         * </pre>
         *
         * <code>string source_partition_token = 1;</code>
         *
         * @param value The sourcePartitionToken to set.
         * @return This builder for chaining.
         */
        public Builder setSourcePartitionToken(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          sourcePartitionToken_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the source change stream
         * partition that recorded changes for the key range that is moving
         * into this partition.
         * </pre>
         *
         * <code>string source_partition_token = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSourcePartitionToken() {
          sourcePartitionToken_ = getDefaultInstance().getSourcePartitionToken();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the source change stream
         * partition that recorded changes for the key range that is moving
         * into this partition.
         * </pre>
         *
         * <code>string source_partition_token = 1;</code>
         *
         * @param value The bytes for sourcePartitionToken to set.
         * @return This builder for chaining.
         */
        public Builder setSourcePartitionTokenBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          sourcePartitionToken_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent)
      }

      // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent)
      private static final com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent();
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MoveInEvent> PARSER =
          new com.google.protobuf.AbstractParser<MoveInEvent>() {
            @java.lang.Override
            public MoveInEvent parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MoveInEvent> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MoveInEvent> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface MoveOutEventOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * An unique partition identifier describing the destination change
       * stream partition that will record changes for the key range that is
       * moving out of this partition.
       * </pre>
       *
       * <code>string destination_partition_token = 1;</code>
       *
       * @return The destinationPartitionToken.
       */
      java.lang.String getDestinationPartitionToken();

      /**
       *
       *
       * <pre>
       * An unique partition identifier describing the destination change
       * stream partition that will record changes for the key range that is
       * moving out of this partition.
       * </pre>
       *
       * <code>string destination_partition_token = 1;</code>
       *
       * @return The bytes for destinationPartitionToken.
       */
      com.google.protobuf.ByteString getDestinationPartitionTokenBytes();
    }

    /**
     *
     *
     * <pre>
     * Describes move-out of the key ranges out of the change stream partition
     * identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * To maintain processing the changes for a particular key in timestamp
     * order, the query processing the
     * [MoveOutEvent][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent]
     * in the partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * should inform the queries processing the destination partitions that
     * they can unblock and proceed processing records past the
     * [commit_timestamp][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.commit_timestamp].
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent}
     */
    public static final class MoveOutEvent extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent)
        MoveOutEventOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use MoveOutEvent.newBuilder() to construct.
      private MoveOutEvent(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private MoveOutEvent() {
        destinationPartitionToken_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new MoveOutEvent();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveOutEvent_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveOutEvent_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.class,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder
                    .class);
      }

      public static final int DESTINATION_PARTITION_TOKEN_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object destinationPartitionToken_ = "";

      /**
       *
       *
       * <pre>
       * An unique partition identifier describing the destination change
       * stream partition that will record changes for the key range that is
       * moving out of this partition.
       * </pre>
       *
       * <code>string destination_partition_token = 1;</code>
       *
       * @return The destinationPartitionToken.
       */
      @java.lang.Override
      public java.lang.String getDestinationPartitionToken() {
        java.lang.Object ref = destinationPartitionToken_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          destinationPartitionToken_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * An unique partition identifier describing the destination change
       * stream partition that will record changes for the key range that is
       * moving out of this partition.
       * </pre>
       *
       * <code>string destination_partition_token = 1;</code>
       *
       * @return The bytes for destinationPartitionToken.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDestinationPartitionTokenBytes() {
        java.lang.Object ref = destinationPartitionToken_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          destinationPartitionToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationPartitionToken_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, destinationPartitionToken_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(destinationPartitionToken_)) {
          size +=
              com.google.protobuf.GeneratedMessageV3.computeStringSize(
                  1, destinationPartitionToken_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent)) {
          return super.equals(obj);
        }
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent other =
            (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent) obj;

        if (!getDestinationPartitionToken().equals(other.getDestinationPartitionToken()))
          return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + DESTINATION_PARTITION_TOKEN_FIELD_NUMBER;
        hash = (53 * hash) + getDestinationPartitionToken().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Describes move-out of the key ranges out of the change stream partition
       * identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * To maintain processing the changes for a particular key in timestamp
       * order, the query processing the
       * [MoveOutEvent][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent]
       * in the partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
       * should inform the queries processing the destination partitions that
       * they can unblock and proceed processing records past the
       * [commit_timestamp][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.commit_timestamp].
       * </pre>
       *
       * Protobuf type {@code
       * google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent)
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEventOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveOutEvent_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveOutEvent_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.class,
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder
                      .class);
        }

        // Construct using
        // com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          destinationPartitionToken_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.spanner.v1.ChangeStreamProto
              .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_MoveOutEvent_descriptor;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
            getDefaultInstanceForType() {
          return com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent build() {
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
            buildPartial() {
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent result =
              new com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.destinationPartitionToken_ = destinationPartitionToken_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent) {
            return mergeFrom(
                (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent other) {
          if (other
              == com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
                  .getDefaultInstance()) return this;
          if (!other.getDestinationPartitionToken().isEmpty()) {
            destinationPartitionToken_ = other.destinationPartitionToken_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    destinationPartitionToken_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object destinationPartitionToken_ = "";

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the destination change
         * stream partition that will record changes for the key range that is
         * moving out of this partition.
         * </pre>
         *
         * <code>string destination_partition_token = 1;</code>
         *
         * @return The destinationPartitionToken.
         */
        public java.lang.String getDestinationPartitionToken() {
          java.lang.Object ref = destinationPartitionToken_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            destinationPartitionToken_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the destination change
         * stream partition that will record changes for the key range that is
         * moving out of this partition.
         * </pre>
         *
         * <code>string destination_partition_token = 1;</code>
         *
         * @return The bytes for destinationPartitionToken.
         */
        public com.google.protobuf.ByteString getDestinationPartitionTokenBytes() {
          java.lang.Object ref = destinationPartitionToken_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            destinationPartitionToken_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the destination change
         * stream partition that will record changes for the key range that is
         * moving out of this partition.
         * </pre>
         *
         * <code>string destination_partition_token = 1;</code>
         *
         * @param value The destinationPartitionToken to set.
         * @return This builder for chaining.
         */
        public Builder setDestinationPartitionToken(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          destinationPartitionToken_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the destination change
         * stream partition that will record changes for the key range that is
         * moving out of this partition.
         * </pre>
         *
         * <code>string destination_partition_token = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDestinationPartitionToken() {
          destinationPartitionToken_ = getDefaultInstance().getDestinationPartitionToken();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * An unique partition identifier describing the destination change
         * stream partition that will record changes for the key range that is
         * moving out of this partition.
         * </pre>
         *
         * <code>string destination_partition_token = 1;</code>
         *
         * @param value The bytes for destinationPartitionToken to set.
         * @return This builder for chaining.
         */
        public Builder setDestinationPartitionTokenBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          destinationPartitionToken_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent)
      }

      // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent)
      private static final com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
              .MoveOutEvent
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent();
      }

      public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<MoveOutEvent> PARSER =
          new com.google.protobuf.AbstractParser<MoveOutEvent>() {
            @java.lang.Override
            public MoveOutEvent parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<MoveOutEvent> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<MoveOutEvent> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int COMMIT_TIMESTAMP_FIELD_NUMBER = 1;
    private com.google.protobuf.Timestamp commitTimestamp_;

    /**
     *
     *
     * <pre>
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return Whether the commitTimestamp field is set.
     */
    @java.lang.Override
    public boolean hasCommitTimestamp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     *
     * @return The commitTimestamp.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getCommitTimestamp() {
      return commitTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : commitTimestamp_;
    }

    /**
     *
     *
     * <pre>
     * Indicates the commit timestamp at which the key range change occurred.
     * DataChangeRecord.commit_timestamps,
     * PartitionStartRecord.start_timestamps,
     * PartitionEventRecord.commit_timestamps, and
     * PartitionEndRecord.end_timestamps can have the same value in the same
     * partition.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder() {
      return commitTimestamp_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : commitTimestamp_;
    }

    public static final int RECORD_SEQUENCE_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object recordSequence_ = "";

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The recordSequence.
     */
    @java.lang.Override
    public java.lang.String getRecordSequence() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        recordSequence_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Record sequence numbers are unique and monotonically increasing (but not
     * necessarily contiguous) for a specific timestamp across record
     * types in the same partition. To guarantee ordered processing, the reader
     * should process records (of potentially different types) in
     * record_sequence order for a specific timestamp in the same partition.
     * </pre>
     *
     * <code>string record_sequence = 2;</code>
     *
     * @return The bytes for recordSequence.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRecordSequenceBytes() {
      java.lang.Object ref = recordSequence_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        recordSequence_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PARTITION_TOKEN_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object partitionToken_ = "";

    /**
     *
     *
     * <pre>
     * Unique partition identifier describing the partition this event
     * occurred on.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEventRecord.
     * </pre>
     *
     * <code>string partition_token = 3;</code>
     *
     * @return The partitionToken.
     */
    @java.lang.Override
    public java.lang.String getPartitionToken() {
      java.lang.Object ref = partitionToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        partitionToken_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Unique partition identifier describing the partition this event
     * occurred on.
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
     * is equal to the partition token of the change stream partition currently
     * queried to return this PartitionEventRecord.
     * </pre>
     *
     * <code>string partition_token = 3;</code>
     *
     * @return The bytes for partitionToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPartitionTokenBytes() {
      java.lang.Object ref = partitionToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        partitionToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MOVE_IN_EVENTS_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent>
        moveInEvents_;

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent>
        getMoveInEventsList() {
      return moveInEvents_;
    }

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEventOrBuilder>
        getMoveInEventsOrBuilderList() {
      return moveInEvents_;
    }

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    @java.lang.Override
    public int getMoveInEventsCount() {
      return moveInEvents_.size();
    }

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
        getMoveInEvents(int index) {
      return moveInEvents_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved into the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved into partition (P1) from partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_in_events {
     *     source_partition_token: "P2"
     *   }
     *   move_in_events {
     *     source_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_out_events {
     *     destination_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEventOrBuilder
        getMoveInEventsOrBuilder(int index) {
      return moveInEvents_.get(index);
    }

    public static final int MOVE_OUT_EVENTS_FIELD_NUMBER = 5;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent>
        moveOutEvents_;

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent>
        getMoveOutEventsList() {
      return moveOutEvents_;
    }

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEventOrBuilder>
        getMoveOutEventsOrBuilderList() {
      return moveOutEvents_;
    }

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    @java.lang.Override
    public int getMoveOutEventsCount() {
      return moveOutEvents_.size();
    }

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
        getMoveOutEvents(int index) {
      return moveOutEvents_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Set when one or more key ranges are moved out of the change stream
     * partition identified by
     * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
     *
     * Example: Two key ranges are moved out of partition (P1) to partition (P2)
     * and partition (P3) in a single transaction at timestamp T.
     *
     * The PartitionEventRecord returned in P1 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P1"
     *   move_out_events {
     *     destination_partition_token: "P2"
     *   }
     *   move_out_events {
     *     destination_partition_token: "P3"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P2 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P2"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     *
     * The PartitionEventRecord returned in P3 will reflect the move as:
     *
     * PartitionEventRecord {
     *   commit_timestamp: T
     *   partition_token: "P3"
     *   move_in_events {
     *     source_partition_token: "P1"
     *   }
     * }
     * </pre>
     *
     * <code>
     * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEventOrBuilder
        getMoveOutEventsOrBuilder(int index) {
      return moveOutEvents_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getCommitTimestamp());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, recordSequence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(partitionToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, partitionToken_);
      }
      for (int i = 0; i < moveInEvents_.size(); i++) {
        output.writeMessage(4, moveInEvents_.get(i));
      }
      for (int i = 0; i < moveOutEvents_.size(); i++) {
        output.writeMessage(5, moveOutEvents_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getCommitTimestamp());
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(recordSequence_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, recordSequence_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(partitionToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, partitionToken_);
      }
      for (int i = 0; i < moveInEvents_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, moveInEvents_.get(i));
      }
      for (int i = 0; i < moveOutEvents_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, moveOutEvents_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord)) {
        return super.equals(obj);
      }
      com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord other =
          (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) obj;

      if (hasCommitTimestamp() != other.hasCommitTimestamp()) return false;
      if (hasCommitTimestamp()) {
        if (!getCommitTimestamp().equals(other.getCommitTimestamp())) return false;
      }
      if (!getRecordSequence().equals(other.getRecordSequence())) return false;
      if (!getPartitionToken().equals(other.getPartitionToken())) return false;
      if (!getMoveInEventsList().equals(other.getMoveInEventsList())) return false;
      if (!getMoveOutEventsList().equals(other.getMoveOutEventsList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasCommitTimestamp()) {
        hash = (37 * hash) + COMMIT_TIMESTAMP_FIELD_NUMBER;
        hash = (53 * hash) + getCommitTimestamp().hashCode();
      }
      hash = (37 * hash) + RECORD_SEQUENCE_FIELD_NUMBER;
      hash = (53 * hash) + getRecordSequence().hashCode();
      hash = (37 * hash) + PARTITION_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionToken().hashCode();
      if (getMoveInEventsCount() > 0) {
        hash = (37 * hash) + MOVE_IN_EVENTS_FIELD_NUMBER;
        hash = (53 * hash) + getMoveInEventsList().hashCode();
      }
      if (getMoveOutEventsCount() > 0) {
        hash = (37 * hash) + MOVE_OUT_EVENTS_FIELD_NUMBER;
        hash = (53 * hash) + getMoveOutEventsList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A partition event record describes key range changes for a change stream
     * partition. The changes to a row defined by its primary key can be captured
     * in one change stream partition for a specific time range, and then be
     * captured in a different change stream partition for a different time range.
     * This movement of key ranges across change stream partitions is a reflection
     * of activities, such as Spanner's dynamic splitting and load balancing, etc.
     * Processing this event is needed if users want to guarantee processing of
     * the changes for any key in timestamp order. If time ordered processing of
     * changes for a primary key is not needed, this event can be ignored.
     * To guarantee time ordered processing for each primary key, if the event
     * describes move-ins, the reader of this partition needs to wait until the
     * readers of the source partitions have processed all records with timestamps
     * &lt;= this PartitionEventRecord.commit_timestamp, before advancing beyond this
     * PartitionEventRecord. If the event describes move-outs, the reader can
     * notify the readers of the destination partitions that they can continue
     * processing.
     * </pre>
     *
     * Protobuf type {@code google.spanner.v1.ChangeStreamRecord.PartitionEventRecord}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord)
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecordOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.class,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.Builder.class);
      }

      // Construct using com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getCommitTimestampFieldBuilder();
          getMoveInEventsFieldBuilder();
          getMoveOutEventsFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        commitTimestamp_ = null;
        if (commitTimestampBuilder_ != null) {
          commitTimestampBuilder_.dispose();
          commitTimestampBuilder_ = null;
        }
        recordSequence_ = "";
        partitionToken_ = "";
        if (moveInEventsBuilder_ == null) {
          moveInEvents_ = java.util.Collections.emptyList();
        } else {
          moveInEvents_ = null;
          moveInEventsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000008);
        if (moveOutEventsBuilder_ == null) {
          moveOutEvents_ = java.util.Collections.emptyList();
        } else {
          moveOutEvents_ = null;
          moveOutEventsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000010);
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.v1.ChangeStreamProto
            .internal_static_google_spanner_v1_ChangeStreamRecord_PartitionEventRecord_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
          getDefaultInstanceForType() {
        return com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord build() {
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord buildPartial() {
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord result =
            new com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord result) {
        if (moveInEventsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)) {
            moveInEvents_ = java.util.Collections.unmodifiableList(moveInEvents_);
            bitField0_ = (bitField0_ & ~0x00000008);
          }
          result.moveInEvents_ = moveInEvents_;
        } else {
          result.moveInEvents_ = moveInEventsBuilder_.build();
        }
        if (moveOutEventsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)) {
            moveOutEvents_ = java.util.Collections.unmodifiableList(moveOutEvents_);
            bitField0_ = (bitField0_ & ~0x00000010);
          }
          result.moveOutEvents_ = moveOutEvents_;
        } else {
          result.moveOutEvents_ = moveOutEventsBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.commitTimestamp_ =
              commitTimestampBuilder_ == null ? commitTimestamp_ : commitTimestampBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.recordSequence_ = recordSequence_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.partitionToken_ = partitionToken_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) {
          return mergeFrom((com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord other) {
        if (other
            == com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.getDefaultInstance())
          return this;
        if (other.hasCommitTimestamp()) {
          mergeCommitTimestamp(other.getCommitTimestamp());
        }
        if (!other.getRecordSequence().isEmpty()) {
          recordSequence_ = other.recordSequence_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getPartitionToken().isEmpty()) {
          partitionToken_ = other.partitionToken_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (moveInEventsBuilder_ == null) {
          if (!other.moveInEvents_.isEmpty()) {
            if (moveInEvents_.isEmpty()) {
              moveInEvents_ = other.moveInEvents_;
              bitField0_ = (bitField0_ & ~0x00000008);
            } else {
              ensureMoveInEventsIsMutable();
              moveInEvents_.addAll(other.moveInEvents_);
            }
            onChanged();
          }
        } else {
          if (!other.moveInEvents_.isEmpty()) {
            if (moveInEventsBuilder_.isEmpty()) {
              moveInEventsBuilder_.dispose();
              moveInEventsBuilder_ = null;
              moveInEvents_ = other.moveInEvents_;
              bitField0_ = (bitField0_ & ~0x00000008);
              moveInEventsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMoveInEventsFieldBuilder()
                      : null;
            } else {
              moveInEventsBuilder_.addAllMessages(other.moveInEvents_);
            }
          }
        }
        if (moveOutEventsBuilder_ == null) {
          if (!other.moveOutEvents_.isEmpty()) {
            if (moveOutEvents_.isEmpty()) {
              moveOutEvents_ = other.moveOutEvents_;
              bitField0_ = (bitField0_ & ~0x00000010);
            } else {
              ensureMoveOutEventsIsMutable();
              moveOutEvents_.addAll(other.moveOutEvents_);
            }
            onChanged();
          }
        } else {
          if (!other.moveOutEvents_.isEmpty()) {
            if (moveOutEventsBuilder_.isEmpty()) {
              moveOutEventsBuilder_.dispose();
              moveOutEventsBuilder_ = null;
              moveOutEvents_ = other.moveOutEvents_;
              bitField0_ = (bitField0_ & ~0x00000010);
              moveOutEventsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getMoveOutEventsFieldBuilder()
                      : null;
            } else {
              moveOutEventsBuilder_.addAllMessages(other.moveOutEvents_);
            }
          }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getCommitTimestampFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  recordSequence_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  partitionToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent m =
                      input.readMessage(
                          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
                              .parser(),
                          extensionRegistry);
                  if (moveInEventsBuilder_ == null) {
                    ensureMoveInEventsIsMutable();
                    moveInEvents_.add(m);
                  } else {
                    moveInEventsBuilder_.addMessage(m);
                  }
                  break;
                } // case 34
              case 42:
                {
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent m =
                      input.readMessage(
                          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
                              .parser(),
                          extensionRegistry);
                  if (moveOutEventsBuilder_ == null) {
                    ensureMoveOutEventsIsMutable();
                    moveOutEvents_.add(m);
                  } else {
                    moveOutEventsBuilder_.addMessage(m);
                  }
                  break;
                } // case 42
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Timestamp commitTimestamp_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          commitTimestampBuilder_;

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       *
       * @return Whether the commitTimestamp field is set.
       */
      public boolean hasCommitTimestamp() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       *
       * @return The commitTimestamp.
       */
      public com.google.protobuf.Timestamp getCommitTimestamp() {
        if (commitTimestampBuilder_ == null) {
          return commitTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTimestamp_;
        } else {
          return commitTimestampBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public Builder setCommitTimestamp(com.google.protobuf.Timestamp value) {
        if (commitTimestampBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          commitTimestamp_ = value;
        } else {
          commitTimestampBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public Builder setCommitTimestamp(com.google.protobuf.Timestamp.Builder builderForValue) {
        if (commitTimestampBuilder_ == null) {
          commitTimestamp_ = builderForValue.build();
        } else {
          commitTimestampBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public Builder mergeCommitTimestamp(com.google.protobuf.Timestamp value) {
        if (commitTimestampBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && commitTimestamp_ != null
              && commitTimestamp_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getCommitTimestampBuilder().mergeFrom(value);
          } else {
            commitTimestamp_ = value;
          }
        } else {
          commitTimestampBuilder_.mergeFrom(value);
        }
        if (commitTimestamp_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public Builder clearCommitTimestamp() {
        bitField0_ = (bitField0_ & ~0x00000001);
        commitTimestamp_ = null;
        if (commitTimestampBuilder_ != null) {
          commitTimestampBuilder_.dispose();
          commitTimestampBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public com.google.protobuf.Timestamp.Builder getCommitTimestampBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getCommitTimestampFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getCommitTimestampOrBuilder() {
        if (commitTimestampBuilder_ != null) {
          return commitTimestampBuilder_.getMessageOrBuilder();
        } else {
          return commitTimestamp_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : commitTimestamp_;
        }
      }

      /**
       *
       *
       * <pre>
       * Indicates the commit timestamp at which the key range change occurred.
       * DataChangeRecord.commit_timestamps,
       * PartitionStartRecord.start_timestamps,
       * PartitionEventRecord.commit_timestamps, and
       * PartitionEndRecord.end_timestamps can have the same value in the same
       * partition.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp commit_timestamp = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getCommitTimestampFieldBuilder() {
        if (commitTimestampBuilder_ == null) {
          commitTimestampBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getCommitTimestamp(), getParentForChildren(), isClean());
          commitTimestamp_ = null;
        }
        return commitTimestampBuilder_;
      }

      private java.lang.Object recordSequence_ = "";

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return The recordSequence.
       */
      public java.lang.String getRecordSequence() {
        java.lang.Object ref = recordSequence_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          recordSequence_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return The bytes for recordSequence.
       */
      public com.google.protobuf.ByteString getRecordSequenceBytes() {
        java.lang.Object ref = recordSequence_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          recordSequence_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @param value The recordSequence to set.
       * @return This builder for chaining.
       */
      public Builder setRecordSequence(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        recordSequence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRecordSequence() {
        recordSequence_ = getDefaultInstance().getRecordSequence();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Record sequence numbers are unique and monotonically increasing (but not
       * necessarily contiguous) for a specific timestamp across record
       * types in the same partition. To guarantee ordered processing, the reader
       * should process records (of potentially different types) in
       * record_sequence order for a specific timestamp in the same partition.
       * </pre>
       *
       * <code>string record_sequence = 2;</code>
       *
       * @param value The bytes for recordSequence to set.
       * @return This builder for chaining.
       */
      public Builder setRecordSequenceBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        recordSequence_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object partitionToken_ = "";

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the partition this event
       * occurred on.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEventRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @return The partitionToken.
       */
      public java.lang.String getPartitionToken() {
        java.lang.Object ref = partitionToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          partitionToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the partition this event
       * occurred on.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEventRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @return The bytes for partitionToken.
       */
      public com.google.protobuf.ByteString getPartitionTokenBytes() {
        java.lang.Object ref = partitionToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          partitionToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the partition this event
       * occurred on.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEventRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @param value The partitionToken to set.
       * @return This builder for chaining.
       */
      public Builder setPartitionToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        partitionToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the partition this event
       * occurred on.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEventRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPartitionToken() {
        partitionToken_ = getDefaultInstance().getPartitionToken();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Unique partition identifier describing the partition this event
       * occurred on.
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token]
       * is equal to the partition token of the change stream partition currently
       * queried to return this PartitionEventRecord.
       * </pre>
       *
       * <code>string partition_token = 3;</code>
       *
       * @param value The bytes for partitionToken to set.
       * @return This builder for chaining.
       */
      public Builder setPartitionTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        partitionToken_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent>
          moveInEvents_ = java.util.Collections.emptyList();

      private void ensureMoveInEventsIsMutable() {
        if (!((bitField0_ & 0x00000008) != 0)) {
          moveInEvents_ =
              new java.util.ArrayList<
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent>(
                  moveInEvents_);
          bitField0_ |= 0x00000008;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEventOrBuilder>
          moveInEventsBuilder_;

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent>
          getMoveInEventsList() {
        if (moveInEventsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(moveInEvents_);
        } else {
          return moveInEventsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public int getMoveInEventsCount() {
        if (moveInEventsBuilder_ == null) {
          return moveInEvents_.size();
        } else {
          return moveInEventsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
          getMoveInEvents(int index) {
        if (moveInEventsBuilder_ == null) {
          return moveInEvents_.get(index);
        } else {
          return moveInEventsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder setMoveInEvents(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent value) {
        if (moveInEventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMoveInEventsIsMutable();
          moveInEvents_.set(index, value);
          onChanged();
        } else {
          moveInEventsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder setMoveInEvents(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder
              builderForValue) {
        if (moveInEventsBuilder_ == null) {
          ensureMoveInEventsIsMutable();
          moveInEvents_.set(index, builderForValue.build());
          onChanged();
        } else {
          moveInEventsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder addMoveInEvents(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent value) {
        if (moveInEventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMoveInEventsIsMutable();
          moveInEvents_.add(value);
          onChanged();
        } else {
          moveInEventsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder addMoveInEvents(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent value) {
        if (moveInEventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMoveInEventsIsMutable();
          moveInEvents_.add(index, value);
          onChanged();
        } else {
          moveInEventsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder addMoveInEvents(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder
              builderForValue) {
        if (moveInEventsBuilder_ == null) {
          ensureMoveInEventsIsMutable();
          moveInEvents_.add(builderForValue.build());
          onChanged();
        } else {
          moveInEventsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder addMoveInEvents(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder
              builderForValue) {
        if (moveInEventsBuilder_ == null) {
          ensureMoveInEventsIsMutable();
          moveInEvents_.add(index, builderForValue.build());
          onChanged();
        } else {
          moveInEventsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder addAllMoveInEvents(
          java.lang.Iterable<
                  ? extends
                      com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent>
              values) {
        if (moveInEventsBuilder_ == null) {
          ensureMoveInEventsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, moveInEvents_);
          onChanged();
        } else {
          moveInEventsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder clearMoveInEvents() {
        if (moveInEventsBuilder_ == null) {
          moveInEvents_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
        } else {
          moveInEventsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public Builder removeMoveInEvents(int index) {
        if (moveInEventsBuilder_ == null) {
          ensureMoveInEventsIsMutable();
          moveInEvents_.remove(index);
          onChanged();
        } else {
          moveInEventsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder
          getMoveInEventsBuilder(int index) {
        return getMoveInEventsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEventOrBuilder
          getMoveInEventsOrBuilder(int index) {
        if (moveInEventsBuilder_ == null) {
          return moveInEvents_.get(index);
        } else {
          return moveInEventsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
                      .MoveInEventOrBuilder>
          getMoveInEventsOrBuilderList() {
        if (moveInEventsBuilder_ != null) {
          return moveInEventsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(moveInEvents_);
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder
          addMoveInEventsBuilder() {
        return getMoveInEventsFieldBuilder()
            .addBuilder(
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder
          addMoveInEventsBuilder(int index) {
        return getMoveInEventsFieldBuilder()
            .addBuilder(
                index,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved into the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved into partition (P1) from partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_in_events {
       *     source_partition_token: "P2"
       *   }
       *   move_in_events {
       *     source_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_out_events {
       *     destination_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent move_in_events = 4;
       * </code>
       */
      public java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder>
          getMoveInEventsBuilderList() {
        return getMoveInEventsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEventOrBuilder>
          getMoveInEventsFieldBuilder() {
        if (moveInEventsBuilder_ == null) {
          moveInEventsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent,
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveInEvent.Builder,
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
                      .MoveInEventOrBuilder>(
                  moveInEvents_,
                  ((bitField0_ & 0x00000008) != 0),
                  getParentForChildren(),
                  isClean());
          moveInEvents_ = null;
        }
        return moveInEventsBuilder_;
      }

      private java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent>
          moveOutEvents_ = java.util.Collections.emptyList();

      private void ensureMoveOutEventsIsMutable() {
        if (!((bitField0_ & 0x00000010) != 0)) {
          moveOutEvents_ =
              new java.util.ArrayList<
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent>(
                  moveOutEvents_);
          bitField0_ |= 0x00000010;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEventOrBuilder>
          moveOutEventsBuilder_;

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent>
          getMoveOutEventsList() {
        if (moveOutEventsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(moveOutEvents_);
        } else {
          return moveOutEventsBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public int getMoveOutEventsCount() {
        if (moveOutEventsBuilder_ == null) {
          return moveOutEvents_.size();
        } else {
          return moveOutEventsBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
          getMoveOutEvents(int index) {
        if (moveOutEventsBuilder_ == null) {
          return moveOutEvents_.get(index);
        } else {
          return moveOutEventsBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder setMoveOutEvents(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent value) {
        if (moveOutEventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMoveOutEventsIsMutable();
          moveOutEvents_.set(index, value);
          onChanged();
        } else {
          moveOutEventsBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder setMoveOutEvents(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder
              builderForValue) {
        if (moveOutEventsBuilder_ == null) {
          ensureMoveOutEventsIsMutable();
          moveOutEvents_.set(index, builderForValue.build());
          onChanged();
        } else {
          moveOutEventsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder addMoveOutEvents(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent value) {
        if (moveOutEventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMoveOutEventsIsMutable();
          moveOutEvents_.add(value);
          onChanged();
        } else {
          moveOutEventsBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder addMoveOutEvents(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent value) {
        if (moveOutEventsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureMoveOutEventsIsMutable();
          moveOutEvents_.add(index, value);
          onChanged();
        } else {
          moveOutEventsBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder addMoveOutEvents(
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder
              builderForValue) {
        if (moveOutEventsBuilder_ == null) {
          ensureMoveOutEventsIsMutable();
          moveOutEvents_.add(builderForValue.build());
          onChanged();
        } else {
          moveOutEventsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder addMoveOutEvents(
          int index,
          com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder
              builderForValue) {
        if (moveOutEventsBuilder_ == null) {
          ensureMoveOutEventsIsMutable();
          moveOutEvents_.add(index, builderForValue.build());
          onChanged();
        } else {
          moveOutEventsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder addAllMoveOutEvents(
          java.lang.Iterable<
                  ? extends
                      com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent>
              values) {
        if (moveOutEventsBuilder_ == null) {
          ensureMoveOutEventsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, moveOutEvents_);
          onChanged();
        } else {
          moveOutEventsBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder clearMoveOutEvents() {
        if (moveOutEventsBuilder_ == null) {
          moveOutEvents_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000010);
          onChanged();
        } else {
          moveOutEventsBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public Builder removeMoveOutEvents(int index) {
        if (moveOutEventsBuilder_ == null) {
          ensureMoveOutEventsIsMutable();
          moveOutEvents_.remove(index);
          onChanged();
        } else {
          moveOutEventsBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder
          getMoveOutEventsBuilder(int index) {
        return getMoveOutEventsFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEventOrBuilder
          getMoveOutEventsOrBuilder(int index) {
        if (moveOutEventsBuilder_ == null) {
          return moveOutEvents_.get(index);
        } else {
          return moveOutEventsBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
                      .MoveOutEventOrBuilder>
          getMoveOutEventsOrBuilderList() {
        if (moveOutEventsBuilder_ != null) {
          return moveOutEventsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(moveOutEvents_);
        }
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder
          addMoveOutEventsBuilder() {
        return getMoveOutEventsFieldBuilder()
            .addBuilder(
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder
          addMoveOutEventsBuilder(int index) {
        return getMoveOutEventsFieldBuilder()
            .addBuilder(
                index,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
                    .getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Set when one or more key ranges are moved out of the change stream
       * partition identified by
       * [partition_token][google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.partition_token].
       *
       * Example: Two key ranges are moved out of partition (P1) to partition (P2)
       * and partition (P3) in a single transaction at timestamp T.
       *
       * The PartitionEventRecord returned in P1 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P1"
       *   move_out_events {
       *     destination_partition_token: "P2"
       *   }
       *   move_out_events {
       *     destination_partition_token: "P3"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P2 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P2"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       *
       * The PartitionEventRecord returned in P3 will reflect the move as:
       *
       * PartitionEventRecord {
       *   commit_timestamp: T
       *   partition_token: "P3"
       *   move_in_events {
       *     source_partition_token: "P1"
       *   }
       * }
       * </pre>
       *
       * <code>
       * repeated .google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent move_out_events = 5;
       * </code>
       */
      public java.util.List<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder>
          getMoveOutEventsBuilderList() {
        return getMoveOutEventsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent.Builder,
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEventOrBuilder>
          getMoveOutEventsFieldBuilder() {
        if (moveOutEventsBuilder_ == null) {
          moveOutEventsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent,
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.MoveOutEvent
                      .Builder,
                  com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
                      .MoveOutEventOrBuilder>(
                  moveOutEvents_,
                  ((bitField0_ & 0x00000010) != 0),
                  getParentForChildren(),
                  isClean());
          moveOutEvents_ = null;
        }
        return moveOutEventsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord.PartitionEventRecord)
    private static final com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord();
    }

    public static com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PartitionEventRecord> PARSER =
        new com.google.protobuf.AbstractParser<PartitionEventRecord>() {
          @java.lang.Override
          public PartitionEventRecord parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PartitionEventRecord> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PartitionEventRecord> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int recordCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object record_;

  public enum RecordCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DATA_CHANGE_RECORD(1),
    HEARTBEAT_RECORD(2),
    PARTITION_START_RECORD(3),
    PARTITION_END_RECORD(4),
    PARTITION_EVENT_RECORD(5),
    RECORD_NOT_SET(0);
    private final int value;

    private RecordCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RecordCase valueOf(int value) {
      return forNumber(value);
    }

    public static RecordCase forNumber(int value) {
      switch (value) {
        case 1:
          return DATA_CHANGE_RECORD;
        case 2:
          return HEARTBEAT_RECORD;
        case 3:
          return PARTITION_START_RECORD;
        case 4:
          return PARTITION_END_RECORD;
        case 5:
          return PARTITION_EVENT_RECORD;
        case 0:
          return RECORD_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RecordCase getRecordCase() {
    return RecordCase.forNumber(recordCase_);
  }

  public static final int DATA_CHANGE_RECORD_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Data change record describing a data change for a change stream
   * partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
   *
   * @return Whether the dataChangeRecord field is set.
   */
  @java.lang.Override
  public boolean hasDataChangeRecord() {
    return recordCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Data change record describing a data change for a change stream
   * partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
   *
   * @return The dataChangeRecord.
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord getDataChangeRecord() {
    if (recordCase_ == 1) {
      return (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Data change record describing a data change for a change stream
   * partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecordOrBuilder
      getDataChangeRecordOrBuilder() {
    if (recordCase_ == 1) {
      return (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance();
  }

  public static final int HEARTBEAT_RECORD_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Heartbeat record describing a heartbeat for a change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
   *
   * @return Whether the heartbeatRecord field is set.
   */
  @java.lang.Override
  public boolean hasHeartbeatRecord() {
    return recordCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Heartbeat record describing a heartbeat for a change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
   *
   * @return The heartbeatRecord.
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord getHeartbeatRecord() {
    if (recordCase_ == 2) {
      return (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Heartbeat record describing a heartbeat for a change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecordOrBuilder
      getHeartbeatRecordOrBuilder() {
    if (recordCase_ == 2) {
      return (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance();
  }

  public static final int PARTITION_START_RECORD_FIELD_NUMBER = 3;

  /**
   *
   *
   * <pre>
   * Partition start record describing a new change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
   * </code>
   *
   * @return Whether the partitionStartRecord field is set.
   */
  @java.lang.Override
  public boolean hasPartitionStartRecord() {
    return recordCase_ == 3;
  }

  /**
   *
   *
   * <pre>
   * Partition start record describing a new change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
   * </code>
   *
   * @return The partitionStartRecord.
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord getPartitionStartRecord() {
    if (recordCase_ == 3) {
      return (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Partition start record describing a new change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecordOrBuilder
      getPartitionStartRecordOrBuilder() {
    if (recordCase_ == 3) {
      return (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.getDefaultInstance();
  }

  public static final int PARTITION_END_RECORD_FIELD_NUMBER = 4;

  /**
   *
   *
   * <pre>
   * Partition end record describing a terminated change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;</code>
   *
   * @return Whether the partitionEndRecord field is set.
   */
  @java.lang.Override
  public boolean hasPartitionEndRecord() {
    return recordCase_ == 4;
  }

  /**
   *
   *
   * <pre>
   * Partition end record describing a terminated change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;</code>
   *
   * @return The partitionEndRecord.
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord getPartitionEndRecord() {
    if (recordCase_ == 4) {
      return (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Partition end record describing a terminated change stream partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;</code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecordOrBuilder
      getPartitionEndRecordOrBuilder() {
    if (recordCase_ == 4) {
      return (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.getDefaultInstance();
  }

  public static final int PARTITION_EVENT_RECORD_FIELD_NUMBER = 5;

  /**
   *
   *
   * <pre>
   * Partition event record describing key range changes for a change stream
   * partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
   * </code>
   *
   * @return Whether the partitionEventRecord field is set.
   */
  @java.lang.Override
  public boolean hasPartitionEventRecord() {
    return recordCase_ == 5;
  }

  /**
   *
   *
   * <pre>
   * Partition event record describing key range changes for a change stream
   * partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
   * </code>
   *
   * @return The partitionEventRecord.
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord getPartitionEventRecord() {
    if (recordCase_ == 5) {
      return (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Partition event record describing key range changes for a change stream
   * partition.
   * </pre>
   *
   * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecordOrBuilder
      getPartitionEventRecordOrBuilder() {
    if (recordCase_ == 5) {
      return (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) record_;
    }
    return com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (recordCase_ == 1) {
      output.writeMessage(1, (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) record_);
    }
    if (recordCase_ == 2) {
      output.writeMessage(2, (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) record_);
    }
    if (recordCase_ == 3) {
      output.writeMessage(
          3, (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) record_);
    }
    if (recordCase_ == 4) {
      output.writeMessage(4, (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) record_);
    }
    if (recordCase_ == 5) {
      output.writeMessage(
          5, (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) record_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (recordCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) record_);
    }
    if (recordCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) record_);
    }
    if (recordCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) record_);
    }
    if (recordCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4, (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) record_);
    }
    if (recordCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5, (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) record_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.v1.ChangeStreamRecord)) {
      return super.equals(obj);
    }
    com.google.spanner.v1.ChangeStreamRecord other = (com.google.spanner.v1.ChangeStreamRecord) obj;

    if (!getRecordCase().equals(other.getRecordCase())) return false;
    switch (recordCase_) {
      case 1:
        if (!getDataChangeRecord().equals(other.getDataChangeRecord())) return false;
        break;
      case 2:
        if (!getHeartbeatRecord().equals(other.getHeartbeatRecord())) return false;
        break;
      case 3:
        if (!getPartitionStartRecord().equals(other.getPartitionStartRecord())) return false;
        break;
      case 4:
        if (!getPartitionEndRecord().equals(other.getPartitionEndRecord())) return false;
        break;
      case 5:
        if (!getPartitionEventRecord().equals(other.getPartitionEventRecord())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (recordCase_) {
      case 1:
        hash = (37 * hash) + DATA_CHANGE_RECORD_FIELD_NUMBER;
        hash = (53 * hash) + getDataChangeRecord().hashCode();
        break;
      case 2:
        hash = (37 * hash) + HEARTBEAT_RECORD_FIELD_NUMBER;
        hash = (53 * hash) + getHeartbeatRecord().hashCode();
        break;
      case 3:
        hash = (37 * hash) + PARTITION_START_RECORD_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionStartRecord().hashCode();
        break;
      case 4:
        hash = (37 * hash) + PARTITION_END_RECORD_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionEndRecord().hashCode();
        break;
      case 5:
        hash = (37 * hash) + PARTITION_EVENT_RECORD_FIELD_NUMBER;
        hash = (53 * hash) + getPartitionEventRecord().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.v1.ChangeStreamRecord parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.spanner.v1.ChangeStreamRecord prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Spanner Change Streams enable customers to capture and stream out changes to
   * their Spanner databases in real-time. A change stream
   * can be created with option partition_mode='IMMUTABLE_KEY_RANGE' or
   * partition_mode='MUTABLE_KEY_RANGE'.
   *
   * This message is only used in Change Streams created with the option
   * partition_mode='MUTABLE_KEY_RANGE'. Spanner automatically creates a special
   * Table-Valued Function (TVF) along with each Change Streams. The function
   * provides access to the change stream's records. The function is named
   * READ_&lt;change_stream_name&gt; (where &lt;change_stream_name&gt; is the
   * name of the change stream), and it returns a table with only one column
   * called ChangeRecord.
   * </pre>
   *
   * Protobuf type {@code google.spanner.v1.ChangeStreamRecord}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.v1.ChangeStreamRecord)
      com.google.spanner.v1.ChangeStreamRecordOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.v1.ChangeStreamRecord.class,
              com.google.spanner.v1.ChangeStreamRecord.Builder.class);
    }

    // Construct using com.google.spanner.v1.ChangeStreamRecord.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (dataChangeRecordBuilder_ != null) {
        dataChangeRecordBuilder_.clear();
      }
      if (heartbeatRecordBuilder_ != null) {
        heartbeatRecordBuilder_.clear();
      }
      if (partitionStartRecordBuilder_ != null) {
        partitionStartRecordBuilder_.clear();
      }
      if (partitionEndRecordBuilder_ != null) {
        partitionEndRecordBuilder_.clear();
      }
      if (partitionEventRecordBuilder_ != null) {
        partitionEventRecordBuilder_.clear();
      }
      recordCase_ = 0;
      record_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.v1.ChangeStreamProto
          .internal_static_google_spanner_v1_ChangeStreamRecord_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord getDefaultInstanceForType() {
      return com.google.spanner.v1.ChangeStreamRecord.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord build() {
      com.google.spanner.v1.ChangeStreamRecord result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord buildPartial() {
      com.google.spanner.v1.ChangeStreamRecord result =
          new com.google.spanner.v1.ChangeStreamRecord(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.v1.ChangeStreamRecord result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.spanner.v1.ChangeStreamRecord result) {
      result.recordCase_ = recordCase_;
      result.record_ = this.record_;
      if (recordCase_ == 1 && dataChangeRecordBuilder_ != null) {
        result.record_ = dataChangeRecordBuilder_.build();
      }
      if (recordCase_ == 2 && heartbeatRecordBuilder_ != null) {
        result.record_ = heartbeatRecordBuilder_.build();
      }
      if (recordCase_ == 3 && partitionStartRecordBuilder_ != null) {
        result.record_ = partitionStartRecordBuilder_.build();
      }
      if (recordCase_ == 4 && partitionEndRecordBuilder_ != null) {
        result.record_ = partitionEndRecordBuilder_.build();
      }
      if (recordCase_ == 5 && partitionEventRecordBuilder_ != null) {
        result.record_ = partitionEventRecordBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.v1.ChangeStreamRecord) {
        return mergeFrom((com.google.spanner.v1.ChangeStreamRecord) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.v1.ChangeStreamRecord other) {
      if (other == com.google.spanner.v1.ChangeStreamRecord.getDefaultInstance()) return this;
      switch (other.getRecordCase()) {
        case DATA_CHANGE_RECORD:
          {
            mergeDataChangeRecord(other.getDataChangeRecord());
            break;
          }
        case HEARTBEAT_RECORD:
          {
            mergeHeartbeatRecord(other.getHeartbeatRecord());
            break;
          }
        case PARTITION_START_RECORD:
          {
            mergePartitionStartRecord(other.getPartitionStartRecord());
            break;
          }
        case PARTITION_END_RECORD:
          {
            mergePartitionEndRecord(other.getPartitionEndRecord());
            break;
          }
        case PARTITION_EVENT_RECORD:
          {
            mergePartitionEventRecord(other.getPartitionEventRecord());
            break;
          }
        case RECORD_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getDataChangeRecordFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getHeartbeatRecordFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getPartitionStartRecordFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 3;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(
                    getPartitionEndRecordFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getPartitionEventRecordFieldBuilder().getBuilder(), extensionRegistry);
                recordCase_ = 5;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int recordCase_ = 0;
    private java.lang.Object record_;

    public RecordCase getRecordCase() {
      return RecordCase.forNumber(recordCase_);
    }

    public Builder clearRecord() {
      recordCase_ = 0;
      record_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecordOrBuilder>
        dataChangeRecordBuilder_;

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     *
     * @return Whether the dataChangeRecord field is set.
     */
    @java.lang.Override
    public boolean hasDataChangeRecord() {
      return recordCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     *
     * @return The dataChangeRecord.
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord getDataChangeRecord() {
      if (dataChangeRecordBuilder_ == null) {
        if (recordCase_ == 1) {
          return (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 1) {
          return dataChangeRecordBuilder_.getMessage();
        }
        return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     */
    public Builder setDataChangeRecord(
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord value) {
      if (dataChangeRecordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        dataChangeRecordBuilder_.setMessage(value);
      }
      recordCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     */
    public Builder setDataChangeRecord(
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Builder builderForValue) {
      if (dataChangeRecordBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        dataChangeRecordBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     */
    public Builder mergeDataChangeRecord(
        com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord value) {
      if (dataChangeRecordBuilder_ == null) {
        if (recordCase_ == 1
            && record_
                != com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance()) {
          record_ =
              com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.newBuilder(
                      (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 1) {
          dataChangeRecordBuilder_.mergeFrom(value);
        } else {
          dataChangeRecordBuilder_.setMessage(value);
        }
      }
      recordCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     */
    public Builder clearDataChangeRecord() {
      if (dataChangeRecordBuilder_ == null) {
        if (recordCase_ == 1) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 1) {
          recordCase_ = 0;
          record_ = null;
        }
        dataChangeRecordBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     */
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Builder
        getDataChangeRecordBuilder() {
      return getDataChangeRecordFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.DataChangeRecordOrBuilder
        getDataChangeRecordOrBuilder() {
      if ((recordCase_ == 1) && (dataChangeRecordBuilder_ != null)) {
        return dataChangeRecordBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 1) {
          return (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Data change record describing a data change for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.DataChangeRecord data_change_record = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.DataChangeRecordOrBuilder>
        getDataChangeRecordFieldBuilder() {
      if (dataChangeRecordBuilder_ == null) {
        if (!(recordCase_ == 1)) {
          record_ = com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.getDefaultInstance();
        }
        dataChangeRecordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord.Builder,
                com.google.spanner.v1.ChangeStreamRecord.DataChangeRecordOrBuilder>(
                (com.google.spanner.v1.ChangeStreamRecord.DataChangeRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 1;
      onChanged();
      return dataChangeRecordBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord,
            com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecordOrBuilder>
        heartbeatRecordBuilder_;

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     *
     * @return Whether the heartbeatRecord field is set.
     */
    @java.lang.Override
    public boolean hasHeartbeatRecord() {
      return recordCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     *
     * @return The heartbeatRecord.
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord getHeartbeatRecord() {
      if (heartbeatRecordBuilder_ == null) {
        if (recordCase_ == 2) {
          return (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 2) {
          return heartbeatRecordBuilder_.getMessage();
        }
        return com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     */
    public Builder setHeartbeatRecord(
        com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord value) {
      if (heartbeatRecordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        heartbeatRecordBuilder_.setMessage(value);
      }
      recordCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     */
    public Builder setHeartbeatRecord(
        com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.Builder builderForValue) {
      if (heartbeatRecordBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        heartbeatRecordBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     */
    public Builder mergeHeartbeatRecord(
        com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord value) {
      if (heartbeatRecordBuilder_ == null) {
        if (recordCase_ == 2
            && record_
                != com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance()) {
          record_ =
              com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.newBuilder(
                      (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 2) {
          heartbeatRecordBuilder_.mergeFrom(value);
        } else {
          heartbeatRecordBuilder_.setMessage(value);
        }
      }
      recordCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     */
    public Builder clearHeartbeatRecord() {
      if (heartbeatRecordBuilder_ == null) {
        if (recordCase_ == 2) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 2) {
          recordCase_ = 0;
          record_ = null;
        }
        heartbeatRecordBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     */
    public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.Builder
        getHeartbeatRecordBuilder() {
      return getHeartbeatRecordFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecordOrBuilder
        getHeartbeatRecordOrBuilder() {
      if ((recordCase_ == 2) && (heartbeatRecordBuilder_ != null)) {
        return heartbeatRecordBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 2) {
          return (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Heartbeat record describing a heartbeat for a change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord heartbeat_record = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord,
            com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecordOrBuilder>
        getHeartbeatRecordFieldBuilder() {
      if (heartbeatRecordBuilder_ == null) {
        if (!(recordCase_ == 2)) {
          record_ = com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.getDefaultInstance();
        }
        heartbeatRecordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord,
                com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord.Builder,
                com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecordOrBuilder>(
                (com.google.spanner.v1.ChangeStreamRecord.HeartbeatRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 2;
      onChanged();
      return heartbeatRecordBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord,
            com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecordOrBuilder>
        partitionStartRecordBuilder_;

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     *
     * @return Whether the partitionStartRecord field is set.
     */
    @java.lang.Override
    public boolean hasPartitionStartRecord() {
      return recordCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     *
     * @return The partitionStartRecord.
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord getPartitionStartRecord() {
      if (partitionStartRecordBuilder_ == null) {
        if (recordCase_ == 3) {
          return (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 3) {
          return partitionStartRecordBuilder_.getMessage();
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     */
    public Builder setPartitionStartRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord value) {
      if (partitionStartRecordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        partitionStartRecordBuilder_.setMessage(value);
      }
      recordCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     */
    public Builder setPartitionStartRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.Builder builderForValue) {
      if (partitionStartRecordBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        partitionStartRecordBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     */
    public Builder mergePartitionStartRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord value) {
      if (partitionStartRecordBuilder_ == null) {
        if (recordCase_ == 3
            && record_
                != com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord
                    .getDefaultInstance()) {
          record_ =
              com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.newBuilder(
                      (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 3) {
          partitionStartRecordBuilder_.mergeFrom(value);
        } else {
          partitionStartRecordBuilder_.setMessage(value);
        }
      }
      recordCase_ = 3;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     */
    public Builder clearPartitionStartRecord() {
      if (partitionStartRecordBuilder_ == null) {
        if (recordCase_ == 3) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 3) {
          recordCase_ = 0;
          record_ = null;
        }
        partitionStartRecordBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     */
    public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.Builder
        getPartitionStartRecordBuilder() {
      return getPartitionStartRecordFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecordOrBuilder
        getPartitionStartRecordOrBuilder() {
      if ((recordCase_ == 3) && (partitionStartRecordBuilder_ != null)) {
        return partitionStartRecordBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 3) {
          return (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Partition start record describing a new change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord partition_start_record = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord,
            com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecordOrBuilder>
        getPartitionStartRecordFieldBuilder() {
      if (partitionStartRecordBuilder_ == null) {
        if (!(recordCase_ == 3)) {
          record_ =
              com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.getDefaultInstance();
        }
        partitionStartRecordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord,
                com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord.Builder,
                com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecordOrBuilder>(
                (com.google.spanner.v1.ChangeStreamRecord.PartitionStartRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 3;
      onChanged();
      return partitionStartRecordBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord,
            com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecordOrBuilder>
        partitionEndRecordBuilder_;

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     *
     * @return Whether the partitionEndRecord field is set.
     */
    @java.lang.Override
    public boolean hasPartitionEndRecord() {
      return recordCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     *
     * @return The partitionEndRecord.
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord getPartitionEndRecord() {
      if (partitionEndRecordBuilder_ == null) {
        if (recordCase_ == 4) {
          return (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 4) {
          return partitionEndRecordBuilder_.getMessage();
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     */
    public Builder setPartitionEndRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord value) {
      if (partitionEndRecordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        partitionEndRecordBuilder_.setMessage(value);
      }
      recordCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     */
    public Builder setPartitionEndRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.Builder builderForValue) {
      if (partitionEndRecordBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        partitionEndRecordBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     */
    public Builder mergePartitionEndRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord value) {
      if (partitionEndRecordBuilder_ == null) {
        if (recordCase_ == 4
            && record_
                != com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord
                    .getDefaultInstance()) {
          record_ =
              com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.newBuilder(
                      (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 4) {
          partitionEndRecordBuilder_.mergeFrom(value);
        } else {
          partitionEndRecordBuilder_.setMessage(value);
        }
      }
      recordCase_ = 4;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     */
    public Builder clearPartitionEndRecord() {
      if (partitionEndRecordBuilder_ == null) {
        if (recordCase_ == 4) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 4) {
          recordCase_ = 0;
          record_ = null;
        }
        partitionEndRecordBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     */
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.Builder
        getPartitionEndRecordBuilder() {
      return getPartitionEndRecordFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecordOrBuilder
        getPartitionEndRecordOrBuilder() {
      if ((recordCase_ == 4) && (partitionEndRecordBuilder_ != null)) {
        return partitionEndRecordBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 4) {
          return (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Partition end record describing a terminated change stream partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord partition_end_record = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord,
            com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecordOrBuilder>
        getPartitionEndRecordFieldBuilder() {
      if (partitionEndRecordBuilder_ == null) {
        if (!(recordCase_ == 4)) {
          record_ =
              com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.getDefaultInstance();
        }
        partitionEndRecordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord.Builder,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecordOrBuilder>(
                (com.google.spanner.v1.ChangeStreamRecord.PartitionEndRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 4;
      onChanged();
      return partitionEndRecordBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord,
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecordOrBuilder>
        partitionEventRecordBuilder_;

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     *
     * @return Whether the partitionEventRecord field is set.
     */
    @java.lang.Override
    public boolean hasPartitionEventRecord() {
      return recordCase_ == 5;
    }

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     *
     * @return The partitionEventRecord.
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord getPartitionEventRecord() {
      if (partitionEventRecordBuilder_ == null) {
        if (recordCase_ == 5) {
          return (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.getDefaultInstance();
      } else {
        if (recordCase_ == 5) {
          return partitionEventRecordBuilder_.getMessage();
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     */
    public Builder setPartitionEventRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord value) {
      if (partitionEventRecordBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        record_ = value;
        onChanged();
      } else {
        partitionEventRecordBuilder_.setMessage(value);
      }
      recordCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     */
    public Builder setPartitionEventRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.Builder builderForValue) {
      if (partitionEventRecordBuilder_ == null) {
        record_ = builderForValue.build();
        onChanged();
      } else {
        partitionEventRecordBuilder_.setMessage(builderForValue.build());
      }
      recordCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     */
    public Builder mergePartitionEventRecord(
        com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord value) {
      if (partitionEventRecordBuilder_ == null) {
        if (recordCase_ == 5
            && record_
                != com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord
                    .getDefaultInstance()) {
          record_ =
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.newBuilder(
                      (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) record_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          record_ = value;
        }
        onChanged();
      } else {
        if (recordCase_ == 5) {
          partitionEventRecordBuilder_.mergeFrom(value);
        } else {
          partitionEventRecordBuilder_.setMessage(value);
        }
      }
      recordCase_ = 5;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     */
    public Builder clearPartitionEventRecord() {
      if (partitionEventRecordBuilder_ == null) {
        if (recordCase_ == 5) {
          recordCase_ = 0;
          record_ = null;
          onChanged();
        }
      } else {
        if (recordCase_ == 5) {
          recordCase_ = 0;
          record_ = null;
        }
        partitionEventRecordBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     */
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.Builder
        getPartitionEventRecordBuilder() {
      return getPartitionEventRecordFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecordOrBuilder
        getPartitionEventRecordOrBuilder() {
      if ((recordCase_ == 5) && (partitionEventRecordBuilder_ != null)) {
        return partitionEventRecordBuilder_.getMessageOrBuilder();
      } else {
        if (recordCase_ == 5) {
          return (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) record_;
        }
        return com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Partition event record describing key range changes for a change stream
     * partition.
     * </pre>
     *
     * <code>.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord partition_event_record = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord,
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.Builder,
            com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecordOrBuilder>
        getPartitionEventRecordFieldBuilder() {
      if (partitionEventRecordBuilder_ == null) {
        if (!(recordCase_ == 5)) {
          record_ =
              com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.getDefaultInstance();
        }
        partitionEventRecordBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord.Builder,
                com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecordOrBuilder>(
                (com.google.spanner.v1.ChangeStreamRecord.PartitionEventRecord) record_,
                getParentForChildren(),
                isClean());
        record_ = null;
      }
      recordCase_ = 5;
      onChanged();
      return partitionEventRecordBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.v1.ChangeStreamRecord)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.v1.ChangeStreamRecord)
  private static final com.google.spanner.v1.ChangeStreamRecord DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.v1.ChangeStreamRecord();
  }

  public static com.google.spanner.v1.ChangeStreamRecord getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ChangeStreamRecord> PARSER =
      new com.google.protobuf.AbstractParser<ChangeStreamRecord>() {
        @java.lang.Override
        public ChangeStreamRecord parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ChangeStreamRecord> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ChangeStreamRecord> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.v1.ChangeStreamRecord getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
