/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/instance/v1/spanner_instance_admin.proto

// Protobuf Java Version: 3.25.8
package com.google.spanner.admin.instance.v1;

/**
 *
 *
 * <pre>
 * Autoscaling configuration for an instance.
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.instance.v1.AutoscalingConfig}
 */
public final class AutoscalingConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.AutoscalingConfig)
    AutoscalingConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AutoscalingConfig.newBuilder() to construct.
  private AutoscalingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutoscalingConfig() {
    asymmetricAutoscalingOptions_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutoscalingConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
        .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.instance.v1.AutoscalingConfig.class,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder.class);
  }

  public interface AutoscalingLimitsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Minimum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to 1.
     * </pre>
     *
     * <code>int32 min_nodes = 1;</code>
     *
     * @return Whether the minNodes field is set.
     */
    boolean hasMinNodes();

    /**
     *
     *
     * <pre>
     * Minimum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to 1.
     * </pre>
     *
     * <code>int32 min_nodes = 1;</code>
     *
     * @return The minNodes.
     */
    int getMinNodes();

    /**
     *
     *
     * <pre>
     * Minimum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000.
     * </pre>
     *
     * <code>int32 min_processing_units = 2;</code>
     *
     * @return Whether the minProcessingUnits field is set.
     */
    boolean hasMinProcessingUnits();

    /**
     *
     *
     * <pre>
     * Minimum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000.
     * </pre>
     *
     * <code>int32 min_processing_units = 2;</code>
     *
     * @return The minProcessingUnits.
     */
    int getMinProcessingUnits();

    /**
     *
     *
     * <pre>
     * Maximum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to min_nodes.
     * </pre>
     *
     * <code>int32 max_nodes = 3;</code>
     *
     * @return Whether the maxNodes field is set.
     */
    boolean hasMaxNodes();

    /**
     *
     *
     * <pre>
     * Maximum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to min_nodes.
     * </pre>
     *
     * <code>int32 max_nodes = 3;</code>
     *
     * @return The maxNodes.
     */
    int getMaxNodes();

    /**
     *
     *
     * <pre>
     * Maximum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000 and be greater than or equal to
     * min_processing_units.
     * </pre>
     *
     * <code>int32 max_processing_units = 4;</code>
     *
     * @return Whether the maxProcessingUnits field is set.
     */
    boolean hasMaxProcessingUnits();

    /**
     *
     *
     * <pre>
     * Maximum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000 and be greater than or equal to
     * min_processing_units.
     * </pre>
     *
     * <code>int32 max_processing_units = 4;</code>
     *
     * @return The maxProcessingUnits.
     */
    int getMaxProcessingUnits();

    com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.MinLimitCase
        getMinLimitCase();

    com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.MaxLimitCase
        getMaxLimitCase();
  }

  /**
   *
   *
   * <pre>
   * The autoscaling limits for the instance. Users can define the minimum and
   * maximum compute capacity allocated to the instance, and the autoscaler will
   * only scale within that range. Users can either use nodes or processing
   * units to specify the limits, but should use the same unit to set both the
   * min_limit and max_limit.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits}
   */
  public static final class AutoscalingLimits extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits)
      AutoscalingLimitsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AutoscalingLimits.newBuilder() to construct.
    private AutoscalingLimits(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AutoscalingLimits() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AutoscalingLimits();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingLimits_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingLimits_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.class,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder
                  .class);
    }

    private int minLimitCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object minLimit_;

    public enum MinLimitCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      MIN_NODES(1),
      MIN_PROCESSING_UNITS(2),
      MINLIMIT_NOT_SET(0);
      private final int value;

      private MinLimitCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MinLimitCase valueOf(int value) {
        return forNumber(value);
      }

      public static MinLimitCase forNumber(int value) {
        switch (value) {
          case 1:
            return MIN_NODES;
          case 2:
            return MIN_PROCESSING_UNITS;
          case 0:
            return MINLIMIT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public MinLimitCase getMinLimitCase() {
      return MinLimitCase.forNumber(minLimitCase_);
    }

    private int maxLimitCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object maxLimit_;

    public enum MaxLimitCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      MAX_NODES(3),
      MAX_PROCESSING_UNITS(4),
      MAXLIMIT_NOT_SET(0);
      private final int value;

      private MaxLimitCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static MaxLimitCase valueOf(int value) {
        return forNumber(value);
      }

      public static MaxLimitCase forNumber(int value) {
        switch (value) {
          case 3:
            return MAX_NODES;
          case 4:
            return MAX_PROCESSING_UNITS;
          case 0:
            return MAXLIMIT_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public MaxLimitCase getMaxLimitCase() {
      return MaxLimitCase.forNumber(maxLimitCase_);
    }

    public static final int MIN_NODES_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Minimum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to 1.
     * </pre>
     *
     * <code>int32 min_nodes = 1;</code>
     *
     * @return Whether the minNodes field is set.
     */
    @java.lang.Override
    public boolean hasMinNodes() {
      return minLimitCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Minimum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to 1.
     * </pre>
     *
     * <code>int32 min_nodes = 1;</code>
     *
     * @return The minNodes.
     */
    @java.lang.Override
    public int getMinNodes() {
      if (minLimitCase_ == 1) {
        return (java.lang.Integer) minLimit_;
      }
      return 0;
    }

    public static final int MIN_PROCESSING_UNITS_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Minimum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000.
     * </pre>
     *
     * <code>int32 min_processing_units = 2;</code>
     *
     * @return Whether the minProcessingUnits field is set.
     */
    @java.lang.Override
    public boolean hasMinProcessingUnits() {
      return minLimitCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Minimum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000.
     * </pre>
     *
     * <code>int32 min_processing_units = 2;</code>
     *
     * @return The minProcessingUnits.
     */
    @java.lang.Override
    public int getMinProcessingUnits() {
      if (minLimitCase_ == 2) {
        return (java.lang.Integer) minLimit_;
      }
      return 0;
    }

    public static final int MAX_NODES_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * Maximum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to min_nodes.
     * </pre>
     *
     * <code>int32 max_nodes = 3;</code>
     *
     * @return Whether the maxNodes field is set.
     */
    @java.lang.Override
    public boolean hasMaxNodes() {
      return maxLimitCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * Maximum number of nodes allocated to the instance. If set, this number
     * should be greater than or equal to min_nodes.
     * </pre>
     *
     * <code>int32 max_nodes = 3;</code>
     *
     * @return The maxNodes.
     */
    @java.lang.Override
    public int getMaxNodes() {
      if (maxLimitCase_ == 3) {
        return (java.lang.Integer) maxLimit_;
      }
      return 0;
    }

    public static final int MAX_PROCESSING_UNITS_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * Maximum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000 and be greater than or equal to
     * min_processing_units.
     * </pre>
     *
     * <code>int32 max_processing_units = 4;</code>
     *
     * @return Whether the maxProcessingUnits field is set.
     */
    @java.lang.Override
    public boolean hasMaxProcessingUnits() {
      return maxLimitCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * Maximum number of processing units allocated to the instance. If set,
     * this number should be multiples of 1000 and be greater than or equal to
     * min_processing_units.
     * </pre>
     *
     * <code>int32 max_processing_units = 4;</code>
     *
     * @return The maxProcessingUnits.
     */
    @java.lang.Override
    public int getMaxProcessingUnits() {
      if (maxLimitCase_ == 4) {
        return (java.lang.Integer) maxLimit_;
      }
      return 0;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (minLimitCase_ == 1) {
        output.writeInt32(1, (int) ((java.lang.Integer) minLimit_));
      }
      if (minLimitCase_ == 2) {
        output.writeInt32(2, (int) ((java.lang.Integer) minLimit_));
      }
      if (maxLimitCase_ == 3) {
        output.writeInt32(3, (int) ((java.lang.Integer) maxLimit_));
      }
      if (maxLimitCase_ == 4) {
        output.writeInt32(4, (int) ((java.lang.Integer) maxLimit_));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (minLimitCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                1, (int) ((java.lang.Integer) minLimit_));
      }
      if (minLimitCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                2, (int) ((java.lang.Integer) minLimit_));
      }
      if (maxLimitCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                3, (int) ((java.lang.Integer) maxLimit_));
      }
      if (maxLimitCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                4, (int) ((java.lang.Integer) maxLimit_));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits)) {
        return super.equals(obj);
      }
      com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits other =
          (com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits) obj;

      if (!getMinLimitCase().equals(other.getMinLimitCase())) return false;
      switch (minLimitCase_) {
        case 1:
          if (getMinNodes() != other.getMinNodes()) return false;
          break;
        case 2:
          if (getMinProcessingUnits() != other.getMinProcessingUnits()) return false;
          break;
        case 0:
        default:
      }
      if (!getMaxLimitCase().equals(other.getMaxLimitCase())) return false;
      switch (maxLimitCase_) {
        case 3:
          if (getMaxNodes() != other.getMaxNodes()) return false;
          break;
        case 4:
          if (getMaxProcessingUnits() != other.getMaxProcessingUnits()) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (minLimitCase_) {
        case 1:
          hash = (37 * hash) + MIN_NODES_FIELD_NUMBER;
          hash = (53 * hash) + getMinNodes();
          break;
        case 2:
          hash = (37 * hash) + MIN_PROCESSING_UNITS_FIELD_NUMBER;
          hash = (53 * hash) + getMinProcessingUnits();
          break;
        case 0:
        default:
      }
      switch (maxLimitCase_) {
        case 3:
          hash = (37 * hash) + MAX_NODES_FIELD_NUMBER;
          hash = (53 * hash) + getMaxNodes();
          break;
        case 4:
          hash = (37 * hash) + MAX_PROCESSING_UNITS_FIELD_NUMBER;
          hash = (53 * hash) + getMaxProcessingUnits();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The autoscaling limits for the instance. Users can define the minimum and
     * maximum compute capacity allocated to the instance, and the autoscaler will
     * only scale within that range. Users can either use nodes or processing
     * units to specify the limits, but should use the same unit to set both the
     * min_limit and max_limit.
     * </pre>
     *
     * Protobuf type {@code google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits)
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingLimits_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingLimits_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.class,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder
                    .class);
      }

      // Construct using
      // com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        minLimitCase_ = 0;
        minLimit_ = null;
        maxLimitCase_ = 0;
        maxLimit_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingLimits_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
          getDefaultInstanceForType() {
        return com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits build() {
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
          buildPartial() {
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits result =
            new com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits result) {
        result.minLimitCase_ = minLimitCase_;
        result.minLimit_ = this.minLimit_;
        result.maxLimitCase_ = maxLimitCase_;
        result.maxLimit_ = this.maxLimit_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits) {
          return mergeFrom(
              (com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits other) {
        if (other
            == com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                .getDefaultInstance()) return this;
        switch (other.getMinLimitCase()) {
          case MIN_NODES:
            {
              setMinNodes(other.getMinNodes());
              break;
            }
          case MIN_PROCESSING_UNITS:
            {
              setMinProcessingUnits(other.getMinProcessingUnits());
              break;
            }
          case MINLIMIT_NOT_SET:
            {
              break;
            }
        }
        switch (other.getMaxLimitCase()) {
          case MAX_NODES:
            {
              setMaxNodes(other.getMaxNodes());
              break;
            }
          case MAX_PROCESSING_UNITS:
            {
              setMaxProcessingUnits(other.getMaxProcessingUnits());
              break;
            }
          case MAXLIMIT_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  minLimit_ = input.readInt32();
                  minLimitCase_ = 1;
                  break;
                } // case 8
              case 16:
                {
                  minLimit_ = input.readInt32();
                  minLimitCase_ = 2;
                  break;
                } // case 16
              case 24:
                {
                  maxLimit_ = input.readInt32();
                  maxLimitCase_ = 3;
                  break;
                } // case 24
              case 32:
                {
                  maxLimit_ = input.readInt32();
                  maxLimitCase_ = 4;
                  break;
                } // case 32
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int minLimitCase_ = 0;
      private java.lang.Object minLimit_;

      public MinLimitCase getMinLimitCase() {
        return MinLimitCase.forNumber(minLimitCase_);
      }

      public Builder clearMinLimit() {
        minLimitCase_ = 0;
        minLimit_ = null;
        onChanged();
        return this;
      }

      private int maxLimitCase_ = 0;
      private java.lang.Object maxLimit_;

      public MaxLimitCase getMaxLimitCase() {
        return MaxLimitCase.forNumber(maxLimitCase_);
      }

      public Builder clearMaxLimit() {
        maxLimitCase_ = 0;
        maxLimit_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * Minimum number of nodes allocated to the instance. If set, this number
       * should be greater than or equal to 1.
       * </pre>
       *
       * <code>int32 min_nodes = 1;</code>
       *
       * @return Whether the minNodes field is set.
       */
      public boolean hasMinNodes() {
        return minLimitCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Minimum number of nodes allocated to the instance. If set, this number
       * should be greater than or equal to 1.
       * </pre>
       *
       * <code>int32 min_nodes = 1;</code>
       *
       * @return The minNodes.
       */
      public int getMinNodes() {
        if (minLimitCase_ == 1) {
          return (java.lang.Integer) minLimit_;
        }
        return 0;
      }

      /**
       *
       *
       * <pre>
       * Minimum number of nodes allocated to the instance. If set, this number
       * should be greater than or equal to 1.
       * </pre>
       *
       * <code>int32 min_nodes = 1;</code>
       *
       * @param value The minNodes to set.
       * @return This builder for chaining.
       */
      public Builder setMinNodes(int value) {

        minLimitCase_ = 1;
        minLimit_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Minimum number of nodes allocated to the instance. If set, this number
       * should be greater than or equal to 1.
       * </pre>
       *
       * <code>int32 min_nodes = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinNodes() {
        if (minLimitCase_ == 1) {
          minLimitCase_ = 0;
          minLimit_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Minimum number of processing units allocated to the instance. If set,
       * this number should be multiples of 1000.
       * </pre>
       *
       * <code>int32 min_processing_units = 2;</code>
       *
       * @return Whether the minProcessingUnits field is set.
       */
      public boolean hasMinProcessingUnits() {
        return minLimitCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Minimum number of processing units allocated to the instance. If set,
       * this number should be multiples of 1000.
       * </pre>
       *
       * <code>int32 min_processing_units = 2;</code>
       *
       * @return The minProcessingUnits.
       */
      public int getMinProcessingUnits() {
        if (minLimitCase_ == 2) {
          return (java.lang.Integer) minLimit_;
        }
        return 0;
      }

      /**
       *
       *
       * <pre>
       * Minimum number of processing units allocated to the instance. If set,
       * this number should be multiples of 1000.
       * </pre>
       *
       * <code>int32 min_processing_units = 2;</code>
       *
       * @param value The minProcessingUnits to set.
       * @return This builder for chaining.
       */
      public Builder setMinProcessingUnits(int value) {

        minLimitCase_ = 2;
        minLimit_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Minimum number of processing units allocated to the instance. If set,
       * this number should be multiples of 1000.
       * </pre>
       *
       * <code>int32 min_processing_units = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinProcessingUnits() {
        if (minLimitCase_ == 2) {
          minLimitCase_ = 0;
          minLimit_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Maximum number of nodes allocated to the instance. If set, this number
       * should be greater than or equal to min_nodes.
       * </pre>
       *
       * <code>int32 max_nodes = 3;</code>
       *
       * @return Whether the maxNodes field is set.
       */
      public boolean hasMaxNodes() {
        return maxLimitCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * Maximum number of nodes allocated to the instance. If set, this number
       * should be greater than or equal to min_nodes.
       * </pre>
       *
       * <code>int32 max_nodes = 3;</code>
       *
       * @return The maxNodes.
       */
      public int getMaxNodes() {
        if (maxLimitCase_ == 3) {
          return (java.lang.Integer) maxLimit_;
        }
        return 0;
      }

      /**
       *
       *
       * <pre>
       * Maximum number of nodes allocated to the instance. If set, this number
       * should be greater than or equal to min_nodes.
       * </pre>
       *
       * <code>int32 max_nodes = 3;</code>
       *
       * @param value The maxNodes to set.
       * @return This builder for chaining.
       */
      public Builder setMaxNodes(int value) {

        maxLimitCase_ = 3;
        maxLimit_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Maximum number of nodes allocated to the instance. If set, this number
       * should be greater than or equal to min_nodes.
       * </pre>
       *
       * <code>int32 max_nodes = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxNodes() {
        if (maxLimitCase_ == 3) {
          maxLimitCase_ = 0;
          maxLimit_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Maximum number of processing units allocated to the instance. If set,
       * this number should be multiples of 1000 and be greater than or equal to
       * min_processing_units.
       * </pre>
       *
       * <code>int32 max_processing_units = 4;</code>
       *
       * @return Whether the maxProcessingUnits field is set.
       */
      public boolean hasMaxProcessingUnits() {
        return maxLimitCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * Maximum number of processing units allocated to the instance. If set,
       * this number should be multiples of 1000 and be greater than or equal to
       * min_processing_units.
       * </pre>
       *
       * <code>int32 max_processing_units = 4;</code>
       *
       * @return The maxProcessingUnits.
       */
      public int getMaxProcessingUnits() {
        if (maxLimitCase_ == 4) {
          return (java.lang.Integer) maxLimit_;
        }
        return 0;
      }

      /**
       *
       *
       * <pre>
       * Maximum number of processing units allocated to the instance. If set,
       * this number should be multiples of 1000 and be greater than or equal to
       * min_processing_units.
       * </pre>
       *
       * <code>int32 max_processing_units = 4;</code>
       *
       * @param value The maxProcessingUnits to set.
       * @return This builder for chaining.
       */
      public Builder setMaxProcessingUnits(int value) {

        maxLimitCase_ = 4;
        maxLimit_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Maximum number of processing units allocated to the instance. If set,
       * this number should be multiples of 1000 and be greater than or equal to
       * min_processing_units.
       * </pre>
       *
       * <code>int32 max_processing_units = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxProcessingUnits() {
        if (maxLimitCase_ == 4) {
          maxLimitCase_ = 0;
          maxLimit_ = null;
          onChanged();
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits)
    private static final com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits();
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AutoscalingLimits> PARSER =
        new com.google.protobuf.AbstractParser<AutoscalingLimits>() {
          @java.lang.Override
          public AutoscalingLimits parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AutoscalingLimits> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AutoscalingLimits> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AutoscalingTargetsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The target high priority cpu utilization percentage that the
     * autoscaler should be trying to achieve for the instance. This number is
     * on a scale from 0 (no utilization) to 100 (full utilization). The valid
     * range is [10, 90] inclusive.
     * </pre>
     *
     * <code>
     * int32 high_priority_cpu_utilization_percent = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The highPriorityCpuUtilizationPercent.
     */
    int getHighPriorityCpuUtilizationPercent();

    /**
     *
     *
     * <pre>
     * Required. The target storage utilization percentage that the autoscaler
     * should be trying to achieve for the instance. This number is on a scale
     * from 0 (no utilization) to 100 (full utilization). The valid range is
     * [10, 99] inclusive.
     * </pre>
     *
     * <code>int32 storage_utilization_percent = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The storageUtilizationPercent.
     */
    int getStorageUtilizationPercent();
  }

  /**
   *
   *
   * <pre>
   * The autoscaling targets for an instance.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets}
   */
  public static final class AutoscalingTargets extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets)
      AutoscalingTargetsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AutoscalingTargets.newBuilder() to construct.
    private AutoscalingTargets(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AutoscalingTargets() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AutoscalingTargets();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingTargets_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingTargets_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.class,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.Builder
                  .class);
    }

    public static final int HIGH_PRIORITY_CPU_UTILIZATION_PERCENT_FIELD_NUMBER = 1;
    private int highPriorityCpuUtilizationPercent_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The target high priority cpu utilization percentage that the
     * autoscaler should be trying to achieve for the instance. This number is
     * on a scale from 0 (no utilization) to 100 (full utilization). The valid
     * range is [10, 90] inclusive.
     * </pre>
     *
     * <code>
     * int32 high_priority_cpu_utilization_percent = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The highPriorityCpuUtilizationPercent.
     */
    @java.lang.Override
    public int getHighPriorityCpuUtilizationPercent() {
      return highPriorityCpuUtilizationPercent_;
    }

    public static final int STORAGE_UTILIZATION_PERCENT_FIELD_NUMBER = 2;
    private int storageUtilizationPercent_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The target storage utilization percentage that the autoscaler
     * should be trying to achieve for the instance. This number is on a scale
     * from 0 (no utilization) to 100 (full utilization). The valid range is
     * [10, 99] inclusive.
     * </pre>
     *
     * <code>int32 storage_utilization_percent = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The storageUtilizationPercent.
     */
    @java.lang.Override
    public int getStorageUtilizationPercent() {
      return storageUtilizationPercent_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (highPriorityCpuUtilizationPercent_ != 0) {
        output.writeInt32(1, highPriorityCpuUtilizationPercent_);
      }
      if (storageUtilizationPercent_ != 0) {
        output.writeInt32(2, storageUtilizationPercent_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (highPriorityCpuUtilizationPercent_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                1, highPriorityCpuUtilizationPercent_);
      }
      if (storageUtilizationPercent_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(2, storageUtilizationPercent_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets)) {
        return super.equals(obj);
      }
      com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets other =
          (com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets) obj;

      if (getHighPriorityCpuUtilizationPercent() != other.getHighPriorityCpuUtilizationPercent())
        return false;
      if (getStorageUtilizationPercent() != other.getStorageUtilizationPercent()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + HIGH_PRIORITY_CPU_UTILIZATION_PERCENT_FIELD_NUMBER;
      hash = (53 * hash) + getHighPriorityCpuUtilizationPercent();
      hash = (37 * hash) + STORAGE_UTILIZATION_PERCENT_FIELD_NUMBER;
      hash = (53 * hash) + getStorageUtilizationPercent();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The autoscaling targets for an instance.
     * </pre>
     *
     * Protobuf type {@code google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets)
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargetsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingTargets_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingTargets_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.class,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.Builder
                    .class);
      }

      // Construct using
      // com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        highPriorityCpuUtilizationPercent_ = 0;
        storageUtilizationPercent_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AutoscalingTargets_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
          getDefaultInstanceForType() {
        return com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets build() {
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
          buildPartial() {
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets result =
            new com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.highPriorityCpuUtilizationPercent_ = highPriorityCpuUtilizationPercent_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.storageUtilizationPercent_ = storageUtilizationPercent_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets) {
          return mergeFrom(
              (com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets other) {
        if (other
            == com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
                .getDefaultInstance()) return this;
        if (other.getHighPriorityCpuUtilizationPercent() != 0) {
          setHighPriorityCpuUtilizationPercent(other.getHighPriorityCpuUtilizationPercent());
        }
        if (other.getStorageUtilizationPercent() != 0) {
          setStorageUtilizationPercent(other.getStorageUtilizationPercent());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  highPriorityCpuUtilizationPercent_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  storageUtilizationPercent_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int highPriorityCpuUtilizationPercent_;

      /**
       *
       *
       * <pre>
       * Required. The target high priority cpu utilization percentage that the
       * autoscaler should be trying to achieve for the instance. This number is
       * on a scale from 0 (no utilization) to 100 (full utilization). The valid
       * range is [10, 90] inclusive.
       * </pre>
       *
       * <code>
       * int32 high_priority_cpu_utilization_percent = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The highPriorityCpuUtilizationPercent.
       */
      @java.lang.Override
      public int getHighPriorityCpuUtilizationPercent() {
        return highPriorityCpuUtilizationPercent_;
      }

      /**
       *
       *
       * <pre>
       * Required. The target high priority cpu utilization percentage that the
       * autoscaler should be trying to achieve for the instance. This number is
       * on a scale from 0 (no utilization) to 100 (full utilization). The valid
       * range is [10, 90] inclusive.
       * </pre>
       *
       * <code>
       * int32 high_priority_cpu_utilization_percent = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The highPriorityCpuUtilizationPercent to set.
       * @return This builder for chaining.
       */
      public Builder setHighPriorityCpuUtilizationPercent(int value) {

        highPriorityCpuUtilizationPercent_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The target high priority cpu utilization percentage that the
       * autoscaler should be trying to achieve for the instance. This number is
       * on a scale from 0 (no utilization) to 100 (full utilization). The valid
       * range is [10, 90] inclusive.
       * </pre>
       *
       * <code>
       * int32 high_priority_cpu_utilization_percent = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearHighPriorityCpuUtilizationPercent() {
        bitField0_ = (bitField0_ & ~0x00000001);
        highPriorityCpuUtilizationPercent_ = 0;
        onChanged();
        return this;
      }

      private int storageUtilizationPercent_;

      /**
       *
       *
       * <pre>
       * Required. The target storage utilization percentage that the autoscaler
       * should be trying to achieve for the instance. This number is on a scale
       * from 0 (no utilization) to 100 (full utilization). The valid range is
       * [10, 99] inclusive.
       * </pre>
       *
       * <code>int32 storage_utilization_percent = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The storageUtilizationPercent.
       */
      @java.lang.Override
      public int getStorageUtilizationPercent() {
        return storageUtilizationPercent_;
      }

      /**
       *
       *
       * <pre>
       * Required. The target storage utilization percentage that the autoscaler
       * should be trying to achieve for the instance. This number is on a scale
       * from 0 (no utilization) to 100 (full utilization). The valid range is
       * [10, 99] inclusive.
       * </pre>
       *
       * <code>int32 storage_utilization_percent = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The storageUtilizationPercent to set.
       * @return This builder for chaining.
       */
      public Builder setStorageUtilizationPercent(int value) {

        storageUtilizationPercent_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The target storage utilization percentage that the autoscaler
       * should be trying to achieve for the instance. This number is on a scale
       * from 0 (no utilization) to 100 (full utilization). The valid range is
       * [10, 99] inclusive.
       * </pre>
       *
       * <code>int32 storage_utilization_percent = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearStorageUtilizationPercent() {
        bitField0_ = (bitField0_ & ~0x00000002);
        storageUtilizationPercent_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets)
    private static final com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets();
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AutoscalingTargets> PARSER =
        new com.google.protobuf.AbstractParser<AutoscalingTargets>() {
          @java.lang.Override
          public AutoscalingTargets parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AutoscalingTargets> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AutoscalingTargets> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface AsymmetricAutoscalingOptionOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Selects the replicas to which this AsymmetricAutoscalingOption
     * applies. Only read-only replicas are supported.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the replicaSelection field is set.
     */
    boolean hasReplicaSelection();

    /**
     *
     *
     * <pre>
     * Required. Selects the replicas to which this AsymmetricAutoscalingOption
     * applies. Only read-only replicas are supported.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The replicaSelection.
     */
    com.google.spanner.admin.instance.v1.ReplicaSelection getReplicaSelection();

    /**
     *
     *
     * <pre>
     * Required. Selects the replicas to which this AsymmetricAutoscalingOption
     * applies. Only read-only replicas are supported.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    com.google.spanner.admin.instance.v1.ReplicaSelectionOrBuilder getReplicaSelectionOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. Overrides applied to the top-level autoscaling configuration
     * for the selected replicas.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the overrides field is set.
     */
    boolean hasOverrides();

    /**
     *
     *
     * <pre>
     * Optional. Overrides applied to the top-level autoscaling configuration
     * for the selected replicas.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The overrides.
     */
    com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .AutoscalingConfigOverrides
        getOverrides();

    /**
     *
     *
     * <pre>
     * Optional. Overrides applied to the top-level autoscaling configuration
     * for the selected replicas.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .AutoscalingConfigOverridesOrBuilder
        getOverridesOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * AsymmetricAutoscalingOption specifies the scaling of replicas identified by
   * the given selection.
   * </pre>
   *
   * Protobuf type {@code
   * google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption}
   */
  public static final class AsymmetricAutoscalingOption
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption)
      AsymmetricAutoscalingOptionOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AsymmetricAutoscalingOption.newBuilder() to construct.
    private AsymmetricAutoscalingOption(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AsymmetricAutoscalingOption() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AsymmetricAutoscalingOption();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .class,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .Builder.class);
    }

    public interface AutoscalingConfigOverridesOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. If specified, overrides the min/max limit in the top-level
       * autoscaling configuration for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the autoscalingLimits field is set.
       */
      boolean hasAutoscalingLimits();

      /**
       *
       *
       * <pre>
       * Optional. If specified, overrides the min/max limit in the top-level
       * autoscaling configuration for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The autoscalingLimits.
       */
      com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
          getAutoscalingLimits();

      /**
       *
       *
       * <pre>
       * Optional. If specified, overrides the min/max limit in the top-level
       * autoscaling configuration for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder
          getAutoscalingLimitsOrBuilder();

      /**
       *
       *
       * <pre>
       * Optional. If specified, overrides the autoscaling target
       * high_priority_cpu_utilization_percent in the top-level autoscaling
       * configuration for the selected replicas.
       * </pre>
       *
       * <code>
       * int32 autoscaling_target_high_priority_cpu_utilization_percent = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The autoscalingTargetHighPriorityCpuUtilizationPercent.
       */
      int getAutoscalingTargetHighPriorityCpuUtilizationPercent();
    }

    /**
     *
     *
     * <pre>
     * Overrides the top-level autoscaling configuration for the replicas
     * identified by `replica_selection`. All fields in this message are
     * optional. Any unspecified fields will use the corresponding values from
     * the top-level autoscaling configuration.
     * </pre>
     *
     * Protobuf type {@code
     * google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides}
     */
    public static final class AutoscalingConfigOverrides
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides)
        AutoscalingConfigOverridesOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use AutoscalingConfigOverrides.newBuilder() to construct.
      private AutoscalingConfigOverrides(
          com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private AutoscalingConfigOverrides() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new AutoscalingConfigOverrides();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                    .AutoscalingConfigOverrides.class,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                    .AutoscalingConfigOverrides.Builder.class);
      }

      private int bitField0_;
      public static final int AUTOSCALING_LIMITS_FIELD_NUMBER = 1;
      private com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
          autoscalingLimits_;

      /**
       *
       *
       * <pre>
       * Optional. If specified, overrides the min/max limit in the top-level
       * autoscaling configuration for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the autoscalingLimits field is set.
       */
      @java.lang.Override
      public boolean hasAutoscalingLimits() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. If specified, overrides the min/max limit in the top-level
       * autoscaling configuration for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The autoscalingLimits.
       */
      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
          getAutoscalingLimits() {
        return autoscalingLimits_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                .getDefaultInstance()
            : autoscalingLimits_;
      }

      /**
       *
       *
       * <pre>
       * Optional. If specified, overrides the min/max limit in the top-level
       * autoscaling configuration for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder
          getAutoscalingLimitsOrBuilder() {
        return autoscalingLimits_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                .getDefaultInstance()
            : autoscalingLimits_;
      }

      public static final int
          AUTOSCALING_TARGET_HIGH_PRIORITY_CPU_UTILIZATION_PERCENT_FIELD_NUMBER = 2;
      private int autoscalingTargetHighPriorityCpuUtilizationPercent_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. If specified, overrides the autoscaling target
       * high_priority_cpu_utilization_percent in the top-level autoscaling
       * configuration for the selected replicas.
       * </pre>
       *
       * <code>
       * int32 autoscaling_target_high_priority_cpu_utilization_percent = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The autoscalingTargetHighPriorityCpuUtilizationPercent.
       */
      @java.lang.Override
      public int getAutoscalingTargetHighPriorityCpuUtilizationPercent() {
        return autoscalingTargetHighPriorityCpuUtilizationPercent_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeMessage(1, getAutoscalingLimits());
        }
        if (autoscalingTargetHighPriorityCpuUtilizationPercent_ != 0) {
          output.writeInt32(2, autoscalingTargetHighPriorityCpuUtilizationPercent_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAutoscalingLimits());
        }
        if (autoscalingTargetHighPriorityCpuUtilizationPercent_ != 0) {
          size +=
              com.google.protobuf.CodedOutputStream.computeInt32Size(
                  2, autoscalingTargetHighPriorityCpuUtilizationPercent_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .AutoscalingConfigOverrides)) {
          return super.equals(obj);
        }
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .AutoscalingConfigOverrides
            other =
                (com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                        .AutoscalingConfigOverrides)
                    obj;

        if (hasAutoscalingLimits() != other.hasAutoscalingLimits()) return false;
        if (hasAutoscalingLimits()) {
          if (!getAutoscalingLimits().equals(other.getAutoscalingLimits())) return false;
        }
        if (getAutoscalingTargetHighPriorityCpuUtilizationPercent()
            != other.getAutoscalingTargetHighPriorityCpuUtilizationPercent()) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasAutoscalingLimits()) {
          hash = (37 * hash) + AUTOSCALING_LIMITS_FIELD_NUMBER;
          hash = (53 * hash) + getAutoscalingLimits().hashCode();
        }
        hash = (37 * hash) + AUTOSCALING_TARGET_HIGH_PRIORITY_CPU_UTILIZATION_PERCENT_FIELD_NUMBER;
        hash = (53 * hash) + getAutoscalingTargetHighPriorityCpuUtilizationPercent();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Overrides the top-level autoscaling configuration for the replicas
       * identified by `replica_selection`. All fields in this message are
       * optional. Any unspecified fields will use the corresponding values from
       * the top-level autoscaling configuration.
       * </pre>
       *
       * Protobuf type {@code
       * google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides)
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverridesOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
              .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
              .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                      .AutoscalingConfigOverrides.class,
                  com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                      .AutoscalingConfigOverrides.Builder.class);
        }

        // Construct using
        // com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides.newBuilder()
        private Builder() {
          maybeForceBuilderInitialization();
        }

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
          maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
          if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
            getAutoscalingLimitsFieldBuilder();
          }
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          autoscalingLimits_ = null;
          if (autoscalingLimitsBuilder_ != null) {
            autoscalingLimitsBuilder_.dispose();
            autoscalingLimitsBuilder_ = null;
          }
          autoscalingTargetHighPriorityCpuUtilizationPercent_ = 0;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
              .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_AutoscalingConfigOverrides_descriptor;
        }

        @java.lang.Override
        public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .AutoscalingConfigOverrides
            getDefaultInstanceForType() {
          return com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverrides.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .AutoscalingConfigOverrides
            build() {
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .AutoscalingConfigOverrides
            buildPartial() {
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides
              result =
                  new com.google.spanner.admin.instance.v1.AutoscalingConfig
                      .AsymmetricAutoscalingOption.AutoscalingConfigOverrides(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                    .AutoscalingConfigOverrides
                result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.autoscalingLimits_ =
                autoscalingLimitsBuilder_ == null
                    ? autoscalingLimits_
                    : autoscalingLimitsBuilder_.build();
            to_bitField0_ |= 0x00000001;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.autoscalingTargetHighPriorityCpuUtilizationPercent_ =
                autoscalingTargetHighPriorityCpuUtilizationPercent_;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides) {
            return mergeFrom(
                (com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                        .AutoscalingConfigOverrides)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                    .AutoscalingConfigOverrides
                other) {
          if (other
              == com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides.getDefaultInstance()) return this;
          if (other.hasAutoscalingLimits()) {
            mergeAutoscalingLimits(other.getAutoscalingLimits());
          }
          if (other.getAutoscalingTargetHighPriorityCpuUtilizationPercent() != 0) {
            setAutoscalingTargetHighPriorityCpuUtilizationPercent(
                other.getAutoscalingTargetHighPriorityCpuUtilizationPercent());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getAutoscalingLimitsFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 16:
                  {
                    autoscalingTargetHighPriorityCpuUtilizationPercent_ = input.readInt32();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
            autoscalingLimits_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder>
            autoscalingLimitsBuilder_;

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return Whether the autoscalingLimits field is set.
         */
        public boolean hasAutoscalingLimits() {
          return ((bitField0_ & 0x00000001) != 0);
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The autoscalingLimits.
         */
        public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
            getAutoscalingLimits() {
          if (autoscalingLimitsBuilder_ == null) {
            return autoscalingLimits_ == null
                ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                    .getDefaultInstance()
                : autoscalingLimits_;
          } else {
            return autoscalingLimitsBuilder_.getMessage();
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setAutoscalingLimits(
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits value) {
          if (autoscalingLimitsBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            autoscalingLimits_ = value;
          } else {
            autoscalingLimitsBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder setAutoscalingLimits(
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder
                builderForValue) {
          if (autoscalingLimitsBuilder_ == null) {
            autoscalingLimits_ = builderForValue.build();
          } else {
            autoscalingLimitsBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder mergeAutoscalingLimits(
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits value) {
          if (autoscalingLimitsBuilder_ == null) {
            if (((bitField0_ & 0x00000001) != 0)
                && autoscalingLimits_ != null
                && autoscalingLimits_
                    != com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                        .getDefaultInstance()) {
              getAutoscalingLimitsBuilder().mergeFrom(value);
            } else {
              autoscalingLimits_ = value;
            }
          } else {
            autoscalingLimitsBuilder_.mergeFrom(value);
          }
          if (autoscalingLimits_ != null) {
            bitField0_ |= 0x00000001;
            onChanged();
          }
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public Builder clearAutoscalingLimits() {
          bitField0_ = (bitField0_ & ~0x00000001);
          autoscalingLimits_ = null;
          if (autoscalingLimitsBuilder_ != null) {
            autoscalingLimitsBuilder_.dispose();
            autoscalingLimitsBuilder_ = null;
          }
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder
            getAutoscalingLimitsBuilder() {
          bitField0_ |= 0x00000001;
          onChanged();
          return getAutoscalingLimitsFieldBuilder().getBuilder();
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder
            getAutoscalingLimitsOrBuilder() {
          if (autoscalingLimitsBuilder_ != null) {
            return autoscalingLimitsBuilder_.getMessageOrBuilder();
          } else {
            return autoscalingLimits_ == null
                ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                    .getDefaultInstance()
                : autoscalingLimits_;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the min/max limit in the top-level
         * autoscaling configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder>
            getAutoscalingLimitsFieldBuilder() {
          if (autoscalingLimitsBuilder_ == null) {
            autoscalingLimitsBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits,
                    com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                        .Builder,
                    com.google.spanner.admin.instance.v1.AutoscalingConfig
                        .AutoscalingLimitsOrBuilder>(
                    getAutoscalingLimits(), getParentForChildren(), isClean());
            autoscalingLimits_ = null;
          }
          return autoscalingLimitsBuilder_;
        }

        private int autoscalingTargetHighPriorityCpuUtilizationPercent_;

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the autoscaling target
         * high_priority_cpu_utilization_percent in the top-level autoscaling
         * configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * int32 autoscaling_target_high_priority_cpu_utilization_percent = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return The autoscalingTargetHighPriorityCpuUtilizationPercent.
         */
        @java.lang.Override
        public int getAutoscalingTargetHighPriorityCpuUtilizationPercent() {
          return autoscalingTargetHighPriorityCpuUtilizationPercent_;
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the autoscaling target
         * high_priority_cpu_utilization_percent in the top-level autoscaling
         * configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * int32 autoscaling_target_high_priority_cpu_utilization_percent = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @param value The autoscalingTargetHighPriorityCpuUtilizationPercent to set.
         * @return This builder for chaining.
         */
        public Builder setAutoscalingTargetHighPriorityCpuUtilizationPercent(int value) {

          autoscalingTargetHighPriorityCpuUtilizationPercent_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. If specified, overrides the autoscaling target
         * high_priority_cpu_utilization_percent in the top-level autoscaling
         * configuration for the selected replicas.
         * </pre>
         *
         * <code>
         * int32 autoscaling_target_high_priority_cpu_utilization_percent = 2 [(.google.api.field_behavior) = OPTIONAL];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearAutoscalingTargetHighPriorityCpuUtilizationPercent() {
          bitField0_ = (bitField0_ & ~0x00000002);
          autoscalingTargetHighPriorityCpuUtilizationPercent_ = 0;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides)
      }

      // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides)
      private static final com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .AutoscalingConfigOverrides();
      }

      public static com.google.spanner.admin.instance.v1.AutoscalingConfig
              .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<AutoscalingConfigOverrides> PARSER =
          new com.google.protobuf.AbstractParser<AutoscalingConfigOverrides>() {
            @java.lang.Override
            public AutoscalingConfigOverrides parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<AutoscalingConfigOverrides> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<AutoscalingConfigOverrides> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverrides
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int REPLICA_SELECTION_FIELD_NUMBER = 1;
    private com.google.spanner.admin.instance.v1.ReplicaSelection replicaSelection_;

    /**
     *
     *
     * <pre>
     * Required. Selects the replicas to which this AsymmetricAutoscalingOption
     * applies. Only read-only replicas are supported.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the replicaSelection field is set.
     */
    @java.lang.Override
    public boolean hasReplicaSelection() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Selects the replicas to which this AsymmetricAutoscalingOption
     * applies. Only read-only replicas are supported.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The replicaSelection.
     */
    @java.lang.Override
    public com.google.spanner.admin.instance.v1.ReplicaSelection getReplicaSelection() {
      return replicaSelection_ == null
          ? com.google.spanner.admin.instance.v1.ReplicaSelection.getDefaultInstance()
          : replicaSelection_;
    }

    /**
     *
     *
     * <pre>
     * Required. Selects the replicas to which this AsymmetricAutoscalingOption
     * applies. Only read-only replicas are supported.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.admin.instance.v1.ReplicaSelectionOrBuilder
        getReplicaSelectionOrBuilder() {
      return replicaSelection_ == null
          ? com.google.spanner.admin.instance.v1.ReplicaSelection.getDefaultInstance()
          : replicaSelection_;
    }

    public static final int OVERRIDES_FIELD_NUMBER = 2;
    private com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .AutoscalingConfigOverrides
        overrides_;

    /**
     *
     *
     * <pre>
     * Optional. Overrides applied to the top-level autoscaling configuration
     * for the selected replicas.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the overrides field is set.
     */
    @java.lang.Override
    public boolean hasOverrides() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Overrides applied to the top-level autoscaling configuration
     * for the selected replicas.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The overrides.
     */
    @java.lang.Override
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .AutoscalingConfigOverrides
        getOverrides() {
      return overrides_ == null
          ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverrides.getDefaultInstance()
          : overrides_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Overrides applied to the top-level autoscaling configuration
     * for the selected replicas.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .AutoscalingConfigOverridesOrBuilder
        getOverridesOrBuilder() {
      return overrides_ == null
          ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverrides.getDefaultInstance()
          : overrides_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getReplicaSelection());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getOverrides());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReplicaSelection());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOverrides());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption)) {
        return super.equals(obj);
      }
      com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption other =
          (com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption) obj;

      if (hasReplicaSelection() != other.hasReplicaSelection()) return false;
      if (hasReplicaSelection()) {
        if (!getReplicaSelection().equals(other.getReplicaSelection())) return false;
      }
      if (hasOverrides() != other.hasOverrides()) return false;
      if (hasOverrides()) {
        if (!getOverrides().equals(other.getOverrides())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasReplicaSelection()) {
        hash = (37 * hash) + REPLICA_SELECTION_FIELD_NUMBER;
        hash = (53 * hash) + getReplicaSelection().hashCode();
      }
      if (hasOverrides()) {
        hash = (37 * hash) + OVERRIDES_FIELD_NUMBER;
        hash = (53 * hash) + getOverrides().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * AsymmetricAutoscalingOption specifies the scaling of replicas identified by
     * the given selection.
     * </pre>
     *
     * Protobuf type {@code
     * google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption)
        com.google.spanner.admin.instance.v1.AutoscalingConfig
            .AsymmetricAutoscalingOptionOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                    .class,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                    .Builder.class);
      }

      // Construct using
      // com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getReplicaSelectionFieldBuilder();
          getOverridesFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        replicaSelection_ = null;
        if (replicaSelectionBuilder_ != null) {
          replicaSelectionBuilder_.dispose();
          replicaSelectionBuilder_ = null;
        }
        overrides_ = null;
        if (overridesBuilder_ != null) {
          overridesBuilder_.dispose();
          overridesBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
            .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_AsymmetricAutoscalingOption_descriptor;
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
          getDefaultInstanceForType() {
        return com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
          build() {
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
          buildPartial() {
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption result =
            new com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.replicaSelection_ =
              replicaSelectionBuilder_ == null
                  ? replicaSelection_
                  : replicaSelectionBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.overrides_ = overridesBuilder_ == null ? overrides_ : overridesBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption) {
          return mergeFrom(
              (com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              other) {
        if (other
            == com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .getDefaultInstance()) return this;
        if (other.hasReplicaSelection()) {
          mergeReplicaSelection(other.getReplicaSelection());
        }
        if (other.hasOverrides()) {
          mergeOverrides(other.getOverrides());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getReplicaSelectionFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getOverridesFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.spanner.admin.instance.v1.ReplicaSelection replicaSelection_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.spanner.admin.instance.v1.ReplicaSelection,
              com.google.spanner.admin.instance.v1.ReplicaSelection.Builder,
              com.google.spanner.admin.instance.v1.ReplicaSelectionOrBuilder>
          replicaSelectionBuilder_;

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the replicaSelection field is set.
       */
      public boolean hasReplicaSelection() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The replicaSelection.
       */
      public com.google.spanner.admin.instance.v1.ReplicaSelection getReplicaSelection() {
        if (replicaSelectionBuilder_ == null) {
          return replicaSelection_ == null
              ? com.google.spanner.admin.instance.v1.ReplicaSelection.getDefaultInstance()
              : replicaSelection_;
        } else {
          return replicaSelectionBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setReplicaSelection(
          com.google.spanner.admin.instance.v1.ReplicaSelection value) {
        if (replicaSelectionBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          replicaSelection_ = value;
        } else {
          replicaSelectionBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder setReplicaSelection(
          com.google.spanner.admin.instance.v1.ReplicaSelection.Builder builderForValue) {
        if (replicaSelectionBuilder_ == null) {
          replicaSelection_ = builderForValue.build();
        } else {
          replicaSelectionBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder mergeReplicaSelection(
          com.google.spanner.admin.instance.v1.ReplicaSelection value) {
        if (replicaSelectionBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && replicaSelection_ != null
              && replicaSelection_
                  != com.google.spanner.admin.instance.v1.ReplicaSelection.getDefaultInstance()) {
            getReplicaSelectionBuilder().mergeFrom(value);
          } else {
            replicaSelection_ = value;
          }
        } else {
          replicaSelectionBuilder_.mergeFrom(value);
        }
        if (replicaSelection_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public Builder clearReplicaSelection() {
        bitField0_ = (bitField0_ & ~0x00000001);
        replicaSelection_ = null;
        if (replicaSelectionBuilder_ != null) {
          replicaSelectionBuilder_.dispose();
          replicaSelectionBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.admin.instance.v1.ReplicaSelection.Builder
          getReplicaSelectionBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getReplicaSelectionFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      public com.google.spanner.admin.instance.v1.ReplicaSelectionOrBuilder
          getReplicaSelectionOrBuilder() {
        if (replicaSelectionBuilder_ != null) {
          return replicaSelectionBuilder_.getMessageOrBuilder();
        } else {
          return replicaSelection_ == null
              ? com.google.spanner.admin.instance.v1.ReplicaSelection.getDefaultInstance()
              : replicaSelection_;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Selects the replicas to which this AsymmetricAutoscalingOption
       * applies. Only read-only replicas are supported.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.ReplicaSelection replica_selection = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.spanner.admin.instance.v1.ReplicaSelection,
              com.google.spanner.admin.instance.v1.ReplicaSelection.Builder,
              com.google.spanner.admin.instance.v1.ReplicaSelectionOrBuilder>
          getReplicaSelectionFieldBuilder() {
        if (replicaSelectionBuilder_ == null) {
          replicaSelectionBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.spanner.admin.instance.v1.ReplicaSelection,
                  com.google.spanner.admin.instance.v1.ReplicaSelection.Builder,
                  com.google.spanner.admin.instance.v1.ReplicaSelectionOrBuilder>(
                  getReplicaSelection(), getParentForChildren(), isClean());
          replicaSelection_ = null;
        }
        return replicaSelectionBuilder_;
      }

      private com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverrides
          overrides_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides.Builder,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverridesOrBuilder>
          overridesBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the overrides field is set.
       */
      public boolean hasOverrides() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The overrides.
       */
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverrides
          getOverrides() {
        if (overridesBuilder_ == null) {
          return overrides_ == null
              ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides.getDefaultInstance()
              : overrides_;
        } else {
          return overridesBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOverrides(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides
              value) {
        if (overridesBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          overrides_ = value;
        } else {
          overridesBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setOverrides(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides.Builder
              builderForValue) {
        if (overridesBuilder_ == null) {
          overrides_ = builderForValue.build();
        } else {
          overridesBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergeOverrides(
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides
              value) {
        if (overridesBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && overrides_ != null
              && overrides_
                  != com.google.spanner.admin.instance.v1.AutoscalingConfig
                      .AsymmetricAutoscalingOption.AutoscalingConfigOverrides
                      .getDefaultInstance()) {
            getOverridesBuilder().mergeFrom(value);
          } else {
            overrides_ = value;
          }
        } else {
          overridesBuilder_.mergeFrom(value);
        }
        if (overrides_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearOverrides() {
        bitField0_ = (bitField0_ & ~0x00000002);
        overrides_ = null;
        if (overridesBuilder_ != null) {
          overridesBuilder_.dispose();
          overridesBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverrides.Builder
          getOverridesBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getOverridesFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
              .AutoscalingConfigOverridesOrBuilder
          getOverridesOrBuilder() {
        if (overridesBuilder_ != null) {
          return overridesBuilder_.getMessageOrBuilder();
        } else {
          return overrides_ == null
              ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides.getDefaultInstance()
              : overrides_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Overrides applied to the top-level autoscaling configuration
       * for the selected replicas.
       * </pre>
       *
       * <code>
       * .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.AutoscalingConfigOverrides overrides = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverrides.Builder,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .AutoscalingConfigOverridesOrBuilder>
          getOverridesFieldBuilder() {
        if (overridesBuilder_ == null) {
          overridesBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                      .AutoscalingConfigOverrides,
                  com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                      .AutoscalingConfigOverrides.Builder,
                  com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                      .AutoscalingConfigOverridesOrBuilder>(
                  getOverrides(), getParentForChildren(), isClean());
          overrides_ = null;
        }
        return overridesBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption)
    }

    // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption)
    private static final com.google.spanner.admin.instance.v1.AutoscalingConfig
            .AsymmetricAutoscalingOption
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption();
    }

    public static com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AsymmetricAutoscalingOption> PARSER =
        new com.google.protobuf.AbstractParser<AsymmetricAutoscalingOption>() {
          @java.lang.Override
          public AsymmetricAutoscalingOption parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AsymmetricAutoscalingOption> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AsymmetricAutoscalingOption> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int AUTOSCALING_LIMITS_FIELD_NUMBER = 1;
  private com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
      autoscalingLimits_;

  /**
   *
   *
   * <pre>
   * Required. Autoscaling limits for an instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the autoscalingLimits field is set.
   */
  @java.lang.Override
  public boolean hasAutoscalingLimits() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. Autoscaling limits for an instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The autoscalingLimits.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
      getAutoscalingLimits() {
    return autoscalingLimits_ == null
        ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
            .getDefaultInstance()
        : autoscalingLimits_;
  }

  /**
   *
   *
   * <pre>
   * Required. Autoscaling limits for an instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder
      getAutoscalingLimitsOrBuilder() {
    return autoscalingLimits_ == null
        ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
            .getDefaultInstance()
        : autoscalingLimits_;
  }

  public static final int AUTOSCALING_TARGETS_FIELD_NUMBER = 2;
  private com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
      autoscalingTargets_;

  /**
   *
   *
   * <pre>
   * Required. The autoscaling targets for an instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the autoscalingTargets field is set.
   */
  @java.lang.Override
  public boolean hasAutoscalingTargets() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Required. The autoscaling targets for an instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The autoscalingTargets.
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
      getAutoscalingTargets() {
    return autoscalingTargets_ == null
        ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
            .getDefaultInstance()
        : autoscalingTargets_;
  }

  /**
   *
   *
   * <pre>
   * Required. The autoscaling targets for an instance.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargetsOrBuilder
      getAutoscalingTargetsOrBuilder() {
    return autoscalingTargets_ == null
        ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
            .getDefaultInstance()
        : autoscalingTargets_;
  }

  public static final int ASYMMETRIC_AUTOSCALING_OPTIONS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption>
      asymmetricAutoscalingOptions_;

  /**
   *
   *
   * <pre>
   * Optional. Optional asymmetric autoscaling options.
   * Replicas matching the replica selection criteria will be autoscaled
   * independently from other replicas. The autoscaler will scale the replicas
   * based on the utilization of replicas identified by the replica selection.
   * Replica selections should not overlap with each other.
   *
   * Other replicas (those do not match any replica selection) will be
   * autoscaled together and will have the same compute capacity allocated to
   * them.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption>
      getAsymmetricAutoscalingOptionsList() {
    return asymmetricAutoscalingOptions_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional asymmetric autoscaling options.
   * Replicas matching the replica selection criteria will be autoscaled
   * independently from other replicas. The autoscaler will scale the replicas
   * based on the utilization of replicas identified by the replica selection.
   * Replica selections should not overlap with each other.
   *
   * Other replicas (those do not match any replica selection) will be
   * autoscaled together and will have the same compute capacity allocated to
   * them.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.spanner.admin.instance.v1.AutoscalingConfig
                  .AsymmetricAutoscalingOptionOrBuilder>
      getAsymmetricAutoscalingOptionsOrBuilderList() {
    return asymmetricAutoscalingOptions_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional asymmetric autoscaling options.
   * Replicas matching the replica selection criteria will be autoscaled
   * independently from other replicas. The autoscaler will scale the replicas
   * based on the utilization of replicas identified by the replica selection.
   * Replica selections should not overlap with each other.
   *
   * Other replicas (those do not match any replica selection) will be
   * autoscaled together and will have the same compute capacity allocated to
   * them.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getAsymmetricAutoscalingOptionsCount() {
    return asymmetricAutoscalingOptions_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional asymmetric autoscaling options.
   * Replicas matching the replica selection criteria will be autoscaled
   * independently from other replicas. The autoscaler will scale the replicas
   * based on the utilization of replicas identified by the replica selection.
   * Replica selections should not overlap with each other.
   *
   * Other replicas (those do not match any replica selection) will be
   * autoscaled together and will have the same compute capacity allocated to
   * them.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
      getAsymmetricAutoscalingOptions(int index) {
    return asymmetricAutoscalingOptions_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Optional asymmetric autoscaling options.
   * Replicas matching the replica selection criteria will be autoscaled
   * independently from other replicas. The autoscaler will scale the replicas
   * based on the utilization of replicas identified by the replica selection.
   * Replica selections should not overlap with each other.
   *
   * Other replicas (those do not match any replica selection) will be
   * autoscaled together and will have the same compute capacity allocated to
   * them.
   * </pre>
   *
   * <code>
   * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOptionOrBuilder
      getAsymmetricAutoscalingOptionsOrBuilder(int index) {
    return asymmetricAutoscalingOptions_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getAutoscalingLimits());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getAutoscalingTargets());
    }
    for (int i = 0; i < asymmetricAutoscalingOptions_.size(); i++) {
      output.writeMessage(3, asymmetricAutoscalingOptions_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAutoscalingLimits());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getAutoscalingTargets());
    }
    for (int i = 0; i < asymmetricAutoscalingOptions_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, asymmetricAutoscalingOptions_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.instance.v1.AutoscalingConfig)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.instance.v1.AutoscalingConfig other =
        (com.google.spanner.admin.instance.v1.AutoscalingConfig) obj;

    if (hasAutoscalingLimits() != other.hasAutoscalingLimits()) return false;
    if (hasAutoscalingLimits()) {
      if (!getAutoscalingLimits().equals(other.getAutoscalingLimits())) return false;
    }
    if (hasAutoscalingTargets() != other.hasAutoscalingTargets()) return false;
    if (hasAutoscalingTargets()) {
      if (!getAutoscalingTargets().equals(other.getAutoscalingTargets())) return false;
    }
    if (!getAsymmetricAutoscalingOptionsList().equals(other.getAsymmetricAutoscalingOptionsList()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAutoscalingLimits()) {
      hash = (37 * hash) + AUTOSCALING_LIMITS_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingLimits().hashCode();
    }
    if (hasAutoscalingTargets()) {
      hash = (37 * hash) + AUTOSCALING_TARGETS_FIELD_NUMBER;
      hash = (53 * hash) + getAutoscalingTargets().hashCode();
    }
    if (getAsymmetricAutoscalingOptionsCount() > 0) {
      hash = (37 * hash) + ASYMMETRIC_AUTOSCALING_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getAsymmetricAutoscalingOptionsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.instance.v1.AutoscalingConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Autoscaling configuration for an instance.
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.instance.v1.AutoscalingConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.instance.v1.AutoscalingConfig)
      com.google.spanner.admin.instance.v1.AutoscalingConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.instance.v1.AutoscalingConfig.class,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.Builder.class);
    }

    // Construct using com.google.spanner.admin.instance.v1.AutoscalingConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAutoscalingLimitsFieldBuilder();
        getAutoscalingTargetsFieldBuilder();
        getAsymmetricAutoscalingOptionsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      autoscalingLimits_ = null;
      if (autoscalingLimitsBuilder_ != null) {
        autoscalingLimitsBuilder_.dispose();
        autoscalingLimitsBuilder_ = null;
      }
      autoscalingTargets_ = null;
      if (autoscalingTargetsBuilder_ != null) {
        autoscalingTargetsBuilder_.dispose();
        autoscalingTargetsBuilder_ = null;
      }
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        asymmetricAutoscalingOptions_ = java.util.Collections.emptyList();
      } else {
        asymmetricAutoscalingOptions_ = null;
        asymmetricAutoscalingOptionsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.instance.v1.SpannerInstanceAdminProto
          .internal_static_google_spanner_admin_instance_v1_AutoscalingConfig_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.AutoscalingConfig getDefaultInstanceForType() {
      return com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.AutoscalingConfig build() {
      com.google.spanner.admin.instance.v1.AutoscalingConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.instance.v1.AutoscalingConfig buildPartial() {
      com.google.spanner.admin.instance.v1.AutoscalingConfig result =
          new com.google.spanner.admin.instance.v1.AutoscalingConfig(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.spanner.admin.instance.v1.AutoscalingConfig result) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          asymmetricAutoscalingOptions_ =
              java.util.Collections.unmodifiableList(asymmetricAutoscalingOptions_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.asymmetricAutoscalingOptions_ = asymmetricAutoscalingOptions_;
      } else {
        result.asymmetricAutoscalingOptions_ = asymmetricAutoscalingOptionsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.spanner.admin.instance.v1.AutoscalingConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.autoscalingLimits_ =
            autoscalingLimitsBuilder_ == null
                ? autoscalingLimits_
                : autoscalingLimitsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.autoscalingTargets_ =
            autoscalingTargetsBuilder_ == null
                ? autoscalingTargets_
                : autoscalingTargetsBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.instance.v1.AutoscalingConfig) {
        return mergeFrom((com.google.spanner.admin.instance.v1.AutoscalingConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.instance.v1.AutoscalingConfig other) {
      if (other == com.google.spanner.admin.instance.v1.AutoscalingConfig.getDefaultInstance())
        return this;
      if (other.hasAutoscalingLimits()) {
        mergeAutoscalingLimits(other.getAutoscalingLimits());
      }
      if (other.hasAutoscalingTargets()) {
        mergeAutoscalingTargets(other.getAutoscalingTargets());
      }
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        if (!other.asymmetricAutoscalingOptions_.isEmpty()) {
          if (asymmetricAutoscalingOptions_.isEmpty()) {
            asymmetricAutoscalingOptions_ = other.asymmetricAutoscalingOptions_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureAsymmetricAutoscalingOptionsIsMutable();
            asymmetricAutoscalingOptions_.addAll(other.asymmetricAutoscalingOptions_);
          }
          onChanged();
        }
      } else {
        if (!other.asymmetricAutoscalingOptions_.isEmpty()) {
          if (asymmetricAutoscalingOptionsBuilder_.isEmpty()) {
            asymmetricAutoscalingOptionsBuilder_.dispose();
            asymmetricAutoscalingOptionsBuilder_ = null;
            asymmetricAutoscalingOptions_ = other.asymmetricAutoscalingOptions_;
            bitField0_ = (bitField0_ & ~0x00000004);
            asymmetricAutoscalingOptionsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getAsymmetricAutoscalingOptionsFieldBuilder()
                    : null;
          } else {
            asymmetricAutoscalingOptionsBuilder_.addAllMessages(
                other.asymmetricAutoscalingOptions_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getAutoscalingLimitsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(
                    getAutoscalingTargetsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                    m =
                        input.readMessage(
                            com.google.spanner.admin.instance.v1.AutoscalingConfig
                                .AsymmetricAutoscalingOption.parser(),
                            extensionRegistry);
                if (asymmetricAutoscalingOptionsBuilder_ == null) {
                  ensureAsymmetricAutoscalingOptionsIsMutable();
                  asymmetricAutoscalingOptions_.add(m);
                } else {
                  asymmetricAutoscalingOptionsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        autoscalingLimits_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder>
        autoscalingLimitsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoscalingLimits field is set.
     */
    public boolean hasAutoscalingLimits() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoscalingLimits.
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
        getAutoscalingLimits() {
      if (autoscalingLimitsBuilder_ == null) {
        return autoscalingLimits_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                .getDefaultInstance()
            : autoscalingLimits_;
      } else {
        return autoscalingLimitsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAutoscalingLimits(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits value) {
      if (autoscalingLimitsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscalingLimits_ = value;
      } else {
        autoscalingLimitsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAutoscalingLimits(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder
            builderForValue) {
      if (autoscalingLimitsBuilder_ == null) {
        autoscalingLimits_ = builderForValue.build();
      } else {
        autoscalingLimitsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAutoscalingLimits(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits value) {
      if (autoscalingLimitsBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && autoscalingLimits_ != null
            && autoscalingLimits_
                != com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                    .getDefaultInstance()) {
          getAutoscalingLimitsBuilder().mergeFrom(value);
        } else {
          autoscalingLimits_ = value;
        }
      } else {
        autoscalingLimitsBuilder_.mergeFrom(value);
      }
      if (autoscalingLimits_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAutoscalingLimits() {
      bitField0_ = (bitField0_ & ~0x00000001);
      autoscalingLimits_ = null;
      if (autoscalingLimitsBuilder_ != null) {
        autoscalingLimitsBuilder_.dispose();
        autoscalingLimitsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder
        getAutoscalingLimitsBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAutoscalingLimitsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder
        getAutoscalingLimitsOrBuilder() {
      if (autoscalingLimitsBuilder_ != null) {
        return autoscalingLimitsBuilder_.getMessageOrBuilder();
      } else {
        return autoscalingLimits_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits
                .getDefaultInstance()
            : autoscalingLimits_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Autoscaling limits for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits autoscaling_limits = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder>
        getAutoscalingLimitsFieldBuilder() {
      if (autoscalingLimitsBuilder_ == null) {
        autoscalingLimitsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimits.Builder,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingLimitsOrBuilder>(
                getAutoscalingLimits(), getParentForChildren(), isClean());
        autoscalingLimits_ = null;
      }
      return autoscalingLimitsBuilder_;
    }

    private com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        autoscalingTargets_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargetsOrBuilder>
        autoscalingTargetsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the autoscalingTargets field is set.
     */
    public boolean hasAutoscalingTargets() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The autoscalingTargets.
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
        getAutoscalingTargets() {
      if (autoscalingTargetsBuilder_ == null) {
        return autoscalingTargets_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
                .getDefaultInstance()
            : autoscalingTargets_;
      } else {
        return autoscalingTargetsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAutoscalingTargets(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets value) {
      if (autoscalingTargetsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        autoscalingTargets_ = value;
      } else {
        autoscalingTargetsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setAutoscalingTargets(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.Builder
            builderForValue) {
      if (autoscalingTargetsBuilder_ == null) {
        autoscalingTargets_ = builderForValue.build();
      } else {
        autoscalingTargetsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeAutoscalingTargets(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets value) {
      if (autoscalingTargetsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && autoscalingTargets_ != null
            && autoscalingTargets_
                != com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
                    .getDefaultInstance()) {
          getAutoscalingTargetsBuilder().mergeFrom(value);
        } else {
          autoscalingTargets_ = value;
        }
      } else {
        autoscalingTargetsBuilder_.mergeFrom(value);
      }
      if (autoscalingTargets_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearAutoscalingTargets() {
      bitField0_ = (bitField0_ & ~0x00000002);
      autoscalingTargets_ = null;
      if (autoscalingTargetsBuilder_ != null) {
        autoscalingTargetsBuilder_.dispose();
        autoscalingTargetsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.Builder
        getAutoscalingTargetsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getAutoscalingTargetsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargetsOrBuilder
        getAutoscalingTargetsOrBuilder() {
      if (autoscalingTargetsBuilder_ != null) {
        return autoscalingTargetsBuilder_.getMessageOrBuilder();
      } else {
        return autoscalingTargets_ == null
            ? com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets
                .getDefaultInstance()
            : autoscalingTargets_;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The autoscaling targets for an instance.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets autoscaling_targets = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargetsOrBuilder>
        getAutoscalingTargetsFieldBuilder() {
      if (autoscalingTargetsBuilder_ == null) {
        autoscalingTargetsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargets.Builder,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AutoscalingTargetsOrBuilder>(
                getAutoscalingTargets(), getParentForChildren(), isClean());
        autoscalingTargets_ = null;
      }
      return autoscalingTargetsBuilder_;
    }

    private java.util.List<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption>
        asymmetricAutoscalingOptions_ = java.util.Collections.emptyList();

    private void ensureAsymmetricAutoscalingOptionsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        asymmetricAutoscalingOptions_ =
            new java.util.ArrayList<
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption>(
                asymmetricAutoscalingOptions_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfig
                .AsymmetricAutoscalingOptionOrBuilder>
        asymmetricAutoscalingOptionsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption>
        getAsymmetricAutoscalingOptionsList() {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(asymmetricAutoscalingOptions_);
      } else {
        return asymmetricAutoscalingOptionsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getAsymmetricAutoscalingOptionsCount() {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        return asymmetricAutoscalingOptions_.size();
      } else {
        return asymmetricAutoscalingOptionsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
        getAsymmetricAutoscalingOptions(int index) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        return asymmetricAutoscalingOptions_.get(index);
      } else {
        return asymmetricAutoscalingOptionsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAsymmetricAutoscalingOptions(
        int index,
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption value) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsymmetricAutoscalingOptionsIsMutable();
        asymmetricAutoscalingOptions_.set(index, value);
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setAsymmetricAutoscalingOptions(
        int index,
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.Builder
            builderForValue) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        ensureAsymmetricAutoscalingOptionsIsMutable();
        asymmetricAutoscalingOptions_.set(index, builderForValue.build());
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAsymmetricAutoscalingOptions(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption value) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsymmetricAutoscalingOptionsIsMutable();
        asymmetricAutoscalingOptions_.add(value);
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAsymmetricAutoscalingOptions(
        int index,
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption value) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAsymmetricAutoscalingOptionsIsMutable();
        asymmetricAutoscalingOptions_.add(index, value);
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAsymmetricAutoscalingOptions(
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.Builder
            builderForValue) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        ensureAsymmetricAutoscalingOptionsIsMutable();
        asymmetricAutoscalingOptions_.add(builderForValue.build());
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAsymmetricAutoscalingOptions(
        int index,
        com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption.Builder
            builderForValue) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        ensureAsymmetricAutoscalingOptionsIsMutable();
        asymmetricAutoscalingOptions_.add(index, builderForValue.build());
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllAsymmetricAutoscalingOptions(
        java.lang.Iterable<
                ? extends
                    com.google.spanner.admin.instance.v1.AutoscalingConfig
                        .AsymmetricAutoscalingOption>
            values) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        ensureAsymmetricAutoscalingOptionsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, asymmetricAutoscalingOptions_);
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearAsymmetricAutoscalingOptions() {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        asymmetricAutoscalingOptions_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeAsymmetricAutoscalingOptions(int index) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        ensureAsymmetricAutoscalingOptionsIsMutable();
        asymmetricAutoscalingOptions_.remove(index);
        onChanged();
      } else {
        asymmetricAutoscalingOptionsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .Builder
        getAsymmetricAutoscalingOptionsBuilder(int index) {
      return getAsymmetricAutoscalingOptionsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig
            .AsymmetricAutoscalingOptionOrBuilder
        getAsymmetricAutoscalingOptionsOrBuilder(int index) {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        return asymmetricAutoscalingOptions_.get(index);
      } else {
        return asymmetricAutoscalingOptionsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.spanner.admin.instance.v1.AutoscalingConfig
                    .AsymmetricAutoscalingOptionOrBuilder>
        getAsymmetricAutoscalingOptionsOrBuilderList() {
      if (asymmetricAutoscalingOptionsBuilder_ != null) {
        return asymmetricAutoscalingOptionsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(asymmetricAutoscalingOptions_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .Builder
        addAsymmetricAutoscalingOptionsBuilder() {
      return getAsymmetricAutoscalingOptionsFieldBuilder()
          .addBuilder(
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
            .Builder
        addAsymmetricAutoscalingOptionsBuilder(int index) {
      return getAsymmetricAutoscalingOptionsFieldBuilder()
          .addBuilder(
              index,
              com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Optional asymmetric autoscaling options.
     * Replicas matching the replica selection criteria will be autoscaled
     * independently from other replicas. The autoscaler will scale the replicas
     * based on the utilization of replicas identified by the replica selection.
     * Replica selections should not overlap with each other.
     *
     * Other replicas (those do not match any replica selection) will be
     * autoscaled together and will have the same compute capacity allocated to
     * them.
     * </pre>
     *
     * <code>
     * repeated .google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption asymmetric_autoscaling_options = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .Builder>
        getAsymmetricAutoscalingOptionsBuilderList() {
      return getAsymmetricAutoscalingOptionsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption,
            com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                .Builder,
            com.google.spanner.admin.instance.v1.AutoscalingConfig
                .AsymmetricAutoscalingOptionOrBuilder>
        getAsymmetricAutoscalingOptionsFieldBuilder() {
      if (asymmetricAutoscalingOptionsBuilder_ == null) {
        asymmetricAutoscalingOptionsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption,
                com.google.spanner.admin.instance.v1.AutoscalingConfig.AsymmetricAutoscalingOption
                    .Builder,
                com.google.spanner.admin.instance.v1.AutoscalingConfig
                    .AsymmetricAutoscalingOptionOrBuilder>(
                asymmetricAutoscalingOptions_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        asymmetricAutoscalingOptions_ = null;
      }
      return asymmetricAutoscalingOptionsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.instance.v1.AutoscalingConfig)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.instance.v1.AutoscalingConfig)
  private static final com.google.spanner.admin.instance.v1.AutoscalingConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.instance.v1.AutoscalingConfig();
  }

  public static com.google.spanner.admin.instance.v1.AutoscalingConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutoscalingConfig> PARSER =
      new com.google.protobuf.AbstractParser<AutoscalingConfig>() {
        @java.lang.Override
        public AutoscalingConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutoscalingConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutoscalingConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.instance.v1.AutoscalingConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
