/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/spanner/admin/database/v1/backup.proto

// Protobuf Java Version: 3.25.4
package com.google.spanner.admin.database.v1;

/**
 *
 *
 * <pre>
 * The request for
 * [CopyBackup][google.spanner.admin.database.v1.DatabaseAdmin.CopyBackup].
 * </pre>
 *
 * Protobuf type {@code google.spanner.admin.database.v1.CopyBackupRequest}
 */
public final class CopyBackupRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.spanner.admin.database.v1.CopyBackupRequest)
    CopyBackupRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use CopyBackupRequest.newBuilder() to construct.
  private CopyBackupRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private CopyBackupRequest() {
    parent_ = "";
    backupId_ = "";
    sourceBackup_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new CopyBackupRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_CopyBackupRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.spanner.admin.database.v1.BackupProto
        .internal_static_google_spanner_admin_database_v1_CopyBackupRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.spanner.admin.database.v1.CopyBackupRequest.class,
            com.google.spanner.admin.database.v1.CopyBackupRequest.Builder.class);
  }

  private int bitField0_;
  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the destination instance that will contain the backup
   * copy. Values are of the form: `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the destination instance that will contain the backup
   * copy. Values are of the form: `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int BACKUP_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object backupId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The id of the backup copy.
   * The `backup_id` appended to `parent` forms the full backup_uri of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The backupId.
   */
  @java.lang.Override
  public java.lang.String getBackupId() {
    java.lang.Object ref = backupId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      backupId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The id of the backup copy.
   * The `backup_id` appended to `parent` forms the full backup_uri of the form
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for backupId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getBackupIdBytes() {
    java.lang.Object ref = backupId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      backupId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SOURCE_BACKUP_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object sourceBackup_ = "";
  /**
   *
   *
   * <pre>
   * Required. The source backup to be copied.
   * The source backup needs to be in READY state for it to be copied.
   * Once CopyBackup is in progress, the source backup cannot be deleted or
   * cleaned up on expiration until CopyBackup is finished.
   * Values are of the form:
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>
   * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The sourceBackup.
   */
  @java.lang.Override
  public java.lang.String getSourceBackup() {
    java.lang.Object ref = sourceBackup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      sourceBackup_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The source backup to be copied.
   * The source backup needs to be in READY state for it to be copied.
   * Once CopyBackup is in progress, the source backup cannot be deleted or
   * cleaned up on expiration until CopyBackup is finished.
   * Values are of the form:
   * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
   * </pre>
   *
   * <code>
   * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for sourceBackup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSourceBackupBytes() {
    java.lang.Object ref = sourceBackup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      sourceBackup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EXPIRE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp expireTime_;
  /**
   *
   *
   * <pre>
   * Required. The expiration time of the backup in microsecond granularity.
   * The expiration time must be at least 6 hours and at most 366 days
   * from the `create_time` of the source backup. Once the `expire_time` has
   * passed, the backup is eligible to be automatically deleted by Cloud Spanner
   * to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the expireTime field is set.
   */
  @java.lang.Override
  public boolean hasExpireTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The expiration time of the backup in microsecond granularity.
   * The expiration time must be at least 6 hours and at most 366 days
   * from the `create_time` of the source backup. Once the `expire_time` has
   * passed, the backup is eligible to be automatically deleted by Cloud Spanner
   * to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The expireTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getExpireTime() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }
  /**
   *
   *
   * <pre>
   * Required. The expiration time of the backup in microsecond granularity.
   * The expiration time must be at least 6 hours and at most 366 days
   * from the `create_time` of the source backup. Once the `expire_time` has
   * passed, the backup is eligible to be automatically deleted by Cloud Spanner
   * to free the resources used by the backup.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
    return expireTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : expireTime_;
  }

  public static final int ENCRYPTION_CONFIG_FIELD_NUMBER = 5;
  private com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryptionConfig_;
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration used to encrypt the backup. If this
   * field is not specified, the backup will use the same encryption
   * configuration as the source backup by default, namely
   * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
   * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionConfig field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionConfig() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration used to encrypt the backup. If this
   * field is not specified, the backup will use the same encryption
   * configuration as the source backup by default, namely
   * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
   * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionConfig.
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig getEncryptionConfig() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }
  /**
   *
   *
   * <pre>
   * Optional. The encryption configuration used to encrypt the backup. If this
   * field is not specified, the backup will use the same encryption
   * configuration as the source backup by default, namely
   * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
   * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
   * </pre>
   *
   * <code>
   * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.spanner.admin.database.v1.CopyBackupEncryptionConfigOrBuilder
      getEncryptionConfigOrBuilder() {
    return encryptionConfig_ == null
        ? com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.getDefaultInstance()
        : encryptionConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, backupId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceBackup_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, sourceBackup_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getExpireTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getEncryptionConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(backupId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, backupId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(sourceBackup_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, sourceBackup_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getExpireTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEncryptionConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.spanner.admin.database.v1.CopyBackupRequest)) {
      return super.equals(obj);
    }
    com.google.spanner.admin.database.v1.CopyBackupRequest other =
        (com.google.spanner.admin.database.v1.CopyBackupRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!getBackupId().equals(other.getBackupId())) return false;
    if (!getSourceBackup().equals(other.getSourceBackup())) return false;
    if (hasExpireTime() != other.hasExpireTime()) return false;
    if (hasExpireTime()) {
      if (!getExpireTime().equals(other.getExpireTime())) return false;
    }
    if (hasEncryptionConfig() != other.hasEncryptionConfig()) return false;
    if (hasEncryptionConfig()) {
      if (!getEncryptionConfig().equals(other.getEncryptionConfig())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    hash = (37 * hash) + BACKUP_ID_FIELD_NUMBER;
    hash = (53 * hash) + getBackupId().hashCode();
    hash = (37 * hash) + SOURCE_BACKUP_FIELD_NUMBER;
    hash = (53 * hash) + getSourceBackup().hashCode();
    if (hasExpireTime()) {
      hash = (37 * hash) + EXPIRE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getExpireTime().hashCode();
    }
    if (hasEncryptionConfig()) {
      hash = (37 * hash) + ENCRYPTION_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionConfig().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.spanner.admin.database.v1.CopyBackupRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for
   * [CopyBackup][google.spanner.admin.database.v1.DatabaseAdmin.CopyBackup].
   * </pre>
   *
   * Protobuf type {@code google.spanner.admin.database.v1.CopyBackupRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.spanner.admin.database.v1.CopyBackupRequest)
      com.google.spanner.admin.database.v1.CopyBackupRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_CopyBackupRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_CopyBackupRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.spanner.admin.database.v1.CopyBackupRequest.class,
              com.google.spanner.admin.database.v1.CopyBackupRequest.Builder.class);
    }

    // Construct using com.google.spanner.admin.database.v1.CopyBackupRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getExpireTimeFieldBuilder();
        getEncryptionConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      parent_ = "";
      backupId_ = "";
      sourceBackup_ = "";
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.spanner.admin.database.v1.BackupProto
          .internal_static_google_spanner_admin_database_v1_CopyBackupRequest_descriptor;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CopyBackupRequest getDefaultInstanceForType() {
      return com.google.spanner.admin.database.v1.CopyBackupRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CopyBackupRequest build() {
      com.google.spanner.admin.database.v1.CopyBackupRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.spanner.admin.database.v1.CopyBackupRequest buildPartial() {
      com.google.spanner.admin.database.v1.CopyBackupRequest result =
          new com.google.spanner.admin.database.v1.CopyBackupRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.spanner.admin.database.v1.CopyBackupRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.backupId_ = backupId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.sourceBackup_ = sourceBackup_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.expireTime_ = expireTimeBuilder_ == null ? expireTime_ : expireTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.encryptionConfig_ =
            encryptionConfigBuilder_ == null ? encryptionConfig_ : encryptionConfigBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.spanner.admin.database.v1.CopyBackupRequest) {
        return mergeFrom((com.google.spanner.admin.database.v1.CopyBackupRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.spanner.admin.database.v1.CopyBackupRequest other) {
      if (other == com.google.spanner.admin.database.v1.CopyBackupRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getBackupId().isEmpty()) {
        backupId_ = other.backupId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getSourceBackup().isEmpty()) {
        sourceBackup_ = other.sourceBackup_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasExpireTime()) {
        mergeExpireTime(other.getExpireTime());
      }
      if (other.hasEncryptionConfig()) {
        mergeEncryptionConfig(other.getEncryptionConfig());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                backupId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                sourceBackup_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getExpireTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getEncryptionConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object parent_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the destination instance that will contain the backup
     * copy. Values are of the form: `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the destination instance that will contain the backup
     * copy. Values are of the form: `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the destination instance that will contain the backup
     * copy. Values are of the form: `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the destination instance that will contain the backup
     * copy. Values are of the form: `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the destination instance that will contain the backup
     * copy. Values are of the form: `projects/&lt;project&gt;/instances/&lt;instance&gt;`.
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object backupId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The id of the backup copy.
     * The `backup_id` appended to `parent` forms the full backup_uri of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The backupId.
     */
    public java.lang.String getBackupId() {
      java.lang.Object ref = backupId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        backupId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the backup copy.
     * The `backup_id` appended to `parent` forms the full backup_uri of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for backupId.
     */
    public com.google.protobuf.ByteString getBackupIdBytes() {
      java.lang.Object ref = backupId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        backupId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the backup copy.
     * The `backup_id` appended to `parent` forms the full backup_uri of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The backupId to set.
     * @return This builder for chaining.
     */
    public Builder setBackupId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      backupId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the backup copy.
     * The `backup_id` appended to `parent` forms the full backup_uri of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBackupId() {
      backupId_ = getDefaultInstance().getBackupId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The id of the backup copy.
     * The `backup_id` appended to `parent` forms the full backup_uri of the form
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>string backup_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for backupId to set.
     * @return This builder for chaining.
     */
    public Builder setBackupIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      backupId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object sourceBackup_ = "";
    /**
     *
     *
     * <pre>
     * Required. The source backup to be copied.
     * The source backup needs to be in READY state for it to be copied.
     * Once CopyBackup is in progress, the source backup cannot be deleted or
     * cleaned up on expiration until CopyBackup is finished.
     * Values are of the form:
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>
     * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The sourceBackup.
     */
    public java.lang.String getSourceBackup() {
      java.lang.Object ref = sourceBackup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        sourceBackup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The source backup to be copied.
     * The source backup needs to be in READY state for it to be copied.
     * Once CopyBackup is in progress, the source backup cannot be deleted or
     * cleaned up on expiration until CopyBackup is finished.
     * Values are of the form:
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>
     * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for sourceBackup.
     */
    public com.google.protobuf.ByteString getSourceBackupBytes() {
      java.lang.Object ref = sourceBackup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        sourceBackup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The source backup to be copied.
     * The source backup needs to be in READY state for it to be copied.
     * Once CopyBackup is in progress, the source backup cannot be deleted or
     * cleaned up on expiration until CopyBackup is finished.
     * Values are of the form:
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>
     * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The sourceBackup to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBackup(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      sourceBackup_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The source backup to be copied.
     * The source backup needs to be in READY state for it to be copied.
     * Once CopyBackup is in progress, the source backup cannot be deleted or
     * cleaned up on expiration until CopyBackup is finished.
     * Values are of the form:
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>
     * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSourceBackup() {
      sourceBackup_ = getDefaultInstance().getSourceBackup();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The source backup to be copied.
     * The source backup needs to be in READY state for it to be copied.
     * Once CopyBackup is in progress, the source backup cannot be deleted or
     * cleaned up on expiration until CopyBackup is finished.
     * Values are of the form:
     * `projects/&lt;project&gt;/instances/&lt;instance&gt;/backups/&lt;backup&gt;`.
     * </pre>
     *
     * <code>
     * string source_backup = 3 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for sourceBackup to set.
     * @return This builder for chaining.
     */
    public Builder setSourceBackupBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      sourceBackup_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp expireTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        expireTimeBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return Whether the expireTime field is set.
     */
    public boolean hasExpireTime() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The expireTime.
     */
    public com.google.protobuf.Timestamp getExpireTime() {
      if (expireTimeBuilder_ == null) {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      } else {
        return expireTimeBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        expireTime_ = value;
      } else {
        expireTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setExpireTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (expireTimeBuilder_ == null) {
        expireTime_ = builderForValue.build();
      } else {
        expireTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder mergeExpireTime(com.google.protobuf.Timestamp value) {
      if (expireTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && expireTime_ != null
            && expireTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getExpireTimeBuilder().mergeFrom(value);
        } else {
          expireTime_ = value;
        }
      } else {
        expireTimeBuilder_.mergeFrom(value);
      }
      if (expireTime_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearExpireTime() {
      bitField0_ = (bitField0_ & ~0x00000008);
      expireTime_ = null;
      if (expireTimeBuilder_ != null) {
        expireTimeBuilder_.dispose();
        expireTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getExpireTimeBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getExpireTimeFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getExpireTimeOrBuilder() {
      if (expireTimeBuilder_ != null) {
        return expireTimeBuilder_.getMessageOrBuilder();
      } else {
        return expireTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : expireTime_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The expiration time of the backup in microsecond granularity.
     * The expiration time must be at least 6 hours and at most 366 days
     * from the `create_time` of the source backup. Once the `expire_time` has
     * passed, the backup is eligible to be automatically deleted by Cloud Spanner
     * to free the resources used by the backup.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp expire_time = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getExpireTimeFieldBuilder() {
      if (expireTimeBuilder_ == null) {
        expireTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getExpireTime(), getParentForChildren(), isClean());
        expireTime_ = null;
      }
      return expireTimeBuilder_;
    }

    private com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryptionConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig,
            com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.CopyBackupEncryptionConfigOrBuilder>
        encryptionConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionConfig field is set.
     */
    public boolean hasEncryptionConfig() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionConfig.
     */
    public com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig getEncryptionConfig() {
      if (encryptionConfigBuilder_ == null) {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      } else {
        return encryptionConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionConfig_ = value;
      } else {
        encryptionConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionConfig(
        com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.Builder builderForValue) {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfig_ = builderForValue.build();
      } else {
        encryptionConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionConfig(
        com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig value) {
      if (encryptionConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && encryptionConfig_ != null
            && encryptionConfig_
                != com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig
                    .getDefaultInstance()) {
          getEncryptionConfigBuilder().mergeFrom(value);
        } else {
          encryptionConfig_ = value;
        }
      } else {
        encryptionConfigBuilder_.mergeFrom(value);
      }
      if (encryptionConfig_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionConfig() {
      bitField0_ = (bitField0_ & ~0x00000010);
      encryptionConfig_ = null;
      if (encryptionConfigBuilder_ != null) {
        encryptionConfigBuilder_.dispose();
        encryptionConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.Builder
        getEncryptionConfigBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getEncryptionConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.spanner.admin.database.v1.CopyBackupEncryptionConfigOrBuilder
        getEncryptionConfigOrBuilder() {
      if (encryptionConfigBuilder_ != null) {
        return encryptionConfigBuilder_.getMessageOrBuilder();
      } else {
        return encryptionConfig_ == null
            ? com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.getDefaultInstance()
            : encryptionConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Optional. The encryption configuration used to encrypt the backup. If this
     * field is not specified, the backup will use the same encryption
     * configuration as the source backup by default, namely
     * [encryption_type][google.spanner.admin.database.v1.CopyBackupEncryptionConfig.encryption_type]
     * = `USE_CONFIG_DEFAULT_OR_BACKUP_ENCRYPTION`.
     * </pre>
     *
     * <code>
     * .google.spanner.admin.database.v1.CopyBackupEncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig,
            com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.Builder,
            com.google.spanner.admin.database.v1.CopyBackupEncryptionConfigOrBuilder>
        getEncryptionConfigFieldBuilder() {
      if (encryptionConfigBuilder_ == null) {
        encryptionConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig,
                com.google.spanner.admin.database.v1.CopyBackupEncryptionConfig.Builder,
                com.google.spanner.admin.database.v1.CopyBackupEncryptionConfigOrBuilder>(
                getEncryptionConfig(), getParentForChildren(), isClean());
        encryptionConfig_ = null;
      }
      return encryptionConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.spanner.admin.database.v1.CopyBackupRequest)
  }

  // @@protoc_insertion_point(class_scope:google.spanner.admin.database.v1.CopyBackupRequest)
  private static final com.google.spanner.admin.database.v1.CopyBackupRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.spanner.admin.database.v1.CopyBackupRequest();
  }

  public static com.google.spanner.admin.database.v1.CopyBackupRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CopyBackupRequest> PARSER =
      new com.google.protobuf.AbstractParser<CopyBackupRequest>() {
        @java.lang.Override
        public CopyBackupRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<CopyBackupRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CopyBackupRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.spanner.admin.database.v1.CopyBackupRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
